/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ratis.logservice.api.ArchiveLogWriter;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.util.LogServiceUtils;

public class ArchiveHdfsLogWriter
implements ArchiveLogWriter {
    private final Configuration configuration;
    private FileSystem hdfs;
    private FSDataOutputStream os;
    private Path currentPath;
    private long currentRecordId;
    private long lastRollRecordId;

    public ArchiveHdfsLogWriter(Configuration conf) {
        this.configuration = conf;
    }

    public ArchiveHdfsLogWriter() {
        this.configuration = new Configuration();
    }

    @Override
    public void init(String archiveLocation, LogName logName) throws IOException {
        this.hdfs = FileSystem.get((Configuration)this.configuration);
        Path loc = new Path(LogServiceUtils.getArchiveLocationForLog(archiveLocation, logName));
        if (!this.hdfs.exists(loc)) {
            this.hdfs.mkdirs(loc);
        }
        this.currentPath = new Path(loc, logName.getName());
        this.os = this.hdfs.create(this.currentPath, true);
    }

    @Override
    public long write(ByteBuffer buffer) throws IOException {
        if (!buffer.hasArray()) {
            throw new IllegalArgumentException("Currently array backed byte buffer is only supported for archive write !!");
        }
        int startIndex = buffer.arrayOffset();
        int curIndex = buffer.arrayOffset() + buffer.position();
        int endIndex = curIndex + buffer.remaining();
        int length = endIndex - startIndex;
        this.os.writeInt(length);
        this.os.write(buffer.array(), startIndex, length);
        ++this.currentRecordId;
        return this.currentRecordId;
    }

    @Override
    public List<Long> write(List<ByteBuffer> records) throws IOException {
        ArrayList<Long> list = new ArrayList<Long>();
        for (ByteBuffer record : records) {
            list.add(this.write(record));
        }
        return list;
    }

    @Override
    public long sync() throws IOException {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        if (this.lastRollRecordId != this.currentRecordId) {
            this.hdfs.rename(this.currentPath, new Path(this.currentPath + "_recordId_" + this.currentRecordId));
        }
    }

    @Override
    public void rollWriter() throws IOException {
        if (this.lastRollRecordId != this.currentRecordId) {
            this.os.close();
            this.hdfs.rename(this.currentPath, new Path(LogServiceUtils.getRolledPathForArchiveWriter(this.currentPath, this.currentRecordId)));
            this.lastRollRecordId = this.currentRecordId;
            this.os = this.hdfs.create(this.currentPath, true);
        }
    }

    @Override
    public long getLastWrittenRecordId() throws IOException {
        this.os.hflush();
        return this.currentRecordId;
    }
}

