/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.function.Function;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.hadooprpc.Proxy;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocol;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocolPB;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.hadoop.HadoopCompatibilityProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.GeneratedMessageV3;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CombinedClientProtocolClientSideTranslatorPB
extends Proxy<CombinedClientProtocolPB>
implements CombinedClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedClientProtocolClientSideTranslatorPB.class);

    public CombinedClientProtocolClientSideTranslatorPB(String addressStr, Configuration conf) throws IOException {
        super(CombinedClientProtocolPB.class, addressStr, conf);
    }

    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return this.handleRequest(request, ClientProtoUtils::toRaftClientRequestProto, ClientProtoUtils::toRaftClientReply, HadoopCompatibilityProtos.ClientOps.submitClientRequest, RaftProtos.RaftClientReplyProto::parseFrom);
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return this.handleRequest(request, ClientProtoUtils::toSetConfigurationRequestProto, ClientProtoUtils::toRaftClientReply, HadoopCompatibilityProtos.ClientOps.setConfiguration, RaftProtos.RaftClientReplyProto::parseFrom);
    }

    public RaftClientReply transferLeadership(TransferLeadershipRequest request) throws IOException {
        return this.handleRequest(request, ClientProtoUtils::toTransferLeadershipRequestProto, ClientProtoUtils::toRaftClientReply, HadoopCompatibilityProtos.ClientOps.transferLeadership, RaftProtos.RaftClientReplyProto::parseFrom);
    }

    public RaftClientReply groupManagement(GroupManagementRequest request) throws IOException {
        return this.handleRequest(request, ClientProtoUtils::toGroupManagementRequestProto, ClientProtoUtils::toRaftClientReply, HadoopCompatibilityProtos.ClientOps.groupManagement, RaftProtos.RaftClientReplyProto::parseFrom);
    }

    public GroupListReply getGroupList(GroupListRequest request) throws IOException {
        return this.handleRequest(request, ClientProtoUtils::toGroupListRequestProto, ClientProtoUtils::toGroupListReply, HadoopCompatibilityProtos.ClientOps.groupList, RaftProtos.GroupListReplyProto::parseFrom);
    }

    public GroupInfoReply getGroupInfo(GroupInfoRequest request) throws IOException {
        return this.handleRequest(request, ClientProtoUtils::toGroupInfoRequestProto, ClientProtoUtils::toGroupInfoReply, HadoopCompatibilityProtos.ClientOps.groupInfo, RaftProtos.GroupInfoReplyProto::parseFrom);
    }

    <REQUEST extends RaftClientRequest, REPLY extends RaftClientReply, PROTO_REQ extends GeneratedMessageV3, PROTO_REP extends GeneratedMessageV3> REPLY handleRequest(REQUEST request, Function<REQUEST, PROTO_REQ> reqToProto, Function<PROTO_REP, REPLY> repToProto, HadoopCompatibilityProtos.ClientOps type, CheckedFunction<byte[], PROTO_REP, InvalidProtocolBufferException> byteToProto) throws IOException {
        GeneratedMessageV3 proto = (GeneratedMessageV3)reqToProto.apply(request);
        try {
            HadoopCompatibilityProtos.ClientRequestProto req = HadoopCompatibilityProtos.ClientRequestProto.newBuilder().setType(type).setRequest(ByteString.copyFrom((byte[])proto.toByteArray())).build();
            byte[] reply = ((CombinedClientProtocolPB)this.getProtocol()).sendClient(null, req).getResponse().toByteArray();
            GeneratedMessageV3 replyProto = (GeneratedMessageV3)byteToProto.apply((Object)reply);
            return (REPLY)((RaftClientReply)repToProto.apply(replyProto));
        }
        catch (ServiceException se) {
            LOG.trace("Failed to handle " + request, (Throwable)se);
            throw new IOException(se);
        }
    }
}

