/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc.server;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.ratis.hadooprpc.server.RaftServerProtocolPB;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.hadoop.HadoopCompatibilityProtos;
import org.apache.ratis.server.protocol.RaftServerProtocol;

@InterfaceAudience.Private
public class RaftServerProtocolServerSideTranslatorPB
implements RaftServerProtocolPB {
    private final RaftServerProtocol impl;

    public RaftServerProtocolServerSideTranslatorPB(RaftServerProtocol impl) {
        this.impl = impl;
    }

    @Override
    public HadoopCompatibilityProtos.ServerReplyProto sendServer(RpcController unused, HadoopCompatibilityProtos.ServerRequestProto requestProto) throws ServiceException {
        HadoopCompatibilityProtos.ServerOps type = requestProto.getType();
        ByteBuffer buffer = requestProto.getRequest().asReadOnlyByteBuffer();
        RaftProtos.RequestVoteReplyProto respone = null;
        try {
            switch (type) {
                case requestVote: {
                    respone = this.requestVote(RaftProtos.RequestVoteRequestProto.parseFrom((ByteBuffer)buffer));
                    break;
                }
                case startLeaderElection: {
                    respone = this.startLeaderElection(RaftProtos.StartLeaderElectionRequestProto.parseFrom((ByteBuffer)buffer));
                    break;
                }
                case installSnapshot: {
                    respone = this.installSnapshot(RaftProtos.InstallSnapshotRequestProto.parseFrom((ByteBuffer)buffer));
                    break;
                }
                case appendEntries: {
                    respone = this.appendEntries(RaftProtos.AppendEntriesRequestProto.parseFrom((ByteBuffer)buffer));
                    break;
                }
                default: {
                    throw new IOException("Invalid Request Type:" + (Object)((Object)type));
                }
            }
            return HadoopCompatibilityProtos.ServerReplyProto.newBuilder().setType(type).setResponse(ByteString.copyFrom((byte[])respone.toByteArray())).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        return this.impl.requestVote(request);
    }

    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        return this.impl.startLeaderElection(request);
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        return this.impl.appendEntries(request);
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        return this.impl.installSnapshot(request);
    }
}

