/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.diffvalidation.skeleton.pathitem;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidatorTemplate;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OperationDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.PathItemDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.util.OasObjectDiffValidatorUtils;

public class PathItemOperationsDiffValidator
extends OasObjectDiffValidatorTemplate<PathItem>
implements PathItemDiffValidator {
    private final List<OperationDiffValidator> operationValidators;

    public PathItemOperationsDiffValidator(List<OperationDiffValidator> operationValidators) {
        this.operationValidators = operationValidators;
    }

    @Override
    public List<OasDiffViolation> validateCompare(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, PathItem leftOasObject, OasObjectPropertyLocation rightLocation, PathItem rightOasObject) {
        Map leftOperationMap = leftOasObject.readOperationsMap();
        Map rightOperationMap = rightOasObject.readOperationsMap();
        ArrayList<OasDiffViolation> violations = new ArrayList<OasDiffViolation>();
        for (Map.Entry entry : leftOperationMap.entrySet()) {
            PathItem.HttpMethod leftMethod = (PathItem.HttpMethod)entry.getKey();
            Operation leftOperation = (Operation)entry.getValue();
            OasObjectPropertyLocation leftOperationLoc = leftLocation.property(leftMethod.toString().toLowerCase(), OasObjectType.OPERATION);
            Operation rightOperation = (Operation)rightOperationMap.get(leftMethod);
            if (rightOperation == null) {
                violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftOperationLoc, leftOperation, null, null, this.operationValidators));
                continue;
            }
            OasObjectPropertyLocation rightOperationLoc = rightLocation.property(leftMethod.toString().toLowerCase(), OasObjectType.OPERATION);
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftOperationLoc, leftOperation, rightOperationLoc, rightOperation, this.operationValidators));
        }
        for (Map.Entry entry : rightOperationMap.entrySet()) {
            PathItem.HttpMethod rightMethod = (PathItem.HttpMethod)entry.getKey();
            if (leftOperationMap.containsKey(rightMethod)) continue;
            Operation rightOperation = (Operation)rightOperationMap.get(rightMethod);
            OasObjectPropertyLocation rightOperationLoc = rightLocation.property(rightMethod.toString().toLowerCase(), OasObjectType.OPERATION);
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, null, null, rightOperationLoc, rightOperation, this.operationValidators));
        }
        return violations;
    }
}

