/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.env.TimeService;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.infra.exception.JobExecutionEnvironmentException;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ConfigurationService {
    private final TimeService timeService;
    private final JobNodeStorage jobNodeStorage;

    public ConfigurationService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.timeService = new TimeService();
    }

    public JobConfiguration load(boolean fromCache) {
        String result;
        if (fromCache) {
            result = this.jobNodeStorage.getJobNodeData("config");
            if (null == result) {
                result = this.jobNodeStorage.getJobNodeDataDirectly("config");
            }
        } else {
            result = this.jobNodeStorage.getJobNodeDataDirectly("config");
        }
        if (result != null) {
            return ((JobConfigurationPOJO)YamlEngine.unmarshal((String)result, JobConfigurationPOJO.class)).toJobConfiguration();
        }
        throw new JobConfigurationException("JobConfiguration was not found. It maybe has been removed or has not been configured correctly.", new Object[0]);
    }

    public JobConfiguration setUpJobConfiguration(String jobClassName, JobConfiguration jobConfig) {
        this.checkConflictJob(jobClassName, jobConfig);
        if (!this.jobNodeStorage.isJobNodeExisted("config") || jobConfig.isOverwrite()) {
            this.jobNodeStorage.replaceJobNode("config", YamlEngine.marshal((Object)JobConfigurationPOJO.fromJobConfiguration((JobConfiguration)jobConfig)));
            this.jobNodeStorage.replaceJobRootNode(jobClassName);
            return jobConfig;
        }
        return this.load(false);
    }

    private void checkConflictJob(String newJobClassName, JobConfiguration jobConfig) {
        if (!this.jobNodeStorage.isJobRootNodeExisted()) {
            return;
        }
        String originalJobClassName = this.jobNodeStorage.getJobRootNodeData();
        if (StringUtils.isNotBlank((CharSequence)originalJobClassName) && !originalJobClassName.equals(newJobClassName)) {
            throw new JobConfigurationException("Job conflict with register center. The job '%s' in register center's class is '%s', your job class is '%s'", new Object[]{jobConfig.getJobName(), originalJobClassName, newJobClassName});
        }
    }

    public void checkMaxTimeDiffSecondsTolerable() throws JobExecutionEnvironmentException {
        int maxTimeDiffSeconds = this.load(true).getMaxTimeDiffSeconds();
        if (0 > maxTimeDiffSeconds) {
            return;
        }
        long timeDiff = Math.abs(this.timeService.getCurrentMillis() - this.jobNodeStorage.getRegistryCenterTime());
        if (timeDiff > (long)maxTimeDiffSeconds * 1000L) {
            throw new JobExecutionEnvironmentException("Time different between job server and register center exceed '%s' seconds, max time different is '%s' seconds.", new Object[]{timeDiff / 1000L, maxTimeDiffSeconds});
        }
    }
}

