/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.rocketMQ.client.java.v5;

import java.lang.reflect.Method;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.rocketMQ.client.java.v5.define.ConsumerEnhanceInfos;

public class MessageListenerInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String CONSUMER_OPERATION_NAME_PREFIX = "RocketMQ/";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        MessageView messageView = (MessageView)allArguments[0];
        ContextCarrier contextCarrier = this.getContextCarrierFromMessage(messageView);
        AbstractSpan span = ContextManager.createEntrySpan((String)(CONSUMER_OPERATION_NAME_PREFIX + messageView.getTopic() + "/Consumer"), (ContextCarrier)contextCarrier);
        Tags.MQ_TOPIC.set(span, messageView.getTopic());
        Object skyWalkingDynamicField = objInst.getSkyWalkingDynamicField();
        if (skyWalkingDynamicField != null) {
            ConsumerEnhanceInfos consumerEnhanceInfos = (ConsumerEnhanceInfos)skyWalkingDynamicField;
            Tags.MQ_BROKER.set(span, consumerEnhanceInfos.getNamesrvAddr());
            span.setPeer(consumerEnhanceInfos.getNamesrvAddr());
        }
        span.setComponent((Component)ComponentsDefine.ROCKET_MQ_CONSUMER);
        SpanLayer.asMQ((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ConsumeResult status = (ConsumeResult)ret;
        if (ConsumeResult.FAILURE.equals((Object)status)) {
            AbstractSpan activeSpan = ContextManager.activeSpan();
            activeSpan.errorOccurred();
            Tags.MQ_STATUS.set(activeSpan, status.name());
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private ContextCarrier getContextCarrierFromMessage(MessageView message) {
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue((String)message.getProperties().get(next.getHeadKey()));
        }
        return contextCarrier;
    }
}

