/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.libraries.eip;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.evaluators.AndEvaluator;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.MatchEvaluator;
import org.apache.synapse.commons.evaluators.OrEvaluator;
import org.apache.synapse.commons.evaluators.source.HeaderTextRetriever;
import org.apache.synapse.commons.evaluators.source.URLTextRetriever;
import org.apache.synapse.libraries.eip.EIPUtils;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.mediators.filters.router.ConditionalRoute;
import org.apache.synapse.mediators.filters.router.ConditionalRouterMediator;

public class DynamicRouterMediator
extends AbstractMediator {
    private static final String DELIMITER_1 = ",";
    private static final String DELIMITER_2 = ";";
    private static final String DELIMITER_3 = "=";
    private static final String DELIMITER_4 = ":";
    private static final String DELIMITER_5 = "\\{AND}";
    private static final String DELIMITER_6 = "\\{OR}";
    MessageContext synCtx;

    @Override
    public boolean mediate(MessageContext msgCtx) {
        this.synCtx = msgCtx;
        ConditionalRouterMediator conditionalRouterMediator = new ConditionalRouterMediator();
        conditionalRouterMediator.setContinueAfter(false);
        this.createDynamicRoute(msgCtx, conditionalRouterMediator);
        conditionalRouterMediator.mediate(msgCtx);
        return true;
    }

    private boolean createDynamicRoute(MessageContext synCtx, ConditionalRouterMediator conditionalRouterMediator) {
        String conditionRouts = (String)EIPUtils.lookupFunctionParam(synCtx, "conditions");
        String[] conditionsSet = conditionRouts.split(DELIMITER_1);
        if (conditionsSet.length == 0) {
            this.log.warn((Object)"No Definitions found for dynamic routing");
            return false;
        }
        for (String conditionRoute : conditionsSet) {
            if (conditionRoute == null || "".equals(conditionRoute.trim())) continue;
            ConditionalRoute conditionalRoute = this.createConRoute(conditionRoute.trim());
            conditionalRouterMediator.addRoute(conditionalRoute);
        }
        return true;
    }

    private ConditionalRoute createConRoute(String conRoute) {
        ConditionalRoute conditionalRoute = new ConditionalRoute();
        String[] conditionDefs = conRoute.split(DELIMITER_2);
        conditionalRoute.setBreakRoute(false);
        if (conditionDefs.length < 2) {
            this.handleException("Conditional Route is not defined", this.synCtx);
            return null;
        }
        String condition = conditionDefs[0];
        String target = conditionDefs[1];
        if (condition != null && !"".equals(condition.trim())) {
            this.createCondition(conditionalRoute, condition.trim());
        } else {
            this.handleException("Routing condition can not be empty", this.synCtx);
        }
        if (target != null && !"".equals(target.trim())) {
            this.createTarget(conditionalRoute, target);
        } else {
            this.handleException("Routing Target can not be empty", this.synCtx);
        }
        return conditionalRoute;
    }

    private void createCondition(ConditionalRoute conRoute, String condition) {
        if (!condition.contains("{AND}") && !condition.contains("{OR}")) {
            Evaluator evaluator = this.createMatchEvaluator(condition);
            conRoute.setEvaluator(evaluator);
        } else if (condition.contains("{AND}") && !condition.contains("{OR}")) {
            Evaluator andEvaluator = this.createAndEvaluator(condition);
            conRoute.setEvaluator(andEvaluator);
        } else if (condition.contains("{OR}") && !condition.contains("{AND}")) {
            Evaluator orEvaluator = this.createOrEvaluator(condition);
            conRoute.setEvaluator(orEvaluator);
        } else {
            this.handleException("Routing condition is wrong", this.synCtx);
        }
    }

    private Evaluator createMatchEvaluator(String matchElements) {
        String[] matchElem = matchElements.split(DELIMITER_3);
        String matchValue = matchElem[0].trim();
        String matchConfig = matchElem[1].trim();
        MatchEvaluator matchEvaluator = new MatchEvaluator();
        String[] matchParams = matchConfig.split(DELIMITER_4);
        URLTextRetriever textRetriever = null;
        String regEx = null;
        if (matchParams.length == 1) {
            regEx = matchParams[0].trim();
            if (matchValue.equals("url")) {
                textRetriever = new URLTextRetriever();
            }
        } else if (matchParams.length == 2) {
            String source = matchParams[0].trim();
            if (matchValue.equals("header")) {
                if (source != null) {
                    textRetriever = new HeaderTextRetriever(source);
                } else {
                    this.handleException("source attribute is required", this.synCtx);
                }
            } else if (matchValue.equals("url")) {
                textRetriever = new URLTextRetriever();
                if (source != null) {
                    textRetriever.setSource(source);
                }
            } else {
                this.handleException("Unsupported evaluator:" + matchValue, this.synCtx);
            }
            regEx = matchParams[1].trim();
        } else {
            this.handleException("Unsupported condition" + matchConfig, this.synCtx);
        }
        matchEvaluator.setTextRetriever(textRetriever);
        if (regEx == null) {
            this.handleException("regex attribute is required", this.synCtx);
            return null;
        }
        matchEvaluator.setRegex(Pattern.compile(regEx));
        return matchEvaluator;
    }

    private Evaluator createAndEvaluator(String andConfig) {
        String[] andEvals = andConfig.split(DELIMITER_5);
        AndEvaluator andEvaluator = new AndEvaluator();
        ArrayList<Evaluator> evaluators = new ArrayList<Evaluator>();
        for (String matchElements : andEvals) {
            if (matchElements == null || "".equals(matchElements.trim())) continue;
            Evaluator evaluator = this.createMatchEvaluator(matchElements.trim());
            evaluators.add(evaluator);
        }
        if (evaluators.size() > 1) {
            andEvaluator.setEvaluators(evaluators.toArray(new Evaluator[evaluators.size()]));
        } else {
            this.handleException("Two or more expressions should be provided under And", this.synCtx);
        }
        return andEvaluator;
    }

    private Evaluator createOrEvaluator(String orConfig) {
        String[] orEvals = orConfig.split(DELIMITER_6);
        OrEvaluator orEvaluator = new OrEvaluator();
        ArrayList<Evaluator> evaluators = new ArrayList<Evaluator>();
        for (String matchElements : orEvals) {
            if (matchElements == null || "".equals(matchElements.trim())) continue;
            Evaluator evaluator = this.createMatchEvaluator(matchElements.trim());
            evaluators.add(evaluator);
        }
        if (evaluators.size() > 1) {
            orEvaluator.setEvaluators(evaluators.toArray(new Evaluator[evaluators.size()]));
        } else {
            this.handleException("Two or more expressions should be provided under Or", this.synCtx);
        }
        return orEvaluator;
    }

    private void createTarget(ConditionalRoute conRoute, String targetVal) {
        Target target = new Target();
        String[] elements = targetVal.split(DELIMITER_3);
        String type = elements[0].trim();
        String value = elements[1].trim();
        if (type.equalsIgnoreCase("seq")) {
            target.setAsynchronous(false);
            target.setSequenceRef(value);
            conRoute.setTarget(target);
        } else {
            this.handleException("Target Sequence has defined wrong", this.synCtx);
        }
    }
}

