100 REM MMCcalc  Terry Fritz
105 V$ = "MMC Calculator  Ver. 2.2   9/12/2000  Terry Fritz"
110 REM Released to the public domain

1000 REM Input data and do a little calculation on it.
1010 CLS : PRINT : PRINT
1020 PRINT V$
1030 PRINT
1100 INPUT "Transformer rated RMS ouput voltage (kV)"; Vo
1103 Vo = Vo * 1000
1105 Vf = 1.41421 * Vo
1110 INPUT "Transformer rated RMS output current (mA)"; Io
1115 Io = Io / 1000
1150 INPUT "Value of individual capacitor (uF)"; C0
1155 C0 = C0 / 1000000!
1156 INPUT "DC voltage of individual capacitor (V)"; Vm
1160 PRINT
1161 PRINT "Lead Spacing (mm)    Value (C/W)"
1162 PRINT "5                    250"
1163 PRINT "7.5                  167"
1164 PRINT "10                   133"
1165 PRINT "15                   83"
1166 PRINT "22.5                 67"
1167 PRINT "27.5                 40"
1168 PRINT "37.5                 33"
1169 PRINT
1170 PRINT "Enter the Thermal Dissipation Value (C/W) from the above chart"
1171 PRINT "based on the distance between the leads of your capacitors"
1172 PRINT
1173 INPUT "Thermal Dissipation Constant (C/W)"; TK
1190 INPUT "Cost of individual capacitor "; Ccost
1200 INPUT "Fundamental frequency of coil (kHz)"; F
1205 F = F * 1000
1210 IF F > 500000 THEN PRINT "Frequency may be too high for this program!"
1250 TANG = F / 1.1E+08
1300 INPUT "Break rate of primary gap (BPS)"; BPS
1600 INPUT "Value desired (nF) [ -1 for LTR ]"; Cwish
1650 Cwish = Cwish / 1E+09
1660 IF Cwish < 0 THEN Cwish = .83 * Io / BPS / Vo

2000 REM  Setup output file.
2010 CLS
2020 ss = 0
2041 OPEN "MMCcalc.txt" FOR OUTPUT AS #1
2042 PRINT V$
2053 PRINT #1, V$
2054 PRINT #1, "Transformer voltage = "; Vo
2055 PRINT #1, "Transformer current = "; Io
2059 PRINT #1, "Firing voltage = "; Vf
2065 PRINT #1, "Fo = "; F
2066 PRINT #1, "Break rate = "; BPS
2067 PRINT #1, "Thermal dissipation constant = "; TK
2077 PRINT #1, "Individual cap value = "; C0
2078 PRINT #1, " "
2080 PRINT "Strings  Caps/Str  Capacitance  Voltage   Temp C    Cost              I Arms"
2085 PRINT #1, "Strings  Caps/Str  Capacitance  Voltage   Temp C    Cost              I Arms"

2090 REM do the actual calculations
2100 FOR Nstring = 1 TO 15
2110 FOR Nline = 1 TO 20
2130 Ct = C0 * Nstring / Nline
2140 Ecap = .5 * C0 * (Vf / Nline) ^ 2
2150 Rcap = TANG / (2 * 3.14159 * C0 * F)
2160 W0 = Rcap * Ecap * BPS / (2 + Rcap)
2170 Irms = (W0 / Rcap) ^ .5 * Nstring
2172 Irms = INT(Irms * 100) / 100
2180 Ncaps = Nline * Nstring
2190 T0 = W0 * TK
2200 Cost = Ncaps * Ccost

4000 REM print it all out
4005 IF Ct <= .95 * Cwish OR Ct >= 1.05 * Cwish THEN 5000
4100 IF T0 <= 5 THEN P$ = "  :-)) "
4110 IF T0 <= 10 AND T0 > 5 THEN P$ = "  :-)  "
4120 IF T0 <= 15 AND T0 > 10 THEN P$ = "  :-|  "
4140 IF T0 <= 20 AND T0 > 15 THEN P$ = "  :-(  "
4150 IF T0 > 20 THEN P$ = "  :-(( "
4160 IF Vf <= Vm * Nline THEN R$ = "  :-))"
4170 IF Vf > Vm * Nline AND Vf <= Vm * Nline * 1.25 THEN R$ = "  :-| "
4180 IF Vf > Vm * Nline * 1.25 THEN R$ = "  :-(("
4210 PRINT USING "###      ###      #####.##        #####   ###.## ####.##"; Nstring; Nline; Ct * 1E+09; Nline * Vm; T0; Cost;
4212 PRINT R$; P$; Irms
4215 PRINT #1, USING "###      ###      #####.##        #####   ###.## ####.##"; Nstring; Nline; Ct * 1E+09; Nline * Vm; T0; Cost;
4220 PRINT #1, R$; P$; Irms
4230 IF T0 < 10 AND Vf <= Vm * Nline AND ss = 0 THEN PRINT "--------------------------------------------------------------------"
4235 IF T0 < 10 AND Vf <= Vm * Nline AND ss = 0 THEN PRINT #1, "--------------------------------------------------------------------": ss = 1

5000 NEXT Nline, Nstring
6000 PRINT " "
8010 CLOSE #1
10000 INPUT "Type E to stop"; q$
10010 IF q$ = "E" OR q$ = "e" THEN END
10020 GOTO 100



