%define name basplnx
%define version 6.0.1

Summary: Broadcom Advanced Server Program (BASP) driver for Linux
Name: %{name}
Version: %{version}
Release: 1
Vendor: Broadcom Corporation
Copyright: Commercial
Group: System Environment/Base
Source: %{name}-%{version}.tgz
BuildRoot: /var/tmp/%{name}-buildroot

%description
BASP is a kernel module designed for Linux 2.4.x kernel that 
provides load-balancing, fault-tolerance, and VLAN features. These features
are provided by creating teams that consist of multiple NIC interfaces.
A team can consist of 1 to 8 NIC interfaces and each interface can be
designated primary or standby. All primary NIC in a team will participate
in Load-balancing operations by sending and receiving a portion of the
total traffic. Standby interfaces will take over in the event that all
primary interfaces have lost their links. VLANs can be added to a team
to allow multiple VLANs with different VLAN IDs. A virtual device
is created for each VLAN added.

%prep
%setup -c -b 0

%build
make

%install
echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/_file.list.%{name}
echo "/etc/init.d/basp" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/etc/basp/baspteam" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/etc/basp/baspif" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/etc/basp/samples/team-sample" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/etc/basp/samples/team-gec" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/etc/basp/samples/team-vlan" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/usr/bin/baspcfg" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/dev/basp" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/usr/src/nice-2.2.16" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/usr/src/nice-2.4.16" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/usr/share/man/man4/basp.4.gz" >> $RPM_BUILD_DIR/_file.list.%{name}
echo "/usr/share/man/man8/baspcfg.8.gz" >> $RPM_BUILD_DIR/_file.list.%{name}
if [ -d /lib/modules/`uname -r`/kernel ]; then
    mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/net/basp
    echo "/lib/modules/`uname -r`/kernel/net/basp/basp.o" >> $RPM_BUILD_DIR/_file.list.%{name}
    echo "/lib/modules/`uname -r`/build/include/linux/nicext.h" >> $RPM_BUILD_DIR/_file.list.%{name}
else
    mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/net
    echo "/lib/modules/*/net/basp.o" >> $RPM_BUILD_DIR/_file.list.%{name}
    echo "/usr/src/linux/include/linux/nicext.h" >> $RPM_BUILD_DIR/_file.list.%{name}
fi
make install PREFIX=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%files -f ../_file.list.%{name}
%doc release.txt
%dir /etc/basp
%dir /etc/basp/samples

%post
chkconfig --del basp
chkconfig --add basp
if [ -d /usr/src/packages ]; then
    chkconfig basp 2345
fi
depmod -a
if [ -f /etc/rc.config ]; then
    pushd .
    cd /etc/init.d/rc2.d
    rm -f S04basp >/dev/null 2>/dev/null
    rm -f K20basp >/dev/null 2>/dev/null
    ln -s ../basp S04basp
    ln -s ../basp K20basp
    cd /etc/init.d/rc3.d
    rm -f S04basp >/dev/null 2>/dev/null
    rm -f K20basp >/dev/null 2>/dev/null
    ln -s ../basp S04basp
    ln -s ../basp K20basp
    cd /etc/init.d/rc5.d
    rm -f S04basp >/dev/null 2>/dev/null
    rm -f K20basp >/dev/null 2>/dev/null
    ln -s ../basp S04basp
    ln -s ../basp K20basp
    popd
fi

%preun
/etc/init.d/basp stop
chkconfig --del basp
if [ -f /etc/rc.config ]; then
    pushd .
    cd /etc/init.d/rc2.d
    rm -f S04basp >/dev/null 2>/dev/null
    rm -f K20basp >/dev/null 2>/dev/null
    cd /etc/init.d/rc3.d
    rm -f S04basp >/dev/null 2>/dev/null
    rm -f K20basp >/dev/null 2>/dev/null
    cd /etc/init.d/rc5.d
    rm -f S04basp >/dev/null 2>/dev/null
    rm -f K20basp >/dev/null 2>/dev/null
    popd
fi

%postun
depmod -a
if [ -d /lib/modules/`uname -r`/kernel ]; then
    rm -rf /lib/modules/`uname -r`/kernel/net/basp >/dev/null 2>/dev/null
fi

%changelog

