/****************************************************************************
 * Copyright(c) 2000 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name: BMAPI.h
 *
 * Description: Broadcom Management API.
 *
 * Author: hyfeng
 *
 * $Log:: /Source/bmapilnx/BMAPI.h                                  $
 * 
 * 115   10/08/02 2:00p Hyfeng
 * 
 * 117   10/03/02 7:27p Hyfeng
 * 
 * 116   9/24/02 1:27p Hyfeng
 * 
 * 115   9/20/02 2:37p Hyfeng
 * 
 * 114   9/16/02 3:54p Hyfeng
 * 
 * 113   9/12/02 3:53p Hyfeng
 * 
 * 112   8/27/02 3:46p Hyfeng
 * 
 * 111   8/23/02 4:15p Hyfeng
 * 
 * 110   8/13/02 2:59p Hyfeng
 * 
 * 109   8/13/02 1:52p Hyfeng
 * 
 * 108   8/07/02 4:50p Hyfeng
 * 
 * 107   7/19/02 7:28p Hyfeng
 * 
 * 106   6/25/02 3:59p Hyfeng
 * 
 * 105   6/20/02 3:11p Hyfeng
 * 
 * 104   6/12/02 7:10p Hyfeng
 * 
 * 103   6/10/02 7:43p Hyfeng
 * 
 * 102   5/22/02 5:17p Hyfeng
 * 
 * 100   5/17/02 5:45p Hyfeng
 * 
 * 99    5/09/02 1:46p Hyfeng
 * 
 * 98    4/25/02 10:40a Hyfeng
 * 
 * 97    4/01/02 10:31a Hyfeng
 * 
 * 96    3/29/02 2:37p Hyfeng
 * 
 * 95    3/29/02 10:34a Hyfeng
 * 
 * 94    3/28/02 2:05p Hyfeng
 * 
 * 93    3/22/02 11:34a Hyfeng
 * 
 * 92    3/21/02 10:16a Hyfeng
 * 
 * 91    3/20/02 2:13p Hyfeng
 * 
 * 90    3/12/02 10:38a Hyfeng
 * 
 * 89    3/07/02 8:15p Hyfeng
 * 
 * 88    2/27/02 7:12p Hyfeng
 * 
 * 87    2/20/02 6:59p Hyfeng
 * 
 * 86    2/20/02 5:56p Hyfeng
 * 
 * 85    2/20/02 8:36a Hyfeng
 * 
 * 84    2/19/02 5:39p Hyfeng
 * 
 * 83    2/19/02 5:20p Hyfeng
 * 
 * 82    2/18/02 9:33p Hyfeng
 * 
 * 81    2/18/02 5:18p Hyfeng
 * 
 * 80    2/14/02 11:54a Hyfeng
 * 
 * 79    2/13/02 6:53p Hyfeng
 * 
 * 78    2/13/02 2:23p Hyfeng
 * 
 * 77    2/12/02 10:13a Hyfeng
 * 
 * 76    2/05/02 9:29p Hyfeng
 * 
 * 75    2/05/02 3:47p Hyfeng
 * 
 * 74    2/02/02 5:27p Hyfeng
 * Add more support for WMI.
 * 
 * 73    2/02/02 12:34p Hyfeng
 * 
 * 72    1/31/02 5:39p Hyfeng
 * 
 * 71    1/29/02 11:53a Hyfeng
 * 
 * 70    1/25/02 8:00p Hyfeng
 * 
 * 69    1/25/02 3:21p Hyfeng
 * 
 * 68    1/23/02 3:43p Hyfeng
 * 
 * 67    1/22/02 11:53a Hyfeng
 * 
 * 66    1/17/02 7:04p Hyfeng
 * 
 * 65    1/15/02 2:59p Hyfeng
 * 
 * 64    1/04/02 5:25p Hyfeng
 * 
 * 63    12/20/01 6:32p Hyfeng
 * 
 * 62    12/13/01 2:39p Hyfeng
 * 
 * 61    12/12/01 2:17p Hyfeng
 * 
 * 60    12/12/01 2:13p Hyfeng
 * 
 * 59    11/29/01 7:49p Hyfeng
 * 
 * 58    11/29/01 7:42p Hyfeng
 * 
 * 57    11/21/01 7:51p Hyfeng
 * 
 * 56    11/20/01 6:07p Havk
 * 
 * 55    11/13/01 1:50p Hyfeng
 * 
 * 54    11/06/01 11:49a Hyfeng
 * 
 * 53    10/11/01 6:34p Hyfeng
 * 
 * 52    8/29/01 6:09p Hyfeng
 * 
 * 51    8/23/01 3:44p Hyfeng
 * 
 * 50    8/20/01 5:17p Hyfeng
 * 
 * 49    8/17/01 5:24p Hyfeng
 * 
 * 48    8/17/01 4:15p Hyfeng
 * Add PCI-X 100 MHZ support.
 * 
 * 47    8/10/01 11:04a Hyfeng
 * 
 * 46    7/20/01 10:49a Zambrano
 * 
 * 45    7/10/01 11:33a Hyfeng
 * 
 * 44    6/27/01 3:34p Hyfeng
 * 
 * 43    6/19/01 3:42p Hyfeng
 * 
 * 42    6/11/01 3:41p Hyfeng
 * 
 * 41    5/24/01 1:56p Hyfeng
 * 
 * 40    5/09/01 3:35p Hyfeng
 * 
 * 39    4/20/01 12:13p Hyfeng
 * 
 * 38    4/20/01 11:13a Hyfeng
 * 
 * 37    3/30/01 11:47a Hyfeng
 * 
 * 36    3/29/01 10:20a Hyfeng
 * 
 * 35    3/13/01 1:44p Hyfeng
 * 
 * 34    3/05/01 3:37p Hyfeng
 * 
 * 33    2/28/01 10:42a Hyfeng
 * 
 * 32    2/21/01 3:15p Hyfeng
 * 
 * 31    2/16/01 2:47p Hyfeng
 * 
 * 29    1/19/01 12:18p Hyfeng
 * 
 * 28    1/05/01 11:31a Hyfeng
 * 
 * 27    12/23/00 2:57p Hyfeng
 * 
 * 26    12/13/00 5:19p Hyfeng
 * 
 * 25    12/07/00 1:49p Hyfeng
 * 
 * 24    12/06/00 11:10a Hyfeng
 * 
 * 23    12/01/00 4:12p Hyfeng
 * 
 * 22    11/29/00 11:27a Hyfeng
 * 
 * 21    11/14/00 3:18p Hyfeng
 * 
 * 20    11/10/00 2:33p Hyfeng
 * 
 * 19    11/06/00 6:37p Hyfeng
 * 
 * 18    11/06/00 12:05p Hyfeng
 * 
 * 17    11/03/00 1:56p Hyfeng
 * 
 * 16    11/01/00 3:40p Hyfeng
 * 
 * 15    10/27/00 1:55p Hyfeng
 * 
 * 14    10/23/00 5:25p Hyfeng
 * 
 * 13    10/18/00 10:46a Hyfeng
 * 
 * 12    10/11/00 6:46p Hyfeng
 * 
 * 11    9/20/00 7:42p Hyfeng
 * 
 * 10    9/18/00 1:52p Hyfeng
 * 
 * 9     8/29/00 2:01p Hyfeng
 * 1. Implement GetVersion().
 * 2. Implement trace log facility.
 * 
 * 8     8/24/00 2:11p Hyfeng
 * Implement BmapiRetrieveLinkStatus and BmapiForceBRCMNicLinkSpeed.
 * 
 * 7     8/21/00 4:36p Hyfeng
 * Complete implementation and test of :
 * BmapiGetTeamListSnapShot
 * BmapiGetTeamSnapShot
 * BmapiGetTeamStatisticsSnapShot
 * BmapiGetNicStatistics
 * BmapiGetBRCMNicInfo
 * BmapiGetBRCMStatistics
 * 
 * Complete test of:
 * BmapiTestControlRegisters
 * BmapiTestEEPROM
 * BmapiTestInternalMemory
 * BmapiTestInterrupt
 * BmapiTestLoopBack
 * BmapiTestCPU
 * BmapiTestLEDs
 * 
 * 6     8/15/00 6:57p Hyfeng
 * Add support for load balancing feature on WIn2000.
 * 
 * 5     8/10/00 5:35p Hyfeng
 * 
 * 4     8/07/00 7:01p Hyfeng
 * Modify support for VLAN
 * 
 * 3     7/24/00 7:31p Hyfeng
 * 1. Implement BmapiGetTeamSnapShot().
 * 2. Implement BmapiGetTeamStatisticsSnapShot().
 * 3. BmapiApplyLBFOCfg support Win 2000.
 * 
 * 2     7/21/00 5:49p Hyfeng
 * 1. Add BmapiGetServiceName()
 * 2. Implement BmapiApplyLBFOCfg() under NT 4.0. W2k still need
 * work.
 * 3. Implement BmapiDoNicIOCTL()
 * 4. Implement BmapiGetTeamListSnapShot()
 * 5. Split source files so that Kennth will be easier to share the
 * same source code.
 * 
 * 1     7/18/00 6:22p Hyfeng
 * Initial revision
 * 
 ****************************************************************************/
#ifndef __BMAPI_h__
#define __BMAPI_h__

#ifdef __cplusplus
extern "C" 
{
#endif





/****************************************************************************
 *  Function Return Code
 ****************************************************************************/
#define BMAPI_OK                        0
#define BMAPI_MEMALLOC                  1       // memory allocation failed
#define BMAPI_READCONFIG                2       // read configuration failed
#define BMAPI_BUFSHORT                  3       // memory buffer too short
#define BMAPI_INVALID_HANDLE            4       // invalid handle
#define BMAPI_INVALID_PARAMETER         5       // one or more of parameters
                                                // are invalid
#define BMAPI_UNSUPPORT_PLATFORM        6       // platform not supported
#define BMAPI_INVALID_DATA_FROM_DRIVER  7       // driver returned data is not
                                                // correct
#define BMAPI_INTERNAL_DATA_ERROR       8       // internal data error
#define BMAPI_INIT_COM_FAILED           9       // initialize COM failed
#define BMAPI_TEAM_NOT_ENOUGH_NIC       10      // Each team must have at least
                                                // on team member and an
                                                // standby adapter or two team
                                                // members
#define BMAPI_INVALID_PHY_NIC_HANDLE    11      // an invalid physical NIC
                                                // handle is used
#define BMAPI_INVALID_TEAM_NAME         12      // the team name is empty or
                                                // has leading space
#define BMAPI_INVALID_TEAM_MEMBER       13      // all adapters of the same
                                                // driver class must be either
                                                // all assigned to teams or all
                                                // unassigned
#define BMAPI_INVALID_VLAN_MEMBER       14      // all physical adapters in the
                                                // team MUST be able to do VLAN
                                                // tag. Currently, only
                                                // BMAPI_ALTEON and
                                                // BMAPI_BRCM5700 can suppoort
                                                // VLAN
#define BMAPI_DRIVER_NOT_INSTALLED      15      // intermediate or miniport
                                                // driver not installed
#define BMAPI_CONFIGURE_REG_FAILED      16      // write registry failed
#define BMAPI_REBOOT_BEFORE_ADD         17      // reboot machine before add
                                                // adapter
#define BMAPI_LOAD_LIBRARY_FAILED       18      // load external help library
                                                // failed
#define BMAPI_CONFIGURE_SYS_FAILED      19      // configure system error
#define BMAPI_DRIVER_NOT_LOADED         20      // driver is not loaded
#define BMAPI_DEVIO_CALL_FAILED         21      // DeviceIoControl() failed
#define BMAPI_BINDING_FAILED            22      // binding is not completed
#define BMAPI_SERVICE_EXIST             23      // service is installed, users
                                                // may need to reboot machine
#define BMAPI_SERVICE_MARK_DELETE       24      // service is marked to delete,
                                                // users may need to reboot
                                                // machine
#define BMAPI_CREATE_SERVICE_FAILED     25      // unable to create service
#define BMAPI_DELETE_SERVICE_FAILED     26      // unable to delete service
#define BMAPI_REMOVE_ROUTE_FAILED       27      // RemoveRouteFromNETBIOS()
                                                // failed
#define BMAPI_DRIVER_COMMUNICATE_ERROR  28      // failed to communicate with
                                                // driver
#define BMAPI_FUNCTION_NOT_ALLOWED      29      // the other function should be
                                                // called before this function
                                                // can be called
#define BMAPI_INVALID_TEAM_ID           30      // invalid team ID
#define BMAPI_UPDATE_CONFIG_FAILED      31      // update configuration failed
#define BMAPI_WRONG_DRIVER_VERSION      32      // the version of driver is not
                                                // supported by BMAPI
#define BMAPI_NO_MAC_ADDR               33      // no MAC address configured
#define BMAPI_NO_VIRTUAL_ADAPTER        34      // no virtual adapter
                                                // configured for the team
#define BMAPI_NO_WRITE_ACCESS_RIGHT     35      // no write access right
#define BMAPI_NOT_SUPPORTED_NIC         36      // the NIC is not supported
#define BMAPI_STANDBY_NOT_SUPPORTED     37      // stand by adapter is not
                                                // supported for the team type
#define BMAPI_CAN_NOT_LOCK_NETCFG       38      // failed to lock network
                                                // configuration in Win2000
#define BMAPI_BMAPI_NOT_INITIALIZED     39      // applications did not call
                                                // BmapiInitialize()
#define BMAPI_EVENT_FEATURE_INI_FAILED  40      // initializeation for event
                                                // feature failed
#define BMAPI_DUPLICATE_TEAM_NAME       41      // applications submit
                                                // duplicate team name when
                                                // calling BmapiApplyLBFOCfg
#define BMAPI_DUPLICATE_PHY_NIC         42      // applications submit
                                                // duplicate physical NIC in
                                                // team configuration when
                                                // calling BmapiApplyLBFOCfg
#define BMAPI_NO_VLAN_NAME              43      // applications submit more
                                                // than one virtual adapter
                                                // for a team and one or more
                                                // virtual adapter doesn't have
                                                // a VLAN name when calling
                                                // BmapiApplyLBFOCfg
#define BMAPI_DUPLICATE_VLAN_NAME       44      // applications submit
                                                // duplicate VLAN name in a
                                                // team when calling
                                                // BmapiApplyLBFOCfg
#define BMAPI_DUPLICATE_VLAN_ID         45      // applications submit
                                                // duplicate VLAN ID in a
                                                // team when calling
                                                // BmapiApplyLBFOCfg
#define BMAPI_INVALID_VLAN_ID           46      // application submit invalid
                                                // VLAN ID when calling
                                                // BmapiApplyLBFOCfg. Valid
                                                // VLAN ID could be from 0 to
                                                // 4094.
#define BMAPI_TOO_MANY_TAGGED_VLANS     47      // we only support up to
                                                // BMAPI_MAXIMUM_MEMBERS_VIR_TEAM - 1
                                                // tagged VLANs plus one
                                                // optional untagged VLAN
#define BMAPI_TOO_MANY_PHY_NICS         48      // too many physical NICs in
                                                // a team
#define BMAPI_TOO_MANY_VIR_NICS         49      // too many virtual NICs in
                                                // a team
#define BMAPI_DUPLICATE_TEAM_ID         50      // applications submit
                                                // duplicate team ID when
                                                // calling BmapiApplyLBFOCfg
#define BMAPI_NIC_NOT_FOUND             51      // NIC not found
#define BMAPI_NIC_NOT_IN_TEAM           52      // NIC is not in the team
#define BMAPI_SCM_LOCKED                53      // service control manager is
                                                // locked
#define BMAPI_UNSUPPORTED_VERSION       54      // unsupported version for
                                                // the data structure
#define BMAPI_UNSUPPORTED_IOCTL         55      // unsupported IOCTL
#define BMAPI_ASF_NOT_CAPABLE           56      // the NIC is not capable of
                                                // ASF feature
#define BMAPI_ASF_NOT_CONFIGURED        57      // the NIC is not configured
                                                // for ASF
#define BMAPI_EEPROM_CORRUPTED          58      // EEPROM of the NIC is
                                                // corrupted
#define BMAPI_READ_EEPROM_FAILED        59      // read EEPROM failed
#define BMAPI_ASF_TABLE_CORRUPTED       60      // ASF table in NIC is
                                                // corrupted
#define BMAPI_SUSPEND_DRIVER_FAILED     61      // failed to suspend driver
                                                // or NIC
#define BMAPI_WRITE_ASF_TABLE_FAILED    62      // obsolete
#define BMAPI_LOCK_NIC_FAILED           63      // failed to gain exclusive
                                                // access to a NIC. Try later.
#define BMAPI_DRIVER_NOT_SUSPENDED      64
#define BMAPI_REGISTER_TEST_FAILED      65
#define BMAPI_MII_REGISTER_TEST_FAILED  66
#define BMAPI_MEMORY_TEST_FAILED        67
#define BMAPI_TEST_INTERRUPT_FAILED     68
#define BMAPI_CPU_TEST_FAILED           69
#define BMAPI_UNABLE_TO_RESET_RX_CPU    70
#define BMAPI_UNABLE_TO_RESET_TX_CPU    71
#define BMAPI_RX_CPU_TEST_FAILED        72
#define BMAPI_TX_CPU_TEST_FAILED        73
#define BMAPI_RESUME_DRIVER_FAILED      74
#define BMAPI_UNABLE_TO_GET_SERVICE_NAME    75
#define BMAPI_UNABLE_TO_LOAD_INTERMEDIATE_DRIVER    76
#define BMAPI_UNABLE_TO_SET_PACKET_FILTER   77
#define BMAPI_LOOPBACK_TEST_FAILED      78
#define BMAPI_NO_DIAG_ACCESS_RIGHT      79      // application did not call
                                                // BmapiInitDiag() with
                                                // successful return
#define BMAPI_WRITE_EEPROM_FAILED       80      // write EEPROM failed
#define BMAPI_ASF_TEST_RESET_FAILED     81      // ASF reset failed
#define BMAPI_ASF_TEST_RX_EVENT_FAILED  82      // ASF RXCPU event failed
#define BMAPI_ASF_TEST_TX_EVENT_FAILED  83      // ASF TXCPU event failed
#define BMAPI_ASF_TEST_POLL_TIMER_FAILED    84  // ASF poll timer failed
#define BMAPI_ASF_TEST_ATTN_LOC_FAILED  85      // ASF ATTN loc failed
#define BMAPI_ASF_TEST_HB_TIMER_FAILED  86      // ASF heartbeat timer failed
#define BMAPI_ASF_TEST_PL_TIMER_FAILED  87      // ASF poll legacy timer failed
#define BMAPI_ASF_TEST_RT_TIMER_FAILED  88      // ASF retransmit timer failed
#define BMAPI_ASF_TEST_WD_TIMER_FAILED  89      // ASF watchdog timer failed
#define BMAPI_ASF_TEST_NO_STAMP         90      // ASF timestamp counter is not
                                                // counting
#define BMAPI_NO_WRITE_EEPROM_PRIV      91      // No priviledge to write
                                                // EEPROM
#define BMAPI_FW_NOT_LOADED             92      // Firmware is not loaded
#define BMAPI_NO_READ_EEPROM_PRIV       93      // No priviledge to read
                                                // EEPROM
#define BMAPI_NO_SYSTEM_UUID            94      // no system UUID found
#define BMAPI_NO_ASF_TABLES             95      // no ASF tables found
#define BMAPI_UNSUPPORTED_FW_VERSION    96      // unsupported firmware version
#define BMAPI_INVALID_OFFSET_OR_LEN     97      // offset or length must be at
                                                // 32-bit alignment
#define BMAPI_READ_REGISTER_FAILED      98      // read register failed
#define BMAPI_WRITE_REGISTER_FAILED     99      // write register failed
#define BMAPI_NO_READ_NIC_MEM_PRIV      100     // no priviledge to read NIC
                                                // memory
#define BMAPI_READ_NIC_MEM_FAILED       101     // read NIC memory failed
#define BMAPI_NO_WRITE_NIC_MEM_PRIV     102     // no priviledge to write NIC
                                                // memory
#define BMAPI_WRITE_NIC_MEM_FAILED      103     // write NIC memory failed
#define BMAPI_CREATELOCK_FAILED         104     // create lock fialed
#define BMAPI_READ_PCI_CONFIG_FAILED    105     // read PCI configuration
#define BMAPI_FILE_OPEN_FAILED          106     // file open failed
#define BMAPI_MEM_MAP_FAILED            107     // map mempry failed
#define BMAPI_NO_IP_INFO                108     // can not find IP information
                                                // for an adapter, could be
                                                // driver is not loaded or
                                                // no IP bind to the adapter
#define BMAPI_NETTEST_INI_FAILED        109     // NetworkTest init failed
                                                // no IP protocol???
#define BMAPI_NETTEST_CFG_FAILED        110     // NetworkTest configure test
                                                // failed
#define BMAPI_NETTEST_ADAPT_NOIP        111     // adapter has no valid IP
#define BMAPI_NETTEST_ADAPT_BIND        112     // bind to adapter failed
#define BMAPI_NETTEST_INVALID_DEST      113     // invalid destination address
#define BMAPI_NETTEST_SEND_FAILED       114     // send packet failed
#define BMAPI_NETTEST_RECV_FAILED       115     // receive packet failed
#define BMAPI_NETTEST_TEST_FAILED       116     // no response received
#define BMAPI_INVALID_TEAMTYPE_CHANGE   117     // unsupported team type
                                                // changed
#define BMAPI_INVALID_TTCFG_PHY         118     // invalis physical NICs for
                                                // turbo teaming
#define BMAPI_UNSUPPORTED_TT_OS         119     // the OS is not supported by
                                                // turbo teaming
#define BMAPI_NO_TT_IN_BASP             120     // no TT can be in BASP team
#define BMAPI_NOT_TT_NIC                121     // the NIC does not support TT
#define BMAPI_CONFIG_TT_FAILED          122     // configure Turbo Team failed
#define BMAPI_INVALID_TEAMTYPE          123     // unsupported team type
#define BMAPI_NON_TT_DRIVER             124     // the driver does not support
                                                // TT



/****************************************************************************
 *  Other definitions
 ****************************************************************************/
#define BMAPI_MAJOR_VERSION             3
#define BMAPI_MINOR_VERSION             0
#define BMAPI_BUILD_VERSION             9

#define BMAPI_MAXIMUM_MEMBERS_PHY_TEAM  8
#define BMAPI_MAXIMUM_MEMBERS_VIR_TEAM  64

#define BMAPI_MEMBER_STATE_UP           0
#define BMAPI_MEMBER_STATE_DOWN         1
#define BMAPI_MEMBER_STATE_DISABLED     2

#define BMAPI_MEMBER_ROLE_LOAD_BALANCE  0
#define BMAPI_MEMBER_ROLE_STAND_BY      1

#define BMAPI_NON_BROADCOM_NIC          0
#define BMAPI_ALTEON                    1
#define BMAPI_BRCM5700                  2
#define BMAPI_UNKNOWN_NIC               3       // driver is not running

#define BMAPI_TEAM_BRCM_LBFO            0
#define BMAPI_TEAM_FEC_GEC              1
#define BMAPI_TEAM_802_3_AD             2
#define BMAPI_TEAM_TURBO                3
#define BMAPI_INVALID_TEAM_TYPE         0xFFFFFFFF

#define BMAPI_MAX_PRODUCT_LEN           80
#define BMAPI_MAX_DESC_LEN              80
#define BMAPI_MAX_VLAN_NAME_LEN         40
#define BMAPI_MAX_TEAM_NAME_LEN         40
#define BMAPI_MAX_IP_ADDR_LEN           20
#define BMAPI_MAX_MEMORY_ADDR_LEN       80
#define BMAPI_MAX_MAC_ADDR_LEN          20
#define BMAPI_MAX_TITLE_LEN             80
#define BMAPI_MAX_MFG_LEN               80
#define BMAPI_MAX_DRV_NAME              32
#define BMAPI_MAX_DRV_INT_TYPE          16
#define BMAPI_MAX_PNP_ID_LEN            120
#define BMAPI_MAX_DRVVER_LEN            40

#define BMAPI_LBFO_MINIPORT_NAME        "Blfm"
#define BMAPI_LBFO_MINIPORT_DESC        "Broadcom Ndis Miniport Driver"
#define BMAPI_LBFO_MINIPORT_TITLE       "BASP Virtual Adapter"

#define BMAPI_INVALID_NIC_HANDLE        0
#define BMAPI_INVALID_TEAM_HANDLE       0

#define BMAPI_MAX_VLAN_ID               4094

#define BMAPI_DRV_STATE_NORMAL_MODE         0
#define BMAPI_DRV_STATE_MEDIA_FAIL          1   // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_ADAPTER_CHECK       2   // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_DIAG_MODE           5
#define BMAPI_DRV_STATE_NIC_REMOVED         6   // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_LOW_POWER_MODE      7
#define BMAPI_DRV_STATE_USER_SIMULATE_FAIL  16  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_OFF_PENDING   32  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_OFF           48  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_OFF_FAULT     64  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_ON_PENDING    80  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_ON            96  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_ON_FAULT      112 // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_RESETTING           0xFFFFFFFF

#define BMAPI_LM_STATUS_LINK_ACTIVE     4
#define BMAPI_LM_STATUS_LINK_DOWN       5

#define BMAPI_LM_MEDIA_TYPE_UNKNOWN     ( U32 )-1
#define BMAPI_LM_MEDIA_TYPE_AUTO        0
#define BMAPI_LM_MEDIA_TYPE_UTP         1
#define BMAPI_LM_MEDIA_TYPE_BNC         2
#define BMAPI_LM_MEDIA_TYPE_AUI         3
#define BMAPI_LM_MEDIA_TYPE_FIBER       4

#define BMAPI_LM_LINE_SPEED_UNKNOWN     0
#define BMAPI_LM_LINE_SPEED_10MBPS      1
#define BMAPI_LM_LINE_SPEED_100MBPS     2
#define BMAPI_LM_LINE_SPEED_1000MBPS    3

#define BMAPI_LM_DUPLEX_MODE_UNKNOWN    0
#define BMAPI_LM_DUPLEX_MODE_HALF       1
#define BMAPI_LM_DUPLEX_MODE_FULL       2

#define BMAPI_LM_BUS_MODE_UNKNOWN       0
#define BMAPI_LM_BUS_MODE_PCI           1
#define BMAPI_LM_BUS_MODE_PCI_X         2

#define BMAPI_LM_BUS_CLOCK_UNKNOWN      0
#define BMAPI_LM_BUS_CLOCK_33MHZ        1
#define BMAPI_LM_BUS_CLOCK_66MHZ        2
#define BMAPI_LM_BUS_CLOCK_133MHZ       3
#define BMAPI_LM_BUS_CLOCK_100MHZ       4
#define BMAPI_LM_BUS_CLOCK_50MHZ        5

#define BMAPI_LM_BUS_SIZE_UNKNOWN       0
#define BMAPI_LM_BUS_SIZE_32BIT         1
#define BMAPI_LM_BUS_SIZE_64BIT         2

#define BMAPI_BUS_TYPE_UNKNOWN          0
#define BMAPI_BUS_TYPE_UNSUPPORTED      1
#define BMAPI_BUS_TYPE_PCI              2
#define BMAPI_BUS_TYPE_PCMCIA           3

#define BMAPI_LM_REQUESTED_MEDIA_TYPE_AUTO                      0x00000000
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS                0x00000003
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS_FULL_DUPLEX    0x00000004
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS               0x00000005
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS_FULL_DUPLEX   0x00000006

// Do NOT force speed on 1000Mbps.
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS              0x00000007
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS_FULL_DUPLEX  0x00000008

#define BMAPI_LBFO_STATUS_NOT_INSTALLED 0
#define BMAPI_LBFO_STATUS_NOT_LOADED    1
#define BMAPI_LBFO_STATUS_LOADED        2

// Used by BmapiGetMultiBRCMNicParams()
#define BMAPI_BRCMNIC_PARAM_TYPE_UNKNOWN    0
#define BMAPI_BRCMNIC_PARAM_TYPE_DWORD      1
#define BMAPI_BRCMNIC_PARAM_TYPE_BINARY     2   // binary data

#define BMAPI_BRCMNIC_PARAM_RESULT_OK           0
#define BMAPI_BRCMNIC_PARAM_RESULT_NOTEXIST     1   // not exist
#define BMAPI_BRCMNIC_PARAM_RESULT_NOTSUPPORTED 2   // not supported
#define BMAPI_BRCMNIC_PARAM_RESULT_ERROR        3   // registry reading error
#define BMAPI_BRCMNIC_PARAM_RESULT_BUFTOOSHORT  4   // buffer too short
#define BMAPI_BRCMNIC_PARAM_RESULT_WRONGDATALEN 5   // incorrect parameter data length
#define BMAPI_BRCMNIC_PARAM_RESULT_DATAINVALID  6   // invalid data value for the parameter

// Configurable Broadcom NIC parameters.
#define BMAPI_BRCMNIC_RXJUMBODESCCNT    0   // type: DWORD, range: 0-255, default: 0
#define BMAPI_BRCMNIC_TASKOFFLOADCAP    1   // type: DWORD
                                            // value: 0 - None (default)
                                            // value: 21 - Tx TCP/IP Checksum
                                            // value: 42 - Rx TCP/IP Checksum
                                            // value: 63 - Tx/Rx TCP/IP Checksum
#define BMAPI_BRCMNIC_WAKEUPMODECAP     2   // type: DWORD
                                            // value: 0 - None
                                            // value: 1 - Magic Packet
                                            // value: 2 - Wake Up Frame
                                            // value: 3 - Both (default)
#define BMAPI_BRCMNIC_FLOWCONTROLCAP    3   // type: DWORD
                                            // value: 0 - Disable (default)
                                            // value: 1 - Rx PAUSE
                                            // value: 2 - Tx PAUSE
                                            // value: 3 - Rx/Tx PAUSE
                                            // value: 2147483648 - Auto
#define BMAPI_BRCMNIC_ENABLE8021P       4   // type: DWORD
                                            // value: 0 - Disable (default)
                                            // value: 1 - Enable
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE    5   // type: DWORD
                                            // value: 1500 (bytes) (default)
                                            // value: 2000 (bytes)
                                            // value: 2500 (bytes)
                                            // value: 3000 (bytes)
                                            // value: 3500 (bytes)
                                            // value: 4000 (bytes)
                                            // value: 4500 (bytes)
                                            // value: 5000 (bytes)
                                            // value: 5500 (bytes)
                                            // value: 6000 (bytes)
                                            // value: 6500 (bytes)
                                            // value: 7000 (bytes)
                                            // value: 7500 (bytes)
                                            // value: 8000 (bytes)
#define BMAPI_BRCMNIC_NETWORKADDRESS    6   // type: binary (6 bytes)
#define BMAPI_BRCMNIC_WOL_SPEED         7   // type: DWORD
                                            // value: 0 - Auto (default)
                                            // value: 1 - 10 Mb
                                            // value: 2 - 100 Mb

// Parameter values for Broadcom NIC.
#define BMAPI_BRCMNIC_RXJUMBODESCCNT_MIN                0   // default
#define BMAPI_BRCMNIC_RXJUMBODESCCNT_MAX                255

#define BMAPI_BRCMNIC_TASKOFFLOADCAP_NONE               0   // default
#define BMAPI_BRCMNIC_TASKOFFLOADCAP_TXTCPIPCHKSUM      21
#define BMAPI_BRCMNIC_TASKOFFLOADCAP_RXTCPIPCHKSUM      42
#define BMAPI_BRCMNIC_TASKOFFLOADCAP_TXRXTCPIPCHKSUM    63

#define BMAPI_BRCMNIC_WAKEUPMODECAP_NONE                0
#define BMAPI_BRCMNIC_WAKEUPMODECAP_MAGICPACKET         1
#define BMAPI_BRCMNIC_WAKEUPMODECAP_WAKEUPFRAME         2
#define BMAPI_BRCMNIC_WAKEUPMODECAP_BOTH                3   // default

#define BMAPI_BRCMNIC_FLOWCONTROLCAP_DISABLE            0   // default
#define BMAPI_BRCMNIC_FLOWCONTROLCAP_RXPAUSE            1
#define BMAPI_BRCMNIC_FLOWCONTROLCAP_TXPAUSE            2
#define BMAPI_BRCMNIC_FLOWCONTROLCAP_RXTXPAUSE          3
#define BMAPI_BRCMNIC_FLOWCONTROLCAP_AUTO               2147483648

#define BMAPI_BRCMNIC_ENABLE8021P_DISABLE               0   // default
#define BMAPI_BRCMNIC_ENABLE8021P_ENABLE                1

#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_1500               1500    // default
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_2000               2000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_2500               2500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_3000               3000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_3500               3500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_4000               4000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_4500               4500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_5000               5000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_5500               5500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_6000               6000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_6500               6500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_7000               7000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_7500               7500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_8000               8000

#define BMAPI_BRCMNIC_WOL_SPEED_AUTO                    0   // default
#define BMAPI_BRCMNIC_WOL_SPEED_10MB                    1
#define BMAPI_BRCMNIC_WOL_SPEED_100MB                   2

// 'flags' in BM_ADAPTER_INFO_EX
#define BMAPI_NIC_NO_MINOPORT_DRV                       0x00000001
#define BMAPI_NIC_ASF_POSSIBLE                          0x00000002

// ASF definition
#define BMAPI_MAX_ALERTDATA                             8
#define BMAPI_ASF_SPEC_1_0_ALERTDATA_ELEMENT_LENGTH     12
#define BMAPI_MAX_CONTROLDATA                           8
#define BMAPI_MAX_SPEC_1_0_CONTROLDATA_ELEMENT_LENGTH   4

// since structure ASF_ADDR has extra 2 bytes other than FixedSMBusAddresses,
// to align the structure to LONG, BMAPI_MAX_FIXEDSMBUSADDR should use
// (multiple of 4) - 2. In this case, we are using 14.
#define BMAPI_MAX_FIXEDSMBUSADDR                        14

// speed defines for BM_ASF_MISC
#define BMAPI_ASF_SPEED_10_100          0
#define BMAPI_ASF_SPEED_10              1
#define BMAPI_ASF_SPEED_100             2
#define BMAPI_ASF_SPEED_1000            3
#define BMAPI_ASF_SPEED_ALL             4
#define BMAPI_ASF_SPEED_MASK            0x7

#define BMAPI_ASF_HALF_DUPLEX           0x20
#define BMAPI_ASF_PAUSE_NOT_CAPABLE     0x40
#define BMAPI_ASF_AUTO_DISABLE          0x80

// Definition for BmapiEnableDevice()
#define BMAPI_NIC_DISABLE               0
#define BMAPI_NIC_ENABLE                1
#define BMAPI_NIC_PROPCHANGE            2

#define BMAPI_FW_MAX_DESCRIPTION_LEN    16

// 'uType' definition for BmapiReadNicMem() and BmapiWriteNicMem().
#define BMAPI_INDIRECT_REG_READ         0
#define BMAPI_INDIRECT_MEM_READ         1
#define BMAPI_PHY_REG_READ              2

// 'uType' definition for BmapiGetIpAddrInfo().
#define BMAPI_IPINFO_IP_LIST            0
#define BMAPI_IPINFO_SUBNETMASK_LIST    1
#define BMAPI_IPINFO_GATEWAY_LIST       2

// 'uWhere' definition for BmapiGetPowerMode().
#define BMAPI_GET_POWER_MODE_DRIVER     0
#define BMAPI_GET_POWER_MODE_EEPROM     1

// 'uWhere' definition for BmapiSetPowerMode().
#define BMAPI_SET_POWER_MODE_DRIVER     0
#define BMAPI_SET_POWER_MODE_EEPROM     1
#define BMAPI_SET_POWER_MODE_BOTH       2       /* EEPROM and driver        */

// Mode definition for BmapiGetPowerMode and BmapiSetPowerMode().
#define BMAPI_POWER_MODE_FULL           0
#define BMAPI_POWER_MODE_LOW            1

// 'SupportedFlags' definition for BM_BRCM_ADAPTER_INFO_EX.
#define BMAPI_TURBO_TEAMING_ENABLE      0x00000001
#define BMAPI_TURBO_TEAMING_CAPABLE     0x00000002

// 'uOption' definition for BmapiWriteFirmwareInfo().
#define BMAPI_WR_FW_MANUFAC             0x00000001

#define BMAPI_MAX_COMMUNITY_NAME_LEN    20



/****************************************************************************/
/* Loopback type.                                                           */
/****************************************************************************/
#define BMAPI_LOOPBACK_TYPE_MAC         0
#define BMAPI_LOOPBACK_TYPE_PHY         1
#define BMAPI_LOOPBACK_TYPE_TWO_NODE    2
#define LOOPBACK_TYPE_MAC               BMAPI_LOOPBACK_TYPE_MAC
#define LOOPBACK_TYPE_PHY               BMAPI_LOOPBACK_TYPE_PHY
#define LOOPBACK_TYPE_TWO_NODE          BMAPI_LOOPBACK_TYPE_TWO_NODE



#ifdef _MSC_VER

//
// extra_info for EVT_ACTIVE and EVT_INACTIVE
//
#define BMAPI_EVINFO_ACTIVITY_LINK      0   // active/inactive due to link status
#define BMAPI_EVINFO_ACTIVITY_MANUAL    1   // active/inactive due to enable/disable
#define BMAPI_EVINFO_ACTIVITY_ADDREMOVE 2   // active/inactive due to add/remove
#define BMAPI_EVINFO_ACTIVITY_STANDBY   3   // active/inactive due to standby
#define BMAPI_EVINFO_ACTIVITY_NONE      0xFFFFFFFF

typedef enum
{
    BMAPI_EVT_ACTIVE = 0,       // adapter is active
    BMAPI_EVT_INACTIVE = 1,     // adapter is inactive
    BMAPI_EVT_LINKUP = 2,       // adapter's link status goes up
    BMAPI_EVT_LINKDOWN = 3,     // adapter's link status goes down
    BMAPI_EVT_ENABLE = 4,       // adapter is enabled via management interface
    BMAPI_EVT_DISABLE = 5,      // adapter is disabled via management interface
    BMAPI_EVT_ADD = 6,          // adapter is added to a team
    BMAPI_EVT_REMOVE = 7,       // adapter is removed from a team
    BMAPI_EVT_ASFCFG_CHG = 100, // adapter's ASF configuration is modified
    BMAPI_EVT_TT_ADD_REMOVE = 201,  // one or more TT is added and/or removed
    BMAPI_EVT_TT_LINKUP = 202,  // all ports on TT are link-up
    BMAPI_EVT_TT_LINKDOWN = 203,// all ports on TT are link-down
    BMAPI_EVT_TT_LINKDEGRADE= 204,  // at leat one port on TT is link-down,
                                    // but not all ports link-down

#if defined(__NETWARE__)
    BMAPI_EVT_DUMMY = 0xFFFFFFF    // make it a 32-bit variable
#else    
    BMAPI_EVT_DUMMY = 0xFFFFFFFF    // make it a 32-bit variable
#endif    
} BMAPI_EV_TYPE;


typedef void (*BMAPIEVENTCALLBACK)( U32 event, const S8 *team_name, U32 team_id, const S8 *adapter_service_name, U32 adapter_handle, U32 lb_number, U32 sb_number, U32 extra_info, void *cookie );

#ifndef BOOL
typedef int                 BOOL;
#endif

#else /* _MSC_VER */

typedef int   BOOL;
#define TRUE  1
#define FALSE 0

#endif /* _MSC_VER */





/****************************************************************************
 *  Data Structures
 ****************************************************************************/
typedef struct _BM_ADAPTER_INFO
{
    // NIC card type. Valid only for physical adapters.
    // BMAPI_NON_BROADCOM_NIC == non Broadcom NIC,
    // BMAPI_ALTEON == T2, BMAPI_BRCM5700 == T3, ...
    U32 nic_type;

    // Application use this handle number to indicate which adapter
    // it is referring to. If handle == BMAPI_INVALID_NIC_HANDLE,
    // The adapter is not found in current configuration.
    U32 handle;

    // pTitle will be the unique "friendly name" displayed to users.
    S8  title[BMAPI_MAX_TITLE_LEN];

    // Product name of the adapter. It Is used to IdentIfy whether two
    // adapters belong the same class of driver.
    S8  product_name[BMAPI_MAX_PRODUCT_LEN];

    // Physical adapter type in a team whether is part of a load
    // balancing team or a fail over adapter.
    // BMAPI_MEMBER_ROLE_LOAD_BALANCE == use for load balancing or unassigned.
    // BMAPI_MEMBER_ROLE_STAND_BY == fail over adapter (standby).
    U32 member_type;

    // Description of the adapter. May not be available for all adapters.
    S8  description[BMAPI_MAX_DESC_LEN];

    // Boolean flag to denote if DHCP is enabled.
    // Not available in non Windows platforms.
    U32 dhcp_enabled;

    // IP address is "192.168.0.1" format. (REG_MULTI_SZ or REG_SZ)
    S8  ip_addr[BMAPI_MAX_IP_ADDR_LEN];

    // subnet mask is "255.255.0.0" format. (REG_MULTI_SZ or REG_SZ)
    S8  subnet_mask[BMAPI_MAX_IP_ADDR_LEN];

    // defaule gateway is "192.168.0.1" format. (REG_MULTI_SZ or REG_SZ)
    S8  default_gateway[BMAPI_MAX_IP_ADDR_LEN];

    // Boolean flag to indicate whether driver is running.
    U32 driver_loaded;

    // These information is valid only driver is running.
    S8  current_mac_addr[BMAPI_MAX_MAC_ADDR_LEN];
    S8  permanent_mac_addr[BMAPI_MAX_MAC_ADDR_LEN];
#ifdef _MSC_VER
    U32 major_version_number;
    U32 minor_version_number;
#else /* _MSC_VER */
    U8  driver_version[BMAPI_MAX_DRVVER_LEN];
#endif /* _MSC_VER */

    // VLAN ID should be filled here. VLAN ID should greater or equal
    // to 1. Exist only for virtual adapters.
    U32 vlan_id;
    S8  vlan_name[BMAPI_MAX_VLAN_NAME_LEN];

    // State of this adapter, can be either up, down or disabled. This
    // is valid only when data is retrieved from BmapiGetTeamSnapShot().
    // Possible value:
    // BMAPI_MEMBER_STATE_UP, BMAPI_MEMBER_STATE_DOWN,
    // BMAPI_MEMBER_STATE_DISABLED
    U32 state;

    // Link speed of the physical NIC in Mbps, i.e. 10 = 10Mbps. This
    // is valid only when physical NIC card data is retrieved from
    // BmapiGetTeamSnapShot()
    U32 link_speed;

} BM_ADAPTER_INFO;



#define BMAPI_ADAPTER_INFO_EX_VER       4

typedef struct _BM_ADAPTER_INFO_EX
{
    //  Version is defined as BMAPI_ADAPTER_INFO_EX_VER.
    //  'version' is required upon input
    U32                 version;

    U32                 flags;
    BM_ADAPTER_INFO     adap_info;

    // If PCI IDs information is not available, the value will be -1 and
    // 'manufacturer' will be "".
    U32                 vendor_id;
    U32                 device_id;
    U32                 subsystem_vendor_id;
    U32                 subsystem_id;
    U8                  manufacturer[BMAPI_MAX_MFG_LEN];

    // revision from PCI bus registers 0x08
    U32                 revision;

    // PCI bus information. If these information are not available,
    // data will be set to -1.
    U32                 bus_no;
    U32                 device_no;
    U32                 function_no;

    // PCI slot number labeled next to motherboard. This is an optional
    // field (at least, LOM will not have it). If it is not available,
    // this field will be set to -1.
    U32                 ui_number;

    // PCI information
    U32                 mem_base_low;
    U32                 mem_base_high;
    U32                 irq;

    // NIC information
    // Available only when vendor_id equal to 0x14E4.
    U32                 phy_id;
    U32                 phy_addr;

    //  ChipId:4, ChipRev:4, MetalRev:8
    // For example :
    // 5700 A1 : 0x7000 : chip ID 0x7, chip rev 0x0, metal rev 0x01
    // 5700 B2 : 0x7000 : chip ID 0x7, chip rev 0x1, metal rev 0x02
    // 5701 A3 : 0x0003 : chip ID 0x0, chip rev 0x0, metal rev 0x03
    U32                 chip_rev_id;

    U32                 media_type;

    // Possible value:
    // BMAPI_LM_LINE_SPEED_UNKNOWN, BMAPI_LM_LINE_SPEED_10MBPS,
    // BMAPI_LM_LINE_SPEED_100MBPS, BMAPI_LM_LINE_SPEED_1000MBPS
    U32                 line_speed;

    // Possible value:
    // BMAPI_LM_STATUS_LINK_ACTIVE, BMAPI_LM_STATUS_LINK_DOWN
    U32                 link_status;

#ifndef _MSC_VER
    // Possible value:
    // BMAPI_LM_DUPLEX_MODE_UNKNOWN, BMAPI_LM_DUPLEX_MODE_HALF
    // BMAPI_LM_DUPLEX_MODE_FULL
    U32                 duplex_mode;
#endif /* _MSC_VER */

    // NIC information
    // Available only when vendor_id equal to 0x14E4.
    U32                 upper_misc_host_ctrl_reg;

    // Driver information
    U8                  driver_name[BMAPI_MAX_DRV_NAME];
    U32                 driver_size;
    U8                  driver_interface_type[BMAPI_MAX_DRV_INT_TYPE];
    U32                 driver_interface_version_major;
    U32                 driver_interface_version_minor;

    // NIC information
    // Available only when vendor_id equal to 0x14E4.
    U32                 internal_ram_size;

    // Could be BMAPI_BUS_TYPE_UNKNOWN, BMAPI_BUS_TYPE_UNSUPPORTED,
    // BMAPI_BUS_TYPE_PCI or BMAPI_BUS_TYPE_PCMCIA
    U32                 bus_type;

} BM_ADAPTER_INFO_EX;



// This structure is for Broadcom BASP virtual adapter only.
#define BMAPI_VIR_NIC_INFO_EX_VER       1

typedef struct _BM_VIR_NIC_INFO_EX
{
    //  Version is defined as BMAPI_VIR_NIC_INFO_EX_VER.
    //  'version' is required upon input
    U32                 version;

    BM_ADAPTER_INFO     adap_info;

    // Possible value:
    // BMAPI_LM_STATUS_LINK_ACTIVE, BMAPI_LM_STATUS_LINK_DOWN
    U32                 link_status;

    // Driver information
    U8                  driver_name[BMAPI_MAX_DRV_NAME];
    U32                 driver_size;
    U8                  driver_interface_type[BMAPI_MAX_DRV_INT_TYPE];
    U32                 driver_interface_version_major;
    U32                 driver_interface_version_minor;

} BM_VIR_NIC_INFO_EX;



typedef struct _BM_BRCM_ADAPTER_INFO
{
    // This structure will host all Broadcom proprietary static data.
    // Ststistic data will be host in separate data structure.

    // PCI information.
    U32 bus_no;
    U32 device_no;
    U32 function_no;
    U32 vendor_id;
    U32 device_id;
    U32 subsystem_vendor_id;
    U32 subsystem_id;
    U32 mem_base_low;
    U32 mem_base_high;

    // Possible value:
    // BMAPI_LM_BUS_MODE_UNKNOWN, BMAPI_LM_BUS_MODE_PCI,
    // BMAPI_LM_BUS_MODE_PCI_X
    U32 mode;

    // Possible value:
    // BMAPI_LM_BUS_CLOCK_UNKNOWN, BMAPI_LM_BUS_CLOCK_33MHZ,
    // BMAPI_LM_BUS_CLOCK_66MHZ, BMAPI_LM_BUS_CLOCK_133MHZ,
    // BMAPI_LM_BUS_CLOCK_100MHZ, BMAPI_LM_BUS_CLOCK_50MHZ
    U32 clock;

    // Possible value:
    // BMAPI_LM_BUS_SIZE_UNKNOWN, BMAPI_LM_BUS_SIZE_32BIT,
    // BMAPI_LM_BUS_SIZE_64BIT
    U32 bus_size;

    // Chip information.

    /* OUI: bit 31-10;   Model#: bit 9-4;   Rev# bit 3-0. */
    U32 phy_id;

    U32 phy_addr;
    U32 irq;

    //  ChipId:4, ChipRev:4, MetalRev:8
    // For example :
    // 5700 A1 : 0x7000 : chip ID 0x7, chip rev 0x0, metal rev 0x01
    // 5700 B2 : 0x7000 : chip ID 0x7, chip rev 0x1, metal rev 0x02
    // 5701 A3 : 0x0003 : chip ID 0x0, chip rev 0x0, metal rev 0x03
    // 5703 A0 : 0x1000 : chip ID 0x1, chip rev 0x0, metal rev 0x00
    // 5704 A0 : 0x2003 : chip ID 0x2, chip rev 0x0, metal rev 0x00
    U32 chip_rev;

    U8  mac_address[8];         // Adapter's MAC address.

    // Driver information.
    U32 mapped_mem_base;

    // Possible value:
    // BMAPI_LM_MEDIA_TYPE_UNKNOWN, BMAPI_LM_MEDIA_TYPE_AUTO,
    // BMAPI_LM_MEDIA_TYPE_UTP, BMAPI_LM_MEDIA_TYPE_BNC,
    // BMAPI_LM_MEDIA_TYPE_AUI, BMAPI_LM_MEDIA_TYPE_FIBER
    U32 media_type;

    // Possible value:
    // BMAPI_LM_LINE_SPEED_UNKNOWN, BMAPI_LM_LINE_SPEED_10MBPS,
    // BMAPI_LM_LINE_SPEED_100MBPS, BMAPI_LM_LINE_SPEED_1000MBPS
    U32 line_speed;

    // Possible value:
    // BMAPI_LM_DUPLEX_MODE_UNKNOWN, BMAPI_LM_DUPLEX_MODE_HALF
    // BMAPI_LM_DUPLEX_MODE_FULL
    U32 duplex_mode;

    // Possible value:
    // BMAPI_LM_STATUS_LINK_ACTIVE, BMAPI_LM_STATUS_LINK_DOWN
    U32 link_status;

    U8  node_address[8];        // Current network address.
    U32 drv_major_ver;
    U32 drv_minor_ver;

    // Possible value:
    // BMAPI_DRV_STATE_NORMAL_MODE, BMAPI_DRV_STATE_DIAG_MODE,
    // BMAPI_DRV_STATE_NIC_REMOVED, BMAPI_DRV_STATE_LOW_POWER_MODE
    U32 drv_state;

} BM_BRCM_ADAPTER_INFO;



#define BMAPI_BRCM_ADAPTER_INFO_EX_VER   3

typedef struct _BM_BRCM_ADAPTER_INFO_EX
{
    // This structure will host all Broadcom proprietary static data.
    // Ststistic data will be host in separate data structure.

    //  Latest version is defined as BMAPI_BRCM_ADAPTER_INFO_EX_VER.
    //  'version' is required upon input
    U32                     version;

    BM_BRCM_ADAPTER_INFO    brcm_info;

    // Defined flags:
    // BMAPI_TURBO_TEAMING_ENABLE, BMAPI_TURBO_TEAMING_CAPABLE
    U32                     SupportedFlags;

    U32                     RequestedMediaType;
    U32                     DisableAutoNeg;

    // This data apply to 5704 NIC only.
    U32                     DualMACCtrlReg;

    // Max. speed for the NIC.
    // Value is the same as 'line_speed'.
    U32                     MaxSpeed;

    U32                     reserved[6];

} BM_BRCM_ADAPTER_INFO_EX;



typedef struct _BM_TEAM_INFO
{
    // Team name.
    S8  team_name[BMAPI_MAX_TEAM_NAME_LEN];

    // Team ID
    U32 team_id;

    // Team Type. BMAPI_TEAM_BRCM_LBFO == Broadcom LBFO,
    // BMAPI_TEAM_802_3_AD == 802.3ad, BMAPI_TEAM_FEC_GEC == FEC/GEC
    U32 team_type;

    // NetworkAddress. It is set if team_type == BMAPI_TEAM_FEC_GEC.
    S8  network_addr[BMAPI_MAX_MAC_ADDR_LEN];

    // number of valid physical adapters in the team
    U32 phy_count;

    // information of each team member
    BM_ADAPTER_INFO phy_member[BMAPI_MAXIMUM_MEMBERS_PHY_TEAM];

    // number of valid virtual adapters in the team
    U32 vir_count;

    // information for team configuration
    BM_ADAPTER_INFO vir_member[BMAPI_MAXIMUM_MEMBERS_VIR_TEAM];

} BM_TEAM_INFO;



typedef struct _BM_PHY_NIC_STATISTICS
{
    // Application use this handle number to know which adapter
    // this statistic structure is referring to.
    U32 handle;

    // number of send request completed by miniport
    U32 send_packet;

    // number of send request discarded
    U32 send_discarded;

    // number of send request dispatched to miniport
    U32 send_dispatched;

    // number of receive packets that are indicated to upper layer
    U32 recv_packet;

    // number of receive packets discarded
    U32 recv_discarded;

    // number of receive discarded because it's too big
    U32 recv_oversize;

} BM_PHY_NIC_STATISTICS;



typedef struct _BM_VIR_NIC_STATISTICS
{
    // Application use this handle number to know which adapter
    // this statistic structure is referring to.
    U32 handle;

    // number of send request discarded for various reasons
    U32 send_all_down;

    // number of send request being queued because out of NDIS_PACKET
    U32 send_queued;

    // number of send request completed
    U32 send_completed;

    // number of receive indicated to upper layer successfully 
    U32 recv_indicated;

} BM_VIR_NIC_STATISTICS;



typedef struct _BM_TEAM_STATISTICS
{
    // Team name.
    S8                      team_name[BMAPI_MAX_TEAM_NAME_LEN];

    // number of send packets that are forwarded to the team members,
    // derived from physical adapter statistics
    U32                     send_packet;

    // number of send packets that are discarded,
    // derived from physical adapter statistics
    U32                     send_discarded;

    // number of send packets that are discarded because all the team 
    // members are malfunctioned, derived from virtual adapter statistics.
    U32                     send_all_down;

    // number of send packets queued by BLF driver waiting for resource
    // derived from virtual adapter statistics.
    U32                     send_queued;

    // number of send packets originated from BLF driver
    U32                     send_adjusted;

    // number of receive packets that are indicated to upper layer,
    // derived from physical adapter statistics
    U32                     recv_packet;

    // number of receive packets discarded, 
    // derived from physical adapter statistics
    U32                     recv_discarded;

    // number of receive discarded because it's too big,
    // derived from physical adapter statistics
    U32                     recv_oversize;

    // number of receive indicated to upper layer successfully 
    // derived from virtual adapter statistics
    U32                     recv_indicated;

    // physical adapter statistics
    // number of valid physical adapters
    U32                     phy_count;

    // statistics of each team member
    BM_PHY_NIC_STATISTICS   phy_member[BMAPI_MAXIMUM_MEMBERS_PHY_TEAM];

    // virtual adapter statistics
    // number of valid virtual adapters
    U32                     vir_count;

    // statistics of each virtual adapter
    BM_VIR_NIC_STATISTICS   vir_member[BMAPI_MAXIMUM_MEMBERS_VIR_TEAM];
} BM_TEAM_STATISTICS;




typedef struct _BM_GENERAL_STATISTICS
{
    U32 xmit_ok;                // OID_GEN_XMIT_OK
    U32 rcv_ok;                 // OID_GEN_RCV_OK
    U32 xmit_error;             // OID_GEN_XMIT_ERROR
    U32 rcv_error;              // OID_GEN_RCV_ERROR
    U32 rcv_no_buffer;          // OID_GEN_RCV_NO_BUFFER
    U64 directed_bytes_xmit;    // OID_GEN_DIRECTED_BYTES_XMIT
    U32 directed_frames_xmit;   // OID_GEN_DIRECTED_FRAMES_XMIT
    U64 multicast_bytes_xmit;   // OID_GEN_MULTICAST_BYTES_XMIT
    U32 multicast_frames_xmit;  // OID_GEN_MULTICAST_FRAMES_XMIT
    U64 broadcast_bytes_xmit;   // OID_GEN_BROADCAST_BYTES_XMIT
    U32 broadcast_frames_xmit;  // OID_GEN_BROADCAST_FRAMES_XMIT
    U64 directed_bytes_rcv;     // OID_GEN_DIRECTED_BYTES_RCV
    U32 directed_frames_rcv;    // OID_GEN_DIRECTED_FRAMES_RCV
    U64 multicast_bytes_rcv;    // OID_GEN_MULTICAST_BYTES_RCV
    U32 multicast_frames_rcv;   // OID_GEN_MULTICAST_FRAMES_RCV
    U64 broadcast_bytes_rcv;    // OID_GEN_BROADCAST_BYTES_RCV
    U32 broadcast_frames_rcv;   // OID_GEN_BROADCAST_FRAMES_RCV
    U32 rcv_crc_error;          // OID_GEN_RCV_CRC_ERROR
    U32 transimit_queue_length; // OID_GEN_TRANSMIT_QUEUE_LENGTH
} BM_GENERAL_STATISTICS;



typedef struct _BM_GENERAL_STATISTICS64
{
    U64 xmit_ok;                // OID_GEN_XMIT_OK
    U64 rcv_ok;                 // OID_GEN_RCV_OK
    U64 xmit_error;             // OID_GEN_XMIT_ERROR
    U64 rcv_error;              // OID_GEN_RCV_ERROR
    U64 rcv_no_buffer;          // OID_GEN_RCV_NO_BUFFER
    U64 directed_bytes_xmit;    // OID_GEN_DIRECTED_BYTES_XMIT
    U64 directed_frames_xmit;   // OID_GEN_DIRECTED_FRAMES_XMIT
    U64 multicast_bytes_xmit;   // OID_GEN_MULTICAST_BYTES_XMIT
    U64 multicast_frames_xmit;  // OID_GEN_MULTICAST_FRAMES_XMIT
    U64 broadcast_bytes_xmit;   // OID_GEN_BROADCAST_BYTES_XMIT
    U64 broadcast_frames_xmit;  // OID_GEN_BROADCAST_FRAMES_XMIT
    U64 directed_bytes_rcv;     // OID_GEN_DIRECTED_BYTES_RCV
    U64 directed_frames_rcv;    // OID_GEN_DIRECTED_FRAMES_RCV
    U64 multicast_bytes_rcv;    // OID_GEN_MULTICAST_BYTES_RCV
    U64 multicast_frames_rcv;   // OID_GEN_MULTICAST_FRAMES_RCV
    U64 broadcast_bytes_rcv;    // OID_GEN_BROADCAST_BYTES_RCV
    U64 broadcast_frames_rcv;   // OID_GEN_BROADCAST_FRAMES_RCV
    U64 rcv_crc_error;          // OID_GEN_RCV_CRC_ERROR
    U64 transimit_queue_length; // OID_GEN_TRANSMIT_QUEUE_LENGTH
} BM_GENERAL_STATISTICS64;



typedef struct _BM_ETHERNET_STATISTICS
{
    U32 rcv_error_alignment;    //OID_802_3_RCV_ERROR_ALIGNMENT
    U32 xmit_one_collision;     //OID_802_3_XMIT_ONE_COLLISION
    U32 xmit_more_collisions;   //OID_802_3_XMIT_MORE_COLLISIONS
    U32 xmit_deferred;          //OID_802_3_XMIT_DEFERRED
    U32 xmit_max_collisions;    //OID_802_3_XMIT_MAX_COLLISIONS
    U32 rcv_overrun;            //OID_802_3_RCV_OVERRUN
    U32 xmit_underrun;          //OID_802_3_XMIT_UNDERRUN
    U32 xmit_heartbeat_failure; //OID_802_3_XMIT_HEARTBEAT_FAILURE
    U32 xmit_times_crs_lost;    //OID_802_3_XMIT_TIMES_CRS_LOST
    U32 xmit_late_collisions;   //OID_802_3_XMIT_LATE_COLLISIONS
} BM_ETHERNET_STATISTICS;



typedef struct _BM_ETHERNET_STATISTICS64
{
    U64 rcv_error_alignment;    //OID_802_3_RCV_ERROR_ALIGNMENT
    U64 xmit_one_collision;     //OID_802_3_XMIT_ONE_COLLISION
    U64 xmit_more_collisions;   //OID_802_3_XMIT_MORE_COLLISIONS
    U64 xmit_deferred;          //OID_802_3_XMIT_DEFERRED
    U64 xmit_max_collisions;    //OID_802_3_XMIT_MAX_COLLISIONS
    U64 rcv_overrun;            //OID_802_3_RCV_OVERRUN
    U64 xmit_underrun;          //OID_802_3_XMIT_UNDERRUN
    U64 xmit_heartbeat_failure; //OID_802_3_XMIT_HEARTBEAT_FAILURE
    U64 xmit_times_crs_lost;    //OID_802_3_XMIT_TIMES_CRS_LOST
    U64 xmit_late_collisions;   //OID_802_3_XMIT_LATE_COLLISIONS
} BM_ETHERNET_STATISTICS64;



typedef struct _BM_BRCM_STATISTICS
{
    // Statistics maintained by Receive MAC.
    U64 ifHCInOctets;
    U64 etherStatsFragments;
    U64 ifHCInUcastPkts;
    U64 ifHCInMulticastPkts;
    U64 ifHCInBroadcastPkts;
    U64 dot3StatsFCSErrors;
    U64 dot3StatsAlignmentErrors;
    U64 xonPauseFramesReceived;
    U64 xoffPauseFramesReceived;
    U64 macControlFramesReceived;
    U64 xoffStateEntered;
    U64 dot3StatsFramesTooLong;
    U64 etherStatsJabbers;
    U64 etherStatsUndersizePkts;
    U64 inRangeLengthError;
    U64 outRangeLengthError;
    U64 etherStatsPkts64Octets;
    U64 etherStatsPkts65Octetsto127Octets;
    U64 etherStatsPkts128Octetsto255Octets;
    U64 etherStatsPkts256Octetsto511Octets;
    U64 etherStatsPkts512Octetsto1023Octets;
    U64 etherStatsPkts1024Octetsto1522Octets;
    U64 etherStatsPkts1523Octetsto2047Octets;
    U64 etherStatsPkts2048Octetsto4095Octets;
    U64 etherStatsPkts4096Octetsto8191Octets;
    U64 etherStatsPkts8192Octetsto9022Octets;

    // Statistics maintained by Transmit MAC.
    U64 ifHCOutOctets;
    U64 etherStatsCollisions;
    U64 outXonSent;
    U64 outXoffSent;
    U64 flowControlDone;
    U64 dot3StatsInternalMacTransmitErrors;
    U64 dot3StatsSingleCollisionFrames;
    U64 dot3StatsMultipleCollisionFrames;
    U64 dot3StatsDeferredTransmissions;
    U64 dot3StatsExcessiveCollisions;
    U64 dot3StatsLateCollisions;
    U64 dot3Collided2Times;
    U64 dot3Collided3Times;
    U64 dot3Collided4Times;
    U64 dot3Collided5Times;
    U64 dot3Collided6Times;
    U64 dot3Collided7Times;
    U64 dot3Collided8Times;
    U64 dot3Collided9Times;
    U64 dot3Collided10Times;
    U64 dot3Collided11Times;
    U64 dot3Collided12Times;
    U64 dot3Collided13Times;
    U64 dot3Collided14Times;
    U64 dot3Collided15Times;
    U64 ifHCOutUcastPkts;
    U64 ifHCOutMulticastPkts;
    U64 ifHCOutBroadcastPkts;
    U64 dot3StatsCarrierSenseErrors;
    U64 ifOutDiscards;
    U64 ifOutErrors;

    // Statistics maintained by Receive List Placement.
    U64 COSIfHCInPkts[16];
    U64 COSFramesDroppedDueToFilters;
    U64 nicDmaWriteQueueFull;
    U64 nicDmaWriteHighPriQueueFull;
    U64 nicNoMoreRxBDs;
    U64 ifInDiscards;
    U64 ifInErrors;
    U64 nicRecvThresholdHit;

    // Statistics maintained by Send Data Initiator.
    U64 COSIfHCOutPkts[16];
    U64 nicDmaReadQueueFull;
    U64 nicDmaReadHighPriQueueFull;
    U64 nicSendDataCompQueueFull;

    // Statistics maintained by Host Coalescing.
    U64 nicRingSetSendProdIndex;
    U64 nicRingStatusUpdate;
    U64 nicInterrupts;
    U64 nicAvoidedInterrupts;
    U64 nicSendThresholdHit;

} BM_BRCM_STATISTICS;



typedef struct _BM_LINK_STATUS
{
    U32 link_status;            // 1 = Link Pass, 0 = Link Fail
    U32 local_Rx_status;        // 1 = Local Receive OK
                                // 0 = Local Receive Error
    U32 remote_Rx_status;       // 1 = Remote Receive OK
                                // 0 = Remote Receive Error
    U32 auto_negotiation_mode;  // 1 = AutoNegotiation is enabled
                                // 0 = Forced speed
    U32 requested_media_type;   // BMAPI_LM_REQUESTED_MEDIA_TYPE_AUTO
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS_FULL_DUPLEX
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS_FULL_DUPLEX
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS_FULL_DUPLEX
    U32 duplex_mode;            // 0 = half duplex
                                // 1 = full duplex
    U32 link_speed;             // BMAPI_LM_LINE_SPEED_UNKNOWN
                                // BMAPI_LM_LINE_SPEED_10MBPS
                                // BMAPI_LM_LINE_SPEED_100MBPS
                                // BMAPI_LM_LINE_SPEED_1000MBPS

} BM_LINK_STATUS;



typedef struct _BM_BRCM_NIC_PARAM_REQ
{
    U32     num_of_params;
    U8      param_id_List[1];
} BM_BRCM_NIC_PARAM_REQ;



typedef struct _BM_BRCM_NIC_PARAM_DATA
{
    U32     param_id;
    U32     param_type;
    U32     param_data_len;
    U32     result;
    U32     offset_next_param;
    U8      param_data[1];
} BM_BRCM_NIC_PARAM_DATA;



#define BMAPI_NIC_PCI_INFO_VER          2

typedef struct _BM_NIC_PCI_INFO
{
    //  Version is defined as BMAPI_NIC_PCI_INFO_VER.
    //  'version' is required upon input
    U16     version;

    // If PCI IDs information is not available, the value will be -1 and
    // 'manufacturer' will be "".
    U16     vendor_id;
    U16     device_id;
    U16     subsystem_vendor_id;
    U16     subsystem_id;
    U8      manufacturer[BMAPI_MAX_MFG_LEN];

    // hardware revision
    U32     revision;

    // PCI bus information. If these information are not available,
    // data will be set to -1.
    U32     bus_no;
    U32     device_no;
    U32     function_no;

    // PCI slot number labeled next to motherboard (W2k only).
    // This is an optional field (at least, LOM will not have it).
    // If it is not available, this field will be set to -1.
    U32     ui_number;

    // PCI information
    U32     mem_base_low;
    U32     mem_base_high;
    U32     irq;

} BM_NIC_PCI_INFO;



//  ASF tables (base on ASF 1.0)
typedef struct _BM_ASF_INFO
{
    U8      MinWatchdogResetValue;
    U8      MinPollingInterval;
    U16     SystemID;

    U8      IANAManufacturerID[4];

    U8      Reserved[4];
} BM_ASF_INFO;

typedef struct _BM_ASF_ALERTDATA
{
    U8      DeviceAddress;
    U8      Command;
    U8      DataMask;
    U8      CompareValue;

    U8      EventSensorType;
    U8      EventType;
    U8      EventOffset;
    U8      EventSourceType;

    U8      EventSeverity;
    U8      SensorNumber;
    U8      Entity;
    U8      EntityInstance;
} BM_ASF_ALERTDATA;

typedef struct _BM_ASF_ALRT
{
    U16                     Reserved;
    U8                      NumberOfAlerts;
    U8                      ArrayElementLength;

    BM_ASF_ALERTDATA        AsfAlertData[BMAPI_MAX_ALERTDATA];
} BM_ASF_ALRT;

typedef struct _BM_ASF_CONTROLDATA
{
    U8      Function;
    U8      DeviceAddress;
    U8      Command;
    U8      DataValue;
} BM_ASF_CONTROLDATA;

typedef struct _BM_ASF_RCTL
{
    U8                      NumberOfControl;
    U8                      ArrayElementLength;
    /* to align to dword */
    U8                      filler[2];
    BM_ASF_CONTROLDATA      AsfControlData[BMAPI_MAX_CONTROLDATA];
} BM_ASF_RCTL;

typedef struct _BM_ASF_RMCP
{
    U8      RemoteControlCapabilities[7];
    U8      RMCPCompletionCode;

    U8      RMCPIANA[4];

    U8      RMCPSpecialCommand;
    U8      RMCPSpecialCommandParameter[2];
    U8      RMCPBootOptions[2];
    U8      RMCPOEMParameters[2];

    /* to align to dword */
    U8      filler;
} BM_ASF_RMCP;

typedef struct _BM_ASF_ADDR
{
    U8      SEEPROMAddress;
    U8      NumberOfDevices;
    U8      FixedSMBusAddresses[BMAPI_MAX_FIXEDSMBUSADDR];
} BM_ASF_ADDR;

struct BM_ASF_CFG
{
    U32     EnableASF           : 1;
    U32     EnableHeartBeat     : 1;
    U32     EnableRMCP          : 1;
    U32     EnablePET           : 1;
    // Enable/Disable WoL on ARP or RMCP packet, while in OS absent
    U32     EnableASFWoL        : 1;
    // Enable/Disable our NIC as a passive Slave Mode.
    // No ARP or Scan on the SMBus.
    U32     EnableSMBusScan     : 1;
    U32     reserved            : 26;
};

typedef struct _BM_ASF_MISC
{
    union {
        struct BM_ASF_CFG   Config;
        U32                 ConfigData;
    } cfg;

    U8      UuidGuid[16];

    U16     HeartBeatTimeValue;     /* in second */
    U8      reserved1[2];

    U8      DelayedPollTimeValue;   /* in second */
    U8      Speed;                  /* see speed defines above */
    U8      ReTransmitTimeValue;    /* in second */
    U8      LegacyPollTimeValue;    /* in second */

    U8      SysIP[4];
    U8      ManagementConsolIP[4];
    U8      GateWayIP[4];
    U8      subnetMask[4];
    U8      communityName[BMAPI_MAX_COMMUNITY_NAME_LEN];
    U8      reserved2[12];
} BM_ASF_MISC;

#define BMAPI_MAX_INIT_DATA 50

typedef struct _BM_SMB_INIT_DATA {
    U8      addr;
    U8      index;
    U8      andMask;
    U8      orMask;
} BM_SMB_INIT_DATA;

//  We will use BMAPI_ASF_T_VERSION to identify the current version of asf_t.
//  Whenever the table is changed for release, BMAPI_ASF_T_VERSION should
//  increase.
#define BMAPI_ASF_T_VERSION         5

typedef struct _BM_ASF_TABLE
{
    U8                  version;    /* version of the table */
    U8                  smbusAddr;  /* forced NIC smbus address, 0 means */
                                    /* use ARP, other value to force */
                                    /* smbus address */
    U8                  reserved[2];
    BM_ASF_INFO         AsfInfo;
    BM_ASF_ALRT         AsfAlert;
    BM_ASF_RCTL         AsfRCtl;
    BM_ASF_RMCP         AsfRmcp;
    BM_ASF_ADDR         AsfAddr;
    BM_ASF_MISC         AsfGui;
    BM_SMB_INIT_DATA    smbInitData[BMAPI_MAX_INIT_DATA];
    U32                 chksum;

    // ASF firmware version description string.
    U8                  firmware_ver_desc[BMAPI_FW_MAX_DESCRIPTION_LEN];

    U32                 fw_asfcfg_ver;      /* firmware asfcfg version */

} BM_ASF_TABLE;



/****************************************************************************/
/* Firmware information and definition                                      */
/*                                                                          */
/* ATTENTION:  Firmware is using Big-ENDIAN and Intel PC is using           */
/*             Little-ENDIAN.                                               */
/****************************************************************************/
#define BMAPI_NTOH32(p)             ( ( U32 )( (*((U8 *) (p)) << 24) | (*((U8 *) (p)+1) << 16) | (*((U8 *) (p)+2) << 8) | *((U8 *) (p)+3) ) )
#define BMAPI_FW_MAGIC_VALUE            0x669955aa
#define BMAPI_FW_MEDIA_MAX_LOAD_STAGES  8

typedef struct _BM_FW_MEDIA_BOOTSTRAP_REGION
{
    // a pattern not likely to occur randomly
    U32     magic_value;

    // where to locate boot code (byte addr)
    U32     sram_start_addr;

    // boot code length (in words)
    U32     code_len;

    // location of code on media (media byte addr)
    U32     code_start_addr;

    // 32-bit CRC
    U32     cksum;

} BM_FW_MEDIA_BOOTSTRAP_REGION;


typedef enum {
    BMAPI_FW_CODE_IMAGE_TYPE_PXE,
    BMAPI_FW_CODE_IMAGE_TYPE_ASF_INIT,
    BMAPI_FW_CODE_IMAGE_TYPE_ASF_CPUA,
    BMAPI_FW_CODE_IMAGE_TYPE_ASF_CPUB,
    BMAPI_FW_CODE_IMAGE_TYPE_ASF_CFG,
    BMAPI_FW_CODE_IMAGE_TYPE_BOOTP,
    BMAPI_FW_CODE_IMAGE_TYPE_RPL,
    BMAPI_FW_CODE_IMAGE_TYPE_USER_BLOCK,
    BMAPI_FW_MAX_CODE_IMAGE_TYPE,
} BM_FW_CODE_IMAGE;


typedef struct _BM_FW_MEDIA_CODE_OFFSET_REGION
{
    // where to locate code region (byte addr)
    U32     sram_start_addr;

/* 3 bits reserved for future use */
#define BMAPI_FW_CODE_LEN_RESERVED          0xe0000000

/* Use 5 bits -- supports up to 32 types */
#define BMAPI_FW_CODE_IMAGE_TYPE(x)         ((x >> 24) & 0x1f)
#define BMAPI_FW_CODE_IMAGE_EXECUTE_A       0x00800000
#define BMAPI_FW_CODE_IMAGE_EXECUTE_B       0x00400000
#define BMAPI_FW_CODE_IMAGE_EXECUTABLE_A(x) (x & BMAPI_FW_CODE_IMAGE_EXECUTE_A)
#define BMAPI_FW_CODE_IMAGE_EXECUTABLE_B(x) (x & BMAPI_FW_CODE_IMAGE_EXECUTE_B)
#define BMAPI_FW_CODE_IMAGE_LENGTH(x)       (x & 0x3fffff)

    // code region length (in words)
    // The top 8 bits are used for TYPE field.
    // We use 22 bit for length so that we accumulate up to 16 Mbyte.
    U32     code_len;

    // location of code on media (media byte addr)
    U32     code_start_addr;

} BM_FW_MEDIA_CODE_OFFSET_REGION;


#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_AUTO      0   // Auto
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_10_H      1   // 10Mbps Half Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_10_F      2   // 10Mbps Full Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_100_H     3   // 100Mbps Half Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_100_F     4   // 100Mbps Full Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_1000_H    5   // 1000Mbps Half Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_1000_F    6   // 1000Mbps Full Duplex

#define BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_PXE       0
#define BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_RPL       1
#define BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_BOOTP     2

#define BMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_AUTO     0
#define BMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_BBS      1
#define BMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_INT18    2
#define BMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_INT19    3

#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_64K    0
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_128K   1
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_256K   2
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_512K   3
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_1M     4
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_2M     5
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_4M     6
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_8M     7
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_16M    8

#define BMAPI_FW_WOL_MASK                   0x00000001
#define BMAPI_FW_PXE_MASK                   0x00000002
#define BMAPI_FW_MBA_MASK                   0x00000002
#define BMAPI_FW_PXE_SPEED_MASK             0x0000003c
#define BMAPI_FW_MBA_SPEED_MASK             0x0000003c
#define BMAPI_FW_MBA_TYPE_MASK              0x00300000
#define BMAPI_FW_MBA_PROT_PXE               0x00000000
#define BMAPI_FW_MBA_PROT_RPL               0x00100000
#define BMAPI_FW_MBA_PROT_BOOTP             0x00200000
#define BMAPI_FW_MBA_TYPE_SHIFT_POS         20
#define BMAPI_FW_FORCE_PCI_MODE_MASK        0x00000040
#define BMAPI_FW_ASF_MASK                   0x00000080
#define BMAPI_FW_PXE_BAR_SIZE               0x00000f00
#define BMAPI_EEPROM_WP_MASK                0x00400000
#define BMAPI_EEPROM_WP_SHIFT_POS           22

#define BMAPI_FW_PXE_BOOT_TYPE_MASK         0x00300000
#define BMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS    20
#define BMAPI_FW_PXE_BOOT_TYPE_PXE          (BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_PXE << BMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS)
#define BMAPI_FW_PXE_BOOT_TYPE_RPL          (BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_RPL << BMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS)
#define BMAPI_FW_PXE_BOOT_TYPE_BOOTP        (BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_BOOTP << BMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS)

#define BMAPI_FW_PXE_BAR_SIZE_SHIFT_POS     16

#define BMAPI_VAUX_CUTOFF_DELAY_CHOICE(x)   (((x)>>23) & 0x3)

#define BMAPI_DRIVER_WOL_DISABLE            0
#define BMAPI_DRIVER_WOL_MAGIC_ENABLE       1
#define BMAPI_DRIVER_WOL_INT_PKT_ENABLE     2
#define BMAPI_DRIVER_WOL_BOTH_ENABLE        3



typedef union _BM_FW_FEATURE_CONFIG
{
    struct
    {
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
        U32                     :4;     /* reserved */
        U32 driver_wol_enable   :2;     
        U32 Wol_Limit_10        :1;
        U32 vaux_cutoff_delay   :2;
        U32 lom_design          :1;
        U32 pxe_boot_protocol   :2;
        U32 pxe_timeout_msg     :4;
        U32 pxe_bootstrap_type  :2;     /* This field should be used by */
                                        /* boot code. This is only */
                                        /* referenced by MBA. */
        U32                     :2;     /* reserved */
        U32 pxe_bar_size        :4;
        U32 asf_enable          :1;
        U32 force_pci           :1;
        U32 pxe_speed           :4;
        U32 pxe_enable          :1;
        U32 wol_enable          :1;
#else
        U32 wol_enable          :1;     /* bit 0      */
        U32 pxe_enable          :1;     /* bit 1      */
        U32 pxe_speed           :4;     /* bit 2:5    */
        U32 force_pci           :1;     /* bit 6      */
        U32 asf_enable          :1;     /* bit 7      */
        U32 pxe_bar_size        :4;     /* bit 8:11   */
        U32                     :2;     /* bit 12:13  */ /* reserved */
        U32 pxe_bootstrap_type  :2;     /* bit 14:15  */
        U32 pxe_timeout_msg     :4;     /* bit 16:19  */
        U32 pxe_boot_protocol   :2;     /* bit 20:21  */ /* This field */
                                        /* should be used by boot code. */
                                        /* This is only referenced by MBA. */
        U32 lom_design          :1;     /* bit 22     */
        U32 vaux_cutoff_delay   :2;     /* bit 23:24  */
        U32 Wol_Limit_10        :1;     /* bit 25     */
        U32 driver_wol_enable   :2;     /* bit 26:27  */
        U32                     :4;
#endif
    } bit;

    U32 word;
} BM_FW_FEATURE_CONFIG;



/* Both channel A and B are used */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_NORMAL      0x0
/* Only Channel B is used */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_CHAN_B      0x1
/* Only Channel A is used */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_CHAN_A      0x2
/* Use XBAR. single config. space for both channels. */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_XBAR        0x3

#define BMAPI_FW_NIC_HW_CONFIG_PHY_TYPE_UNKNOWN     0
#define BMAPI_FW_NIC_HW_CONFIG_PHY_TYPE_COPPER      1
#define BMAPI_FW_NIC_HW_CONFIG_PHY_TYPE_FIBER       2

#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_UNKNOWN     0
#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_TRIPLE_LINK 1
/* This is used in Dell's Viper */
#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_LINK_SPEED  2
#define BMAPI_NIC_HW_CONFIG_LED_MODE_PHY_MODE_1     1  
#define BMAPI_NIC_HW_CONFIG_LED_MODE_PHY_MODE_2     2

#define BMAPI_FW_NIC_HW_CONFIG_VOLTAGE_1_3_V        0x0
#define BMAPI_FW_NIC_HW_CONFIG_VOLTAGE_1_8_V        0x1
#define BMAPI_FW_NIC_HW_CONFIG_VOLTAGE_MASK         0x3
#define BMAPI_FW_NIC_HW_CONFIG_VOLTAGE_PARM(x)      (x & NIC_HW_CONFIG_VOLTAGE_MASK)

/* Both channel A and B are used */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_NORMAL      0x0
/* Only Channel B is used */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_CHAN_B      0x1
/* Only Channel A is used */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_CHAN_A      0x2
/* Use XBAR. single config. space for both channels. */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_XBAR        0x3

#define BMAPI_NIC_HW_CONFIG_DAUL_MAC_MASK           0xc00
#define BMAPI_NIC_DUAL_MAC_SHIFT_POS                10
#define BMAPI_NIC_HW_CONFIG_DUAL_MAC_PARM(x)        ((x & NIC_HW_CONFIG_DAUL_MAC_MASK) >> NIC_DUAL_MAC_SHIFT_POS)
#define BMAPI_NIC_HW_CONFIG_PSM_NORMAL              0
#define BMAPI_NIC_HW_CONFIG_PSM_LOW                 1

typedef union _BM_FW_NIC_HW_CONFIG
{
    struct
    {
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
        U32 reserved                :17;
        U32 enable_auto_powerdown   :1;
        U32 mini_pci                :1;
        U32 power_saving_mode       :1;
        U32 dual_mac_mode           :2;
        U32 max_pci_retry           :3;
        U32 forced_max_pci_retry    :1;
        U32 phy_type                :2;
        U32 phy_led_mode            :2;
        U32 voltage_source          :2;
#else
        U32 voltage_source          :2;     /* bit 0:1     */
        U32 phy_led_mode            :2;     /* bit 2:3     */
        U32 phy_type                :2;     /* bit 4:5     */
        U32 forced_max_pci_retry    :1;     /* bit 6       */
        U32 max_pci_retry           :3;     /* bit 7:9     */
        U32 dual_mac_mode           :2;     /* bit 10:11   */
        U32 power_saving_mode       :1;     /* bit 12      */
        U32 mini_pci                :1;     /* bit 13      */
        U32 enable_auto_powerdown   :1;     /* bit 14      */
        U32 reserved                :17;
#endif
    } bit;

    U32     word;
} BM_FW_NIC_HW_CONFIG;


typedef union _BM_NIC_SHARED_CONFIG
{
    struct
    {
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
        U32 reserved:29;
        U32 FiberWoLCapable:1;
        U32 Reserved:1;		/* it was BothPort100MbpsCapable, now absolete */
	    U32 portSwap:1;
#else
	    U32 portSwap:1;
        U32 Reserved:1;	    /* it was BothPort100MbpsCapable, now absolete */
        U32 FiberWoLCapable:1;
        U32 reserved:29;
#endif
    } bit;

    U32 word;
} BM_NIC_SHARED_CONFIG;


typedef struct _BM_FW_MEDIA_MANUFACT_REGION
{
    // Version format of this data structure
    U8                      manuf_format_rev;

    // reserved, must be 0
    U8                      reserved1;

    // length of this structure in bytes
    U16                     length;

    // PHY ID of physical device
    U32                     phy_id;

    // MAC address
    U8                      mac_address[8];

    // part number. Printable string ending in '\0'.
    U8                      part_number[16];

    // part revision. Two printable ascii char.
    U8                      part_revision[2];

    // single byte acending rev number
    // Lower byte is major version number. (Little-Endian)
    // Higher byte is minor version number. (Little-Endian)
    U16                     bootcode_fw_revision;

    // ascii manufact date, wwyy, \0 by next field
    U8                      manuf_data[4];

    // pointer to 32 byte opaque OEM area or 0
    U32                     oem_area_p;

    // pci device id
    U16                     pci_dev_id;

    // pci vendor id
    U16                     pci_vend_id;

    // alternate pci subsystem id
    U16                     pci_sub_id;

    // alternate pci subsystem vendor id
    U16                     pci_sub_vend_id;

    // cpu clock speed in Mhz rounded
    U16                     cpu_clk;

    U16                     reserved3;

    // software key, used to enable
    U8                      sw_key[16];

    U8                      power_dissipated[4];
    U8                      power_consumed[4];  

    BM_FW_FEATURE_CONFIG    feature_config;

    BM_FW_NIC_HW_CONFIG     hw_config;

    // Second MAC address for second channel in BCM5704
    U8                      mac_addressb[8];

    // second MAC feature_config
    BM_FW_FEATURE_CONFIG    feature_configb;

    // second MAC hw_config
    BM_FW_NIC_HW_CONFIG     hw_configb;

    BM_NIC_SHARED_CONFIG    shared_config;

    U8                      reserved4[28];

    // 32-bit CRC
    U32                     cksum;

} BM_FW_MEDIA_MANUFACT_REGION;


#define BMAPI_FW_MAX_VPD_W_LENGTH           128

typedef struct _BM_FW_MEDIA_VPD_WRITE
{
    U8  data[BMAPI_FW_MAX_VPD_W_LENGTH];
} BM_FW_MEDIA_VPD_WRITE;


typedef struct _BM_FW_MEDIA_VPD
{
    BM_FW_MEDIA_VPD_WRITE   vpd_r;
    BM_FW_MEDIA_VPD_WRITE   vpd_w;
} BM_FW_MEDIA_VPD;


typedef struct _BM_FW_EEPROM_INFO
{
    BM_FW_MEDIA_BOOTSTRAP_REGION    bootstrap;
    BM_FW_MEDIA_CODE_OFFSET_REGION  code_offsets[BMAPI_FW_MEDIA_MAX_LOAD_STAGES];
    BM_FW_MEDIA_MANUFACT_REGION     manufact;
    BM_FW_MEDIA_VPD                 vpd;

} BM_FW_EEPROM_INFO;


#define BMAPI_FW_INFO_VER   1

typedef struct _BM_FW_INFO
{
    //  Version is defined as BMAPI_FW_INFO_VER.
    //  'version' is required upon input
    U32                 version;

    BM_FW_EEPROM_INFO   eeprom_info;

    // Firmware version description string.
    U8                  firmware_ver_desc[BMAPI_FW_MAX_DESCRIPTION_LEN];

} BM_FW_INFO;



/****************************************************************************
 *  APIs Definition
 ****************************************************************************/
void    BmapiGetVersion( U32 *pMajorVersion, U32 *pMinorVersion,
            U32 *pBuildVersion );
U32     BmapiInitialize( void );
U32     BmapiUninitialize( void );
U32     BmapiGetNumPhyNic( U32 *pNumOfPhy );
U32     BmapiGetAllPhyNic( BM_ADAPTER_INFO *pPhyList, U32 uNumOfPhy );
U32     BmapiGetServiceName( U32 handle, U8 *pServiceName, U32 uBufLen );
U32     BmapiInitializeEx( U32 bKeepCom );
U32     BmapiIsInitialized();
U32     BmapiGetHandleByServiceName( U8 *pServiceName, U32 *handle );
U32     BmapiGetNicPciInfo( U32 handle, BM_NIC_PCI_INFO *pNicPciInfo );
U32     BmapiInitDiag( U32 handle );
U32     BmapiUnInitDiag( U32 handle );
U32     BmapiGetNumPhyNicEx( U32 *pNumOfPhy );
U32     BmapiGetAllPhyNicHandles( U32 *pHandleList, U32 uNumOfPhy );
U32     BmapiGetPhyNic( U32 handle, BM_ADAPTER_INFO_EX *pNicInfoEx );
U32     BmapiGetASFTable( U32 handle, BM_ASF_TABLE *pNicASF );
U32     BmapiSetASFTable( U32 handle, BM_ASF_TABLE *pNicASF );
U32     BmapiGetBIOS( U64 start_addr, void *buffer, U32 length );
U32     BmapiGetSystemASFTables( BM_ASF_TABLE *pAsfTbls );
U32     BmapiWriteFirmware( U32 handle, U32 uOffset, U32 *pDataBuf,
            U32 uBufLen, U8 *pChk );
U32     BmapiReadFirmware( U32 handle, U32 uOffset, U32 *pDataBuf,
            U32 uBufLen, U8 *pChk );

#ifdef _MSC_VER
U32     BmapiGetNumUnassignedNic( U32 *pNumOfUnassigned );
U32     BmapiGetAllUnassignedNic( BM_ADAPTER_INFO *pUnassignedList,
                U32 uNumOfUnassigned );
U32     BmapiGetNumTeam( U32 *pNumOfTeam );
U32     BmapiGetAllTeam( BM_TEAM_INFO *pTeamList, U32 uNumOfTeam );
U32     BmapiApplyLBFOCfg( BM_TEAM_INFO *pTeamList, U32 uNumOfTeam,
                U32 *pReboot );
U32     BmapiGetTeamListSnapShot( U32 *pNumOfTeam, U32 *pIDList );
U32     BmapiGetTeamSnapShot( U32 teamId, BM_TEAM_INFO *pTeam );
U32     BmapiGetTeamStatisticsSnapShot( U32 teamId,
                BM_TEAM_STATISTICS *pTeamStatistics );
U32     BmapiDoNicIOCTL( U32 handle, U32 ioctlCode, void *pInBuf,
                U32 inBufSize, void *pOutBuf, U32 *pOutBufSize,
                U32 *pResult );
U32     BmapiGetNicStatistics( U32 handle,
                BM_GENERAL_STATISTICS *pGenStatistics,
                BM_ETHERNET_STATISTICS *pEthStatistics );
U32     BmapiRetrieveLinkStatus( U32 handle, BM_LINK_STATUS *pLinkStatus );
U32     BmapiGetBRCMNicInfo( U32 handle, BM_BRCM_ADAPTER_INFO *pBRCMNicInfo );
//U32     BmapiGetServiceName( U32 handle, U8 *pServiceName, U32 uBufLen );
BOOL    BmapiTestControlRegisters( U32 handle, char *pRstr );
BOOL    BmapiTestMIIRegisters( U32 handle, char *pRstr );
BOOL    BmapiTestEEPROM( U32 handle, char *pRstr );
BOOL    BmapiTestInternalMemory( U32 handle, char *pRstr );
//BOOL    BmapiTestExternalMemory( U32 handle, U32 ExtMemSize, char *pRstr );
BOOL    BmapiTestInterrupt( U32 handle, char *pRstr );
BOOL    BmapiTestLoopBack( U32 handle, U32 Lbtype, char *pRstr );
BOOL    BmapiTestCPU( U32 handle, char *pRstr );
BOOL    BmapiTestLEDs( U32 handle, U32 BlinkDurationSec );
U32     BmapiGetBRCMNicStatistics( U32 handle,
                BM_BRCM_STATISTICS *pBrcmStatistics );
U32     BmapiForceBRCMNicLinkSpeed( U32 handle, U32 uAutoNegotiation,
                U32 uLinkSpeed );
U32     BmapiLBFOSoftwareStatus( U32 *status );
U32     BmapiGetPnpDevId( U32 handle, U8 *pDevID, U32 *pBufLen,
                U32 *pRegIndex, U32 *pSlotNumber );
BOOL    BmapiSuspendDriver( U32 handle, char *pRstr );
BOOL    BmapiResumeDriver( U32 handle, char *pRstr );
U32     BmapiEnableDevice( U32 handle, U32 uEnable );
U32     BmapiRegisterEvent( U32 event, BMAPIEVENTCALLBACK func, void *cookie,
                U32 *event_handle );
U32     BmapiUnRegisterEvent( U32 event_handle );
//U32     BmapiInitializeEx( U32 bKeepCom );
//U32     BmapiIsInitialized();
U32     BmapiGetBRCMNicParam( U32 handle, U32 param, void *data, U32 length );
U32     BmapiSetBRCMNicParam( U32 handle, U32 param, void *data, U32 length );
U32     BmapiGetMultiBRCMNicParams( U32 handle, U8 *inbuf, U32 inbuflen,
                U8 *outbuf, U32 outbuflen );
U32     BmapiSetMultiBRCMNicParams( U32 handle, U8 *inoutbuf, U32 buflen );
U32     BmapiRefreshData();
//U32     BmapiGetHandleByServiceName( U8 *pServiceName, U32 *handle );
U32     BmapiIMOnlineDevice( U32 team_id, U32 handle, U32 bOnline );
U32     BmapiGetNicStatistics64( U32 handle,
                BM_GENERAL_STATISTICS64 *pGenStatistics,
                BM_ETHERNET_STATISTICS64 *pEthStatistics );
//U32     BmapiGetNicPciInfo( U32 handle, BM_NIC_PCI_INFO *pNicPciInfo );
//U32     BmapiInitDiag( U32 handle );
//U32     BmapiUnInitDiag( U32 handle );
//U32     BmapiGetNumPhyNicEx( U32 *pNumOfPhy );
//U32     BmapiGetAllPhyNicHandles( U32 *pHandleList, U32 uNumOfPhy );
//U32     BmapiGetPhyNic( U32 handle, BM_ADAPTER_INFO_EX *pNicInfoEx );
//U32     BmapiGetASFTable( U32 handle, BM_ASF_TABLE *pNicASF );
//U32     BmapiSetASFTable( U32 handle, BM_ASF_TABLE *pNicASF );
//U32     BmapiGetBIOS( U64 start_addr, void *buffer, U32 length );
U32     BmapiTestControlRegistersEx( U32 handle );
U32     BmapiTestMIIRegistersEx( U32 handle );
U32     BmapiTestEEPROMEx( U32 handle );
U32     BmapiTestInternalMemoryEx( U32 handle );
//U32     BmapiTestExternalMemoryEx( U32 handle, U32 ExtMemSize );
U32     BmapiTestInterruptEx( U32 handle );
U32     BmapiTestLoopBackEx( U32 handle, U32 Lbtype );
U32     BmapiTestCPUEx( U32 handle );
U32     BmapiTestLEDsEx( U32 handle, U32 BlinkDurationSec );
U32     BmapiSuspendDriverEx( U32 handle );
U32     BmapiResumeDriverEx( U32 handle );
U32     BmapiGetFirmwareInfo( U32 handle, BM_FW_INFO *pFWInfo );
U32     BmapiTestASF( U32 handle );
//U32     BmapiWriteFirmware( U32 handle, U32 uOffset, U32 *pDataBuf,
//                U32 uBufLen, U8 *pChk );
//U32     BmapiReadFirmware( U32 handle, U32 uOffset, U32 *pDataBuf,
//                U32 uBufLen, U8 *pChk );
//U32     BmapiGetSystemASFTables( BM_ASF_TABLE *pAsfTbls );
U32     BmapiGetBrcmVirNic( U32 handle, BM_VIR_NIC_INFO_EX *pNicInfoEx );
U32     BmapiReadNicMem( U32 handle, U32 uType, U32 uOffset, U32 *pData,
                U8 *pChk );
U32     BmapiWriteNicMem( U32 handle, U32 uType, U32 uOffset, U32 uData,
                U8 *pChk );
U32     BmapiGetIpAddrInfo( U32 handle, U32 uType, U8 *pBuf, U32 *pLen );
U32     BmapiTestNetwork( U32 handle, U8 *pDestIP, U32 uRetry );
U32     BmapiGetPowerMode( U32 handle, U32 uWhere, U32 uPort, U32 *pMode );
U32     BmapiSetPowerMode( U32 handle, U32 uWhere, U32 uPort, U32 uMode );
U32     BmapiGetBRCMNicInfoEx( U32 handle,
                BM_BRCM_ADAPTER_INFO_EX *pBRCMNicInfoEx );
U32     BmapiGetLastDiagPort( U32 handle, U32 *pPort );
U32     BmapiWriteFirmwareInfo( U32 handle, BM_FW_INFO *pFWInfo, U32 uOption );
U32     BmapiGetTTBRCMNicInfo( U32 handle,
                BM_BRCM_ADAPTER_INFO_EX *pBRCMNicInfoEx, U32 uPort );

#endif /* _MSC_VER */




#ifdef __cplusplus
};
#endif

#endif /* __BMAPI_h__ */
