/****************************************************************************
 * Copyright(c) 2000 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name: bcmtype.h
 *
 * Description: Cross-Processor/OS/Compiler data type definition
 *
 * Author: ffan
 *
 * $Log:: /Source/BCM5700/asf/app/bcmtype.h                         $
 * 
 * 6     6/25/02 3:25p Dtran
 * 
 * 4     7/31/01 10:51a Hyfeng
 * Add few more lines for ASF project.
 * 
 * 3     7/20/01 10:49a Zambrano
 * 
 * 1     4/30/00 2:05p Ffan
 * Initial check-in. Both outbound and inbound load-balance and
 * failover are working.
 *
 ****************************************************************************/
#ifndef __bcmtype_h__
#define __bcmtype_h__

/*
 * define the data model
 */
#if !defined(LP64) && !defined(P64) && !defined(LLP64)
  /* VC 32-bit compiler 5.0 or later */
  #if (_MSC_VER > 800)
    #define P64
  #elif defined(__sun)
    /* Solaris */
    #define LP64
  #elif defined(_HPUX_SOURCE)
    /* HP/UX */
    #define LP64
  #elif defined(__FreeBSD__)
    /* FreeBSD */
    #define LP64
  #elif defined(LINUX)
    /* Linux */
    #define LP64
  #elif defined(__bsdi__)
    /* BSDI */
    #define LP64
  #elif defined(_IRIX)
    #define LP64
  #elif defined(__NETWARE__)
    #define P64
  #endif /* _IRIX */
#endif /* !LP64 && !P64 && !LLP64 */

/*
 * define sized type
 */
#if defined(P64) || defined(LLP64)
  /* P64 */
  typedef unsigned __int64    U64;
  typedef unsigned int        U32;
  typedef unsigned short      U16;
  typedef unsigned char       U8;
  typedef signed __int64      S64;
  typedef signed int          S32;
  typedef signed short        S16;
  typedef signed char         S8;

  typedef unsigned int        u32;
  typedef unsigned short      u16;
  typedef unsigned char       u8;
  typedef unsigned char       u08;
#elif defined(LP64)
  /* LP64: Sun, HP and etc */
  typedef unsigned long long  U64;
  typedef unsigned int        U32;
  typedef unsigned short      U16;
  typedef unsigned char       U8;
  typedef signed long long    S64;
  typedef signed int          S32;
  typedef signed short        S16;
  typedef signed char         S8;
#else 
  /* assume others: 16-bit */
  typedef unsigned char       U64[8];
  typedef unsigned long       U32;
  typedef unsigned int        U16;
  typedef unsigned char       U8;
  typedef signed char         S64[8];
  typedef signed long         S32;
  typedef signed short        S16;
  typedef signed char         S8;
#endif /*  */

#endif/* __bcmtype_h__ */

