#!/bin/sh
# $Id: $
#
# Component:	TivoliPlus (installation utilities)
#
# $Source: $
# $Revision: $
#
# Description:  Common installation support functions for T/EC.
#
# External Variable References / Initialization:
#
# Author:	Glenn Zazulia
#		Tivoli Systems, Inc.
# Modifications:
#	fpc	10/1/96	made generic
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1996-1999.
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

######################################################################
#
#	T/EC Functions
#
######################################################################
errmsg()
{
	echo "Error:  $*" >&2
}

errinfo()
{
	echo "$*" >&2
}

debugmsg()
{
	$Debug	&&  echo "Debug:  $*"
}

get_tme_server_SentryMonitors_path()
{
  # first get the TMR server's host name
  ALI_OID=`wlookup -r distinguished ServerManagedNode`
  TME_HOSTNAME=`idlattr -t -g $ALI_OID label string`

  # now find it's install path
  OSERV=`objcall 0.0.0 get_oserv`
  INST_DIR=`objcall $OSERV query install_dir`
  INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`

  # return the concatenated result
  eval echo $TME_HOSTNAME:$INST_DIR/generic/SentryMonitors
}

add_to_backout_list()
{
	BackoutList="$* $BackoutList"		# Add to (reverse-)ordered list
}

BackoutList=					# Initialization

backout()
{
	# Warning:  because of some sh's poor handling of scoped args, we
	#	    must restore args after any function call.
	args=$BackoutList
	set -- $args
	while [ $# -gt 0 ]; do
		State=$1  skip=1
		case $State in
			RuleBase)
				errinfo "Deleting $Rulebase rulebase."
				wdelrb $Rulebase
				;;
			ClassFile)
				cfile=`echo $2 | awk -F/ '{print $NF}'`
				errinfo "Deleting new $cfile class file."
				wdelrbclass $cfile $Rulebase
				skip=2
				;;
			RulesFile)
				rfile=$2  skip=2
				errinfo "Deleting new $rfile rules file."
				wdelrbrules $rfile $Rulebase
				;;
			EventSource)
				esrc=$2  skip=2
				errinfo "Deleting $esrc event source."
				wdelsrc $esrc
				;;
			EventGroup)
				errinfo "Deleting $EventGroup event group."
				wdeleg $EventGroup
				;;
			AssignConsole)
				errinfo Unassigning $EventGroup from $EventConsole.
				wunassigneg @EnterpriseClient:"$EventConsole" $EventGroup
				;;
			Filters)
				errinfo "Sorry, unable to delete filters."
				;;
			DeletedPlusRule)
				rulefile=$2  skip=2
				errinfo "Adding back $rulefile rules file."
				wimprbrules $rulefile $Rulebase
				;;
		esac
		set -- $args
		shift $skip
		args="$*"
	done
	errmsg "Installation Failed."
	exit 1
}

verify_rule_base()
{
	if [ -z "$Rulebase" ]
	then
		errmsg "A rulebase must be defined!"
		backout
	fi
	if wlsrb | grep "^${Rulebase}$"				>/dev/null 2>&1
	then
		CreateNewRulebase=false
		# make sure the user didn't also include a clone rulebase
		#if [ ! -z "$CloneRulebase" ]: then
		#	errmsg $Rulebase rulebase already exists.  Only define \
		#		a clone rulebase when creating a new rulebase!
		#	backout
		#fi
	else
		CreateNewRulebase=true
	fi
}

verify_clone_rule_base()
{
	if [ -z "$CloneRulebase" ]
	then
		errmsg "Clone rulebase must be defined!"
		backout
	fi
	if wlsrb | grep "^${CloneRulebase}$"			>/dev/null 2>&1
	then
		debugmsg "$CloneRulebase exists."
	else
		errmsg "$CloneRulebase rulebase must already exist!"
		backout
	fi
}

#verify_clone_dir_path()
#{
#	if [ ! -d "$RulebasePath" ]
#	then
#		if mkdir.sh $RulebasePath
#		then
#			debugmsg "Created $RulebasePath"
#		else
#			errmsg "Cannot create new rulebase path."
#			backout
#		fi
#	fi
#}

verify_event_console()
{
	if [ -n "$EventConsole" ]
	then
		if wlookup -r EnterpriseClient "$EventConsole"	>/dev/null 2>&1
		then
			debugmsg "Event console \"$EventConsole\" exists."
		else
			errmsg "Event console \"$EventConsole\" does not exist!"
			backout
		fi
	fi
}

verify_sentry_classes()
{
	if wlsrbclass $VerificationRB | grep "^$SentryClassFile$" >/dev/null 2>&1
	then
		debugmsg "Sentry classes are ok."
	else
		debugmsg "Sentry classes have not been installed, adding them."
		ClassFiles="$SentryClassFiles $ClassFiles"
	fi
}

verify_sentry_rules()
{
	if wlsrbrules $VerificationRB | grep "$SentryRulesFile"	>/dev/null 2>&1
	then
		debugmsg "Sentry rules are ok."
	else
		errmsg	"Sentry rules have not been installed!
"		"	Please refer to Tivoli+ ReadMe for instructions."
		backout
	fi
}

err_output=/tmp/ptc$$

compile_rule_base()
{
	RB=$1
	if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" ] ;then
		COMPILE_FLAGS="-t"
	fi

	debugmsg "Compiling $RB rulebase..."
	wcomprules $COMPILE_FLAGS $RB >$err_output 2>&1 &&  rm -f $err_output
}

verify_current_rule_base_compiles()
{
	if compile_rule_base $VerificationRB
	then
		debugmsg "Pre-existing $VerificationRB rulebase compiles successfully."
	else
		errmsg	"Pre-existing $VerificationRB rulebase does not compile!
"			"	Please correct before continuing installation:
"
		[ -f $err_output ] && cat $err_output >&2 && rm -f $err_output
		backout
	fi
}

verify_new_rule_base_compiles()
{
	if compile_rule_base $Rulebase
	then
		debugmsg "New $Rulebase rulebase compiles successfully."
	else
		errmsg "New $Rulebase rulebase does not compile:
"
		[ -f $err_output ] && cat $err_output >&2 && rm -f $err_output
		backout
	fi
}

create_new_rule_base()
{
	if error=`wcrtrb -d $RulebasePath $Rulebase 2>&1`
	then
		debugmsg "Created $Rulebase rulebase."
		add_to_backout_list RuleBase
	else
		if echo $error | grep "mkdir.*13" >/dev/null 2>&1; then
			error=":  no permission to create \"$RulebasePath\" directory."
		elif [ -n "$error" ]; then
			error=":  $error"
		else
			error=.
		fi
		errmsg "Failed to create $Rulebase rulebase$error"
		backout
	fi
}

clone_rule_base()
{
	if wcprb -crf $CloneRulebase $Rulebase
	then
		debugmsg "Copied $CloneRulebase rulebase to $Rulebase."
	else
		errmsg "Failed to copy $CloneRulebase rulebase to $Rulebase."
		backout
	fi
}

import_new_classes()
{
	if [ ! "$ClassPathSearchOrder" ]; then
		ClassPathSearchOrder="
			$PRODDIR
			`get_tme_server_SentryMonitors_path`
			$BINDIR/../generic/SentryMonitors
			$LINKDIR
		"
	fi

	for cfile in $ClassFiles
	do
		strip_cfile=`echo $cfile | awk -F/ '{print $NF}'`
		
		# debugmsg "looking for $strip_cfile in $Rulebase"
		#
		#	only import a new class file if we're *sure* it's
		#	not already there
		#
#		if wlsrbclass $Rulebase $strip_cfile		>/dev/null 2>&1
#		then
#			errinfo "$strip_cfile already exists in $Rulebase"
#		else
		    for c_path in $ClassPathSearchOrder; do
			cfile_full=${c_path}/${strip_cfile}
			wimprbclass_cmd=wimprbclass

			#
			#  beware of using an existing rulebase that already has a Sentry.baroc
			# defined.  remove it, and try add the newer version after the default
			# baroc files.
			#
                        if [ "$UseExisting" = on ] && [ ${strip_cfile} = "Sentry.baroc" ]; then 
                        	if wlsrbclass $Rulebase $SentryClassFile > /dev/null 2>&1 
				then
                               		debugmsg $SentryClassFile already exists in $Rulebase rulebase.
				else
                               		wdelrbclass ${strip_cfile} $Rulebase > /dev/null 2>&1
					wimprbclass_cmd="wimprbclass -a tec.baroc"
				fi
			fi

			debugmsg "trying to import $cfile_full into $Rulebase"
			if ${wimprbclass_cmd} $cfile_full $Rulebase	>/dev/null 2>&1
			then
				# 
				#  Sentry.baroc is a special case.  it's important the DM_Extension_Base 
				# class defined in newer versions of this file always exist, so partners
				# can create custom events w/o regard to the version of DM their end
				# customers are using.  
				#  if this class doesn't exist in the first version imported, try again
				# until it is.  
				#
                        	if [ ${strip_cfile} = "Sentry.baroc" ]; then 
					if wlsrbclass $Rulebase $SentryClassFile > /dev/null 2>&1
					then
						debugmsg Imported $cfile_full to $Rulebase rulebase.
						add_to_backout_list ClassFile $cfile_full
						break
					else
                                		debugmsg $SentryClassFile does not exists in $Rulebase rulebase. trying again.
                                		wdelrbclass ${strip_cfile} $Rulebase > /dev/null 2>&1
					fi
				else
					debugmsg Imported $cfile_full to $Rulebase rulebase.
					add_to_backout_list ClassFile $cfile_full
					break
                        	fi
			else
				debugmsg Failed to import $cfile_full to $Rulebase rulebase.
#				backout
			fi

                    done
#		fi
	done
}

delete_plus_rules()
{
	for rfile in $PlusRulesFiles
	do
		RulesFile=`echo $rfile | awk -F/ '{print $NF}'`
		if wdelrbrules $RulesFile $Rulebase		>/dev/null 2>&1
		then
			debugmsg "Deleted $RulesFile from $Rulebase rulebase."
			add_to_backout_list DeletedPlusRule $rfile
		fi
	done
}

import_new_rules()
{
	for rfile in $RulesFiles
	do
		RulesFile=`echo $rfile | awk -F/ '{print $NF}'`
		if wlsrbrules $Rulebase $RulesFile		>/dev/null 2>&1
		then
			debugmsg $RulesFile is already configured in $Rulebase rulebase.
		else
			if wimprbrules $rfile $Rulebase
			then
				debugmsg Imported $rfile to $Rulebase rulebase.
				add_to_backout_list RulesFile $RulesFile
			else
				errmsg Failed to import $rfile to $Rulebase rulebase.
				backout
			fi
		fi
	done
}

create_new_event_source()
{
	if wcrtsrc -b $TmpBitmap $TmpSource
	then
		debugmsg "Created $TmpSource event source."
		add_to_backout_list EventSource $TmpSource
	else
		errmsg "Failed to create $TmpSource event source."
		backout
	fi
}

install_new_event_source()
{
	for SourceID in $Sources
	do
		eval TmpSource=$"$SourceID"
		eval TmpBitmap=$"$SourceID"Bitmap

		#
		#  	TEC3.6 changed the output of wlssrc, so determine the TEC
		# 	version before grep-ing	
		#
		TEC=`wlookup -r ProductInfo TEC_SERVER 2>/dev/null`
		TEC_REVISION=`idlattr -t -g $TEC revision string 2>/dev/null | sed 's/"//g'`
		if ( expr $TEC_REVISION \>= 3.6 >/dev/null && wlssrc  2>/dev/null | \
                        grep "^${TmpSource}$" >/dev/null 2>&1 ) || \
                   ( expr $TEC_REVISION \< 3.6 >/dev/null && wlssrc  2>/dev/null | \
                        grep "^${TmpSource} " >/dev/null 2>&1 )
		then
			debugmsg "$TmpSource event source already exists."
			if $PreDeleteEventSources; then
				if wdelsrc $TmpSource; then
					debugmsg "Removed $TmpSource."
				else
					errmsg Failed to delete $TmpSource event source.
					backout
				fi
				create_new_event_source
			fi
		else
			create_new_event_source
		fi
	done
}

create_new_event_group()
{
	if wcrteg -b TivoliPlus $EventGroup
	then
		debugmsg "Created $EventGroup event group."
		add_to_backout_list EventGroup
	else
		errmsg "Failed to create $EventGroup event group."
		backout
	fi
}

install_new_event_group()
{
	if wlseg  2>/dev/null | grep "^${EventGroup}$"		>/dev/null 2>&1
	then
		debugmsg "$EventGroup event group already exists."
		if $PreDeleteEventGroup; then
			if wdeleg $EventGroup; then
				debugmsg "Removed $EventGroup."
			else
				errmsg Failed to delete $EventGroup event group.
				backout
			fi
			create_new_event_group
		fi
	else
		create_new_event_group
	fi
}

assign_event_group_to_console()
{
	if [ -n "$EventConsole" ]
	then
		if wlsassigneg @EnterpriseClient:"$EventConsole" |
			grep "^${EventGroup} "			>/dev/null 2>&1
		then
			debugmsg $EventGroup already assigned to event console \
				$EventConsole.
			add_to_backout_list AssignConsole
		else
			if wassigneg @EnterpriseClient:"$EventConsole" \
				$EventGroup $EventGroupRoles	>/dev/null 2>&1
			then
				debugmsg Assigned $EventGroup event group to \
					event console $EventConsole.
			else
				errmsg Failed to assign $EventGroup event group\
					to event console $EventConsole.
				backout
			fi
		fi
	fi
}

load_new_rules()
{
	if wloadrb $Rulebase
	then
		debugmsg "Loaded $Rulebase rulebase."
	else
		errmsg "Failed to load $Rulebase into EventServer"
		backout
	fi
}

restart_event_server()
{
	if wstopesvr
	then
		debugmsg "Stopped Event Server."
		sleep 6
		if wstartesvr; then
			debugmsg "Started Event Server."
		else
			errmsg "Failed to start Event Server."
		fi
	else
		errmsg	Failed to stop Event Server.  Event Server must be \
			restarted before instalation is complete!
	fi
}

add_filter()
{
	if waddegflt $1 $EventGroup
	then
		debugmsg "Added event filter $Filter ($1)"
	else
		errmsg "Failed adding event filter $Filter ($1)"
		backout
	fi
}

install_new_event_filters()
{
	CurrentFilters=`wlseg -f $EventGroup 2>/dev/null | sed 's/,//g' | \
		awk '/class:/ {
				if ($4 != "*") printf("-c %s",$4);
				if ($6 != "*") printf(" -s %s",$6);
				if ($8 != "*") printf(" -o %s",$8);
				if ($10 != "*") printf(" -r %s",$10);
				if ($12 != "*") printf(" -u %s",$12);
				printf("\n");
				}'`
	for Filter in $Filters
	do
		eval TmpFilter=$"$Filter"
		ALREADY_GOT_IT=0
		OLDIFS=$IFS
		IFS="
"
		export IFS
		for CurrentFilter in $CurrentFilters
		do
			if [ "$TmpFilter" = "$CurrentFilter" ]
			then
				debugmsg "\"$TmpFilter\" filter already exists."
				ALREADY_GOT_IT=1
				break
			fi
		done
		IFS=$OLDIFS
		export IFS
		if [ $ALREADY_GOT_IT -eq 0 ]; then
			add_filter "$TmpFilter"
		fi
	done
}

#
# install the Trouble Ticketing script
#
install_trouble_ticket_script ()
{
	if [ -z "$TEC_TT_OPEN_SCRIPT_1" ]; then
		return 0
	fi

	TEC_TOPDIR=$BINDIR/TME/TEC
	TEC_SCRIPTS=$TEC_TOPDIR/scripts
	TEC_MULTI_SCRIPTS=$TEC_SCRIPTS/tt_multi
	TEC_MULTI_TAG=$TEC_TOPDIR/multi-scripts.installed
	TEC_SCRIPT_NAME=tt.$Short_PRODNAME.$SHORT_VERSION.$VERSION.sh

#
#	if there's a file where the directory should be, rename it.
#
	if [ ! -d $TEC_SCRIPTS ] ; then
#
#	if there is a file named $BINDIR/TME/TEC/scripts
#	move it to scripts.old
#
		if [ -f $TEC_SCRIPTS ] ; then
			mv $TEC_SCRIPTS $TEC_SCRIPTS.old
		fi
#
#	Create the directory
#
		mkdir.sh $TEC_SCRIPTS
	fi

#
#	Copy Tivoli Trouble Ticket script to safe place
#
	if [ -f $TEC_MULTI_TAG ]; then
		echo New trouble ticket script already in place
	else
		mkdir.sh $TEC_MULTI_SCRIPTS
#
#	Copy any previous trouble ticket script to the new
#	directory so we don't lose anything that was already there.
#
		mv $TEC_TOPDIR/TroubleTicket.sh $TEC_MULTI_SCRIPTS
		cp $LINKDIR/PLUStt_multi.sh $TEC_TOPDIR/TroubleTicket.sh
		touch $TEC_MULTI_TAG
	fi

#
#	Move the old copy
#
	if [ -f $TEC_MULTI_SCRIPTS/$TEC_SCRIPT_NAME ] ; then
		mv $TEC_MULTI_SCRIPTS/$TEC_SCRIPT_NAME \
		$TEC_MULTI_SCRIPTS/$TEC_SCRIPT_NAME.orig
	fi

	cp $TEC_TT_OPEN_SCRIPT_1 $TEC_MULTI_SCRIPTS/$TEC_SCRIPT_NAME

#
#	Do an om_set_id on the native TEC trouble_ticketing method
#
	CLIENT=`wlookup -r Classes EnterpriseClient`
	METH_OBJ=`objcall $CLIENT _get_behavior`
	objcall $METH_OBJ om_set_id run_user_defined_tt_script root ""
}


