#!/bin/sh
#
# File:		PLUScreate_sublist_task.sh
#
# Product:	Tivoli Module
# Description:	Shell Script to create a subscription list
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997-1999.
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#
[ "$DEBUG" = true ] && set -xv

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT=PLUScreate_sublist_task.sh

THIS_DIR=`dirname $0`
PATH=$THIS_DIR:$PATH; export PATH

#
#	The standard directory and the (optional) /Plus override script
#
ETC=/etc/Tivoli

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

. $ETC/setup_env.sh


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts may be
#		redirected to a file in TEMP by the same name as the script.
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > $DEBUGDIR/$THIS_SCRIPT 2>&1 && set -xv && DEBUG=true && export DEBUG
[ -f "$DEBUGDIR" ] && set -xv && DEBUG=true && export DEBUG

rc=0

echo "*** Executing $THIS_SCRIPT ($TASK_PROGPATH)"

if [  $# -lt 2 ] ; then
	echo Usage: $THIS_SCRIPT module_name sublist_name [dataless_ep_boolean]
	exit 1
fi

MODULE_NAME="$1"
SUBLIST_NAME="$2"
DATALESS_EP="$3"

if wlookup -ar Gateway > /dev/null 2>& 1; then
  :
else
  DATALESS_EP=false
  echo "WARNING: This version of the Framework does not support dataless endpoints ..." >& 2
fi

PMDSL=$INST_DIR/generic_unix/TME/PLUS/LINK/PM_icon.d
if [ "$DATALESS_EP" = true ]; then
  PMSTATE=TSPMD
  PMXPM=$INST_DIR/generic_unix/TME/PLUS/LINK/PM_icon_dataless.xpm  
else
  PMSTATE=TSPM
  PMXPM=$INST_DIR/generic_unix/TME/PLUS/LINK/PM_icon.xpm
fi

if wlsicon -r ProfileManager | grep "^$PMSTATE$" > /dev/null; then
  :
else
  wputicon -r ProfileManager $PMSTATE $PMDSL $PMXPM
fi


wcrtsprfmgr "$MODULE_NAME" "$SUBLIST_NAME" $PMSTATE $DATALESS_EP
rc=$?

if [ "$DATALESS_EP" = true ]; then
	wsetpm -d  "@ProfileManager:$SUBLIST_NAME#$IRONAME"
fi

echo "*** Exiting $THIS_SCRIPT ($TASK_PROGPATH) with return code $rc"
echo

exit $rc

