#!/bin/sh
# $Id: $
#
# Component:	TivoliPlus Generic Installation Script, for use with winstruct_plus
#
# $Source: $
# $Revision: $
#
# Description:  
#		
#
# Author:	Annelle Harrison
#		Tivoli Systems, Inc.
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1997-1999.
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

##############################################################################
# This script is normally located under the export area specified 
# on the winstruct_plus command line:
#      <plus_export_dir>/generic_unix/TME/PLUS/LINK
# or as specified using the -D option on the winstruct_plus command line.
# An alternative script may be specified using the -D option on the
# winstruct_plus command line.  The following files may contain
# information from previous uses of the -D option; these values may override
# the default locations:
#        $DBDIR/AMS/<module-name>/Default/plus_script
#        $DBDIR/AMS/<module-name>/Default/plus_export_dir
#
# This script will do the following:
# 1. Source the info_file_path script that is passed in as an argument
# 2. Use information in the script to determine the module's Tivoli target 
#    installation directory
# 3. Copy the info script to the export_path area
# 4. Check for ability to copy LINK and binaries from the
#    export area to the Tivoli install tree: $INST_DIR
#    - make backups of stuff in the install dir that we might not want to step on (?)
#    - copy, move, or merge contents of export area into the
#      appropriate Tivoli install directory on this node
#    - exit if can't do it
#    - note that a copy of the info_file_path script is now present in the install 
#      directory
# 5. Check for existence of some minimal set of .gdf variables to make sure we
#    can continue
# 6. Process information in the info file, creating link objects, etc.
#
##################################################################################

usage() {
  echo "  Usage: `basename $0` [ -a | -jfs ] [ -u ] [ -d ] [ -c ] <info_file_path> <export_path>" >&2
  echo "             -a   = do all (default)" >& 2
  echo "             -u   = undo" >& 2
  echo "             -t   = do tasks/jobs" >& 2
  echo "             -f   = do file packs" >& 2
  echo "             -s   = do sentries" >& 2
  echo "             -d   = debug on" >& 2
  echo "             -c   = copy files only" >& 2
  exit 1
}

do_instruct() {
  
  [ "$DEBUG" = true ] && set -x

  common_init || return 1

  log_start_instruct || return 1

  #
  # Create the top level plus collection and the collection for this module
  #
  create_plus_collection || return 1
  
  init_module_globals || return 1

  if $ALL ; then
	  #
	  #	set install options
	  #
	  set_install_options || return 1

	  #
	  # Create application launch icons
	  #
	  create_app_launch || return 1
  fi

  if IsValidPolicyRegion "$APP_PR_NAME"; then

	  if $ALL ; then
	  	#
	  	# Create subscription list profile managers.
	  	#
	  	create_subscription_lists || return 1

	  	#
	  	# Determine to which subscription list, if any, this host should be added
	  	#
	  	add_host_to_subscription_lists || return 1
	  fi

	  if $DO_JOBS || $ALL ; then
	  	#
	  	# Create application management jobs, mapping them to tasks created by winstruct
	  	#
	  	create_administrative_jobs || return 1

	  	#
	 	# Create /Plus configuration jobs
	  	#
	  	create_plus_config_jobs || return 1

		#
		# Create filepack configuration jobs, but only if courier is installed
		#
		if $COURIER_INSTALLED ; then
			create_filepack_config_jobs || return 1
		fi

		#
		# Create logfile adapter configuration job, regardless of whether
		# TEC or logfile is installed
		#
		create_log_config_jobs || return 1
	  fi

	  #
	  # If Sentry is installed, then create the link objects and indicator
	  #	collections
	  #
	  if $SENTRY_INSTALLED ; then
		if $DO_SENTRIES || $ALL ; then
			create_sentry_profile_links || return 1
		fi
	  else
		echo Tivoli/Sentry NOT installed!
	  fi

	  #
	  # If Courier is installed, then create the file packages
	  #
	  if $COURIER_INSTALLED ; then
		if $DO_FILEPACKS || $ALL ; then
			create_file_package_links || return 1
		fi
	  else
		echo Tivoli/Courier NOT installed!
	  fi

	  #
	  # If TEC is installed, then create the events and load rule bases
	  #
	  if $TEC_INSTALLED ; then
		#
		# Create hidden tasks (create_tec_hidden_tasks)
		#
	        ### actually, this is done by winstruct_task, regardless of $TEC_INSTALLED 

		#
		# Install TEC config job
		#
		if $DO_JOBS || $ALL ; then
			create_tec_config_jobs || return 1
		fi
	  else
		echo Tivoli Enterprise Console NOT installed!
	  fi

  fi

  refresh_plus_collection

  touch $DBDIR/${SHORT_prodname}plus-installed

  log_end_instruct

}

undo_instruct() {

  [ "$DEBUG" = true ] && set -x

  set_path_and_dir || return 1

  set_region_vars

  init_module_globals || return 1

  log_start_instruct

  #
  # undo everything in the reverse order of installation ...
  #

  if $DO_JOBS || $ALL ; then

	delete_log_config_jobs || return 1

  	delete_tec_config_jobs || return 1

	delete_filepack_config_jobs || return 1

  	delete_plus_config_jobs || return 1

  	delete_administrative_jobs || return 1

  fi

  if $DO_FILEPACKS || $ALL ; then

  	delete_file_packages || return 1

  fi

  if $DO_SENTRIES || $ALL ; then

	delete_sentry_profiles || return 1

  fi

  if $DO_JOBS || $ALL ; then

  	delete_app_launch || return 1

 	remove_install_options || return 1

  fi

  if $ALL ; then

	### remove_host_from_subscription_lists || return 1

  	delete_subscription_lists || return 1

  	remove_plus_collection || return 1

 	rm -f $DBDIR/${SHORT_prodname}plus-installed
  fi

  log_end_instruct

} # end of undo_instruct ...

undo_infra() {

  [ "$DEBUG" = true ] && set -x

  log_start_instruct

  if $DO_SENTRIES || $ALL ; then
    delete_infra_sentries || return 1
    delete_infra_tasks $SENTRYTASKS || return 1
  fi
  
  if $DO_FILEPACKS || $ALL ; then
    delete_infra_filepacks || return 1
    delete_infra_tasks $FILEPACKTASKS || return 1
  fi

  if $DO_JOBS || $ALL ; then
    ALL_OTHER_TASKS="$TASKS $HIDDENTASKS $TECTASKS $LOGTASKS $ABOUTTASKS $CONFIGTASKS"
    delete_infra_tasks $ALL_OTHER_TASKS || return 1
    delete_default_tasklib || return 1
    delete_infra_tasklibs || return 1
  fi

  if $ALL ; then
    delete_infra_app_pr || return 1
  fi

  refresh_desktop

  log_end_instruct

}

undo_prodinfo() {
  if [ "$PATCH_ID" ]; then
    if wlookup -r ProductInfo "$PATCH_ID"; then
      pi_obj=`wlookup -r ProductInfo "$PATCH_ID"`
      objcall $pi_obj _delete
    fi
    rm -f $INST_DIR/generic_unix/.installed/${PATCH_ID}_GBIN
    rm -f $INST_DIR/lcf_bundle/.installed/${PATCH_ID}_LCF
    rm -f $INST_DIR/../msg_cat/.installed/${PATCH_ID}_CAT
  fi
}

#############################################################################
#
#	Setup Tivoli environment variables and call scripts
#	to set up product specific stuff.
#

ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f $ETC/$SCRIPT ]; then
	SCRIPT=setup_env.sh
fi

. $ETC/$SCRIPT

#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR

REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi


DEBUGDIR=$TEMP/.plusdebug
if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" -o "$DEBUG" = true ]; then
  DEBUG=true
else
  DEBUG=false
fi
export DEBUG

#
# The SCRIPTNAME var may be used by logging routines ...
#
THIS_SCRIPT=`echo $0 | tr "\\\\\\\\" "/"`
THIS_SCRIPT=`basename $THIS_SCRIPT`
SCRIPTNAME=${SCRIPTNAME:-$THIS_SCRIPT}

#
# command line processing begins here:
#
OPTSTRING="dujtfsarci"
ALL=true; REGION_ONLY=false; UNDO=false; COPY_FILES_ONLY=false; UNDO_INFRA=false; UNDO_PRODINFO=false
DO_JOBS=false; DO_FILEPACKS=false; DO_SENTRIES=false;
ALL_OPT=false

while getopts $OPTSTRING opt; do
    case $opt in
      d) DEBUG=true;;
      u) UNDO=true; UNDO_INFRA=true;;
      a) ALL_OPT=true; ALL=true;;
      j | t) DO_JOBS=true; ALL=false;;
      f) DO_FILEPACKS=true; ALL=false;;
      s) DO_SENTRIES=true; ALL=false;;
      r) REGION_ONLY=true; ALL=false;;
      c) COPY_FILES_ONLY=true; ALL=false;;
     *?) usage;;
    esac
done
shift `expr $OPTIND - 1`

INFO_SCRIPT=$1
EXPORT_LOC=$2

if [ ! "$INFO_SCRIPT" ]; then
  # assume module and LINK are already in place and we
  # got called from the module dir:
  INFO_SCRIPT="./PLUSproduct-info.sh"
fi
if [ ! "$EXPORT_LOC" ]; then
  EXPORT_LOC="$INST_DIR/.."
fi

if [ ! -d "$EXPORT_LOC/bin" -o ! -f "$INFO_SCRIPT" ]; then
  usage
fi  

#
# locate and source other common utilities that should be in the export location
#
UTIL_SCRIPTS_PATH="$EXPORT_LOC/bin/generic_unix/TME/PLUS/LINK"
if [ -f "${UTIL_SCRIPTS_PATH}/PLUScommon-install.sh" -a \
     -f "${UTIL_SCRIPTS_PATH}/PLUScommon-instruct.sh" ]; then
  . ${UTIL_SCRIPTS_PATH}/PLUScommon-install.sh
  . ${UTIL_SCRIPTS_PATH}/PLUScommon-instruct.sh
else
  echo "Missing files: ${UTIL_SCRIPTS_PATH}/PLUScommon*.sh" >&2
  exit 1
fi

#
# set some vars that may be referenced by the INFO_SCRIPT before we source it ...
#

if wlookup -r Classes EventServer >/dev/null 2>&1; then 
  # then we know TEC is installed!
	TEC_SENTRY_RESET_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_NORMAL_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_FATAL_CLAUSE="-T FATAL EventServer"
	TEC_SENTRY_CRITICAL_CLAUSE="-T CRITICAL EventServer"
	TEC_SENTRY_SEVERE_CLAUSE="-T MINOR EventServer"
	TEC_SENTRY_WARNING_CLAUSE="-T WARNING EventServer"
	TEC_SENTRY_HARMLESS_CLAUSE="-T HARMLESS EventServer"
fi

#
# Now source the info script!
#
. $INFO_SCRIPT

#
# Make sure the info script included required vars to let us proceed
#
if [ ! "$LINKDIR" -o \
     ! "$PLUSDIR" -o \
     ! "$PRODDIR" ]; then
  echo "Missing PLUSDIR, LINKDIR, or PRODDIR location information in $INFO_SCRIPT!" >&2
  exit 1
fi

if [ ! "$WINSTRUCTED" = true ]; then
  WINSTRUCTED=false
fi

#
# If we're instructed, then we can't undo the infrastructure
#
if $WINSTRUCTED && $UNDO ; then
  UNDO_INFRA=false
fi

#
# User must use all option if s/he wants to undo app launch, install opts, and sublists ...
#
if $UNDO; then
  if $ALL_OPT; then
    ALL=true
  else
    ALL=false
  fi
fi

if [ ! "$APP_PR_NAME" ] ; then
  if $WINSTRUCTED ; then
  	echo "Missing APP_PR_NAME information in $INFO_SCRIPT!" >&2
  	exit 1
  else
	APP_PR_NAME="$MEDIUM_PRODNAME"
  fi
fi
export WINSTRUCTED
export LINKDIR
export PLUSDIR
export PRODDIR
export APP_PR_NAME

#
# Set/resolve/export some important values according to data in the info script
#
if [ ! "$MODULE_VERSION" ]; then
  # a default:
  MODULE_VERSION="3.0"  
fi
if [ "$TOP_COLLECTION" -a ! "$TOP_PR_TO_USE" ]; then
  TOP_PR_TO_USE="$TOP_COLLECTION"
else
  TOP_PR_TO_USE="TivoliPlus"
fi
if [ "$TOP_ICON" -a ! "$COLL_ICON_TO_USE" ]; then
  COLL_ICON_TO_USE="$TOP_ICON"
else
  COLL_ICON_TO_USE="$LINKDIR/Sol_icon.xpm"
fi
if [ "$TOP_STATE" -a ! "NEW_COLL_STATE" ]; then
  NEW_COLL_STATE="$TOP_STATE"
else
  NEW_COLL_STATE="TSCOLL"
fi
export MODULE_VERSION
export TOP_PR_TO_USE
export COLL_ICON_TO_USE
export NEW_COLL_STATE

#
# Set shell flags for trace, abort install if error
#
if $DEBUG; then set -xv; fi
set -e

#
# Start processing info here
#
if $UNDO ; then
   undo_instruct || exit 1
   if $UNDO_INFRA ; then
     undo_infra || exit 1
   fi
   undo_prodinfo || exit 1
else
   copy_module_files "$INFO_SCRIPT" "$EXPORT_LOC"
   if [ $? -ne 0 ]; then
     echo "File installation failed!" >&2
     exit 1
   elif $COPY_FILES_ONLY ; then
     exit 0
   else
     ##################
     #
     # At this point processing is similar to that in PLUSinstall.sh
     #
     if $WINSTRUCTED ; then
       do_instruct || exit 1
     else
       $LINKDIR/PLUSinstall.sh
     fi
   fi
fi
exit 0


