#!/bin/sh
# $Id: $
#
# Component:	/Plus utility script
#
# Description:  
#
# Author:	<generated>
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1996-1999.
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

#
#	The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f $ETC/$SCRIPT ]; then
	SCRIPT=setup_env.sh
fi

. $ETC/$SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PATH=$LINKDIR:$PATH

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi
export TEMP

if [ ! -d $TEMP ]; then
	mkdir -p $TEMP
fi

DEBUGDIR=$TEMP/.plusdebug

SCRIPTNAME=`echo $0 | tr "\\\\\\\\" "/"`
SCRIPTNAME=`basename $`

[ -d "$DEBUGDIR" ] && exec > $DEBUGDIR/$SCRIPTNAME 2>&1 && set -xv
[ -f "$DEBUGDIR" -o "$DEBUG" = true ] && set -xv

ODNUM=`odadmin | grep Dispatcher | awk '{print $3}'`
if [ $ODNUM -ne 1 ]; then
	exit 0
else
	exit 1
fi
