#!/bin/sh
# $Id: $
#
# Component:	TivoliPlus (installation utilities)
#
# $Source: $
# $Revision: $
#
# Description:  Common installation support functions for TivoliPlus modules.	
#		This script should be "sourced" at the top of the TivoliPlus
#		module initialization scripts (for ALI/server and clients).
#
# External Variable References / Initialization:
#
# Author:	Annelle Harrison
#		Tivoli Systems, Inc.
# Modifications:
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1998, 1999
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

usage() {
  PROGNAME=`echo $0 | sed -e 's.\\\\./.g'`
  PROGNAME=`basename $PROGNAME`
  echo "  Usage: $PROGNAME [ -d] <PLUSproduct-info.sh path>" >&2
  echo "           -d  = turn on debug tracing" >&2
  exit 1
}

if [ "$1" = "-d" ]; then
  DEBUG_OPT="-d"
  shift
else
  DEBUG_OPT=""
fi

if [ -z "$1" ]; then
  usage
elif [ ! -f "$1" ]; then
  echo "Product info file ($1) not found" >&2
  usage
fi

#
#	Source the Tivoli setup script
#
ETC=/etc/Tivoli
SCRIPT=setup_env.sh
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi
. $ETC/$SCRIPT

#
#	Set path
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PATH=$LINKDIR:$PATH
export PATH

SCRIPTNAME=`echo $0 | tr "\\\\\\\\" "/"`
SCRIPTNAME=`basename $SCRIPTNAME`; export SCRIPTNAME

. $1
if [ "$LONG_PRODNAME" ]; then
  echo "Removing Tivoli database information for \"$LONG_PRODNAME\""
  sleep 5
  PLUSinstruct.sh -u $DEBUG_OPT $1
else
  echo "$1 is not a valid product info file ..."
  usage
fi
