#!/bin/sh
PATH=/usr/bin:/bin:/usr/ucb:$PATH
export PATH

if [ $# -ne 1 ] ; then
	echo usage $0 path
fi

DESIRED_DIR=$1
CURRENT_DIR=
prefix=false
INCREMENTAL=`echo $1 | sed -e 's/\// /g'`
for next_dir in $INCREMENTAL
do
	drive=`echo $next_dir | grep :`
    if [ "x${drive}" !=  "x" ]
    then
     	CURRENT_DIR=${drive}/
        prefix=true
        next_dir=""
        shift
   	elif [ $prefix = true ]
    then 
		CURRENT_DIR=$CURRENT_DIR${next_dir}
        prefix=false
    else
	        CURRENT_DIR=$CURRENT_DIR/${next_dir}
	fi

	if [ ! -d "$CURRENT_DIR" ] ; then
		mkdir $CURRENT_DIR
		if [ ! -d "$CURRENT_DIR" ] ; then
			break
		fi
	fi
done	

if [ ! -d $DESIRED_DIR ] ; then
	#Failed
	exit 10
else
	#Succeeded	
	exit 0
fi
