#!/bin/sh
#
# File:		AppNamePLUSinstall_after.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

MODULE_VERSION=;export MODULE_VERSION

#
#	The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f $ETC/$SCRIPT ]; then
	SCRIPT=setup_env.sh
fi

. $ETC/$SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

#
#       Process winstall variables 
#
ALL=false; REGION_ONLY=false; UNDO=false; COPY_FILES_ONLY=false; UNDO_INFRA=false
DO_JOBS=false; DO_FILEPACKS=false; DO_SENTRIES=false

if [ $UNINSTALL -eq 1 ]; then
  UNDO=true
  UNINSTALL_OPTS=""
fi

## cue off DOTASKS from winstall being either "0" or "1" to know
## if we're in incremental install mode ...
if [ "$DOTASKS" ]; then
  INCREMENTAL_INSTALL=true
  if [ $DOALL -eq 1 ]; then
    ALL=true
    UNINSTALL_OPTS="a"
  fi
else
  INCREMENTAL_INSTALL=false
  ALL=true
fi

if [ "$ALL" = false ]; then
  if [ $DOTASKS -eq 1 ]; then
    DO_JOBS=true
    UNINSTALL_OPTS="j${UNINSTALL_OPTS}"
  fi
  if [ $DOMONS -eq 1 ]; then
    DO_SENTRIES=true
    UNINSTALL_OPTS="s${UNINSTALL_OPTS}"
  fi
  if [ $DOFPS -eq 1 ]; then
    DO_FILEPACKS=true
    UNINSTALL_OPTS="f${UNINSTALL_OPTS}"
  fi
fi

export INCREMENTAL_INSTALL ALL DO_JOBS DO_SENTRIES DO_FILEPACKS UNDO

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/UM_SERVICES
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh
# load isInventoryInstalled
#. ./isInventoryInstalled.sh 

#
#	This setting controls the task library creation behavior
#
USE_TLL=true; export USE_TLL

#
#	This setting determines if TMA (LCF endpoints) are supported in this install)
#
TMA_ENABLED=true
if wlookup -ar Gateway > /dev/null 2>& 1; then
  :
else
  echo "Dataless endpoints are not supported by this version of Tivoli" >& 2
  TMA_ENABLED=false
fi
export TMA_ENABLED

#
#       Use the MODULE setting to determine the patch id (for uninstall)
#
PATCH_ID=RRPlus; export PATCH_ID

#
#	Use the module-level TaskRoles setting to set up a default ROLE for tasks
#
DEFAULT_TASKROLES=super; export DEFAULT_TASKROLES

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug

SCRIPTNAME=`echo $0 | tr "\\\\\\\\" "/"`
SCRIPTNAME=`basename $SCRIPTNAME`

[ -d "$DEBUGDIR" ] && exec > $DEBUGDIR/$SCRIPTNAME && DEBUG=true && set -xv
[ -f "$DEBUGDIR" ] && DEBUG=true && set -xv

chmod +x $LINKDIR/Link.install $LINKDIR/Link.init $LINKDIR/Link.cfg $LINKDIR/w* $LINKDIR/cfgappicon $LINKDIR/faux* $LINKDIR/*.sh


if $UNDO; then
  ## use existing undo interface to PLUSinstruct.sh ...
  $LINKDIR/PLUSinstruct.sh -ud${UNINSTALL_OPTS} ./PLUSproduct-info.sh

else
  ## do install

  . $LINKDIR/PLUSinstall.sh

  echo "Finished installing the basics" >> $TEMP/ums_inv.log


  ###########################################################################
  #
  #  at this point the plus module has been installed.
  #  insert any code to run after installation here.
  #

  # enable dataless mode for Subscribers of UM Services Profile Manager
  wsetpm -d @ProfileManager:'Subscribers of UM Services'

  echo "done dataless Subscribers of UM Services" >> $TEMP/ums_inv.log

  POLICY_REGION=`wtmrname`

  # remove the task associated with the launch
  # wrm /Administrators/Root_"$POLICY_REGION"/TivoliPlus/"$MEDIUM_PRODNAME"/"Launch Netfinity Director"

  wrm /Administrators/Root_"$POLICY_REGION"/TivoliPlus/"$MEDIUM_PRODNAME"/"Launch UM Services"


  #  set up inventory library and queries
  QUERY_LIB='UM Services Inventory Queries'
  INVENTORY_PRFMGR='UM Services Inventory'
  INVENTORY_HWPRF='UM Services PC HW Scan'
  INVENTORY_SWPRF='UM Services PC SW Scan'
  DB2_QUERIES='ums_queries_db2.sh'
  QUERIES='ums_queries.sh'
  CIM_DB2MIF_FILE='c:/uminvdb2.mif'
  CIM_MIF_FILE='c:/umsinv.mif'
  DMI_DB2MIF_FILE='c:/umativdb2.mif'
  DMI_MIF_FILE='c:/umativoli.mif'
  INVENTORY_SCRIPT='pctmeinv.bat'

  export QUERY_LIB
  set +e
  INVENTORY_INSTALLED=0			# Indicate Inventory is not installed
  

  # Get Inventory object
  INVENTORY_OID=`wlookup -r Classes InventoryProfile`
  STATUS=$?

  if [ \( $STATUS -eq 0 \) -a \( x"$INVENTORY_OID" != x \) ]
  then
      INVENTORY_INSTALLED=1			# Indicate that Inventory is installed
  fi

  #isInventoryInstalled
  if [ $INVENTORY_INSTALLED -eq 1 ]
  then

    wsetpr "InventoryProfile" "$POLICY_REGION"
    STATUS=$?
    if [ $STATUS -ne 0 ]
    then
      echo "ERROR: Inventory module was not properly setup on the Tivoli TMR Server/Managed Node."
      echo "ERROR: Inventory module was not properly setup on the Tivoli TMR Server/Managed Node." >> $TEMP/ums_inv.log
      echo >> $TEMP/ums_inv.log
      echo
    else
      echo "Added Resource Inventory Profile to the Policy Region."
      echo "Added Resource Inventory Profile to the Policy Region." >> $TEMP/ums_inv.log
      echo >> $TEMP/ums_inv.log
      echo

      wsetpr "QueryLibrary" "$POLICY_REGION"
      STATUS=$?
      if [ $STATUS -ne 0 ]
      then
        echo "ERROR: Inventory module was not properly setup on the Tivoli TMR Server/Managed Node."
        echo "ERROR: Inventory module was not properly setup on the Tivoli TMR Server/Managed Node." >> $TEMP
/ums_inv.log
        echo >>$TEMP/ums_inv.log
        echo
      else
        DB_VENDOR=`wgetrim inventory | grep "Vendor" | awk '{print $3}'`

        echo "Creating the Table & Views for UM Services Inventory..."
        echo "Creating the Table & Views for UMS Services Inventory..." >> $TEMP/ums_inv.log
        echo "Please wait..."
        echo

        case "$DB_VENDOR" in
	    MS_SQL)
		echo "To create tables for ORACLE, Go into SQL session as user tivoli"
		#isql -U tivoli -i ums_ms_sql_schema.sql -P tivoli >> $TEMP/ums_inv.log
		;;
	    SYBASE)
		echo "To create tables for ORACLE, Go into SQL session as user tivoli"
		#isql -U tivoli -i ums_sybase_schema.sql -P tivoli >> $TEMP/ums_inv.log
		;;
	    DB2)
		echo "To create tables for DB2, ..... "
		echo "run db2 -f ums_db2_sql_schema.sql -o -t, after connecting"
		echo "to the inventory database"
		;;
	    ORACLE)
		echo "To create tables for ORACLE, Go into SQL session as user tivoli"
		echo "type in:  \"@ums_oracle_schema.sql\""
		;;
        esac

        echo "Table & Views for UMS Agent Inventory created."
        echo "Table & Views for UMS Agent Inventory created." >> $TEMP/ums_inv.log
        echo "Creating query library in $POLICY_REGION ..."
        echo "Creating query library in $POLICY_REGION ..." >> $TEMP/ums_inv.log

        wsetpr "QueryLibrary" @"$MEDIUM_PRODNAME"
#        wcrtqlib "$POLICY_REGION" "$QUERY_LIB"
        wcrtqlib "$MEDIUM_PRODNAME" "$QUERY_LIB"
        STATUS=$?

        if [ $STATUS -eq 0 ]
        then
          echo $QUERY_LIB ":QueryLibrary created."
          echo $QUERY_LIB ":QueryLibrary created." >> $TEMP/ums_inv.log

#QLIB=wlookup -r QueryLibrary $QUERY_LIB
#Add to the proper solutions collection

#LIBRARY=`wlookup Library`

#COLLECTIONGUI=`idlcall "$LIBRARY" lookup_object '"imp_TMF_TGC::CollectionGUI" {0}'`
#COLLOBJ=`idlcall "$COLLECTIONGUI" lookup_object '"'$SOLNAME'" {0}'`

#gcoadd "$COLLOBJ" "$QLIB"
#idlcall "$COLLOBJ" refresh_collection

        
#          wln "/Administrators/Root_"$POLICY_REGION"/"$POLICY_REGION"/$QUERY_LIB" "TivoliPlus/$MEDIUM_PRODNAME" 2> $TEMP/ums_temp
#          cat $TEMP/ums_temp 
#          cat $TEMP/ums_temp >> $TEMP/ums_inv.log

          # populate UMS Agent query library
          if [ "$INTERP" = "w32-ix86" ]; then
             if [ "$DB_VENDOR" = "DB2" ]
             then
               bash "$DB2_QUERIES" "$QUERY_LIB"
             else
               bash "$QUERIES" "$QUERY_LIB"    
             fi
          else
             if [ "$DB_VENDOR" = "DB2" ]
             then
               sh "$DB2_QUERIES" "$QUERY_LIB"
             else
               sh "$QUERIES" "$QUERY_LIB"    
             fi
          fi

          echo "Creating Profile Manager: $INVENTORY_PRFMGR "
          echo "Creating Profile Manager: $INVENTORY_PRFMGR " >> $TEMP/ums_inv.log

#          wsetpr ProfileManager "$POLICY_REGION"
          wsetpr ProfileManager @"$MEDIUM_PRODNAME"
#          wcrtsprfmgr "$MEDIUM_PRODNAME" $INVENTORY_PRFMGR dataless 2> $TEMP/ums_temp
          wcrtprfmgr @"$MEDIUM_PRODNAME" "$INVENTORY_PRFMGR" 2> $TEMP/ums_temp
          cat $TEMP/ums_temp 
          cat $TEMP/ums_temp >> $TEMP/ums_inv.log
          # enable dataless mode for inventory profile manager
          wsetpm -d @ProfileManager:"$INVENTORY_PRFMGR"
          #cat uma_temp
          #cat uma_temp >> umainstall.log

          echo "Creating Profile: $INVENTORY_PRF in Profile Manager: $INVENTORY_PRFMGR"
          echo "Creating Profile: $INVENTORY_PRF in Profile Manager: $INVENTORY_PRFMGR" >> $TEMP/ums_inv.log

          wsetpr InventoryProfile @"$MEDIUM_PRODNAME"
          wcrtprf @ProfileManager:"$INVENTORY_PRFMGR" InventoryProfile "$INVENTORY_HWPRF" 2> $TEMP/ums_temp
          wcrtprf @ProfileManager:"$INVENTORY_PRFMGR" InventoryProfile "$INVENTORY_SWPRF" 2> $TEMP/ums_temp

#          wcrtsprf SLINK \"$MEDIUM_PRODNAME\" InventoryProfile \$INVENTORY_PRFMGR \$INVENTORY_PRFMGR 2> $TEMP/ums_temp
#          wcrtsprf 'AppName Plus for Tivoli' InventoryProfile $INVENTORY_PRF @ProfileManager:$INVENTORY_PRFMGR 2> $TEMP/ums_temp
          cat $TEMP/ums_temp
          cat $TEMP/ums_temp >> $TEMP/ums_inv.log

          echo "Configuring the $INVENTORY_HWPRF for UMS MIFS"
          echo "Configuring the $INVENTORY_HWPRF for UMS MIFS" >> $TEMP/ums_inv.log
          if [ "$DB_VENDOR" = "DB2" ]
          then
	      wsetiprf -D "This profile runs TMEINV on the clients and updates the hardware inventory database" -r ALL -m \
            HW_MIF_READ,SW_MIF_IGNORE,CUSTOM_MIF_READ -s SW_SCAN_OFF,HW_SCAN_ON,SCRIPT_ON \
            -M "$CIM_DB2MIF_FILE","$DMI_DB2MIF_FILE" -S "$INVENTORY_SCRIPT" \
            @InventoryProfile:"$INVENTORY_HWPRF"

          else    
	      wsetiprf -D "This profile runs TMEINV on the clients and updates the hardware inventory database" -r ALL -m \
            HW_MIF_READ,SW_MIF_IGNORE,CUSTOM_MIF_READ -s SW_SCAN_OFF,HW_SCAN_ON,SCRIPT_ON \
            -M "$CIM_MIF_FILE","$DMI_MIF_FILE" -S "$INVENTORY_SCRIPT" \
            @InventoryProfile:"$INVENTORY_HWPRF"
          fi

          echo "Configuring the $INVENTORY_SWPRF for UMS MIFS"
          echo "Configuring the $INVENTORY_SWPRF for UMS MIFS" >> $TEMP/ums_inv.log
	    wsetiprf -D "This profile runs TMEINV on the clients and updates the sofware inventory database" -r ALL -m \
          HW_MIF_IGNORE,SW_MIF_READ,CUSTOM_MIF_IGNORE -s SW_SCAN_ON,HW_SCAN_OFF,SCRIPT_OFF \
          @InventoryProfile:"$INVENTORY_SWPRF"

          wsetipext -a .MOF @InventoryProfile:"$INVENTORY_SWPRF"
 
          wmv /Library/PolicyRegion/"$MEDIUM_PRODNAME"/"$QUERY_LIB" /Administrators/Root_"$POLICY_REGION"/TivoliPlus/"$MEDIUM_PRODNAME" 2> $TEMP/ums_temp
          cat $TEMP/ums_temp 
          cat $TEMP/ums_temp >> $TEMP/ums_inv.log

          wmv /Library/PolicyRegion/"$MEDIUM_PRODNAME"/"$INVENTORY_PRFMGR" /Administrators/Root_"$POLICY_REGION"/TivoliPlus/"$MEDIUM_PRODNAME" 2> $TEMP/ums_temp
          cat $TEMP/ums_temp 
          cat $TEMP/ums_temp >> $TEMP/ums_inv.log

        fi  # success status on wcrtqlib

      fi  # success status on wsetpr "QueryLibrary"  ...

    fi  # success status on wsetpr "Inventory profile" ...

  fi  # inventory module is installed

fi  # if $UNDO ...

exit 0
