#!/bin/sh
#
# File:		PLUSproduct-info.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#
MODULE_VERSION=3.0; export MODULE_VERSION

#
#	UM Services
#
SHORT_Prodname=Um_services
SHORT_prodname=um_services
SHORT_PRODNAME=UM_SERVICES
REAL_PRODNAME="UM Services"

#
#	Product Version Information
#
VERSION_MAJOR=1
VERSION_MINOR=2
VERSION_REV=
SHORT_VERSION="$VERSION_MAJOR.$VERSION_MINOR"
LONG_VERSION="Version $SHORT_VERSION, Revision $VERSION_REV"

#
#	Product Naming Information
#
MEDIUM_PRODNAME="$REAL_PRODNAME Plus for Tivoli"
LONG_PRODNAME="$MEDIUM_PRODNAME, $LONG_VERSION"

#
#	Product Manufacturer, serial number, etc.
#
APP_MANUFACTURER="IBM Corp."
APP_LANGID=""
APP_BUILDID="$SHORT_PRODNAME""PLUS"
APP_PARTNO="part number"
APP_SERIALNO="serial number"
APP_DESCRIPTION=""

#
#	Directory Information
#
PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/$SHORT_PRODNAME
ICONDSL=UM_SERVICES_icon.d

#
#	Icon Bitmaps
#
PLUSBITMAP="$PRODDIR/umsPlus.xpm"
STDBITMAP="$PRODDIR/ums.xpm"


#
#	Subscription List Info
#
SUBLIST_PM_1="Subscribers of UM Services"
SUBLIST_PM_1_DEPS="SUBLIST_PM_1_DEP_1"
SUBLIST_PM_1_ICONSTATE="STATE_UM_SERVICES_Subscribers_of_UM_Services_icon.d"
SUBLIST_PM_1_DEP_1="check_app_client.sh"
SUBLIST_PM_1_PLATFORM="unknown"
SUBLIST_PM_1_ICONDSL="Subscribers_of_UM_Services_icon.d"
SUBLIST_PMS="SUBLIST_PM_1"

#
#	Task Libraries
#
TASKLIB_3_VMAJOR="1"
TASKLIB_3_VMINOR="0"
TASKLIB_2_VMAJOR="1"
TASKLIB_2_VMINOR="0"
TASKLIB_6_TLL="IBM_Corp__Launch_UM_Services__V1_0.tll"
TASKLIB_1_VMAJOR="1"
TASKLIB_1_VMINOR="0"
TASKLIB_4_TLL="IBM_Corp__Install_UM_Services__V1_0.tll"
TASKLIB_3_TLL="IBM_Corp__Hidden_Tasks_for_UM_Services__V1_0.tll"
TASKLIB_6_VREV="a"
TASKLIB_6_VERSION="1.0a"
TASKLIB_5_VERSION="1.0a"
TASKLIB_4_VERSION="1.0a"
TASKLIB_2_VERSION="1.0a"
TASKLIB_1_VERSION="1.0a"
TASKLIB_3_VERSION="1.0a"
TASKLIB_5="Plus Configuration for UM Services"
TASKLIB_1_TLL="IBM_Corp__TEC_Configuration_for_UM_Services__V1_0.tll"
TASKLIB_5_VREV="a"
TASKLIB_4="Install UM Services"
TASKLIB_4_VREV="a"
TASKLIB_3_PLATFORM="unknown"
TASKLIB_1_PLATFORM="unknown"
TASKLIB_2_PLATFORM="unknown"
TASKLIB_4_PLATFORM="unknown"
TASKLIB_5_PLATFORM="unknown"
TASKLIB_6_PLATFORM="unknown"
TASKLIB_3="Hidden Tasks for UM Services"
TASKLIB_5_TLL="IBM_Corp__Plus_Configuration_for_UM_Services__V1_0.tll"
TASKLIB_1="TEC Configuration for UM Services"
TASKLIB_3_VREV="a"
TASKLIB_6_VMAJOR="1"
TASKLIB_6_VMINOR="0"
TASKLIB_2_TLL="IBM_Corp__Administrative_Tasks_for_UM_Services__V1_0.tll"
TASKLIB_2_VREV="a"
TASKLIB_5_VMAJOR="1"
TASKLIB_5_VMINOR="0"
TASKLIB_4_VMAJOR="1"
TASKLIB_6="Launch UM Services"
TASKLIB_4_VMINOR="0"
TASKLIB_1_VREV="a"
TASKLIB_2="Administrative Tasks for UM Services"
TASKLIBS="TASKLIB_1 TASKLIB_2 TASKLIB_3 TASKLIB_4 TASKLIB_5 TASKLIB_6"

#
#	Application Launch Icon Info
#
LAUNCH_ICON_1_DSL="Launch_UM_Services.d"
TASK_4_ICONDSL="Launch_UM_Services_icon.d"
LAUNCH_ICON_1="Launch UM Services"
TASK_4_DEP_1="OS_version.sh"
TASK_3_DEP_1="OS_version.sh"
TASK_2_DEP_1="OS_version.sh"
TASK_1_DEP_1="OS_version.sh"
TASK_4_USER=""
LAUNCH_ICON_1_MENU_2_SCRIPT="ums.sh"
TASK_4_LIBR="$TASKLIB_6"
LAUNCH_ICON_1_MENU_1_DIALOG="ums.sh.d"
TASK_4_ICONSTATE="STATE_UM_SERVICES_Launch_UM_Services_icon.d"
LAUNCH_ICON_1_MENUS="LAUNCH_ICON_1_MENU_1 LAUNCH_ICON_1_MENU_2"
TASK_1_DEP_2="check_app_server.sh"
TASK_2_DEP_2="check_app_server.sh"
TASK_3_DEP_2="check_app_server.sh"
TASK_4_DEP_2="check_app_server.sh"
LAUNCH_ICON_1_MENU_1_SCRIPT="post_ums.sh"
LAUNCH_ICON_1_PLATFORM="unknown"
LAUNCH_ICON_1_MENU_1_ARG_1="hostname"
LAUNCH_ICON_1_MENU_1_ARG_2="port"
TASK_1_TARGETS=""
TASK_2_TARGETS=""
TASK_3_TARGETS=""
TASK_4_TARGETS=""
TASK_1_DEPS="TASK_1_DEP_1 TASK_1_DEP_2"
TASK_2_DEPS="TASK_2_DEP_1 TASK_2_DEP_2"
TASK_3_DEPS="TASK_3_DEP_1 TASK_3_DEP_2"
TASK_4_DEPS="TASK_4_DEP_1 TASK_4_DEP_2"
TASK_4_JOB="Launch UM Services"
TASK_1_INDCOLLS=""
TASK_2_INDCOLLS=""
TASK_3_INDCOLLS=""
TASK_4_INDCOLLS=""
LAUNCH_ICON_1_MENU_1="Launch UM Services"
LAUNCH_ICON_1_MENU_2="Launch UM Services"
TASK_4="Launch UM Services"
TASK_4_SCRIPT="ums.sh"
TASK_4_DIALOG="ums_sh.d"
LAUNCH_ICONS="LAUNCH_ICON_1"

#
#	Install Options
#
INSTALL_OPTS=""

#
#	Generic Tasks
#
TASK_1_TARGETS=""
TASK_2_TARGETS="TASK_2_TARGET_1"
TASK_3_TARGETS="TASK_3_TARGET_1"
TASK_3="Shutdown UM Services"
TASK_2_ICONDSL="Reboot_UM_Services_icon.d"
TASK_1_USER=""
TASK_2="Reboot UM Services"
TASK_3_ICONDSL="Shutdown_UM_Services_icon.d"
TASK_2_TARGET_1="Subscribers of UM Services"
TASK_3_SCRIPT="shutdownUMS.bat"
TASK_3_USER=""
TASK_3_DEP_2="OS_version.sh"
TASK_2_DEP_2="OS_version.sh"
TASK_1_DEP_2="OS_version.sh"
TASK_2_USER=""
TASK_2_JOB="Reboot UM Services"
TASK_1_ICONDSL="Wakeup_UM_Services_icon.d"
TASK_3_DEP_1="check_tme_server.sh"
TASK_2_DEP_1="check_tme_server.sh"
TASK_1_DEP_1="check_tme_server.sh"
#TASK_1_DIALOG="wakeupUMS_sh.d"
TASK_3_LIBR="$TASKLIB_2"
TASK_2_LIBR="$TASKLIB_2"
TASK_1_LIBR="$TASKLIB_2"
TASK_3_JOB="Shutdown UM Services"
TASK_1="Wakeup UM Services"
TASK_1_JOB="Wakeup UM Services"
TASK_1_ICONSTATE="STATE_UM_SERVICES_Wakeup_UM_Services_icon.d"
TASK_2_ICONSTATE="STATE_UM_SERVICES_Reboot_UM_Services_icon.d"
TASK_3_ICONSTATE="STATE_UM_SERVICES_Shutdown_UM_Services_icon.d"
TASK_2_SCRIPT="rebootUMS.bat"
TASK_1_SCRIPT="wakeupUMS.sh"
TASK_3_TARGET_1="Subscribers of UM Services"
TASK_1_TARGET_1="Subscribers of UM Services"
TASKS="TASK_1 TASK_2 TASK_3 TASK_4"

#
#	Dependency Tasks
#


#
#	Sentry Tasks
#


#
#	Plus Configuration Tasks
#
CONFIGTASK_1_DEP_1="OS_version.sh"
CONFIGTASK_1="About UM Services"
CONFIGTASK_1_TARGETS="CONFIGTASK_1_TARGET_1"
CONFIGTASK_1_ICONSTATE="STATE_UM_SERVICES_About_UM_Services_icon.d"
CONFIGTASK_1_DEP_2="check_tme_server.sh"
CONFIGTASK_1_INDCOLLS=""
CONFIGTASK_1_SCRIPT="_about.sh"
CONFIGTASK_1_USER=""
CONFIGTASK_1_TARGET_1="Subscribers of UM Services"
CONFIGTASK_1_DEPS="CONFIGTASK_1_DEP_1 CONFIGTASK_1_DEP_2"
CONFIGTASK_1_JOB="About UM Services"
CONFIGTASK_1_ICONDSL="About_UM_Services_icon.d"
CONFIGTASK_1_LIBR="$TASKLIB_5"
CONFIGTASKS="CONFIGTASK_1"

#
#	Hidden Tasks
#
HIDDENTASK_1="Reload UM Services SNMP Agent"
HIDDENTASK_1_SCRIPT="ReloadSNMP.sh"
HIDDENTASK_2_SCRIPT="RestartHTTP.sh"
HIDDENTASK_2_USER=""
HIDDENTASK_1_USER=""
HIDDENTASK_2_DEP_1="check_tec_server.sh"
HIDDENTASK_1_DEP_1="check_tec_server.sh"
HIDDENTASK_1_TARGETS=""
HIDDENTASK_2_TARGETS=""
HIDDENTASK_1_INDCOLLS=""
HIDDENTASK_2_INDCOLLS=""
HIDDENTASK_2_JOB="Restart UM Services HTTP Server"
HIDDENTASK_2_DEPS="HIDDENTASK_2_DEP_1 HIDDENTASK_2_DEP_2"
HIDDENTASK_1_JOB="Reload UM Services SNMP Agent"
HIDDENTASK_1_DEPS="HIDDENTASK_1_DEP_1 HIDDENTASK_1_DEP_2"
HIDDENTASK_2_DEP_2="OS_version.sh"
HIDDENTASK_1_DEP_2="OS_version.sh"
HIDDENTASK_2="Restart UM Services HTTP Server"
HIDDENTASK_2_LIBR="$TASKLIB_3"
HIDDENTASK_1_LIBR="$TASKLIB_3"
HIDDENTASKS="HIDDENTASK_1 HIDDENTASK_2"

#
#	Logfile Adapter Configuration Tasks
#


#
#	TEC Configuration Tasks
#
TECTASK_1_JOB="Setup TEC Event Server for UM Services"
TECTASK_1_LIBR="$TASKLIB_1"
TECTASK_1="Setup TEC Event Server for UM Services"
TECTASK_1_USER=""
TECTASK_1_DEPS="TECTASK_1_DEP_1 TECTASK_1_DEP_2"
TECTASK_1_ICONDSL="Setup_TEC_Event_Server_for_UM_Services_icon.d"
TECTASK_1_INDCOLLS=""
TECTASK_1_DEP_2="OS_version.sh"
TECTASK_1_ICONSTATE="STATE_UM_SERVICES_Setup_TEC_Event_Server_for_UM_Services_icon.d"
TECTASK_1_DEP_1="check_tec_server.sh"
TECTASK_1_TARGETS=""
TECTASK_1_DIALOG="rb_setup_sh.d"
TECTASK_1_SCRIPT="rb_setup.sh"
TECTASKS="TECTASK_1"

#
#	Baroc files
#
TEC_BAROC_FILE_2="$PRODDIR/IBM_Corp__Monitors_for_UM_Services__V1_0.baroc"
TEC_BAROC_FILE_1="$PRODDIR/UMStecad_snmp.baroc"
TEC_BAROC_FILES="TEC_BAROC_FILE_1 TEC_BAROC_FILE_2"

#
#	FMT files
#
TEC_FMT_FILES=""

#
#	Rules files
#
TEC_RULE_FILE_1="$PRODDIR/ums.rls"
TEC_RULE_FILES="TEC_RULE_FILE_1"

#
#	File package configuration tasks
#
FILEPACKTASKS="FILEPACKTASK_1"

#
#	File Package Info
#
FILEPACKTASK_1_JOB="Prepare for UM Services install"
FILEPACK_1_CONFIG_TASKS="TRUE"
FILEPACK_1_FPKEYWORDS="E3_Filepack_Client_cdf_filepackage.keywords"
FILEPACK_1_FPNESTFPS="E3_Filepack_Client_cdf_filepackage.nested_fps"
FILEPACK_1="Install UM Services"
FILEPACK_1_TARGETS="FILEPACK_1_TARGET_1"
FILEPACKTASK_1="Prepare for UM Services install"
FILEPACKTASK_1_ICONDSL="Prepare_for_UM_Services_install_icon.d"
FILEPACKTASK_1_SCRIPT="ums_config_fp.sh"
FILEPACKTASK_1_DEP_2="OS_version.sh"
FILEPACK_1_DEPS="FILEPACK_1_DEP_1 FILEPACK_1_DEP_2"
FILEPACKTASK_1_TARGET_1="Subscribers of UM Services"
FILEPACKTASK_1_DEPS="FILEPACKTASK_1_DEP_1 FILEPACKTASK_1_DEP_2"
FILEPACK_1_TARGET_1="Subscribers of UM Services"
FILEPACKTASK_1_INDCOLLS=""
FILEPACK_1_ICONSTATE="STATE_UM_SERVICES_Install_UM_Services_icon.d"
FILEPACK_1_VREV="a"
FILEPACKTASK_1_DIALOG="ums_config_fp_sh.d"
FILEPACK_1_DEP_1="check_tme_server.sh"
FILEPACK_1_FPEXCLFILES="E3_Filepack_Client_cdf_filepackage.excluded_files"
FILEPACK_1_FPINCLFILES="E3_Filepack_Client_cdf_filepackage.included_files"
FILEPACK_1_PLATFORM="unknown"
FILEPACK_1_SHORTNAME="E3_Filepack_Client_cdf_filepackage"
FILEPACK_1_FPDEF="E3_Filepack_Client_cdf_filepackage.def"
FILEPACK_1_INDCOLLS=""
FILEPACKTASK_1_TARGETS="FILEPACKTASK_1_TARGET_1"
FILEPACK_1_VERSION="1.0a"
FILEPACKTASK_1_USER=""
FILEPACKTASK_1_LIBR="$TASKLIB_4"
FILEPACK_1_VMAJOR="1"
FILEPACK_1_VMINOR="0"
FILEPACK_1_ICONDSL="Install_UM_Services_icon.d"
FILEPACKTASK_1_DEP_1="check_tme_server.sh"
FILEPACK_1_DEP_2="OS_version.sh"
FILEPACK_1_FPDEFHEADER="E3_Filepack_Client_cdf_filepackage.header"
FILEPACKTASK_1_ICONSTATE="STATE_UM_SERVICES_Prepare_for_UM_Services_install_icon.d"
FILEPACKS="FILEPACK_1"

#
#	Indicator Collection Info
#
INDCOLL_1="Indicators for UM Services Monitors"
INDCOLL_1_DEPS="INDCOLL_1_DEP_1 INDCOLL_1_DEP_2"
INDCOLL_1_DEP_2="check_tme_server.sh"
INDCOLL_1_DEP_1="OS_version.sh"
INDCOLL_1_PLATFORM="unknown"
INDCOLLS="INDCOLL_1"

#
#	Sentry PMs
#
SENTRY_PM_1="Monitors for UM Services"
SENTRY_PM_1_ICONDSL="Monitors_for_UM_Services_icon.d"
SENTRY_PM_1_TARGET_1="Subscribers of UM Services"
SENTRY_PM_1_VERSION="1.0a"
SENTRY_PM_1_INDCOLL_1="Indicators for UM Services Monitors"
SENTRY_PM_1_PLATFORM="unknown"
SENTRY_PM_1_VREV="a"
SENTRY_PM_1_VMAJOR="1"
SENTRY_PM_1_VMINOR="0"
SENTRY_PM_1_ICONSTATE="STATE_UM_SERVICES_Monitors_for_UM_Services_icon.d"
SENTRY_PM_1_INDCOLLS="SENTRY_PM_1_INDCOLL_1"
SENTRY_PM_1_TARGETS="SENTRY_PM_1_TARGET_1"
SENTRY_PMS="SENTRY_PM_1"

#
#	Monitors
#
MONITOR_2="SNMPCheck"
MONITOR_1_COND_1_LEVEL="critical"
MONITOR_1="HTTPCheck"
MONITOR_2_COND_1_VALUE="down"
MONITOR_1_COND_1_VALUE="down"
MONITOR_1_COND_1_LIBR="$TASKLIB_4"
MONITOR_2_COND_1_LEVEL="critical"
MONITOR_2_ARGS=""
MONITOR_2_COND_1_TEC_CLAUSE="$TEC_SENTRY_CRITICAL_CLAUSE"
MONITOR_1_COND_1_TEC_CLAUSE="$TEC_SENTRY_CRITICAL_CLAUSE"
MONITOR_2_COND_1_LIBR="$TASKLIB_4"
MONITOR_2_SAMP="5 minutes"
MONITOR_1_SAMP="5 minutes"
MONITOR_2_PROG="null/SNMPCheck"
MONITOR_1_ARGS=""
MONITOR_1_PM="$SENTRY_PM_1"
MONITOR_2_PM="$SENTRY_PM_1"
MONITOR_1_CONDS="MONITOR_1_COND_1"
MONITOR_1_PMVAR="SENTRY_PM_1"
MONITOR_2_PMVAR="SENTRY_PM_1"
MONITOR_1_PROG="null/HTTPCheck"
MONITOR_2_CONDS="MONITOR_2_COND_1"
MONITOR_1_MONCAPCOL="IBM_Corp__Monitors_for_UM_Services__V1_0"
MONITOR_2_MONCAPCOL="IBM_Corp__Monitors_for_UM_Services__V1_0"
MONITOR_2_COND_1_TASK=""
MONITOR_1_COND_1_TASK=""
MONITOR_2_COND_1_OPER="->"
MONITOR_1_COND_1_OPER="->"
MONITORS="MONITOR_1 MONITOR_2"
