#!/bin/sh
#
# File:		ReloadSNMP.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

###
#
# is_OS_NT
#
is_OS_NT() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ "`uname`" = "Windows_NT" ]; then
    return 0
  else
    return 1
  fi
}

############### Start of main ################################################
if [ -n "" ]; then
	set -x
fi

rc=0
PROGNAME=`echo $0 | sed -e 's.\\\\./.g'`
PROGNAME=`basename $PROGNAME`

echo "*** Executing $PROGNAME"
if is_OS_NT; then
	status=$("$UMS_HOME/TME/bin/StartService" /C SNMP)
	echo "SNMP Status = $status"
	if [ $status = up ]; then
		dependency=$("$UMS_HOME/TME/bin/StartService" /E SNMP)
		while [ $status = up ]; do
			sleep 10
			status=$("$UMS_HOME/TME/bin/StartService" /C SNMP)
		done
		for service in $dependency; do
			echo "Starting $service"
			"$UMS_HOME/TME/bin/StartService" /S $service
		done
	else
		echo "Starting SNMP"
		"$UMS_HOME/TME/bin/StartService" /S SNMP
	fi
else
	start snmp.exe
fi
echo "*** Exiting $PROGNAME with return code $rc"
exit $rc
