#
#   IBM UMS event class definition statements
#
#   Generic Event

CLASS UMS_GenericEvent
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGGenericEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGGenericEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END

#   Temperature Event

CLASS UMS_TemperatureNormal
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGTemperatureEventSeverity"), VALUE(=,0) ;
    3: ATTR(=,"iBMPSGTemperatureEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END

CLASS UMS_TemperatureOutOfRange
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGTemperatureEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGTemperatureEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;
    msg = PRINTF("%s from system %s",$V3,$F1);
END

CLASS UMS_TemperatureCriticallyOutOfRange
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGTemperatureEventSeverity"), VALUE(=,2) ;
    3: ATTR(=,"iBMPSGTemperatureEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   Voltage Event

CLASS UMS_VoltageNormal
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGVoltageEventSeverity"), VALUE(=,0) ;
    3: ATTR(=,"iBMPSGVoltageEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END

CLASS UMS_VoltageOutOfRange
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGVoltageEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGVoltageEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;
    msg = PRINTF("%s from system %s",$V3,$F1);
END

CLASS UMS_VoltageCriticallyOutOfRange
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGVoltageEventSeverity"), VALUE(=,2) ;
    3: ATTR(=,"iBMPSGVoltageEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END

#   Chassis Event

CLASS UMS_ChassisInPlace
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGChassisEventSeverity"), VALUE(=,0) ;
    3: ATTR(=,"iBMPSGChassisEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END

CLASS UMS_ChassisIntruded
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGChassisEventSeverity"), VALUE(=,2) ;
    3: ATTR(=,"iBMPSGChassisEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;
    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   Fan Event

CLASS UMS_FanOperational
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGFanEventSeverity"), VALUE(=,0) ;
    3: ATTR(=,"iBMPSGFanEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END

CLASS UMS_FanOutOfOrder
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGFanEventSeverity"), VALUE(=,2) ;
    3: ATTR(=,"iBMPSGFanEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;
    msg = PRINTF("%s from system %s",$V3,$F1);
END

#   Processor Event

CLASS UMS_Processor
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGProcessorEventSeverity"), VALUE(=,0) ;
    3: ATTR(=,"iBMPSGProcessorEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END

CLASS UMS_ProcessorRemoved
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGProcessorEventSeverity"), VALUE(=,2) ;
    3: ATTR(=,"iBMPSGProcessorEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;
    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   Storage Event

CLASS UMS_StorageNormal
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGStorageEventSeverity"), VALUE(=,0) ;
    3: ATTR(=,"iBMPSGStorageEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END

CLASS UMS_StorageLow
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGStorageEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGStorageEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;
    msg = PRINTF("%s from system %s",$V3,$F1);
END

CLASS UMS_StorageVeryLow
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGStorageEventSeverity"), VALUE(=,2) ;
    3: ATTR(=,"iBMPSGStorageEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   Asset Event

CLASS UMS_AssetChanged
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGAssetEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGAssetEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   SMART Event

CLASS UMS_SMARTEvent
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGSMARTEventSeverity"), VALUE(=,2) ;
    3: ATTR(=,"iBMPSGSMARTEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;
    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   POST Event

CLASS UMS_POSTEvent
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGPOSTEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGPOSTEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   Configuration Change Event

CLASS UMS_ConfigurationChanged
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGConfigurationChangeEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGConfigurationChangeEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   LANLeash Event

CLASS UMS_LANLeashEvent
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGLANLeashEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGLANLeashEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;
    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   Lease Expiration Event

CLASS UMS_LeaseExpired
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGLeaseExpirationEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGLeaseExpirationEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END


#   Warranty Expiration Event

CLASS UMS_WarrantyExpired
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.159") ;
    2: ATTR(=,"iBMPSGWarrantyExpirationEventSeverity"), VALUE(=,1) ;
    3: ATTR(=,"iBMPSGWarrantyExpirationEventDescription") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    description = $V3 ;

    msg = PRINTF("%s from system %s",$V3,$F1);
END

#
#  Netfinity Director event class definitions
#

CLASS Netfinity_Director_Event
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.146") ;
    2: ATTR(=,"trapSeverity"), VALUE(CONTAINS, "Unknown") ;
    3: ATTR(=,"trapSenderName") ;
    4: ATTR(=,"trapText") ;
    5: ATTR(=,"trapOriginator") ;
    6: ATTR(=,"trapCategory") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    trapSenderName = $V3;
    description = $V4 ;
    trapOriginator = $V5;
    trapCategory = $V6;

    msg = PRINTF("System %s had an unknown trap described as followed: %s",$V5,$V4);
END

CLASS Netfinity_Director_Event_INFO
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.146") ;
    2: ATTR(=,"trapSeverity"), VALUE(CONTAINS, "Harmless") ;
    3: ATTR(=,"trapSenderName") ;
    4: ATTR(=,"trapText") ;
    5: ATTR(=,"trapOriginator") ;
    6: ATTR(=,"trapCategory") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    trapSenderName = $V3;
    description = $V4 ;
    trapOriginator = $V5;
    trapCategory = $V6;

    msg = PRINTF("For your information, system %s had a trap described as followed: %s",$V5,$V4);
END

CLASS Netfinity_Director_Event_WARNING
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.146") ;
    2: ATTR(=,"trapSeverity"), VALUE(CONTAINS, "Warning") ;
    3: ATTR(=,"trapSenderName") ;
    4: ATTR(=,"trapText") ;
    5: ATTR(=,"trapOriginator") ;
    6: ATTR(=,"trapCategory") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    trapSenderName = $V3;
    description = $V4 ;
    trapOriginator = $V5;
    trapCategory = $V6;

    msg = PRINTF("System %s had a trap described as followed: %s",$V5,$V4);
END

CLASS Netfinity_Director_Event_MINOR
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.146") ;
    2: ATTR(=,"trapSeverity"), VALUE(CONTAINS, "Minor") ;
    3: ATTR(=,"trapSenderName") ;
    4: ATTR(=,"trapText") ;
    5: ATTR(=,"trapOriginator") ;
    6: ATTR(=,"trapCategory") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    trapSenderName = $V3;
    description = $V4 ;
    trapOriginator = $V5;
    trapCategory = $V6;

    msg = PRINTF("System %s had a trap described as followed: %s",$V5,$V4);
END

CLASS Netfinity_Director_Event_CRITICAL
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.146") ;
    2: ATTR(=,"trapSeverity"), VALUE(CONTAINS, "Critical") ;
    3: ATTR(=,"trapSenderName") ;
    4: ATTR(=,"trapText") ;
    5: ATTR(=,"trapOriginator") ;
    6: ATTR(=,"trapCategory") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    trapSenderName = $V3;
    description = $V4 ;
    trapOriginator = $V5;
    trapCategory = $V6;

    msg = PRINTF("System %s had a trap described as followed: %s",$V5,$V4);
END

CLASS Netfinity_Director_Event_FATAL
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.2.6.146") ;
    2: ATTR(=,"trapSeverity"), VALUE(CONTAINS, "Fatal") ;
    3: ATTR(=,"trapSenderName") ;
    4: ATTR(=,"trapText") ;
    5: ATTR(=,"trapOriginator") ;
    6: ATTR(=,"trapCategory") ;
  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    trapSenderName = $V3;
    description = $V4 ;
    trapOriginator = $V5;
    trapCategory = $V6;

    msg = PRINTF("System %s had a trap described as followed: %s",$V5,$V4);
END


# AOL Traps

CLASS UMS_AOLPresenceHeartbeat
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 0;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Presence heartbeat expired in system %s", $V3);
END

CLASS UMS_AOLCoverTamper
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 1;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Cover tampered in system %s", $V3);
END

CLASS UMS_AOLVoltageFanTemp
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 2;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Voltage/fan/Temperature out of specification in system %s", $V3);
END

CLASS UMS_AOLLANLeash
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 3;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("LAN leash tampered in system %s", $V3);
END

CLASS UMS_AOLTemperature
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 4;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Temperature out of specification in system %s", $V3);
END

CLASS UMS_AOLProcessorMissing
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 5;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Processor missing in system %s", $V3);
END

CLASS UMS_AOLProcessorTemp
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 6;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Processor over temperature in system %s", $V3);
END

CLASS UMS_AOLWatchdog
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 7;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Watchdog event has occurred in system %s", $V3);
END

CLASS UMS_AOLPOST
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 8;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("P.O.S.T. event has occurred in system %s", $V3);
END

CLASS UMS_AOLUnknownEvent
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 9;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Unknown event has occurred in system %s", $V3);
END

CLASS UMS_AOLProcessor0Missing
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 10;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Processor 0 missing in system %s", $V3);
END

CLASS UMS_AOLProcessor1Missing
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 11;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Processor 1 missing in system %s", $V3);
END

CLASS UMS_AOLVoltageFan
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 12;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Voltage/fan out of specification in system %s", $V3);
END

CLASS UMS_AOLVoltage
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 13;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Voltage out of specification in system %s", $V3);
END

CLASS UMS_AOLFan
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 14;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Fan out of specification in system %s", $V3);
END

CLASS UMS_AOLFanTemp
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 15;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Fan/temperature out of specification in system %s", $V3);
END

CLASS UMS_AOLVoltageTemp
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 16;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Voltage/temperature out of specification in system %s", $V3);
END

CLASS UMS_AOLUndock
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 17;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Surprised undock event has occurred in system %s", $V3);
END

CLASS UMS_AOLEventClear
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 18;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Event clear has occurred in system %s", $V3);
END

CLASS UMS_AOLClientAdded
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 19;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Client added in system %s", $V3);
END

CLASS UMS_AOLClientDeleted
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.343.2.8.1.1") ;
    2: $SPECIFIC = 20;
    3: ATTR(=,"systemName") ;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
    systemName = $V3;
   
    msg = PRINTF("Client deleted in system %s", $V3);
END

CLASS UMS_PETPresenceHeartbeat
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 2584320;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Presence heartbeat expired", $F1);
END

CLASS UMS_PETCoverTamper
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 356096;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Cover tampered in system", $F1);
END

CLASS UMS_PETVoltageFanTemp
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 552706;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Voltage/fan/temperature out of specification", $F1);
END

CLASS UMS_PETLANLeash
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 356100;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: LAN leash tampered", $F1);
END

CLASS UMS_PETTemperature
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 93952;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Temperature out of specification", $F1);
END

CLASS UMS_PETProcessorMissing
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 356099;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Processor missing", $F1);
END

CLASS UMS_PETProcessorTemp
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 487169;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Processor over temperature", $F1);
END

CLASS UMS_PETWatchdog
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 1142534;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Watchdog event has occurred", $F1);
END

CLASS UMS_PETPOST
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 1011456;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: P.O.S.T. event has occurred", $F1);
END

CLASS UMS_PETVoltage
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 159488;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Voltage out of specification", $F1);
END

CLASS UMS_PETFan
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 290560;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Fan out of specification", $F1);
END

CLASS UMS_PETFanTemp
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 683778;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Fan/temperature out of specification", $F1);
END

CLASS UMS_PETUndock
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 356101;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Surprised undock event has occurred", $F1);
END

CLASS UMS_PETEventClear
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 1076994;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Event clear has occurred", $F1);
END

CLASS UMS_PETAlertOnLAN
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.3183.1.1") ;
    2: $SPECIFIC = 2277391;

  FETCH
    1:IPNAME($AGENT_ADDR) ;
  MAP
    hostname = $F1;
   
    msg = PRINTF("Host %s sent a trap described as: Alert on LAN 2 has occurred", $F1);
END

