#!/bin/sh
#
# File:		_about.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

###
#
#   errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

########################################################################

if [ -n "" ]; then
        DEBUG=true
fi
[ "$DEBUG" = true ] && set -x

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT="_about.sh"

#
#       Make sure we're running on a Managed Node
#
if is_lcf_ep; then
  errecho "Cannot run $THIS_SCRIPT: endpoint $ENDPOINT_OID is not a ManagedNode"
  exit 1
fi

#
#	The standard directory and the (optional) /Plus override script
#
ETC=/etc/Tivoli
SETUP_SCRIPT=""

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
	SETUP_SCRIPT=setup_env.sh
fi

. $ETC/$SETUP_SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/UM_SERVICES
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts may be
#		redirected to a file in TEMP by the same name as the script.
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > $DEBUGDIR/$THIS_SCRIPT 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv

#
#	If there are install options from PLUSproduct-info.sh, bring them in!
#
if [ -n "$INSTALL_OPTS" ]; then
	. $LINKDIR/PLUSget_install_opts.sh
fi

###############################################################################
###############################################################################

#
#	Display the product name and version, manufacturer, etc.
#
if [ -n "$MEDIUM_PRODNAME" ]; then
	echo "About $MEDIUM_PRODNAME:" 
fi

if [ -n "$SHORT_VERSION" ]; then
	echo "  Version:           $SHORT_VERSION" 
fi

if [ -n "$VERSION_REV" ]; then
	echo "  Revision:          $VERSION_REV" 
fi

if [ -n "$PRODDIR" ]; then
	echo "  Product Directory: $PRODDIR" 
fi

if [ -n "$APP_MANUFACTURER" ]; then
	echo "  Manufacturer:      $APP_MANUFACTURER" 
fi

if [ -n "$APP_LANGID" ]; then
	echo "  Language ID:       $APP_LANGID" 
fi

APP_PARTNO="00N9043"
if [ -n "$APP_PARTNO" ]; then
	echo "  Part Number:       $APP_PARTNO" 
fi

APP_COPYRIGHT1="Licensed Program Product: IBM Universal Manageability Services"
APP_COPYRIGHT2=" "
APP_COPYRIGHT3="(C) COPYRIGHT IBM Corporation. 1996, 1997, 1998, 1999"
APP_COPYRIGHT4="All Rights Reserved"
APP_COPYRIGHT5=" "
APP_COPYRIGHT6="US Government Users Restricted Rights - Use, duplication,"
APP_COPYRIGHT7="or disclosure restricted by GSA ADP Schedule Contract with"
APP_COPYRIGHT8="IBM Corp. and its licensors."
APP_COPYRIGHT9=" "

if [ -n "$APP_COPYRIGHT1" ]; then
	echo "  Copyright:     $APP_COPYRIGHT1" 
	echo "                 $APP_COPYRIGHT2" 
	echo "                 $APP_COPYRIGHT3" 
	echo "                 $APP_COPYRIGHT4" 
	echo "                 $APP_COPYRIGHT5" 
	echo "                 $APP_COPYRIGHT6" 
	echo "                 $APP_COPYRIGHT7" 
	echo "                 $APP_COPYRIGHT8" 
	echo "                 $APP_COPYRIGHT9" 
fi

if [ -n "$APP_DESCRIPTION" ]; then
	echo "-------------------------------------" 
	echo "$APP_DESCRIPTION" 
fi
