#!/bin/sh
#
# File:		check_app_client.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

###
#
#   errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

########################################################################

if [ -n "" ]; then
        DEBUG=true
fi
[ "$DEBUG" = true ] && set -x

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT="check_app_client.sh"

#
#       Make sure we're running on a Managed Node
#
if is_lcf_ep; then
  errecho "Cannot run $THIS_SCRIPT: endpoint $ENDPOINT_OID is not a ManagedNode"
  exit 1
fi

#
#	The standard directory and the (optional) /Plus override script
#
ETC=/etc/Tivoli
SETUP_SCRIPT=""

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
	SETUP_SCRIPT=setup_env.sh
fi

. $ETC/$SETUP_SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/UM_SERVICES
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug
[ -d "$DEBUGDIR" ] && exec > $DEBUGDIR/$THIS_SCRIPT 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv

#
#	If there are install options from PLUSproduct-info.sh, bring them in!
#
if [ -n "$INSTALL_OPTS" ]; then
	. $LINKDIR/PLUSget_install_opts.sh
fi

###############################################################################
###############################################################################
#
# Insert your application specific code here, using the following as an example
#
###############################################################################
###############################################################################

#STATUS=0
# change to 1 so that the managed node does not become the subscriber
STATUS=1

echo "*** Executing $THIS_SCRIPT"

# if dependencies are okay and configuration of this component should continue,
# then 
#	STATUS=0
# else
# 	STATUS=1
# fi

echo "*** Exiting $THIS_SCRIPT ($TASK_PROGPATH) with return code $STATUS"

exit $STATUS
