#!/bin/sh
#
# File:		post_ums.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#
if [ -n "" ]; then
	set -x
fi

#
#	The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f $ETC/$SCRIPT ]; then
	SCRIPT=setup_env.sh
fi

. $ETC/$SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/UM_SERVICES
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug

SCRIPTNAME=`echo $0 | tr "\\\\\\\\" "/"`
SCRIPTNAME=`basename $SCRIPTNAME`

[ -d "$DEBUGDIR" ] && exec > $DEBUGDIR/$SCRIPTNAME 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv

TASK_NAME="Launch UM Services"
ARGLIST="hostname port"
COMPONENT_NAME="Launch UM Services"

DIALOG_DESCRIPTOR="ums.sh.d"

if [ "$DIALOG_DESCRIPTOR" = "$INSTALL_OPTS_DIALOG" ]; then
  IS_INSTALL_OPTS=true
  ARGS_TO_ITERATE="$INSTALL_OPTS"
else
  IS_INSTALL_OPTS=false
  ARGS_TO_ITERATE="$ARGLIST"
fi

ARGS=""

#
#	First retrieve the previous values for the arguments
#
for var in $ARGS_TO_ITERATE; do
	if [ "$IS_INSTALL_OPTS" = true ]; then

		# each INSTALL_OPT needs "eval'ed" and a different pres object
		eval REALVAR='"$'$var'"'
		eval OPTNAME='"$'$var'_NAME"'

		#	This is the name of the presentation object on which
		#		install opts variables are hung.
		PRESNAME=@Presentation:"$OPTNAME"_"$MNNAME"
	else
		REALVAR="$var"
		PRESNAME=@Presentation:"$COMPONENT_NAME"_"$MNNAME"_"$MEDIUM_PRODNAME"
	fi		

	#	Retrieve the current value, tack on quotes needed by wpostdialog
	VALUE=`wgetattr $REALVAR "$PRESNAME"` >/dev/null 2>&1
	VALUE=\""'$VALUE'"\" 

	#	accumulate the arguments for the call to wpostdialog
	ARGS="$ARGS $REALVAR $VALUE"
done

#
#	Display the dialog with the current settings
#
DIALOG_NAME=\""'$TASK_NAME'"\"
eval wpostdialog $DIALOG_DESCRIPTOR dialog_name $DIALOG_NAME \
	$ARGS application APPICON

#
#	Check the return code from the dialog
#
if [ $? -ne 0 ] ; then
	wdispmsg "Unable to post the argument prompt dialog"
	exit 1
fi

exit 0
