#!/bin/sh
#
# File:         rb_setup.sh
#
# Product:      Tivoli Module
# Description:  Shell Script
# Author:               Module Generator
#
# Generated:    
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

###
#
#   errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

########################################################################

if [ -n "" ]; then
        DEBUG=true
fi
[ "$DEBUG" = true ] && set -x

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT="rb_setup.sh"

#
#       Make sure we're running on a Managed Node
#
if is_lcf_ep; then
  errecho "Cannot run $THIS_SCRIPT: endpoint $ENDPOINT_OID is not a ManagedNode"
  exit 1
fi

#
#	The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f $ETC/$SCRIPT ]; then
	SCRIPT=setup_env.sh
fi

. $ETC/$SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/UM_SERVICES
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh
export WINSTRUCTED
export MODULE_VERSION

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > $DEBUGDIR/$THIS_SCRIPT 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv
if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" -o "$DEBUG" = true ]; then
  DEBUG=true
else
  DEBUG=false
fi
export DEBUG

#
#	Messages
#
ERRNORULEBASE="Error: Missing value for argument \"Rule Base Name\""

SOURCE_NAME=UM_SERVICES

###################
# Support Functions
###################

errexit()
{
	echo "$*" >&2
	exit 1
}

. $LINKDIR/PLUScommon-tec-install.sh

echo "*** Executing $THIS_SCRIPT ($TASK_PROGPATH)"

###################
# Process Arguments
###################

#
#	Usage Check
#
ARGLIST="Rule_Base_Name__new_or_existing__ Rule_Base_to_clone__if_new__ Path_for_Rule_Base__if_new__ Name_of_Event_Console_to_configure__optional__"

if [ $# -ne `echo $ARGLIST | wc -w` ]; then
	errexit "Usage: $THIS_SCRIPT $ARGLIST"
fi

RB_NAME=$1
RB_TO_CLONE=$2
RB_PATH=$3
EV_CONSOLE=$4

if [ ! "$RB_NAME" ]; then
	errexit "$ERRNORULEBASE"
fi

#UseNew=$1
#UseExisting=$2
#ExistingRulebase=$3
#NewRulebase=$4
#CloneRulebase=$5
#RulebasePath=$6
#EventConsole=$7

#
#  Map arguments to some standard variable names
#
if [ "$RB_TO_CLONE" ]; then
  UseNew=on
  NewRulebase="$RB_NAME"
  CloneRulebase="$RB_TO_CLONE"
else
  UseExisting=on
  ExistingRulebase="$RB_NAME"
fi
RulebasePath="$RB_PATH"
EventConsole="$EV_CONSOLE"


if   [ "$UseNew" = on ]; then
	Rulebase=$NewRulebase
	if wlsrb "^${Rulebase}$" > /dev/null 2>&1 ;then
		errmsg "There is an existing '${Rulebase}' rule base."
		exit 1
	fi
elif [ "$UseExisting" = on ]; then
	Rulebase=$ExistingRulebase
	if wlsrb "^${Rulebase}$" >/dev/null 2>&1 ;then
		debugmsg "Found rule base '${Rulebase}'"
	else
		errmsg "The rule base '${Rulebase}' does not exist." >&2
		exit 1
	fi
else
	errmsg "You must specify either a new or an existing rule base."
	exit 1
fi

# when a duplicate event source is found, should we delete it
PreDeleteEventGroup=0
PreDeleteEventSources=0

#Sources="Source1 Source2 Source3"
Sources="Source1"
#Source2="$SOURCE_NAME"  Source1Bitmap="JLINK"
Source1="SENTRY"        Source2Bitmap="sentry48"
#Source3="LOGFILE"       Source3Bitmap="logf48"

#Filters="Filter1 Filter2 Filter3 Filter4"
Filters="Filter1 Filter2"
#Filter1="-c UMS_EVENT -s $SOURCE_NAME"

Filter1="-c UMS_EVENT -s SNMP"

Filter2="-c IBM_Corp__Monitors_for_UM_Services__V1_0 -s SENTRY"

#Filter2="-c ${SHORT_Prodname}Base -s $SOURCE_NAME"
#Filter3="-c ${SHORT_Prodname}Base -s LOGFILE"
#Filter4="-c ${SHORT_Prodname}CustomMonitors -s SENTRY"

PlusRules="$LINKDIR/tivoli_plus.rls"
UMSRules='ums.rls'
RulesFiles="$PlusRules $UMSRules"
for f in $TEC_RULE_FILES; do
	eval RULE_FILE='"$'$f'"'
	RulesFiles="$RULE_FILE $RulesFiles"
done
for f in $TEC_BAROC_FILES; do
	eval BAROC_FILE='"$'$f'"'
	ClassFiles="$ClassFiles $BAROC_FILE"
done
ClassIfPresent="${SHORT_Prodname}Base"

DM_VERSION=3_5

DM_MAJOR=`echo $DM_VERS | awk -F. '{print $1}' | awk -F_ '{print $1}'`
DM_MINOR=`echo $DM_VERS | awk -F. '{print $2}' | awk -F_ '{print $2}'`
if [ ! "$DM_MAJOR" ]; then
  DM_MAJOR=3; DM_MINOR=5
elif [ ! "$DM_MINOR" ]; then
  DM_MAJOR=3; DM_MINOR=5
fi
### Avoid referring to a DM version, but if needed you could do the next 3 statements:
#DM_CLASS=Sentry${DM_MAJOR}_${DM_MINOR}
#DM_BASE_CLASS=${DM_CLASS}_Base
#DM_MON_BAROC_FILE=Sentry${DM_MAJOR}.${DM_MINOR}Monitors.baroc

DM_CLASS=DM_Extension
DM_CLASS_BASE=${DM_CLASS}_Base
DM_MON_BAROC_FILES=""

baroc_files="
  Sentry.baroc 
  Sentry2.0Monitors.baroc 
  Sentry3.5Monitors.baroc
"
for f1 in $DM_MON_BAROC_FILES; do
  new=true
  for f2 in $baroc_files; do
    if [ "$f1" = "$f2" ]; then
      new=false
      break
    fi
  done 
  if $new; then
    baroc_files="$baroc_files $f1"
  fi
done

# class checked to determine if $SentryClassFiles needs to be installed
SentryClassFile=$DM_CLASS_BASE     

# baroc files installed if $SentryClassFile doesn't exist
SentryClassFiles="`echo ${baroc_files}`"   
###SentryClassFiles="${LINKDIR}/Sentry.baroc ${LINKDIR}/${DM_MON_BAROC_FILE}"

LocalClassPath=$BINDIR/../generic/SentryMonitors
TMRClassPath=`get_tme_server_SentryMonitors_path`
LinkClassPath=$LINKDIR
ProdClassPath=$PRODDIR

### Modify this if desired:
ClassPathSearchOrder="$ProdClassPath $TMRClassPath $LocalClassPath $LinkClassPath"

#EventGroup="${SHORT_Prodname}Plus"
EventGroup="UM_Services_Plus"
EventGroupRoles="senior admin user"

verify_rule_base
if $CreateNewRulebase; then
	echo Creating new rulebase $Rulebase
	verify_clone_rule_base
	VerificationRB=$CloneRulebase
else
	echo $Rulebase already exists
	VerificationRB=$Rulebase
fi
verify_event_console
verify_sentry_classes
verify_current_rule_base_compiles

if $CreateNewRulebase; then
	create_new_rule_base
	clone_rule_base
	verify_new_rule_base_compiles
fi

import_new_classes

$PreDeletePlusRules && delete_plus_rules
import_new_rules

verify_new_rule_base_compiles


# we do not need to UM Services source since we do not have the specialized adapter for it
# install_new_event_source
install_new_event_group
install_new_event_filters

assign_event_group_to_console

load_new_rules

install_trouble_ticket_script

restart_event_server
