#!/bin/sh
#
# File:		ums.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

###
#
#   errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

###
#
# is_managed_node
#
is_managed_node() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 0
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 1
  else
    return 0
  fi
}

###
#
# is_OS_NT
#
is_OS_NT() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ "`uname`" = "Windows_NT" ]; then
    return 0
  else
    return 1
  fi
}


###
#
#   Return value for BINDIR
#
bindir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    INTERP=`objcall $OSERV query interp`; export INTERP
    inst_dir="`objcall $OSERV query install_dir`"
    bindir="$inst_dir/$INTERP"
  else
    bindir="$LCF_BINDIR/.."
  fi
  bindir="`echo $bindir | sed -e 's,\\\\,/,g'`"
  echo $bindir
}

###
#
#   Return value for INST_DIR
#
inst_dir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    inst_dir="`objcall $OSERV query install_dir`"
  else
    inst_dir="$LCFROOT"
  fi
  inst_dir="`echo $inst_dir | sed -e 's,\\\\,/,g'`"
  echo $inst_dir
}

###
#
#   Return correct value for tmp directory
#
temp() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    temp=/tmp
    if is_OS_NT; then
	temp="$DBDIR/tmp"
    fi
  else
    if [ -n "$LCF_TEMPDIR" ]; then
      temp="$LCF_TEMPDIR"
    else
      temp="$LCF_DATDIR/tmp"
    fi
  fi
  if [ ! -d "$temp" ]; then
    mkdir -p "$temp"
  fi
  echo $temp
}

###
#
#    Find the Tivoli etc directory and source the right environment setup file
#
source_etc_setup_env() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    ETC=/etc/Tivoli

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/system32/drivers/etc/Tivoli
    fi

    # Look for the optional Plus override script, if not there use the standard one
    SETUP_SCRIPT=""
    if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
	SETUP_SCRIPT=setup_env.sh
    fi
    . $ETC/$SETUP_SCRIPT
  else
    # not a managed node; find the most recent lcf_env.sh and source it
    ETC=/etc/Tivoli/lcf

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/Tivoli/lcf
    fi
    SETUP_SCRIPT=lcf_env.sh
    LCF_ETC_SCRIPT=`echo \`ls -td ${ETC}/*\` | awk '{print $1}'`/$SETUP_SCRIPT
    if [ -f "$LCF_ETC_SCRIPT" ]; then
      . $LCF_ETC_SCRIPT
    fi
  fi
}

###
#
# ironame
#
ironame() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    #
    #	Get the region name to avoid collisions
    #
    iro=`wlookup InterRegion`
    ironame=`idlattr -t -g $iro name string`
    ironame=`eval echo $ironame`
    echo $ironame
  else
    echo ""
  fi
}

###
#
# mnname
#
mnname() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    mnoid=`objcall 0.0.0 get_host_location`
    eval mnname=`idlattr -t -g $mnoid label string`
    echo $mnname
  else
    echo ""
  fi
}

###
#
# source_product_info
#
source_product_info() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -d "$1" ]; then
    cd "$1"
    if [ -f PLUSproduct-info.sh ]; then
      . ./PLUSproduct-info.sh
      export WINSTRUCTED
      export MODULE_VERSION
    else
      errecho "$1/PLUSproduct-info.sh not found!"
    fi
  else
    errecho "$1/PLUSproduct-info.sh not found!"
  fi
}

###
#
# get_install_opts
#
get_install_opts() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -n "$INSTALL_OPTS" ]; then
   if [ -f "$LINKDIR/PLUSget_install_opts.sh" ]; then
	. "$LINKDIR/PLUSget_install_opts.sh"
   fi
  fi
}

####
#
# Managed node launch
#
mn_launch() {

  ARGLIST="hostname port"
  COMPONENT_NAME="Launch UM Services"
  PRESNAME=@Presentation:"$COMPONENT_NAME"_"$MNNAME"_"$MEDIUM_PRODNAME"
  DIALOG_DESCRIPTOR="ums.sh.d"

  ###############################################################################
  ###############################################################################
  #
  # Insert your application specific code here, using the following as an example
  #
  ###############################################################################
  ###############################################################################

  #
  # Under Windows_NT, a GUI should be launched using the wrunui command, 
  # and only on the active desktop
  #
  if is_OS_NT ; then
    MACHINE=`echo $WD_DISPLAY | awk -F : '{print $1}'`
    if [ "$MNNAME" != "$MACHINE" ]; then
      wdispmsg "This task can only be run on $MNNAME from a Tivoli desktop on $MNNAME."
      exit 0
    fi
    WRUNUI="$BINDIR/bin/wrunui.exe"
    if [ ! -f "$WRUNUI" ]; then
      wdispmsg "$WRUNUI NOT FOUND.  Please contact Tivoli Customer Support."
      exit 0
    fi

  # look for the web browser
    APP_PATH=`wgetval -k "SOFTWARE\microsoft\windows\currentversion\app paths\iexplore.exe" -n "path"`
    if [ -z "$APP_PATH" ]
    then
      APP_PATH=`wgetval -k "SOFTWARE\microsoft\windows\currentversion\app paths\netscape.exe" -n "path"`
      if [ -z "$APP_PATH" ]
      then
        wdispmsg "Web browser is not found.  Please install the web browser in order to launch the UM Services"
        exit 0
      fi
      BROWSER="netscape.exe"
    else
      # remove ; char from the path
      APP_PATH=`echo $APP_PATH | sed -e 's/;//' `
      BROWSER="iexplore.exe"
    fi

  fi

  #
  # if there are input arguments, associate them with the presentation object
  # associated with this app launch icon
  #
  ARG_VALUES=""
  for var in $ARGLIST; do
	REALVAR="$var"
	VALUE="$1"
	shift

	#
	# First, call wgetattr to see if the attribute exists .
	# If the attribute does not exist, use waddattr to
	# create it
	#
	wgetattr $REALVAR "$PRESNAME" > /dev/null 2>&1
	if [ $? -ne 0 ] ; then
		waddattr -v "$VALUE" $REALVAR "$PRESNAME" > /dev/null 2>&1
	else
		wsetattr    "$VALUE" $REALVAR "$PRESNAME" > /dev/null 2>&1
	fi

	# Accumulate values in case we need the values for the launch later, e.g.:
      if [ $var = hostname ]
      then
         VALUE='http://'"$VALUE"
      elif [ $var = port ]
      then
         VALUE=":$VALUE"
      fi
	ARG_VALUES="$ARG_VALUES$VALUE"
  done

  #
  # The following sets the path and display, and then allows the
  # determination of the correct binaries according to the OS type
  #
  PATH=/usr/bin:/bin:/usr/sbin:/sbin:/usr/ucb:$PATH:$APP_PATH
  DISPLAY=$WD_DISPLAY
  export PATH DISPLAY

  cmd="netscape"

  OS=`uname -sr`
  case $OS in
	"SunOS 5"*)	  full_cmd="$cmd $ARG_VALUES"	;;
	HP-UX*)		  full_cmd="$cmd $ARG_VALUES"	;;
	AIX*)		  full_cmd="$cmd $ARG_VALUES"	;;
	Windows_NT*)	cmd="$BROWSER"; full_cmd="$WRUNUI $cmd $ARG_VALUES" ;;
	*)
		wdispmsg "There is no \"$cmd\" utility for this platform."
		exit 0
		;;
  esac
  if type $cmd > /dev/null 2>&1; then
    error="`$full_cmd 2>&1`"  || {
	   wdispmsg "Error starting \"$full_cmd\" from method $THIS_SCRIPT:
	   $error (return code: $?)"
	}
  else
    wdispmsg "\"$cmd\" not found in PATH."
  fi

}


####
#
# LCF endpoint launch
#
lcf_ep_launch() {

  ###############################################################################
  ###############################################################################
  #
  # Insert your application specific code here, using the following as an example
  #
  ###############################################################################
  ###############################################################################

  #
  # Under Windows_NT, a GUI should be launched using the wrunuiep command, 
  # and only on the active desktop
  #
  EPNAME=`echo $ENDPOINT | awk '{print $1}'`
  if is_OS_NT ; then
    MACHINE=`echo $WD_DISPLAY | awk -F : '{print $1}'`
    if [ "$EPNAME" != "$MACHINE" ]; then
      errecho "This task can only be run on $EPNAME from a Tivoli desktop on $MACHINE."
      exit 1
    fi
    WRUNUI="$BINDIR/bin/wrunuiep.exe"
    if [ ! -f "$WRUNUI" ]; then
      errecho "$WRUNUI NOT FOUND.  Please contact Tivoli Customer Support."
      exit 1
    fi
  fi

  #
  # if there are input arguments, get their values
  #
  ARG_VALUES="$*"

  #
  # process the arguments
  #
  rc=0

  echo "*** Executing $THIS_SCRIPT"
  I=1
  while [ $# -gt 0 ]; do
	echo "argument $I: '$1'"
	I=`expr $I + 1`
	shift
  done
  echo "*** Exiting $THIS_SCRIPT with return code $rc"

  #
  # The following sets the path and display, and then allows the
  # determination of the correct binaries according to the OS type
  #
  PATH=/usr/bin:/bin:/usr/sbin:/sbin:/usr/ucb:$PATH
  DISPLAY=$WD_DISPLAY
  export PATH DISPLAY

  cmd="Your_App_Launch_Command"

  UNIX_OS=`uname -sr`
  case $UNIX_OS in
	"SunOS 5"*)	cmd="${cmd}_SunOS";  full_cmd="$cmd $ARG_VALUES"	;;
	HP-UX*)		cmd="${cmd}_HPUX";   full_cmd="$cmd $ARG_VALUES"	;;
	AIX*)		cmd="${cmd}_AIX";    full_cmd="$cmd $ARG_VALUES"	;;
	Windows_NT*)	cmd="${cmd}_NT.exe"; full_cmd="$WRUNUI $cmd $ARG_VALUES" ;;
	*)
		errecho "There is no \"$cmd\" utility for this platform."
		exit 1
		;;
  esac

  if type $cmd > /dev/null 2>&1; then
    error="`$full_cmd 2>&1`"  || {
	   errecho "Error starting \"$full_cmd\" from method $THIS_SCRIPT:
	   (return code: $?)"; exit 1
	}
  else
    errecho "\"$cmd\" not found in PATH."
    exit 1
  fi
}


##################################################################################
#
#
if [ -n "" ]; then
  set -x
  DEBUG=true
fi

THIS_SCRIPT="`echo $0 | sed -e 's.\\\\./.g'`"
THIS_SCRIPT=`basename "$THIS_SCRIPT"`

#
#	Set up some popular environment variables
#
source_etc_setup_env
BINDIR="`bindir`"; export BINDIR
INST_DIR="`inst_dir`"; export INST_DIR
MNNAME="`mnname`"; export MNNAME
TEMP="`temp`"; export TEMP

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts may be
#		redirected to a file in TEMP by the same name as the script.
#
DEBUGDIR="$TEMP/.plusdebug"
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > "$DEBUGDIR/$THIS_SCRIPT" 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv
[ "$DEBUG" = true ] && set -xv

#
#	Set up variables for our basic directories, path
#
PLUSDIR="$INST_DIR/generic_unix/TME/PLUS"
LINKDIR="$PLUSDIR/LINK"
PRODDIR="$PLUSDIR/UM_SERVICES"
PATH="$LINKDIR:$PRODDIR:$PATH"
export PATH

#
#	Source the PLUSproduct-info.sh file
#
source_product_info "$PRODDIR"

#
#	If there are install options from PLUSproduct-info.sh, bring them in!
#
get_install_opts

#
#	Now perform the correct type of launch
#
if is_managed_node; then
  mn_launch $*
else
  lcf_ep_launch $*
fi

# A non-zero exit status from a method causes an odstat error
exit 0	
