#!/bin/sh
#
# File:         ums_config_fp.sh
#
# Product:      Tivoli Module
# Description:  Shell Script
# Author:               Module Generator
#
# Generated:    
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

###
#
#   errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

########################################################################

if [ -n "" ]; then
        DEBUG=true
fi
[ "$DEBUG" = true ] && set -x

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT="ums_config_fp.sh"

#
#       Make sure we're running on a Managed Node
#
if is_lcf_ep; then
  errecho "Cannot run $THIS_SCRIPT: endpoint $ENDPOINT_OID is not a ManagedNode"
  exit 1
fi

#
#       The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#       If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#       Look for our override script, if not there, then use the
#               standard one.
#
if [ ! -f $ETC/$SCRIPT ]; then
        SCRIPT=setup_env.sh
fi

. $ETC/$SCRIPT

#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/UM_SERVICES
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh
export WINSTRUCTED
export MODULE_VERSION


#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > $DEBUGDIR/$THIS_SCRIPT 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv
if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" -o "$DEBUG" = true ]; then
  DEBUG=true
else
  DEBUG=false
fi
export DEBUG

#
#	Messages
#
ERRCONFIG="Error configuring FilePackage"
SUCCESSCONFIG="Successfully configured FilePackage"
ERRNOARG="Error: Missing value for argument"
ERRSRCHOST="Error: Cannot find managed node"
ERRUPDATE="Must specify y or n for product update flag"
ERRUNKNOWNFP="Error: Could not determine filepack id for this task"
ERRNOSRCHOST="You must specify the managed node on which the UM Services install files reside!"
ERRNOSRCPATH="You must specify the directory on the source host where the install files reside!"
ERRNODESTPATH="You must specify the directory where the UM Services will be installed!"
ERRNOROOT="Do not install into the root filesystem. Please provide a directory."

###################
# Support Functions
###################

errexit()
{
	echo "$*" >&2
	exit 1
}

errmsg()
{
	echo "$*" >&2
}

######################################################################
#
#	fp_replace_keyword
#
fp_replace_keyword() {
  keyvalpair="$1"
  fpdesc="$2"
  tmpdesc=${fpdesc}.tmp

  # split the keyword and value
  key=`echo $keyvalpair | awk -F= '{print $1}'`
  sed -e "s~^${key}=.*~${keyvalpair}~" $fpdesc > $tmpdesc
  if grep "^${key}=" $tmpdesc > /dev/null ; then
    :  #it got there
  else
    echo "$keyvalpair" >> $tmpdesc
  fi
  mv $tmpdesc $fpdesc
}

######################################################################
#
#	to_unix
#
to_unix()
{
  if [ "$INTERP" = "w32-ix86" ] ; then
    UNIX_PATH=`echo $1 | sed -e 's|\\\\|/|g'`
  else
    UNIX_PATH=`printf "%s\n" "$1" | sed -e 's|\\\\|/|g'`
  fi
 
  eval $2="\"$UNIX_PATH\""
}

######################################################################
#
#	fp_platform
#
fp_platform() {
  case "$1" in
    WINNT|nt)    fp_plat=nt;;
    WIN95|win95) fp_plat=win95;;
    WIN98|win98) fp_plat=win98;;
    WIN*|win*)   fp_plat=win;;
    NetWare|nw)  fp_plat=nw;;
    OS2|os2)     fp_plat=os2;;
    DOS|dos)     fp_plat=dos;;
    *?)          fp_plat=unix;;
  esac
  echo $fp_plat
}

######################################################################
#
#	lookup_filepack_id
#
lookup_filepack_id() {
  match_name=$1
  eval match_name="$match_name"
  for i in $FILEPACKS; do
    eval name='"$'${i}'"'
    eval uiname='"$'${i}'_UINAME"'
    if [ "$name" = "$match_name" ]; then
      echo "$i"
      return 0
    elif [ "$uiname" = "$match_name" ]; then
      echo "$i"
      return 0
    fi
  done
  return 1
}

######################################################################
#
#	replace_nested_fp_name
#
replace_nested_fp_name() {
  fpid="$1"
  fpdesc="$2"
  tmpdesc=${fpdesc}.tmp
  rm -f $tmpdesc

  eval fpname='"$'$fpid'"'
  eval fpnestfps='"$'$fpid'_FPNESTFPS"'

  if [ -f "$fpnestfps" ]; then
    # Copy the nested file package list, appending the inter-region name
    while read line; do
      if [ "$line" ]; then
        nestref=${line}
        if lookup_filepack_id "$nestref"; then
          nestid=`lookup_filepack_id "$nestref"`
          eval nestname='"$'$nestid'"'
          nestname=${nestname}#${IRONAME}
          sed -e "s~^${nestref}~\"${nestname}\"~" $fpdesc > $tmpdesc
        else
          errecho "Unable to locate nested file package!"
          return 1
        fi
      fi
    done <$fpnestfps
  fi
  if [ -f "$tmpdesc" ]; then
    mv $tmpdesc $fpdesc
  fi
}

######################################################################
#
#	create_afterscript
#
create_afterscript()
{
	DEST_PATH=$1
	NEWAFTERSCRIPT=$PRODDIR/ums_fp_after.bat

	rm -f $NEWAFTERSCRIPT

	DEST_DRIVE=`echo $DEST_PATH | cut -f1 -d:`
	DEST_DRIVE=$DEST_DRIVE":"
	echo -e "$DEST_DRIVE\r\n" >>$NEWAFTERSCRIPT

	let i=2
	DEST_DIR=$DEST_DRIVE"/"
	RESULT=`echo $DEST_PATH | cut -f$i -d/`
	echo -e "cd \\\"$RESULT\"\r\n" >>$NEWAFTERSCRIPT
	DEST_DIR=$DEST_DIR"$RESULT"
	while [ "$DEST_DIR" != "$DEST_PATH" ]; do
		let i=i+1
		RESULT=`echo $DEST_PATH | cut -f$i -d/`
		echo "cd \"$RESULT\"\r\n" >>$NEWAFTERSCRIPT
		DEST_DIR=$DEST_DIR"/$RESULT"
	done

	echo "setup.exe -s custom.iss" >>$NEWAFTERSCRIPT
}

###################
# Process Arguments
###################

#
#	Usage Check
#
ARGLIST="Source_Host_ Source_Path_ Destination_Path_"
if [ $# -ne `echo $ARGLIST | wc -w` ]; then
	errexit "Usage: $THIS_SCRIPT $ARGLIST"
fi

#
#	set some local environment variables from the command line arguments
#
for arg in $ARGLIST; do
	eval $arg='"$1"'
	echo "$arg: $1"
	shift
done


#
# 	check each argument for validity; 
#	  (in the general case we just check for existence)
#
#EMPTY_ARG=0
#for arg in $ARGLIST; do
#	eval val='"$'$arg'"'
#	if [ ! "$val" -o "$val" = "off" ]; then
#		EMPTY_ARG=1
#		errmsg "$ERRNOARG \"$arg\""
#	fi
#done
#if [ $EMPTY_ARG -eq 1 ] ; then
#	exit 1
#fi


#
# Map incoming argument names for use later, for example:
#
#SRC_HOST="$Get_Source_Files_from_Managed_Node_"
SRC_HOST="$Source_Host_"
SRC_PATH="$Source_Path_"
#TARGET="$Target_Installation_Architecture_"
#UPDATE="$Update__y_or_n__"
DEST_PATH="$Destination_Path_"
export DEST_PATH

# Variables passed to prog_env variable so that
# they can be resolved in endpoint by
# %CURDRIVE% and %CURDIR% in afterscript
DEST_DRIVE=`echo $DEST_PATH | cut -f1 -d:`
DEST_DRIVE=$DEST_DRIVE":"
export DEST_DRIVE
if [ "$INTERP" = "w32-ix86" ] ; then
	DEST_DIR=`echo $DEST_PATH | sed -e 's|/|\\\\|g'`
	DEST_DIR=`echo $DEST_DIR | sed -e 's|\\\\|\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\|g'`
elif [ "$INTERP" = "solaris2" ]; then
   DEST_DIR=`printf "%s\n" "$DEST_PATH" | sed -e 's|/|\\\\|g'`
   DEST_DIR=`printf "%s\n" "$DEST_DIR" | sed -e 's|\\\\|\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\|g'`
else
    	DEST_DIR=`print -R $DEST_PATH | sed -e 's|/|\\\\|g'`
    	DEST_DIR=`print -R $DEST_DIR | sed -e 's|\\\\|\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\|g'`
fi
export DEST_DIR

to_unix "$SRC_PATH" SRC_PATH
to_unix "$DEST_PATH" DEST_PATH

if [ "x$SRC_HOST" = "x" ]; then
    errmsg "$ERRNOSRCHOST \"$arg\""
    exit 1
fi

if [ "x$SRC_PATH" = "x" ]; then
    errmsg "$ERRNOSRCPATH \"$arg\""
    exit 1
fi

if [ "x$DEST_PATH" = "x" ]; then
    errmsg "$ERRNODESTPATH \"$arg\""
    exit 1
fi

if [ "$DEST_PATH" = "/" ]; then
    errmsg "$ERRNOROOT \"$arg\""
    exit 1
fi

#
# Add any needed argument information to CUSTOM_ENV for the fp; for example:
#
CUSTOM_ENV="UPDATE='$UPDATE'"

#
# Make sure it makes sense to continue, for example:
#
wlookup -r ManagedNode "$SRC_HOST" > /dev/null 2>&1
STATUS=$?
if [ $STATUS -ne 0 ] ;then
	errexit "$ERRSRCHOST $SRC_HOST"
fi
#case "$UPDATE" in
#	y|n)	;;
#	*)	errexit "$ERRUPDATE"
#esac


#**********************************************************************
#	
#	Add code here to modify file package description file
#
#**********************************************************************

#
#	FP gets a value FILEPACK_<NUM>, which references the filepackage 
#	definition variables in PLUSproduct-info.sh
#

FP=
THIS_COMPONENT_NAME="Install UM Services"
for fp in $FILEPACKS; do
   if [ "$WINSTRUCTED" = true ]; then
	eval COMPNAME='"$'$fp'_UINAME"'    # UINAME reflects component name in winstruct-land
   else
	eval COMPNAME='"$'$fp'"'
   fi
   if [ "$COMPNAME" -a "$COMPNAME" = "$THIS_COMPONENT_NAME" ]; then     # it's us!
	FP="$fp"
	break
   fi
done
if [ ! "$FP" ]; then
	errexit "$ERRUNKNOWNFP"
fi


eval FPNAME='"$'$FP'"'
eval FPSHORTNAME='"$'$FP'_SHORTNAME"'
eval FPDEF='"$'$FP'_FPDEF"'
eval FPKEYWORDS='"$'$FP'_FPKEYWORDS"'
eval FPDEFHEADER='"$'$FP'_FPDEFHEADER"'
eval FPINCLFILES='"$'$FP'_FPINCLFILES"'
eval FPEXCLFILES='"$'$FP'_FPEXCLFILES"'
eval FPNESTFPS='"$'$FP'_FPNESTFPS"'

# These may have a nested variable, so eval them again:
eval FPDEF=$FPDEF
eval FPKEYWORDS=$FPKEYWORDS
eval FPDEFHEADER=$FPDEFHEADER
eval FPINCLFILES=$FPINCLFILES
eval FPEXCLFILES=$FPEXCLFILES
eval FPNESTFPS=$FPNESTFPS

#
#	These environment variables contain the install script names
#
eval FPBEFOREINSTALL='"$'$FP'_BEFORE_INSTALL"'
eval FPAFTERINSTALL='"$'$FP'_AFTER_INSTALL"'
eval FPONCOMMIT='"$'$FP'_ON_COMMIT"'
eval FPBEFOREREMOVAL='"$'$FP'_BEFORE_REMOVE"'
eval FPAFTERREMOVAL='"$'$FP'_AFTER_REMOVE"'
eval FPONERROR='"$'$FP'_ON_ERROR"'

    # These vars could contain nested vars, eval them again
    eval fpdef=$fpdef
    eval fpkeywords=$fpkeywords
    eval fpdefheader=$fpdefheader
    eval fpinclfiles=$fpinclfiles
    eval fpexclfiles=$fpexclfiles
    eval fpnestfps=$fpnestfps

    keyword_suffixes="
      before_prog_path
      before_input_path
      after_prog_path
      after_input_path
      commit_prog_path
      commit_input_path
      removal_prog_path
      removal_input_path
      after_removal_prog_path
      after_removal_input_path
      on_error_prog_path
      on_error_input_path
    "
    eval before_prog_path='"$'$fp'_BEFORE_INSTALL"'
    eval before_input_path='"$'$fp'_BEFORE_INSTALL_INPUT"'
    eval after_prog_path='"$'$fp'_AFTER_INSTALL"'
    eval after_input_path='"$'$fp'_AFTER_INSTALL_INPUT"'
    eval commit_prog_path='"$'$fp'_ON_COMMIT"'
    eval commit_input_path='"$'$fp'_ON_COMMIT_INPUT"'
    eval removal_prog_path='"$'$fp'_BEFORE_REMOVE"'
    eval removal_input_path='"$'$fp'_BEFORE_REMOVE_INPUT"'
    eval after_removal_prog_path='"$'$fp'_AFTER_REMOVE"'
    eval after_removal_input_path='"$'$fp'_AFTER_REMOVE_INPUT"'
    eval on_error_prog_path='"$'$fp'_ON_ERROR"'
    eval on_error_input_path='"$'$fp'_ON_ERROR_INPUT"'

    ## plat=`fp_platform $fpplatform`
    plat=`fp_platform $TARGET`

FPDESC=$PRODDIR/$FPSHORTNAME.fp
NEWFPDESC=$TEMP/$FPSHORTNAME.fp

#
#	Here is where you may want to modify the filepackage description
#	before you import it into the file package profile.
#	In this example, we make a processed copy in $NEWFPDESC so that the 
#       original description file is intact for the next time the fp 
#       configuration task is run.
#
rm -f $NEWFPDESC

# Copy the filepackage definition header
cat $FPDEFHEADER >$NEWFPDESC

# Add the custom environment as constructed from this task's arg list
echo prog_env='"'$CUSTOM_ENV'"' >> $NEWFPDESC

#
#	The REPLACE_KEYWORD variable contains the names of other variables
#	that contain keyword value pairs that will be replaced in the key-
#	word list.  Add more keywords by adding more names to the
#	REPLACE_KEYWORDS variable.  The two commented lines below show
#	how to add another variable.
#
REPLACE_KEYWORD1="log_host=$SRC_HOST"
REPLACE_KEYWORDS="REPLACE_KEYWORD1"

REPLACE_KEYWORD2="src_relpath=\"$SRC_PATH\""
REPLACE_KEYWORDS="REPLACE_KEYWORD1 REPLACE_KEYWORD2"

REPLACE_KEYWORD3="nt_platform_prefix=\"$DEST_PATH\""
REPLACE_KEYWORDS="REPLACE_KEYWORD1 REPLACE_KEYWORD2 REPLACE_KEYWORD3"

REPLACE_KEYWORD4="log_file=$TEMP/umsinst.log"
REPLACE_KEYWORDS="REPLACE_KEYWORD1 REPLACE_KEYWORD2 REPLACE_KEYWORD3 REPLACE_KEYWORD4"

REPLACE_KEYWORD5="win95_platform_prefix=\"$DEST_PATH\""
REPLACE_KEYWORDS="REPLACE_KEYWORD1 REPLACE_KEYWORD2 REPLACE_KEYWORD3 REPLACE_KEYWORD4 REPLACE_KEYWORD5"

REPLACE_KEYWORD6="nt_after_prog_path=\"$DEST_PATH\"/Win32/Install/en/ums_fp_after.bat"
REPLACE_KEYWORDS="REPLACE_KEYWORD1 REPLACE_KEYWORD2 REPLACE_KEYWORD3 REPLACE_KEYWORD4 REPLACE_KEYWORD5 REPLACE_KEYWORD6"

REPLACE_KEYWORD7="win95_after_prog_path=\"$DEST_PATH\"/Win32/Install/en/ums_fp_after.bat"
REPLACE_KEYWORDS="REPLACE_KEYWORD1 REPLACE_KEYWORD2 REPLACE_KEYWORD3 REPLACE_KEYWORD4 REPLACE_KEYWORD5 REPLACE_KEYWORD6 REPLACE_KEYWORD7"

REPLACE_KEYWORD8="prog_env=\"CURDIR='"$DEST_DIR"' CURDRIVE=$DEST_DRIVE\""
REPLACE_KEYWORDS="REPLACE_KEYWORD1 REPLACE_KEYWORD2 REPLACE_KEYWORD3 REPLACE_KEYWORD4 REPLACE_KEYWORD5 REPLACE_KEYWORD6 REPLACE_KEYWORD7 REPLACE_KEYWORD8"

REPLACE_KEYWORD9="descend_dirs=n"
REPLACE_KEYWORDS="REPLACE_KEYWORD1 REPLACE_KEYWORD2 REPLACE_KEYWORD3 REPLACE_KEYWORD4 REPLACE_KEYWORD5 REPLACE_KEYWORD6 REPLACE_KEYWORD7 REPLACE_KEYWORD8 REPLACE_KEYWORD9"

REPLACE_KEYWORD10="keep_paths=y"
REPLACE_KEYWORDS="REPLACE_KEYWORD1 REPLACE_KEYWORD2 REPLACE_KEYWORD3 REPLACE_KEYWORD4 REPLACE_KEYWORD5 REPLACE_KEYWORD6 REPLACE_KEYWORD7 REPLACE_KEYWORD8 REPLACE_KEYWORD9 REPLACE_KEYWORD10"

#create_afterscript "$DEST_PATH"
cat $FPKEYWORDS >> $NEWFPDESC

# First replace keywords with values from component
for kw in $keyword_suffixes; do
      eval fp_replace_keyword ${plat}_${kw}='"$'$kw'"' $NEWFPDESC
done

# Now, using the local keyword list, replace values from the $FPKEYWORDS file
for repkey in $REPLACE_KEYWORDS; do
      eval KEYVALPAIR='"$'$repkey'"'
#      eval fp_replace_keyword $KEYVALPAIR $NEWFPDESC
      fp_replace_keyword "$KEYVALPAIR" $NEWFPDESC
done

echo "%" >>$NEWFPDESC

# Copy the actual file list.
#cat $FPINCLFILES >>$NEWFPDESC
#echo "%" >>$NEWFPDESC

# Im doing this instead because its the only way I can get the after scripts
# source directory to point to the right place
cat - >> $NEWFPDESC <<EOF
"$SRC_PATH/"*
"$SRC_PATH/../files/"*
"$SRC_PATH/ums_fp_after.bat"
%
EOF

# Copy the nested file package list
cat $FPNESTFPS >>$NEWFPDESC
echo "%" >>$NEWFPDESC

# Copy the excluded file list
if [ -f $FPEXCLFILES ]; then
	cat $FPEXCLFILES >>$NEWFPDESC
fi

# make sure nested fp's are referred to correctly 
#  (i.e. may need to use the winstructed name, 
#   and they need the IRONAME appended)
replace_nested_fp_name $fp $NEWFPDESC

#
#	Now use the general purpose wcrtsprfl to create the file pack and plus link
#
if [ "$WINSTRUCTED" = "true" ]; then
	eval FPUINAME='"$'$FP'_UINAME"'
	eval FPPARENT='"$'$FP'_PARENT"'
else
	FPUINAME="$FPNAME"
	FPPARENT="$FPNAME"
fi
if [ "$TARGET" ]; then
   CONFIGURED_FPNAME="$FPUINAME for $TARGET"
else
   CONFIGURED_FPNAME="$FPUINAME"
fi
LINK_NAME="$CONFIGURED_FPNAME"

wcrtsprfl       -s "NCLINK"        \
                "$FPUINAME" \
                FilePackage \
                "$CONFIGURED_FPNAME" \
                "$FPPARENT" \
                "$LINK_NAME"

STATUS=$?
if [ $STATUS -ne 0 ] ; then
	errexit $ERRCONFIG "'"$CONFIGURED_FPNAME"'"
fi

wimprtfp -h @ManagedNode:"$SRC_HOST"  @FilePackage:"$CONFIGURED_FPNAME#$IRONAME" < $NEWFPDESC
STATUS=$?

if [ $STATUS -ne 0 ] ; then
	errmsg $ERRCONFIG "'"$CONFIGURED_FPNAME"'"
else
	echo $SUCCESSCONFIG "'"$CONFIGURED_FPNAME"'"
###	rm $NEWFPDESC
	echo $NEWFPDESC
fi

exit $STATUS


