drop table UMA_System_Enclosure cascade constraints ;

create table UMA_System_Enclosure (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Manufacturer varchar2(255) NULL,
   Type varchar2(255) NULL,
   Cabinet_Lock_Present varchar2(32) NULL );

create unique index UMA_ISystem_Enclosure on UMA_System_Enclosure
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_System_Enclosure add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VSystem_Enclosure;

create view UMA_VSystem_Enclosure
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_System_Enclosure.*
from
   COMPUTER_SYSTEM, UMA_System_Enclosure
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_System_Enclosure.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VSystem_Enclosure');

drop table UMA_CIM cascade constraints ;

create table UMA_CIM (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   CIM_Version varchar2(255) NULL );

create unique index UMA_ICIM on UMA_CIM
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_CIM add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VCIM;

create view UMA_VCIM
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_CIM.*
from
   COMPUTER_SYSTEM, UMA_CIM
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_CIM.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VCIM');

drop table UMA_System_Board_Configurac1d cascade constraints ;

create table UMA_System_Board_Configurac1d (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   String varchar2(255) NULL );

create unique index UMA_ISystem_Board_Configurac1d on UMA_System_Board_Configurac1d
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_System_Board_Configurac1d add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VSystem_Board_Configurac1d;

create view UMA_VSystem_Board_Configurac1d
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_System_Board_Configurac1d.*
from
   COMPUTER_SYSTEM, UMA_System_Board_Configurac1d
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_System_Board_Configurac1d.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VSystem_Board_Configurac1d');

drop table UMA_IP_Network_Configuration cascade constraints ;

create table UMA_IP_Network_Configuration (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   IP_Address varchar2(255) NULL,
   IP_Subnet_Mask varchar2(255) NULL,
   IP_Gateway varchar2(255) NULL,
   DNS_Servers varchar2(255) NULL,
   DHCP_Enabled varchar2(32) NULL,
   DNS_Hostname varchar2(255) NULL,
   DNS_Domain varchar2(255) NULL );

create unique index UMA_IIP_Network_Configuration on UMA_IP_Network_Configuration
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_IP_Network_Configuration add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VIP_Network_Configuration;

create view UMA_VIP_Network_Configuration
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_IP_Network_Configuration.*
from
   COMPUTER_SYSTEM, UMA_IP_Network_Configuration
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_IP_Network_Configuration.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VIP_Network_Configuration');

drop table UMA_IPX_Network_Configuration cascade constraints ;

create table UMA_IPX_Network_Configuration (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   IPX_Enabled varchar2(32) NULL,
   IPX_Frame_Type varchar2(255) NULL,
   IPX_Address varchar2(255) NULL );

create unique index UMA_IIPX_Network_Configuration on UMA_IPX_Network_Configuration
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_IPX_Network_Configuration add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VIPX_Network_Configuration;

create view UMA_VIPX_Network_Configuration
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_IPX_Network_Configuration.*
from
   COMPUTER_SYSTEM, UMA_IPX_Network_Configuration
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_IPX_Network_Configuration.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VIPX_Network_Configuration');

drop table UMA_Lease_Information cascade constraints ;

create table UMA_Lease_Information (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Lessor varchar2(64) NULL,
   Lease_Start_Date varchar2(25) NULL,
   Lease_End_Date varchar2(25) NULL,
   Lease_Term__months_ varchar2(20) NULL,
   Lease_Amount varchar2(10) NULL );

create unique index UMA_ILease_Information on UMA_Lease_Information
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Lease_Information add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VLease_Information;

create view UMA_VLease_Information
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Lease_Information.*
from
   COMPUTER_SYSTEM, UMA_Lease_Information
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Lease_Information.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VLease_Information');

drop table UMA_Geographic_Information cascade constraints ;

create table UMA_Geographic_Information (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Locale varchar2(255) NULL,
   Country_Code varchar2(255) NULL,
   OS_Language varchar2(20) NULL,
   Code_Set varchar2(255) NULL );

create unique index UMA_IGeographic_Information on UMA_Geographic_Information
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Geographic_Information add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VGeographic_Information;

create view UMA_VGeographic_Information
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Geographic_Information.*
from
   COMPUTER_SYSTEM, UMA_Geographic_Information
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Geographic_Information.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VGeographic_Information');

drop table UMA_Memory_Details cascade constraints ;

create table UMA_Memory_Details (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Device_Locator varchar2(255) NULL,
   siz_ varchar2(20) NULL,
   Form_Factor varchar2(255) NULL,
   Type varchar2(255) NULL,
   Speed varchar2(20) NULL,
   Data_Width varchar2(20) NULL,
   Total_Width varchar2(20) NULL );

create unique index UMA_IMemory_Details on UMA_Memory_Details
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Memory_Details add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VMemory_Details;

create view UMA_VMemory_Details
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Memory_Details.*
from
   COMPUTER_SYSTEM, UMA_Memory_Details
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Memory_Details.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VMemory_Details');

drop table UMA_Network_Details cascade constraints ;

create table UMA_Network_Details (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Network_Adapter varchar2(255) NULL,
   Network_Driver varchar2(255) NULL,
   MAC_Address varchar2(255) NULL );

create unique index UMA_INetwork_Details on UMA_Network_Details
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Network_Details add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VNetwork_Details;

create view UMA_VNetwork_Details
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Network_Details.*
from
   COMPUTER_SYSTEM, UMA_Network_Details
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Network_Details.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VNetwork_Details');

drop table UMA_Personalized_Data cascade constraints ;

create table UMA_Personalized_Data (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Label1 varchar2(32) NULL,
   Data1 varchar2(32) NULL,
   Label2 varchar2(32) NULL,
   Data2 varchar2(32) NULL,
   Label3 varchar2(32) NULL,
   Data3 varchar2(32) NULL,
   Label4 varchar2(32) NULL,
   Data4 varchar2(32) NULL,
   Label5 varchar2(32) NULL,
   Data5 varchar2(32) NULL );

create unique index UMA_IPersonalized_Data on UMA_Personalized_Data
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Personalized_Data add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VPersonalized_Data;

create view UMA_VPersonalized_Data
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Personalized_Data.*
from
   COMPUTER_SYSTEM, UMA_Personalized_Data
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Personalized_Data.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VPersonalized_Data');

drop table UMA_Port_Connectors cascade constraints ;

create table UMA_Port_Connectors (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Logical_Name varchar2(255) NULL,
   Connector_Type varchar2(255) NULL,
   Port_Type varchar2(255) NULL,
   Tag varchar2(255) NULL );

create unique index UMA_IPort_Connectors on UMA_Port_Connectors
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Port_Connectors add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VPort_Connectors;

create view UMA_VPort_Connectors
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Port_Connectors.*
from
   COMPUTER_SYSTEM, UMA_Port_Connectors
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Port_Connectors.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VPort_Connectors');

drop table UMA_Processor_Details cascade constraints ;

create table UMA_Processor_Details (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Processor varchar2(255) NULL,
   Family varchar2(255) NULL,
   Clock_Speed varchar2(20) NULL,
   External_Clock_Speed varchar2(20) NULL,
   Max_Clock_Speed varchar2(20) NULL,
   Manufacturer varchar2(255) NULL,
   Processor_ID varchar2(255) NULL,
   Processor_Type varchar2(255) NULL );

create unique index UMA_IProcessor_Details on UMA_Processor_Details
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Processor_Details add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VProcessor_Details;

create view UMA_VProcessor_Details
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Processor_Details.*
from
   COMPUTER_SYSTEM, UMA_Processor_Details
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Processor_Details.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VProcessor_Details');

drop table UMA_Serial_Number_Information cascade constraints ;

create table UMA_Serial_Number_Information (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Asset varchar2(255) NULL,
   Serial_Number varchar2(23) NULL,
   Manufacturer varchar2(255) NULL,
   Model varchar2(255) NULL,
   Type varchar2(255) NULL );

create unique index UMA_ISerial_Number_Information on UMA_Serial_Number_Information
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Serial_Number_Information add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VSerial_Number_Information;

create view UMA_VSerial_Number_Information
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Serial_Number_Information.*
from
   COMPUTER_SYSTEM, UMA_Serial_Number_Information
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Serial_Number_Information.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VSerial_Number_Information');

drop table UMA_IBM_UM_Services cascade constraints ;

create table UMA_IBM_UM_Services (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Name varchar2(255) NULL,
   Version varchar2(64) NULL,
   Build_Number varchar2(64) NULL,
   HTTPD_Port varchar2(20) NULL,
   SNMP_Traps_Enabled varchar2(32) NULL,
   Trap_Destinations varchar2(255) NULL );

create unique index UMA_IIBM_UM_Services on UMA_IBM_UM_Services
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_IBM_UM_Services add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VIBM_UM_Services;

create view UMA_VIBM_UM_Services
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_IBM_UM_Services.*
from
   COMPUTER_SYSTEM, UMA_IBM_UM_Services
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_IBM_UM_Services.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VIBM_UM_Services');

drop table UMA_User_Details cascade constraints ;

create table UMA_User_Details (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   User_Name varchar2(64) NULL,
   User_Phone varchar2(20) NULL,
   User_Department varchar2(64) NULL,
   User_Position varchar2(64) NULL,
   System_Location varchar2(64) NULL );

create unique index UMA_IUser_Details on UMA_User_Details
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_User_Details add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VUser_Details;

create view UMA_VUser_Details
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_User_Details.*
from
   COMPUTER_SYSTEM, UMA_User_Details
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_User_Details.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VUser_Details');

drop table UMA_Video_Details cascade constraints ;

create table UMA_Video_Details (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Manufacturer varchar2(255) NULL,
   Description varchar2(255) NULL,
   Current_Vertical_Resolution varchar2(20) NULL,
   Current_Horizontal_Resolution varchar2(20) NULL,
   Current_Number_of_Bits_per_Pix varchar2(20) NULL,
   Video_RAM_Memory_Size varchar2(20) NULL,
   Driver_Filename varchar2(255) NULL,
   Current_Refresh_Rate varchar2(20) NULL,
   Color_Depth varchar2(20) NULL );

create unique index UMA_IVideo_Details on UMA_Video_Details
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Video_Details add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VVideo_Details;

create view UMA_VVideo_Details
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Video_Details.*
from
   COMPUTER_SYSTEM, UMA_Video_Details
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Video_Details.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VVideo_Details');

drop table UMA_Warranty_Information cascade constraints ;

create table UMA_Warranty_Information (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Warranty_Duration varchar2(20) NULL,
   Warranty_End_Date varchar2(25) NULL,
   Warranty_Cost varchar2(10) NULL );

create unique index UMA_IWarranty_Information on UMA_Warranty_Information
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Warranty_Information add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VWarranty_Information;

create view UMA_VWarranty_Information
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Warranty_Information.*
from
   COMPUTER_SYSTEM, UMA_Warranty_Information
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Warranty_Information.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VWarranty_Information');

drop table UMA_DMI cascade constraints ;

create table UMA_DMI (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Version varchar2(64) NULL,
   Product varchar2(64) NULL,
   Win32_DMI_Directory varchar2(18) NULL );

create unique index UMA_IDMI on UMA_DMI
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_DMI add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VDMI;

create view UMA_VDMI
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_DMI.*
from
   COMPUTER_SYSTEM, UMA_DMI
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_DMI.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VDMI');

commit;

drop table UMA_System_Slots cascade constraints ;

create table UMA_System_Slots (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Slot_Type varchar2(255) NULL,
   Slot_Data_Bus_Width varchar2(20) NULL,
   Supports_Hot_Plug varchar2(32) NULL,
   Current_Usage varchar2(255) NULL,
   SlotDesignation varchar2(255) NULL,
   Shared_Slot_Opening varchar2(32) NULL,
   Supports_PME_Signal varchar2(32) NULL,
   Tag varchar2(255) NULL );

create unique index UMA_ISystem_Slots on UMA_System_Slots
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_System_Slots add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VSystem_Slots;

create view UMA_VSystem_Slots
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_System_Slots.*
from
   COMPUTER_SYSTEM, UMA_System_Slots
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_System_Slots.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VSystem_Slots');

drop table UMA_SNMP_Agent_Configuration cascade constraints ;

create table UMA_SNMP_Agent_Configuration (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   SNMP_Traps_Enabled varchar2(32) NULL,
   Trap_Destinations varchar2(255) NULL );

create unique index UMA_ISNMP_Agent_Configuration on UMA_SNMP_Agent_Configuration
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_SNMP_Agent_Configuration add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VSNMP_Agent_Configuration;

create view UMA_VSNMP_Agent_Configuration
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_SNMP_Agent_Configuration.*
from
   COMPUTER_SYSTEM, UMA_SNMP_Agent_Configuration
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_SNMP_Agent_Configuration.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VSNMP_Agent_Configuration');

drop table UMA_Alert_On_LAN_Settings cascade constraints ;

create table UMA_Alert_On_LAN_Settings (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   Alerts_Enabled varchar2(32) NULL,
   Retransmission_Interval varchar2(20) NULL,
   Polling_Interval varchar2(20) NULL,
   Heartbeat_Interval varchar2(20) NULL,
   Hardware_Version varchar2(255) NULL,
   Alert_Destination varchar2(255) NULL,
   Auto_Clear_Events varchar2(32) NULL,
   Heartbeat_Enabled varchar2(32) NULL,
   Hardware_Enabled varchar2(32) NULL,
   Watchdog_Interval varchar2(20) NULL,
   Watchdog_Enabled varchar2(32) NULL );

create unique index UMA_IAlert_On_LAN_Settings on UMA_Alert_On_LAN_Settings
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Alert_On_LAN_Settings add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VAlert_On_LAN_Settings;

create view UMA_VAlert_On_LAN_Settings
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Alert_On_LAN_Settings.*
from
   COMPUTER_SYSTEM, UMA_Alert_On_LAN_Settings
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Alert_On_LAN_Settings.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VAlert_On_LAN_Settings');

drop table UMA_AssetID cascade constraints ;

create table UMA_AssetID (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   System_Name varchar2(255) NULL,
   System_Model varchar2(255) NULL,
   Product_Name varchar2(255) NULL,
   LCCM_Image_Profile varchar2(20) NULL,
   LCCM_Image_Date varchar2(25) NULL,
   System_Serial_Number varchar2(255) NULL,
   System_GUID varchar2(255) NULL,
   System_Asset_Number varchar2(32) NULL,
   AssetID_Tag varchar2(255) NULL,
   Last_Inventoried varchar2(25) NULL,
   Purchase_Date varchar2(25) NULL );

create unique index UMA_IAssetID on UMA_AssetID
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_AssetID add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VAssetID;

create view UMA_VAssetID
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_AssetID.*
from
   COMPUTER_SYSTEM, UMA_AssetID
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_AssetID.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VAssetID');

drop table UMA_BIOS_Details cascade constraints ;

create table UMA_BIOS_Details (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   BIOS_Manufacturer varchar2(255) NULL,
   BIOS_Version varchar2(64) NULL,
   BIOS_Release_Date varchar2(25) NULL,
   Supports_SMBIOS varchar2(32) NULL,
   SMBIOS_Major_Version varchar2(20) NULL,
   SMBIOS_Minor_Version varchar2(20) NULL );

create unique index UMA_IBIOS_Details on UMA_BIOS_Details
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_BIOS_Details add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VBIOS_Details;

create view UMA_VBIOS_Details
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_BIOS_Details.*
from
   COMPUTER_SYSTEM, UMA_BIOS_Details
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_BIOS_Details.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VBIOS_Details');

drop table UMA_Cache cascade constraints ;

create table UMA_Cache (
   HARDWARE_SYSTEM_ID varchar2(64) NOT NULL,
   CONFIG_CHANGE_TYPE varchar2(12) NOT NULL,
   CONFIG_CHANGE_TIME varchar2(32) NOT NULL,
   Row_Index varchar2(5) NOT NULL,
   level_ varchar2(255) NULL,
   System_Cache_Size varchar2(20) NULL,
   System_Cache_Write_Policy varchar2(255) NULL,
   Socket_Designation varchar2(255) NULL,
   Cache_Location varchar2(255) NULL );

create unique index UMA_ICache on UMA_Cache
(
   HARDWARE_SYSTEM_ID,
   CONFIG_CHANGE_TYPE,
   CONFIG_CHANGE_TIME,
   Row_Index
);

alter table UMA_Cache add ( primary key ( HARDWARE_SYSTEM_ID, CONFIG_CHANGE_TYPE, Row_Index ));

drop view UMA_VCache;

create view UMA_VCache
as
select
   COMPUTER_SYSTEM.TME_OBJECT_ID,
   COMPUTER_SYSTEM.TME_OBJECT_LABEL,
   UMA_Cache.*
from
   COMPUTER_SYSTEM, UMA_Cache
where
   COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
   UMA_Cache.HARDWARE_SYSTEM_ID;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMA_VCache');

drop view UMS_VINSTALLED_UMS_AGENT;

create view UMS_VINSTALLED_UMS_AGENT
as
select
    COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID,
    COMPUTER_SYSTEM.TME_OBJECT_ID,
    COMPUTER_SYSTEM.TME_OBJECT_LABEL,
    INSTALLED_UNKNOWN_FILE.INSTALLED_FILE_NAME,
    INSTALLED_UNKNOWN_FILE.INSTALLED_FILE_SIZE,
    INSTALLED_UNKNOWN_FILE.INSTALLED_FILE_PATH,
    INSTALLED_UNKNOWN_FILE.INSTALLED_FILE_DATE,
    INSTALLED_UNKNOWN_FILE.INSTALLED_FILE_TIME
from
    COMPUTER_SYSTEM,
    INSTALLED_UNKNOWN_FILE
where
    COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
    INSTALLED_UNKNOWN_FILE.HARDWARE_SYSTEM_ID
and 
    upper(INSTALLED_UNKNOWN_FILE.INSTALLED_FILE_NAME) = 'UMSAGENT.MOF';    

insert into QUERY_VIEWS (VIEW_NAME) values ('UMS_VINSTALLED_UMS_AGENT');

commit;

drop view UMS_VIP_MAC_ADDRESS;

create view UMS_VIP_MAC_ADDRESS
as
select
    COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID,
    COMPUTER_SYSTEM.TME_OBJECT_ID,
    COMPUTER_SYSTEM.TME_OBJECT_LABEL,
    UMA_Network_Details.MAC_Address,
    UMA_IP_Network_Configuration.IP_Address,
    UMA_IP_Network_Configuration.IP_Subnet_Mask
from
    COMPUTER_SYSTEM,
    UMA_Network_Details,
    UMA_IP_Network_Configuration
where
    COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
    UMA_Network_Details.HARDWARE_SYSTEM_ID
and 
    COMPUTER_SYSTEM.HARDWARE_SYSTEM_ID =
    UMA_IP_Network_Configuration.HARDWARE_SYSTEM_ID
and
    UMA_Network_Details.Row_Index =
    UMA_IP_Network_Configuration.Row_Index;

insert into QUERY_VIEWS (VIEW_NAME) values ('UMS_VIP_MAC_ADDRESS');
commit;

