TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
fi

echo "Creating query 'Cache' in $QUERY_LIB..." 
echo "Creating query 'Cache' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Cache" -r inventory -v UMA_VCache \
   -c TME_OBJECT_LABEL \
   -c level_ \
   -c System_Cache_Size \
   -c System_Cache_Write \
   -c Socket_Designation \
   -c Cache_Location \
"$QUERY_LIB" "Cache" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Cache' query already exists."
fi

echo "Creating query 'System Enclosure' in $QUERY_LIB..." 
echo "Creating query 'System Enclosure' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "System Enclosure" -r inventory -v UMA_VSystem_Encyoe \
   -c TME_OBJECT_LABEL \
   -c Manufacturer \
   -c Type \
   -c Cabinet_Lock_Prese \
"$QUERY_LIB" "System Enclosure" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'System Enclosure' query already exists."
fi

echo "Creating query 'CIM' in $QUERY_LIB..." 
echo "Creating query 'CIM' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "CIM" -r inventory -v UMA_VCIM \
   -c TME_OBJECT_LABEL \
   -c CIM_Version \
"$QUERY_LIB" "CIM" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'CIM' query already exists."
fi

echo "Creating query 'System Board Configuration' in $QUERY_LIB..." 
echo "Creating query 'System Board Configuration' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "System Board Configuration" -r inventory -v UMA_VSystem_Boac1d \
   -c TME_OBJECT_LABEL \
   -c String \
"$QUERY_LIB" "System Board Configuration" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'System Board Configuration' query already exists."
fi

echo "Creating query 'IP Network Configuration' in $QUERY_LIB..." 
echo "Creating query 'IP Network Configuration' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "IP Network Configuration" -r inventory -v UMA_VIP_Networkc1b \
   -c TME_OBJECT_LABEL \
   -c IP_Address \
   -c IP_Subnet_Mask \
   -c IP_Gateway \
   -c DNS_Servers \
   -c DHCP_Enabled \
   -c DNS_Hostname \
   -c DNS_Domain \
"$QUERY_LIB" "IP Network Configuration" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'IP Network Configuration' query already exists."
fi

echo "Creating query 'IPX Network Configuration' in $QUERY_LIB..." 
echo "Creating query 'IPX Network Configuration' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "IPX Network Configuration" -r inventory -v UMA_VIPX_Networc1c \
   -c TME_OBJECT_LABEL \
   -c IPX_Enabled \
   -c IPX_Frame_Type \
   -c IPX_Address \
"$QUERY_LIB" "IPX Network Configuration" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'IPX Network Configuration' query already exists."
fi

echo "Creating query 'Lease Information' in $QUERY_LIB..." 
echo "Creating query 'Lease Information' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Lease Information" -r inventory -v UMA_VLease_Infoujc \
   -c TME_OBJECT_LABEL \
   -c Lessor \
   -c Lease_Start_Date \
   -c Lease_End_Date \
   -c Lease_Term__months \
   -c Lease_Amount \
"$QUERY_LIB" "Lease Information" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Lease Information' query already exists."
fi

echo "Creating query 'Geographic Information' in $QUERY_LIB..." 
echo "Creating query 'Geographic Information' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Geographic Information" -r inventory -v UMA_VGeographicuj7 \
   -c TME_OBJECT_LABEL \
   -c Locale \
   -c Country_Code \
   -c OS_Language \
   -c Code_Set \
"$QUERY_LIB" "Geographic Information" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Geographic Information' query already exists."
fi

echo "Creating query 'Memory Details' in $QUERY_LIB..." 
echo "Creating query 'Memory Details' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Memory Details" -r inventory -v UMA_VMemory_Detf0m \
   -c TME_OBJECT_LABEL \
   -c Device_Locator \
   -c siz_ \
   -c Form_Factor \
   -c Type \
   -c Speed \
   -c Data_Width \
   -c Total_Width \
"$QUERY_LIB" "Memory Details" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Memory Details' query already exists."
fi

echo "Creating query 'Network Details' in $QUERY_LIB..." 
echo "Creating query 'Network Details' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Network Details" -r inventory -v UMA_VNetwork_Def0l \
   -c TME_OBJECT_LABEL \
   -c Network_Adapter \
   -c Network_Driver \
   -c MAC_Address \
"$QUERY_LIB" "Network Details" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Network Details' query already exists."
fi

echo "Creating query 'Personalized Data' in $QUERY_LIB..." 
echo "Creating query 'Personalized Data' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Personalized Data" -r inventory -v UMA_VPersonalizsq3 \
   -c TME_OBJECT_LABEL \
   -c Label1 \
   -c Data1 \
   -c Label2 \
   -c Data2 \
   -c Label3 \
   -c Data3 \
   -c Label4 \
   -c Data4 \
   -c Label5 \
   -c Data5 \
"$QUERY_LIB" "Personalized Data" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Personalized Data' query already exists."
fi

echo "Creating query 'Port Connectors' in $QUERY_LIB..." 
echo "Creating query 'Port Connectors' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Port Connectors" -r inventory -v UMA_VPort_Conneoit \
   -c TME_OBJECT_LABEL \
   -c Logical_Name \
   -c Connector_Type \
   -c Port_Type \
   -c Tag \
"$QUERY_LIB" "Port Connectors" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Port Connectors' query already exists."
fi

echo "Creating query 'Processor Details' in $QUERY_LIB..." 
echo "Creating query 'Processor Details' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Processor Details" -r inventory -v UMA_VProcessor_f0j \
   -c TME_OBJECT_LABEL \
   -c Processor \
   -c Family \
   -c Clock_Speed \
   -c External_Clock_Spe \
   -c Max_Clock_Speed \
   -c Manufacturer \
   -c Processor_ID \
   -c Processor_Type \
"$QUERY_LIB" "Processor Details" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Processor Details' query already exists."
fi

echo "Creating query 'Serial Number Information' in $QUERY_LIB..." 
echo "Creating query 'Serial Number Information' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Serial Number Information" -r inventory -v UMA_VSerial_Numuj4 \
   -c TME_OBJECT_LABEL \
   -c Asset \
   -c Serial_Number \
   -c Manufacturer \
   -c Model \
   -c Type \
"$QUERY_LIB" "Serial Number Information" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Serial Number Information' query already exists."
fi

echo "Creating query 'IBM UM Services' in $QUERY_LIB..." 
echo "Creating query 'IBM UM Services' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "IBM UM Services" -r inventory -v UMA_VIBM_UM_Seroqd \
   -c TME_OBJECT_LABEL \
   -c Name \
   -c Version \
   -c Build_Number \
   -c HTTPD_Port \
   -c SNMP_Traps_Enabled \
   -c Trap_Destinations \
"$QUERY_LIB" "IBM UM Services" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'IBM UM Services' query already exists."
fi

echo "Creating query 'User Details' in $QUERY_LIB..." 
echo "Creating query 'User Details' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "User Details" -r inventory -v UMA_VUser_Details \
   -c TME_OBJECT_LABEL \
   -c User_Name \
   -c User_Phone \
   -c User_Department \
   -c User_Position \
   -c System_Location \
"$QUERY_LIB" "User Details" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'User Details' query already exists."
fi

echo "Creating query 'Video Details' in $QUERY_LIB..." 
echo "Creating query 'Video Details' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Video Details" -r inventory -v UMA_VVideo_Details \
   -c TME_OBJECT_LABEL \
   -c Manufacturer \
   -c Description \
   -c Current_Vertical_R \
   -c Current_Horizontal \
   -c Current_Number_of_ \
   -c Video_RAM_Memory_S \
   -c Driver_Filename \
   -c Current_Refresh_Ra \
   -c Color_Depth \
"$QUERY_LIB" "Video Details" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Video Details' query already exists."
fi

echo "Creating query 'Warranty Information' in $QUERY_LIB..." 
echo "Creating query 'Warranty Information' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Warranty Information" -r inventory -v UMA_VWarranty_Iuj9 \
   -c TME_OBJECT_LABEL \
   -c Warranty_Duration \
   -c Warranty_End_Date \
   -c Warranty_Cost \
"$QUERY_LIB" "Warranty Information" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Warranty Information' query already exists."
fi

QUERY_LIB=$1

echo "Creating query 'DMI' in $QUERY_LIB..." 
echo "Creating query 'DMI' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "DMI" -r inventory -v UMA_VDMI \
   -c TME_OBJECT_LABEL \
   -c Version \
   -c Product \
   -c Win32_DMI_Director \
"$QUERY_LIB" "DMI" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'DMI' query already exists."
fi

echo "Creating query 'System Slots' in $QUERY_LIB..." 
echo "Creating query 'System Slots' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "System Slots" -r inventory -v UMA_VSystem_Slots \
   -c TME_OBJECT_LABEL \
   -c Slot_Type \
   -c Slot_Data_Bus_Widt \
   -c Supports_Hot_Plug \
   -c Current_Usage \
   -c SlotDesignation \
   -c Shared_Slot_Openin \
   -c Supports_PME_Signa \
   -c Tag \
"$QUERY_LIB" "System Slots" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'System Slots' query already exists."
fi

echo "Creating query 'SNMP Agent Configuration' in $QUERY_LIB..." 
echo "Creating query 'SNMP Agent Configuration' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "SNMP Agent Configuration" -r inventory -v UMA_VSNMP_Agentc1b \
   -c TME_OBJECT_LABEL \
   -c SNMP_Traps_Enabled \
   -c Trap_Destinations \
"$QUERY_LIB" "SNMP Agent Configuration" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'SNMP Agent Configuration' query already exists."
fi

echo "Creating query 'Alert On LAN Settings' in $QUERY_LIB..." 
echo "Creating query 'Alert On LAN Settings' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "Alert On LAN Settings" -r inventory -v UMA_VAlert_On_Lhhr \
   -c TME_OBJECT_LABEL \
   -c Alerts_Enabled \
   -c Retransmission_Int \
   -c Polling_Interval \
   -c Heartbeat_Interval \
   -c Hardware_Version \
   -c Alert_Destination \
   -c Auto_Clear_Events \
   -c Heartbeat_Enabled \
   -c Hardware_Enabled \
   -c Watchdog_Interval \
   -c Watchdog_Enabled \
"$QUERY_LIB" "Alert On LAN Settings" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'Alert On LAN Settings' query already exists."
fi

echo "Creating query 'AssetID' in $QUERY_LIB..." 
echo "Creating query 'AssetID' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "AssetID" -r inventory -v UMA_VAssetID \
   -c TME_OBJECT_LABEL \
   -c System_Name \
   -c System_Model \
   -c Product_Name \
   -c LCCM_Image_Profile \
   -c LCCM_Image_Date \
   -c System_Serial_Numb \
   -c System_GUID \
   -c System_Asset_Numbe \
   -c AssetID_Tag \
   -c Last_Inventoried \
   -c Purchase_Date \
"$QUERY_LIB" "AssetID" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'AssetID' query already exists."
fi

echo "Creating query 'BIOS Details' in $QUERY_LIB..." 
echo "Creating query 'BIOS Details' in $QUERY_LIB..." >> $TEMP/umsinstall.log 
wcrtquery -d "BIOS Details" -r inventory -v UMA_VBIOS_Details \
   -c TME_OBJECT_LABEL \
   -c BIOS_Manufacturer \
   -c BIOS_Version \
   -c BIOS_Release_Date \
   -c Supports_SMBIOS \
   -c SMBIOS_Major_Versi \
   -c SMBIOS_Minor_Versi \
"$QUERY_LIB" "BIOS Details" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "'BIOS Details' query already exists."
fi

echo "Creating query Installed UM Services in $QUERY_LIB..." 
echo "Creating query Installed UM Services in $QUERY_LIB..." >> $TEMP/umsinstall.log
wcrtquery -d "Installed UM Services" -r inventory -v UMS_VINSTALLED_UMS \
          -c TME_OBJECT_ID \
          -c TME_OBJECT_LABEL \
          -c INST_FILE_NAME \
          -c INST_FILE_SIZE \
          -c INST_FILE_PATH \
          -c INST_FILE_DATE \
          -c INST_FILE_TIME \
	  -w "order by TME_OBJECT_LABEL" \
"$QUERY_LIB" "Installed UM Services" 2>> $TEMP/umsinstall.log
ERR=$?
if [ $ERR -ne 0 ] ; then
   echo "Installed UM Services query already exists."
fi

