#!/bin/sh
#
# File:		wakeupUMS.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	04/28/1999
#
# (C) COPYRIGHT Tivoli Systems, Inc., YEAR=1997
# All Rights Reserved
# Licensed Material - Property of IBM
#

###
#
#   errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

###
#
# is_managed_node
#
is_managed_node() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 0
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 1
  else
    return 0
  fi
}

###
#
# is_OS_NT
#
is_OS_NT() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ "`uname`" = "Windows_NT" ]; then
    return 0
  else
    return 1
  fi
}


###
#
#   Return value for BINDIR
#
bindir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    INTERP=`objcall $OSERV query interp`; export INTERP
    inst_dir="`objcall $OSERV query install_dir`"
    bindir="$inst_dir/$INTERP"
  else
    bindir="$LCF_BINDIR/.."
  fi
  bindir="`echo $bindir | sed -e 's,\\\\,/,g'`"
  echo $bindir
}

###
#
#   Return value for INST_DIR
#
inst_dir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    inst_dir="`objcall $OSERV query install_dir`"
  else
    inst_dir="$LCFROOT"
  fi
  inst_dir="`echo $inst_dir | sed -e 's,\\\\,/,g'`"
  echo $inst_dir
}

###
#
#   Return correct value for tmp directory
#
temp() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    temp=/tmp
    if is_OS_NT; then
	temp="$DBDIR/tmp"
    fi
  else
    if [ -n "$LCF_TEMPDIR" ]; then
      temp="$LCF_TEMPDIR"
    else
      temp="$LCF_DATDIR/tmp"
    fi
  fi
  if [ ! -d "$temp" ]; then
    mkdir -p "$temp"
  fi
  echo $temp
}

###
#
#    Find the Tivoli etc directory and source the right environment setup file
#
source_etc_setup_env() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    ETC=/etc/Tivoli

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/system32/drivers/etc/Tivoli
    fi

    # Look for the optional Plus override script, if not there use the standard one
    SETUP_SCRIPT=""
    if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
	SETUP_SCRIPT=setup_env.sh
    fi
    . $ETC/$SETUP_SCRIPT
  else
    # not a managed node; find the most recent lcf_env.sh and source it
    ETC=/etc/Tivoli/lcf

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/Tivoli/lcf
    fi
    SETUP_SCRIPT=lcf_env.sh
    LCF_ETC_SCRIPT=`echo \`ls -td ${ETC}/*\` | awk '{print $1}'`/$SETUP_SCRIPT
    if [ -f "$LCF_ETC_SCRIPT" ]; then
      . $LCF_ETC_SCRIPT
    fi
  fi
}

###
#
# ironame
#
ironame() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    #
    #	Get the region name to avoid collisions
    #
    iro=`wlookup InterRegion`
    ironame=`idlattr -t -g $iro name string`
    ironame=`eval echo $ironame`
    echo $ironame
  else
    echo ""
  fi
}

###
#
# mnname
#
mnname() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    mnoid=`objcall 0.0.0 get_host_location`
    eval mnname=`idlattr -t -g $mnoid label string`
    echo $mnname
  else
    echo ""
  fi
}

###
#
# source_product_info
#
source_product_info() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -d "$1" ]; then
    cd "$1"
    if [ -f PLUSproduct-info.sh ]; then
      . ./PLUSproduct-info.sh
      export WINSTRUCTED
      export MODULE_VERSION
    else
      errecho "$1/PLUSproduct-info.sh not found!"
    fi
  else
    errecho "$1/PLUSproduct-info.sh not found!"
  fi
}

###
#
# get_install_opts
#
get_install_opts() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -n "$INSTALL_OPTS" ]; then
   if [ -f "$LINKDIR/PLUSget_install_opts.sh" ]; then
	. "$LINKDIR/PLUSget_install_opts.sh"
   fi
  fi
}

###
#
# Execute
#
Execute()
{
  
  # initialize node name list
  	NODELIST=$NODE
	
  # ProfileManager names are specified
	if [ -n "$SUBSCRIBER" ]; then
		for PROFILEMANAGER in $SUBSCRIBER; do
			NODELIST="$NODELIST `wgetsub @$PROFILEMANAGER`"
		done
	fi

  #execute java command
	if [ -n "$NODELIST" ] ; then
		IFS=$IFS_SAVE
		wcrtqlib "$MEDIUM_PRODNAME" "WakeUpOnLanLibrary"
		wcrtquery -r inventory -v UMS_VIP_MAC_ADDRESS \
			-c MAC_Address -c IP_Address -c IP_Subnet_Mask \
			"WakeUpOnLanLibrary" "WakeUpOnLan"
		for NODE in $NODELIST; do
			ID=`wlookup -r Endpoint "$NODE"`
			if [ -z "$ID" ]; then
				ID=`wlookup -r ManagedNode "$NODE"`
			fi

			if [ -n "$ID" ]; then
				wsetquery -w "TME_OBJECT_ID = "\'"$ID"\'"" "WakeUpOnLan"
			else
				wsetquery -w "TME_OBJECT_LABEL = "\'"$NODE"\'"" "WakeUpOnLan"
			fi
			PARAMETER=`wrunquery -n -d " " "WakeUpOnLan"`
			if [ -n "$PARAMETER" ] ; then
				PARAMETER=`echo $PARAMETER | 'sed' -e s/://g | 'cut' -f1,2,3 -d' '`
				echo $NODE : $PARAMETER

                UNIX_OS=`uname -sr`
                case $UNIX_OS in
                	"SunOS 5"*)	jre -cp ./wakeonlan.jar com.ibm.sysmgt.wakeonlan.WakeOnLan $PARAMETER	;;
                    HP-UX*)		jre -cp ./wakeonlan.jar com.ibm.sysmgt.wakeonlan.WakeOnLan $PARAMETER	;;
                	AIX*)		jre -cp ./wakeonlan.jar com.ibm.sysmgt.wakeonlan.WakeOnLan $PARAMETER	;;
                	Windows_NT*)	jview -cp $PRODDIR/wakeonlan.jar com.ibm.sysmgt.wakeonlan.WakeOnLan $PARAMETER ;;
                	*)
                		wdispmsg "There is no \"$cmd\" utility for this platform."
                		exit 0
                     		;;
                esac
			fi	
		done
		wdel "@Query:WakeUpOnLan"
        	wdel "@QueryLibrary:WakeUpOnLanLibrary"
	fi	
	
}

####
#
# Managed node launch
#
mn_launch() {

  ARGLIST=""
  COMPONENT_NAME="Wakeup UM Services"
  PRESNAME=@Presentation:"$COMPONENT_NAME"_"$MNNAME"_"$MEDIUM_PRODNAME"
  DIALOG_DESCRIPTOR="wakeupUMS.sh.d"

  ###############################################################################
  ###############################################################################
  #
  # Insert your application specific code here, using the following as an example
  #
  ###############################################################################
  ###############################################################################

  #
  # Under Windows_NT, a GUI should be launched using the wrunui command, 
  # and only on the active desktop
  #
  #if is_OS_NT ; then
  #  MACHINE=`echo $WD_DISPLAY | awk -F : '{print $1}'`
  #  if [ "$MNNAME" != "$MACHINE" ]; then
  #    wdispmsg "This task can only be run on $MNNAME from a Tivoli desktop on $MNNAME."
  #    exit 0
  #  fi
  #  WRUNUI="$BINDIR/bin/wrunui.exe"
  #  if [ ! -f "$WRUNUI" ]; then
  #    wdispmsg "$WRUNUI NOT FOUND.  Please contact Tivoli Customer Support."
  #    exit 0
  #  fi
  #fi

  #
  # The following sets the path and display, and then allows the
  # determination of the correct binaries according to the OS type
  #
  PATH=/usr/bin:/bin:/usr/sbin:/sbin:/usr/ucb:$PATH
  DISPLAY=$WD_DISPLAY
  export PATH DISPLAY

  IFS=,
  Execute
}


####
#
# LCF endpoint launch
#
lcf_ep_launch() {

  ###############################################################################
  ###############################################################################
  #
  # Insert your application specific code here, using the following as an example
  #
  ###############################################################################
  ###############################################################################

  #
  # Under Windows_NT, a GUI should be launched using the wrunuiep command, 
  # and only on the active desktop
  #
  EPNAME=`echo $ENDPOINT | awk '{print $1}'`
  if is_OS_NT ; then
    MACHINE=`echo $WD_DISPLAY | awk -F : '{print $1}'`
    if [ "$EPNAME" != "$MACHINE" ]; then
      errecho "This task can only be run on $EPNAME from a Tivoli desktop on $MACHINE."
      exit 1
    fi
    WRUNUI="$BINDIR/bin/wrunuiep.exe"
    if [ ! -f "$WRUNUI" ]; then
      errecho "$WRUNUI NOT FOUND.  Please contact Tivoli Customer Support."
      exit 1
    fi
  fi

  #
  # The following sets the path and display, and then allows the
  # determination of the correct binaries according to the OS type
  #
  PATH=/usr/bin:/bin:/usr/sbin:/sbin:/usr/ucb:$PATH
  DISPLAY=$WD_DISPLAY
  export PATH DISPLAY

  IFS=,
  Execute	

}


##################################################################################
#
#
NODE=$1
SUBSCRIBER=$2
echo Node Name: $NODE
echo Subscriber Name: $SUBSCRIBER
if [ -n "" ]; then
  set -x
  DEBUG=true
fi
#set -x
#DEBUG=false

THIS_SCRIPT="`echo $0 | sed -e 's.\\\\./.g'`"
THIS_SCRIPT=`basename "$THIS_SCRIPT"`

#
#	Set up some popular environment variables
#
source_etc_setup_env
BINDIR="`bindir`"; export BINDIR
INST_DIR="`inst_dir`"; export INST_DIR
MNNAME="`mnname`"; export MNNAME
TEMP="`temp`"; export TEMP

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts may be
#		redirected to a file in TEMP by the same name as the script.
#
DEBUGDIR="$TEMP/.plusdebug"
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > "$DEBUGDIR/$THIS_SCRIPT" 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv
[ "$DEBUG" = true ] && set -xv

#
#	Set up variables for our basic directories, path
#
PLUSDIR="$INST_DIR/generic_unix/TME/PLUS"
LINKDIR="$PLUSDIR/LINK"
PRODDIR="$PLUSDIR/UM_SERVICES"
PATH="$LINKDIR:$PRODDIR:$PATH"
export PATH
IFS_SAVE=$IFS
#
#	Source the PLUSproduct-info.sh file
#
source_product_info "$PRODDIR"

#
#	If there are install options from PLUSproduct-info.sh, bring them in!
#
get_install_opts

#
#	Now perform the correct type of launch
#
IFS=,
if is_managed_node; then
  mn_launch
else
  lcf_ep_launch
fi

# A non-zero exit status from a method causes an odstat error
exit 0	
