/*
 * This demo shows the use of a positioner with XOR drawmode, most
 * useful for overlaying positioner on top of other object
 *
 *  This file is part of xforms package
 *  T.C. Zhao and M. Overmars  1997
 */

#include <stdio.h>
#include "forms.h"

FL_OBJECT *xval, *yval, *xyplot;

/* callback routine */
void
positioner_cb(FL_OBJECT *ob, long q)
{
    char str[30];
    sprintf(str,"%f",fl_get_positioner_xvalue(ob));
    fl_set_object_label(xval,str);
    sprintf(str,"%f",fl_get_positioner_yvalue(ob));
    fl_set_object_label(yval,str);
}

void
positioner_cb2(FL_OBJECT *ob, long q)
{
    char str[30];
    float xmin, xmax, ymin, ymax;
    
    fl_get_xyplot_xbounds(xyplot,&xmin,&xmax);
    fl_get_xyplot_ybounds(xyplot,&ymin,&ymax);

    sprintf(str,"%f",xmin+fl_get_positioner_xvalue(ob)*(xmax-xmin));
    fl_set_object_label(xval,str);
    sprintf(str,"%f",ymin+fl_get_positioner_yvalue(ob)*(ymax-ymin));
    fl_set_object_label(yval,str);
}

int
main(int argc, char *argv[])
{
  FL_FORM *form;
  FL_OBJECT *pos, *button, *ob;
  float xx[] = {-2, -1,  0,  1, 2};
  float yy[] = {4,   1,  0,  1, 4};
  float xmin, ymin, xmax, ymax;

  fl_set_border_width(-2);
  fl_initialize(&argc, argv, "FormDemo", 0, 0);

  form = fl_bgn_form(FL_UP_BOX,350,310);

     ob = fl_add_pixmap(FL_NORMAL_PIXMAP, 60, 25, 100, 100, "");
     fl_set_object_boxtype(ob, FL_DOWN_BOX);
     fl_set_pixmap_file(ob, "porsche.xpm");

     pos = fl_add_positioner(FL_OVERLAY_POSITIONER,60,25,100,100,"");
     fl_set_positioner_xbounds(pos,0,1);
     fl_set_positioner_ybounds(pos,0,1);
     fl_set_object_callback(pos,positioner_cb,0);

     xval = fl_add_box(FL_DOWN_BOX,230,25,100,30,"");
     yval = fl_add_box(FL_DOWN_BOX,230,60,100,30,"");
     fl_set_object_color(xval,FL_COL1,FL_COL1);
     fl_set_object_color(yval,FL_COL1,FL_COL1);

     xyplot = fl_add_xyplot(FL_NORMAL_XYPLOT, 40, 130, 160, 160, "");
     fl_set_xyplot_xbounds(xyplot, -2, 2);
     fl_set_xyplot_ybounds(xyplot, 0, 4);
     fl_set_xyplot_data(xyplot,xx,yy,5,0,0,0);
     fl_set_xyplot_interpolate(xyplot,0,2,0.1);
     
     button = fl_add_button(FL_NORMAL_BUTTON,230,200,100,30,"Exit");
  fl_end_form();

  fl_show_form(form,FL_PLACE_CENTER,FL_TRANSIENT,"XOR Positioner");

  /* figure out the plotting area  */
  fl_xyplot_w2s(xyplot, -2, 0, &xmin, &ymax);
  fl_xyplot_w2s(xyplot, 2, 4, &xmax, &ymin);

  fl_addto_form(form);
     pos = fl_add_positioner(FL_OVERLAY_POSITIONER,xmin, ymin, 
                             xmax-xmin+1, ymax-ymin+1, "");
     fl_set_positioner_xbounds(pos,0,1);
     fl_set_positioner_ybounds(pos,0,1);
     fl_set_object_callback(pos,positioner_cb2,0); 
  fl_end_form();

  positioner_cb2(pos,0);

  fl_do_forms();
  fl_hide_form(form);

  return 0;
}
