/*
  File autogenerated by gengetopt version 2.17
  generated with the following command:
  /usr/bin/gengetopt --input ./cmdline.sh 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "The Ganglia Metric Client (gmetric) announces a metric\non the list of defined send channels defined in a configuration file";

const char *gengetopt_args_info_usage = "Usage: gmetric [OPTIONS]...";

const char *gengetopt_args_info_help[] = {
  "  -h, --help          Print help and exit",
  "  -V, --version       Print version and exit",
  "  -c, --conf=STRING   The configuration file to use for finding send channels  \n                        (default=`/etc/gmond.conf')",
  "  -n, --name=STRING   Name of the metric",
  "  -v, --value=STRING  Value of the metric",
  "  -t, --type=STRING   Either \n                        string|int8|uint8|int16|uint16|int32|uint32|float|double",
  "  -u, --units=STRING  Unit of measure for the value e.g. Kilobytes, Celcius  \n                        (default=`')",
  "  -s, --slope=STRING  Either zero|positive|negative|both  (default=`both')",
  "  -x, --tmax=INT      The maximum time in seconds between gmetric calls  \n                        (default=`60')",
  "  -d, --dmax=INT      The lifetime in seconds of this metric  (default=`0')",
  "  -S, --spoof=STRING  IP address and name of host/device (colon separated) we \n                        are spoofing  (default=`')",
  "  -H, --heartbeat     spoof a heartbeat message (use with spoof option)",
    0
};

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->conf_given = 0 ;
  args_info->name_given = 0 ;
  args_info->value_given = 0 ;
  args_info->type_given = 0 ;
  args_info->units_given = 0 ;
  args_info->slope_given = 0 ;
  args_info->tmax_given = 0 ;
  args_info->dmax_given = 0 ;
  args_info->spoof_given = 0 ;
  args_info->heartbeat_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->conf_arg = gengetopt_strdup ("/etc/gmond.conf");
  args_info->conf_orig = NULL;
  args_info->name_arg = NULL;
  args_info->name_orig = NULL;
  args_info->value_arg = NULL;
  args_info->value_orig = NULL;
  args_info->type_arg = NULL;
  args_info->type_orig = NULL;
  args_info->units_arg = gengetopt_strdup ("");
  args_info->units_orig = NULL;
  args_info->slope_arg = gengetopt_strdup ("both");
  args_info->slope_orig = NULL;
  args_info->tmax_arg = 60;
  args_info->tmax_orig = NULL;
  args_info->dmax_arg = 0;
  args_info->dmax_orig = NULL;
  args_info->spoof_arg = gengetopt_strdup ("");
  args_info->spoof_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{
  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->conf_help = gengetopt_args_info_help[2] ;
  args_info->name_help = gengetopt_args_info_help[3] ;
  args_info->value_help = gengetopt_args_info_help[4] ;
  args_info->type_help = gengetopt_args_info_help[5] ;
  args_info->units_help = gengetopt_args_info_help[6] ;
  args_info->slope_help = gengetopt_args_info_help[7] ;
  args_info->tmax_help = gengetopt_args_info_help[8] ;
  args_info->dmax_help = gengetopt_args_info_help[9] ;
  args_info->spoof_help = gengetopt_args_info_help[10] ;
  args_info->heartbeat_help = gengetopt_args_info_help[11] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  printf("\n%s\n\n", gengetopt_args_info_usage);
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  if (args_info->conf_arg)
    {
      free (args_info->conf_arg); /* free previous argument */
      args_info->conf_arg = 0;
    }
  if (args_info->conf_orig)
    {
      free (args_info->conf_orig); /* free previous argument */
      args_info->conf_orig = 0;
    }
  if (args_info->name_arg)
    {
      free (args_info->name_arg); /* free previous argument */
      args_info->name_arg = 0;
    }
  if (args_info->name_orig)
    {
      free (args_info->name_orig); /* free previous argument */
      args_info->name_orig = 0;
    }
  if (args_info->value_arg)
    {
      free (args_info->value_arg); /* free previous argument */
      args_info->value_arg = 0;
    }
  if (args_info->value_orig)
    {
      free (args_info->value_orig); /* free previous argument */
      args_info->value_orig = 0;
    }
  if (args_info->type_arg)
    {
      free (args_info->type_arg); /* free previous argument */
      args_info->type_arg = 0;
    }
  if (args_info->type_orig)
    {
      free (args_info->type_orig); /* free previous argument */
      args_info->type_orig = 0;
    }
  if (args_info->units_arg)
    {
      free (args_info->units_arg); /* free previous argument */
      args_info->units_arg = 0;
    }
  if (args_info->units_orig)
    {
      free (args_info->units_orig); /* free previous argument */
      args_info->units_orig = 0;
    }
  if (args_info->slope_arg)
    {
      free (args_info->slope_arg); /* free previous argument */
      args_info->slope_arg = 0;
    }
  if (args_info->slope_orig)
    {
      free (args_info->slope_orig); /* free previous argument */
      args_info->slope_orig = 0;
    }
  if (args_info->tmax_orig)
    {
      free (args_info->tmax_orig); /* free previous argument */
      args_info->tmax_orig = 0;
    }
  if (args_info->dmax_orig)
    {
      free (args_info->dmax_orig); /* free previous argument */
      args_info->dmax_orig = 0;
    }
  if (args_info->spoof_arg)
    {
      free (args_info->spoof_arg); /* free previous argument */
      args_info->spoof_arg = 0;
    }
  if (args_info->spoof_orig)
    {
      free (args_info->spoof_orig); /* free previous argument */
      args_info->spoof_orig = 0;
    }
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->conf_given) {
    if (args_info->conf_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "conf", args_info->conf_orig);
    } else {
      fprintf(outfile, "%s\n", "conf");
    }
  }
  if (args_info->name_given) {
    if (args_info->name_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "name", args_info->name_orig);
    } else {
      fprintf(outfile, "%s\n", "name");
    }
  }
  if (args_info->value_given) {
    if (args_info->value_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "value", args_info->value_orig);
    } else {
      fprintf(outfile, "%s\n", "value");
    }
  }
  if (args_info->type_given) {
    if (args_info->type_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "type", args_info->type_orig);
    } else {
      fprintf(outfile, "%s\n", "type");
    }
  }
  if (args_info->units_given) {
    if (args_info->units_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "units", args_info->units_orig);
    } else {
      fprintf(outfile, "%s\n", "units");
    }
  }
  if (args_info->slope_given) {
    if (args_info->slope_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "slope", args_info->slope_orig);
    } else {
      fprintf(outfile, "%s\n", "slope");
    }
  }
  if (args_info->tmax_given) {
    if (args_info->tmax_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "tmax", args_info->tmax_orig);
    } else {
      fprintf(outfile, "%s\n", "tmax");
    }
  }
  if (args_info->dmax_given) {
    if (args_info->dmax_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "dmax", args_info->dmax_orig);
    } else {
      fprintf(outfile, "%s\n", "dmax");
    }
  }
  if (args_info->spoof_given) {
    if (args_info->spoof_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "spoof", args_info->spoof_orig);
    } else {
      fprintf(outfile, "%s\n", "spoof");
    }
  }
  if (args_info->heartbeat_given) {
    fprintf(outfile, "%s\n", "heartbeat");
  }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "conf",	1, NULL, 'c' },
        { "name",	1, NULL, 'n' },
        { "value",	1, NULL, 'v' },
        { "type",	1, NULL, 't' },
        { "units",	1, NULL, 'u' },
        { "slope",	1, NULL, 's' },
        { "tmax",	1, NULL, 'x' },
        { "dmax",	1, NULL, 'd' },
        { "spoof",	1, NULL, 'S' },
        { "heartbeat",	0, NULL, 'H' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVc:n:v:t:u:s:x:d:S:H", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'c':	/* The configuration file to use for finding send channels.  */
          if (local_args_info.conf_given)
            {
              fprintf (stderr, "%s: `--conf' (`-c') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->conf_given && ! override)
            continue;
          local_args_info.conf_given = 1;
          args_info->conf_given = 1;
          if (args_info->conf_arg)
            free (args_info->conf_arg); /* free previous string */
          args_info->conf_arg = gengetopt_strdup (optarg);
          if (args_info->conf_orig)
            free (args_info->conf_orig); /* free previous string */
          args_info->conf_orig = gengetopt_strdup (optarg);
          break;

        case 'n':	/* Name of the metric.  */
          if (local_args_info.name_given)
            {
              fprintf (stderr, "%s: `--name' (`-n') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->name_given && ! override)
            continue;
          local_args_info.name_given = 1;
          args_info->name_given = 1;
          if (args_info->name_arg)
            free (args_info->name_arg); /* free previous string */
          args_info->name_arg = gengetopt_strdup (optarg);
          if (args_info->name_orig)
            free (args_info->name_orig); /* free previous string */
          args_info->name_orig = gengetopt_strdup (optarg);
          break;

        case 'v':	/* Value of the metric.  */
          if (local_args_info.value_given)
            {
              fprintf (stderr, "%s: `--value' (`-v') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->value_given && ! override)
            continue;
          local_args_info.value_given = 1;
          args_info->value_given = 1;
          if (args_info->value_arg)
            free (args_info->value_arg); /* free previous string */
          args_info->value_arg = gengetopt_strdup (optarg);
          if (args_info->value_orig)
            free (args_info->value_orig); /* free previous string */
          args_info->value_orig = gengetopt_strdup (optarg);
          break;

        case 't':	/* Either string|int8|uint8|int16|uint16|int32|uint32|float|double.  */
          if (local_args_info.type_given)
            {
              fprintf (stderr, "%s: `--type' (`-t') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->type_given && ! override)
            continue;
          local_args_info.type_given = 1;
          args_info->type_given = 1;
          if (args_info->type_arg)
            free (args_info->type_arg); /* free previous string */
          args_info->type_arg = gengetopt_strdup (optarg);
          if (args_info->type_orig)
            free (args_info->type_orig); /* free previous string */
          args_info->type_orig = gengetopt_strdup (optarg);
          break;

        case 'u':	/* Unit of measure for the value e.g. Kilobytes, Celcius.  */
          if (local_args_info.units_given)
            {
              fprintf (stderr, "%s: `--units' (`-u') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->units_given && ! override)
            continue;
          local_args_info.units_given = 1;
          args_info->units_given = 1;
          if (args_info->units_arg)
            free (args_info->units_arg); /* free previous string */
          args_info->units_arg = gengetopt_strdup (optarg);
          if (args_info->units_orig)
            free (args_info->units_orig); /* free previous string */
          args_info->units_orig = gengetopt_strdup (optarg);
          break;

        case 's':	/* Either zero|positive|negative|both.  */
          if (local_args_info.slope_given)
            {
              fprintf (stderr, "%s: `--slope' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->slope_given && ! override)
            continue;
          local_args_info.slope_given = 1;
          args_info->slope_given = 1;
          if (args_info->slope_arg)
            free (args_info->slope_arg); /* free previous string */
          args_info->slope_arg = gengetopt_strdup (optarg);
          if (args_info->slope_orig)
            free (args_info->slope_orig); /* free previous string */
          args_info->slope_orig = gengetopt_strdup (optarg);
          break;

        case 'x':	/* The maximum time in seconds between gmetric calls.  */
          if (local_args_info.tmax_given)
            {
              fprintf (stderr, "%s: `--tmax' (`-x') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->tmax_given && ! override)
            continue;
          local_args_info.tmax_given = 1;
          args_info->tmax_given = 1;
          args_info->tmax_arg = strtol (optarg, &stop_char, 0);
          if (!(stop_char && *stop_char == '\0')) {
            fprintf(stderr, "%s: invalid numeric value: %s\n", argv[0], optarg);
            goto failure;
          }
          if (args_info->tmax_orig)
            free (args_info->tmax_orig); /* free previous string */
          args_info->tmax_orig = gengetopt_strdup (optarg);
          break;

        case 'd':	/* The lifetime in seconds of this metric.  */
          if (local_args_info.dmax_given)
            {
              fprintf (stderr, "%s: `--dmax' (`-d') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->dmax_given && ! override)
            continue;
          local_args_info.dmax_given = 1;
          args_info->dmax_given = 1;
          args_info->dmax_arg = strtol (optarg, &stop_char, 0);
          if (!(stop_char && *stop_char == '\0')) {
            fprintf(stderr, "%s: invalid numeric value: %s\n", argv[0], optarg);
            goto failure;
          }
          if (args_info->dmax_orig)
            free (args_info->dmax_orig); /* free previous string */
          args_info->dmax_orig = gengetopt_strdup (optarg);
          break;

        case 'S':	/* IP address and name of host/device (colon separated) we are spoofing.  */
          if (local_args_info.spoof_given)
            {
              fprintf (stderr, "%s: `--spoof' (`-S') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->spoof_given && ! override)
            continue;
          local_args_info.spoof_given = 1;
          args_info->spoof_given = 1;
          if (args_info->spoof_arg)
            free (args_info->spoof_arg); /* free previous string */
          args_info->spoof_arg = gengetopt_strdup (optarg);
          if (args_info->spoof_orig)
            free (args_info->spoof_orig); /* free previous string */
          args_info->spoof_orig = gengetopt_strdup (optarg);
          break;

        case 'H':	/* spoof a heartbeat message (use with spoof option).  */
          if (local_args_info.heartbeat_given)
            {
              fprintf (stderr, "%s: `--heartbeat' (`-H') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->heartbeat_given && ! override)
            continue;
          local_args_info.heartbeat_given = 1;
          args_info->heartbeat_given = 1;
          break;


        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
