#!/bin/bash
#
#  Program:      setup_reports.sh
#
#  Description:  This program does post installation configuration to allow
#    the configurator to run properly.
#
#    This setup script installs the REPORTS package.
#
#  History:
#
#

echo "Starting Compaq Configurator setup script...REPORTS Module"

# Setup the datastore components
if [ -a /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/reports.xml ]; then
    echo "  - Datastore already installed...(This must be an upgrade)"    
else
    echo "  - Installing new datastore..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/reports.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/*
    chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/*
fi

# Set SUID on custom components
echo "  - Setting SUID on select programs..."
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/reports/webalizer.cpq
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/reports/webalizer.cpq

# Wipe out webalizer information
if [ -a /var/cpqcfg/html/webalizer/index.html ]; then
    echo "  - Webalizer already installed...(This must be an upgrade)"
else
    echo "  - Scheduling and initializing webalizer..."
    mkdir /var/cpqcfg/html/webalizer
    rm /var/cpqcfg/html/webalizer/*
    echo "<HTML><HEAD></HEAD><BODY bgcolor=white><CENTER><H3>Web server statistics not collected yet.</H3><P>The web server statistics will be collected once each hour.  Once the statistics have been collected, you may view the data at this location.</CENTER></BODY></HTML>" > /var/cpqcfg/html/webalizer/index.html
    chown cpqcfg:cpqcfg /var/cpqcfg/html/webalizer/index.html
fi

# Start routine webalizer reports (LEAVE THE NEW LINES IN!!!)
echo "  - Scheduling and initializing reports and alerts..."
echo "MAILTO=\"\"
30 * * * * /var/cpqcfg/cgi-bin/CompaqConfigurator/system/reports/webalizer.cpq
0-59/15 * * * * /var/cpqcfg/cgi-bin/CompaqConfigurator/system/alerts/alerts.cpq
" | /usr/bin/crontab -u cpqcfg -

# Install the startup script
if [ -a /etc/rc.d/init.d/cpqcfg ]; then
    echo "  - cpqcfg already in init.d...(This must be an upgrade)"
else
    echo "  - Tying configurator into normal run-level..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/cpqcfg /etc/rc.d/init.d/cpqcfg
    chown root:root /etc/rc.d/init.d/cpqcfg
    chmod 770 /etc/rc.d/init.d/cpqcfg
    # Hook into the normal run-level
    ln -s /etc/rc.d/init.d/cpqcfg /etc/rc.d/rc3.d/S85cpqcfg
    ln -s /etc/rc.d/init.d/cpqcfg /etc/rc.d/rc3.d/K85cpqcfg
fi

# END OF SCRIPT
echo "** Finished! **"
