//***************************************************************
//                  Foundation Agents Control File
//***************************************************************
//    The following section is the main control section for this
//    product.
//***************************************************************
//
//    Name = The Marketing Name of the product
//
//    Description = What is displayed as the description of the
//              product. (Required Field)
//
//    Execute = This option is used to execute an application.
//              Some possible uses for this would be launching
//              another installation program, or a configuration
//              applet.
//
//    RequiredSpace = The total amount of disk space required
//              by this product for installation.
//
//    Dependency = This is a field that will specify a case
//              that must exist for the product to be installed.
//
//    Compaq_System = This field specifies if it needs to be a
//              Compaq System.
//                    1 = Needs to be a Compaq Machine
//                    0 = Can be any machine type
//
//    Services = This is a list of services that need to be
//              setup.  The list here, is a list of the service name
//              divided by a comma.  Each service name will then
//              be a section listed in the services section.
//
//    Registry = This is a list of registry keys that need to be
//              added.
//
//    DefaultLoad = This will specify if the product is loaded as a
//              default.
//                     1 = Product is loaded
//                     0 = Product is not loaded
//
//    Version = This is the current version of the agents
//
//    MinBuildNumber = This value will give a specific product the
//              ability to not install on a version of NT different from
//              the main product.
//
//    MaxBuildNumber = Similar to th MinBuildNumber, this one will
//              allow you to specifiy the maximum build number for this
//              product.
//
//    DllCalls = This is for specifiying additional Dll calls.
//
//***************************************************************

[Main]
Name=Compaq Foundation Agents
Description=This component runs as a software service under Windows. The service collects information for the host including clustering, software version, and external MIB status at periodic intervals and makes the collected data available to the Compaq SNMP agent. It also provides threshold support and SNMP alerts.
Execute=CONTROL,OLD_CONTROL
RequiredSpace=1000000
Dependency=
Compaq_System=1
Services=CQMGHOST,CQMGHOSTNoSNMP
Registry=SNMP_Extension,SNMP_Extension2,SNMP_Extension4,Add_Remove,Add_Remove2,CatMsg,CatCount
RegistryDelete=OLD_SNMP
BranchDelete=OLDMGMT
DefaultLoad=1
Version=%%SMA_REL_MAJ%%.%%SMA_REL_MIN%%.%%SMA_REL_CUT%%.0
VersionFile=.\cqmghost.exe
InstalledVersionFile=WindowsSysDir\cpqmgmt\cqmghost\cqmghost.exe
Include=
RebootRequired=0
RebootUpgrade=0
DllCalls=EVENTDLL,EVENTDLL2,EVENTDLL3

//***************************************************************
//    This is where the start menu items are added.
//***************************************************************
//
//    Folder = The folder to be added
//
//    Entry# = The entries to be added
//
//***************************************************************

[Start Menu]
Folder=Compaq Products and Services
Entry1="Compaq Management Agents Readme"  $(!STF_WINDOWSSYSPATH)"\NOTEPAD.EXE "$(!CPQMgmtDir)"\readme.txt" "PROGMAN.EXE" 29
Entries=README

README_SOURCE=readme.lnk
README_DESTINATION=Compaq Management Agents Readme.lnk
//***************************************************************
//    Locations of all of the source directories
//***************************************************************
//
//    The entry names are the ones specifid in the [Files] section
//    by the NAME_SOURCE directories.  This abstacts the actual
//    source directory, to this portion of the control file.
//
//***************************************************************

[SourcePath]
CqMgHost=.
CqMgHostX2=.\cqmghost
Cluster=.\ComnClus
ExeSymbols=support\symbols\exe
DllSymbols=support\symbols\dll
SysSymbols=support\symbols\sys
RootDir=.

//***************************************************************
//    Locations of all of the destination directories
//***************************************************************
//
//    The entry names are the ones specifid in the [Files] section
//    by the NAME_DESTINATION directories.  This abstacts the actual
//    destination directory, to this portion of the control file.
//
//***************************************************************

[DestinationPath]
CPQMgmt=WindowsSysDir\CPQMgmt
System=WindowsSysDir
CqMgHost=WindowsSysDir\CPQMgmt\CqMgHost
ExeSymbols=WindowsDir\symbols\exe
DllSymbols=WindowsDir\symbols\dll
SysSymbols=WindowsDir\symbols\sys
Drivers=WindowsSysDir\drivers
Login=WindowsSysDir
Groups=%USERPROFILE%\Start Menu\Programs\Compaq Products and Services

//***************************************************************
//    Names of all of the files that are to be copied
//***************************************************************
//
//    FILE_LIST = This lists a code name for a file grouping.
//              Each group is a set of files that are similar in
//              behavior.  They all have the same source, destination
//              and flag conditions.  All file groups are separated
//              by a comma.
//
//    DEFAULT_NOTIFY = This is the default for the files in this section
//              it specifies if the dialog box will appear or not that
//              will ask if you want to over-write the file.  Any file
//              group that specifys a notify will be over-written.
//                    1 = Will display box
//                    0 = Will write over existing file.
//
//    NAME_SOURCE = This shows the name of the source directory
//              for the group of files called NAME.
//
//    NAME_DESTINATION = This shows the name of the destination directory
//              for the group of files called NAME.
//
//    NAME_FILES = This is a list of the files that need to be copied.
//
//    NAME_NOTIFY = This will over-write the DEFAULT_NOTIFY option
//              listed above.  If it is not specified, it will NOT
//              chage the default.
//                    1 = Will display box
//                    0 = Will write over existing file.
//
//    NAME_UNINSTALL = This will determine if the files listed will be
//               removed on an uninstall.  The default is uninstall all
//               files.
//                    1 = Will uninstall this group of files
//                    0 = Will leave these files during an uninstall
//
//    DELETE_FILES = List of files to be deleted
//
//***************************************************************

[Files]
FILE_LIST=CPQMGMT,CqMgHost,NTRoot-System,Message-System,Debug-Exe,Debug-Dll,HostReadme,Install
DELETE_FILES=OLD,420SPLIT,OLD_CPQMGMT,GROUPS
DEFAULT_NOTIFY=1

CPQMGMT_SOURCE=CqMgHost
CPQMGMT_DESTINATION=CPQMgmt
CPQMGMT_FILES=cpqclnt.exe,readme.txt,readme.htm
CPQMGMT_UNINSTALL=1

CqMgHost_SOURCE=CqMgHost
CqMgHost_DESTINATION=CqMgHost
CqMgHost_FILES=cqmghost.exe,cqmghost.dll,hostalrt.dll,hostmib.dll,cpqmhost.dll,cpqthrsh.dll,hostsnmp.dll,cpqswv.dll,cpqclus.dll,cpqstat.dll,cpqperf.dll,cpqmib1k.dll
CqMgHost_UNINSTALL=1

Install_SOURCE=CqMgHost
Install_DESTINATION=CPQMgmt
Install_FILES=install.exe,inshelp.hlp
Install_UNINSTALL=0

NTRoot-System_SOURCE=CqMgHost
NTRoot-System_DESTINATION=System
NTRoot-System_FILES=cpqdbg.exe,cpqmgmt.cpl,cpqmgmt.hlp,cqhstutl.dll
NTRoot-System_UNINSTALL=1

Message-System_SOURCE=CqMgHost
Message-System_DESTINATION=System
Message-System_FILES=cpqhsmsg.dll
Message-System_UNINSTALL=0

HostReadme_SOURCE=CqMgHostX2
HostReadme_DESTINATION=CqMgHost
HostReadme_FILES=readme.txt
HostReadme_UNINSTALL=1

Debug-Exe_SOURCE=ExeSymbols
Debug-Exe_DESTINATION=ExeSymbols
Debug-Exe_FILES=cqmghost.pdb,cpqdbg.pdb
Debug-Exe_UNINSTALL=1

Debug-Dll_SOURCE=DllSymbols
Debug-Dll_DESTINATION=DllSymbols
Debug-Dll_FILES=cqmghost.pdb,hostalrt.pdb,hostmib.pdb,cpqhsmsg.pdb,cpqmhost.pdb,cpqthrsh.pdb,hostsnmp.pdb,cpqswv.pdb,cpqclus.pdb,cpqstat.pdb,cpqperf.pdb,cpqmib1k.pdb,cqhstutl.pdb
Debug-Dll_UNINSTALL=1

OLD_SOURCE=CqMgHost
OLD_FILES=cpqhost.dll,cpqups.dll,cpqups.cpl,cpqupd.hlp,snmp351.exe

420SPLIT_SOURCE=CPQMgmt
420SPLIT_FILES=cpqalert.dll,cpqbssa.txt,cpqclus.dll,cpqfca.dll,cpqhlth.dll,cpqide.dll,cpqmdisk.dll,cpqmgmt.dll,cpqmgmt.exe,cpqmhost.dll,cpqmib.dll,cpqmib1k.dll,cpqmida.dll,cpqmscsi.dll,cpqmsg.dll,cpqnics.dll,cpqsm2.dll,cpqsnmp.dll,cpqstat.dll,cpqswv.dll,cpqthrsh.dll,iawnteng.cnt,iawnteng.hlp,iawnteng.gid,nicmib.dll

OLD_CPQMGMT_SOURCE=CPQMgmt
OLD_CPQMGMT_FILES=readme.txt

GROUPS_SOURCE=Groups
GROUPS_FILES=Insight Management Agents Readme.lnk,Insight Server Agents Readme.lnk,Insight Server Agents Guide.lnk,Insight Agents for Windows NT Guide.lnk

//***************************************************************
//    Names of the services that are to be installed
//***************************************************************
//
//    Description = The Display name of the service
//
//    Path = The Image Path of the service
//
//    Dependencies = This is a field that will specify a case
//              that must exist for the service to be installed.
//
//    Start = The start parameter for the service
//
//    Type = The type value for the service
//
//    ObjectName = The Name of the object
//
//***************************************************************

[CQMGHOST]
Name=CqMgHost
Description=Compaq Foundation Agents
Path=%SystemRoot%\system32\cpqmgmt\CqMgHost\CQMGHOST.EXE
Dependency=SYSTEM\CurrentControlSet\Services\SNMP
Start=2
Type=16
DependOnGroup=
DependOnService=
ErrorControl=1
ObjectName=LocalSystem
RegKeys=Parameters,Linkage,APPTRAP,HOSTALRT,CPQMHOST,CPQTHRSH,CPQSWV,CPQCLUS,CPQSTAT,CPQPERF,CPQSNMP
EventMessageFile=%SystemRoot%\system32\CpqHsMSG.DLL
EventMessageEntry=Foundation Agents

[CQMGHOSTNoSNMP]
Name=CqMgHost
Description=Compaq Foundation Agents
Path=%SystemRoot%\system32\cpqmgmt\CqMgHost\CQMGHOST.EXE
Dependency=!SYSTEM\CurrentControlSet\Services\SNMP
Start=2
Type=16
DependOnGroup=
DependOnService=
ErrorControl=1
ObjectName=LocalSystem
RegKeys=Parameters,Linkage,APPTRAP,HOSTALRT,CPQMHOST,CPQTHRSH,CPQSWV,CPQCLUS,CPQSTAT,CPQPERF,CPQSNMP
EventMessageFile=%SystemRoot%\system32\CpqHsMSG.DLL
EventMessageEntry=Foundation Agents


//***************************************************************
//    Names of the sub-services that are to be installed
//***************************************************************
//
//  Name = The Name of the sub-service as it appears in the
//         registry beneath the calling service
//
//  Description = The value that is called DisplayName in the
//         registry
//
//  Keys = A three part value that is seperated by a "#" that adds
//         additional keys to the sub-service.  It goes in the following
//         order:
//              KeyName,Type, Value
//              KeyName = The Key that will be written into the registry
//
//              Type = The type of entry that will be created include:
//                     DWORD
//                     EXPAND_SZ
//                     MULTI_SZ
//                     REG_SZ
//
//              Value = The initial starting value
//
//  RegKeys = This will add additional "sub service" to the
//         sub-service, allowing you to add additional levels in
//         the registry.
//
//***************************************************************

[APPTRAP]
Name=apptrap
Keys=Debugger,REG_SZ,drwtsn32 -p %ld -e %ld -g

[HOSTALRT]
Name=HOSTALRT
Description=Host Remote Alerter
Enable=1

[CPQMHOST]
Name=CPQMHOST
Description=Host Information
Enable=1

[CPQTHRSH]
Name=CPQTHRSH
Description=Threshold Support
Enable=1

[CPQSWV]
Name=CPQSWV
Description=Software Version
Enable=1

[CPQCLUS]
Name=CPQCLUS
Description=Clustering Information
Enable=SYSTEM\CurrentControlSet\Services\ClusSvc

[CPQSTAT]
Name=CPQSTAT
Description=External Status Information
Enable=1

[CPQPERF]
Name=CPQPERF
Description=Operating System Information
Enable=1

[CPQSNMP]
Name=CPQSNMP
Description=Host SNMP Extension Agent
Keys=Pathname,EXPAND_SZ,%SystemRoot%\System32\CpqMgmt\CqMgHost\HOSTMIB.DLL # SetsEnabled,DWORD,1

[Parameters]
Name=Parameters
Keys=AsyncActive1,DWORD,0 # Destination,MULTI,NULL # Domain,RES_SZ,NULL # Password,BINARY,00 # PhoneBookEntry,REG_SZ,NULL # PhoneNumber,REG_SZ,NULL # Retry,DWORD,1 # Username,REG_SZ,NULL # ProcMon,BINARY,00
RegKeys=CPQMIB1K#

[Security]
Name=Security

[Enum]
Name=Enum
Keys=Count,DWORD,1 # NextInstance,DWORD,1 # 0,REG_SZ,Root\LEGACY_CQMGHOST\0000

[Linkage]
Name=Linkage
RegKeys=Disabled#

[Disabled]
Name=Disabled

[CPQMIB1K]
Name=CPQMIB1K
Keys=Pathname,EXPAND_SZ,%SystemRoot%\system32\cpqmgmt\cqmghost\CPQMIB1K.DLL


//***************************************************************
//    Names of the Registry Values that are to be installed
//***************************************************************
//
//    NAME - The label of how it will be refered by the service
//           This value gives the key that the registry will be
//           Installed into
//
//    NAME_Dependency - This key must exist for the value to be
//           Installed
//
//    NAME_Name - This is the value to be created
//
//    NAME_Type - This is the type of registy entry that will be
//           created.
//
//    NAME_Data - This is the data that will be entered
//
//***************************************************************


[Registry]
SNMP_Extension=SYSTEM\CurrentControlSet\Services\SNMP\Parameters\ExtensionAgents
SNMP_Extension_Dependency=SYSTEM\CurrentControlSet\Services\SNMP
SNMP_Extension_Name=CPQHOSTSNMP
SNMP_Extension_Type=REG_SZ
SNMP_Extension_Data=System\CurrentControlSet\Services\CqMgHost\CPQSNMP

SNMP_Extension2=SYSTEM\CurrentControlSet\Services\SNMP\Parameters\ExtensionAgents
SNMP_Extension2_Dependency=SYSTEM\CurrentControlSet\Services\SNMP
SNMP_Extension2_Name=CPQMIB1K
SNMP_Extension2_Type=REG_SZ
SNMP_Extension2_Data=System\CurrentControlSet\Services\CqMgHost\Parameters\CPQMIB1k

SNMP_Extension4=SYSTEM\CurrentControlSet\Services\SNMP\Parameters\ExtensionAgents
SNMP_Extension4_Dependency=SYSTEM\CurrentControlSet\Services\ClusSvc & SYSTEM\CurrentControlSet\Services\SNMP
SNMP_Extension4_Name=CPQCEAG
SNMP_Extension4_Type=REG_SZ
SNMP_Extension4_Data=SOFTWARE\Compaq\CompaqClusterNTExtensionAgent\CurrentVersion

Add_Remove=SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Compaq Management Agents
Add_Remove_Name=DisplayName
Add_Remove_Type=REG_SZ
Add_Remove_Data=Compaq Management Agents

Add_Remove2=SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Compaq Management Agents
Add_Remove2_Name=UninstallString
Add_Remove2_Type=REG_SZ
Add_Remove2_Data=%SystemRoot%\System32\cpqmgmt\install.exe /r

CatMsg=System\CurrentControlSet\Services\EventLog\System\Foundation Agents
CatMsg_Name=CategoryMessageFile
CatMsg_Data=%SystemRoot%\system32\cpqhsmsg.dll
CatMsg_Type=EXPAND_SZ

CatCount=System\CurrentControlSet\Services\EventLog\System\Foundation Agents
CatCount_Name=CategoryCount
CatCount_Data=16
CatCount_Type=DWORD

OLD_SNMP=SYSTEM\CurrentControlSet\Services\SNMP\Parameters\ExtensionAgents
OLD_SNMP_Name=CPQSNMP

OLDMGMT=SYSTEM\CurrentControlSet\Services\CPQMgmt

[DllCalls]
EVENTDLL_FILE=hostevnt.dll
EVENTDLL_FUNCTION=CPQ_seedRegistry

EVENTDLL2_FILE=hostevnt.dll
EVENTDLL2_FUNCTION=CPQ_seedSwVerTable

EVENTDLL3_FILE=hostevnt.dll
EVENTDLL3_FUNCTION=CPQ_seedStatusMibTable

[Execute]
OLD_CONTROL=WindowsSysDir\rundll32.exe shell32.dll,Control_RunDLL cpqmgmt.cpl,,/setup
OLD_CONTROL_DEPENDENCY=VER(1234-3400)

CONTROL=WindowsSysDir\control.exe cpqmgmt.cpl /setup
CONTROL_DEPENDENCY=!VER(1234-3400)
