#!/bin/bash
#
#  Program:      setup_apache.sh
#
#  Description:  This program does post installation configuration to allow
#    the configurator to run properly.
#
#    This setup script installs the APACHE package.
#
#  History:
#
#

echo "Starting Compaq Configurator setup script...APACHE Module"

# First we stop Apache
echo "  - Stopping Apache"
/etc/rc.d/init.d/httpd stop

# First we add the site_admins group
echo "  - Adding \"site_admins\" group..."
/usr/sbin/groupadd site_admins

# Make dummy SSL CRT file
if [ -a /etc/httpd.conf/ssl.crt/server.crt ]; then
    echo "  - Skipping the SSL certificate creation...(This must be an upgrade)"
else
    echo "  - Installing dummy SSL certificate..."
    touch /etc/httpd/conf/ssl.crt/server.crt
fi

# Make the Virtual Sites directory
if [ -a /home/VirtualSites ]; then
    echo "  - /home/VirtualSites already exists...(This must be an upgrade)"
else
    echo "  - Building Virtual Sites directory (/home/VirtualSites)..."
    mkdir /home/VirtualSites
    chown cpqcfg:cpqcfg /home/VirtualSites
fi

# Add the include line to the main httpd.conf file
echo "  - Including vhost.conf in main httpd.conf file..."
touch /etc/httpd/conf/vhosts.conf
EXISTS=`grep "Include /etc/httpd/conf/vhosts.conf" /etc/httpd/conf/httpd.conf`

if [ "$EXISTS" != "" ]; then
    echo "    * Virtual Hosts file already included"
else
    echo "    * Adding Virtual Hosts file inclusion directive"
    echo "Include /etc/httpd/conf/vhosts.conf" >> /etc/httpd/conf/httpd.conf
fi

# Install the datastore
if [ -a /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/apache.xml ]; then
    echo "  - Datastore already installed...(This must be an upgrade)"    
else
    echo "  - Installing new datastore..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/apache.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/apache.xml
    chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/apache.xml

    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/virtualsites.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/virtualsites.xml
    chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/virtualsites.xml

    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/profiles.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/profiles.xml
    chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/profiles.xml
fi

# Set SUID on custom components
echo "  - Setting SUID on select programs..."
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*


# Updating httpd.conf
EXISTS=`grep "<IfModule mod_speling.c>" /etc/httpd/conf/httpd.conf`

if [ "$EXISTS" != "" ]; then
    echo "  - Modular httpd.conf seems to already exist. Not replacing '/etc/httpd/conf/httpd.conf'...(This must be an upgrade)"
else
    echo "  - Replacing httpd.conf with modular config file..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/httpd.conf /etc/httpd/conf/httpd.conf
fi

# Front Page setup
echo "  - Upgrading front page config files...(If necessary)"
/bin/sh -c /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/upgradefp.pl 2> /dev/null &
if [ -a /etc/httpd/conf/fphttpd.conf ]; then
    echo "  - Front Page seems to already be installed...(This must be an upgrade)"
else
    echo "  - Building fphttpd.conf and mod_frontpage.so for Front Page requirements..."
    rm /etc/httpd/conf/fphttpd.conf
    touch /etc/httpd/conf/fphttpd.conf
    chown cpqcfg:cpqcfg /etc/httpd/conf/fphttpd.conf
    touch /usr/lib/apache/mod_frontpage.so
fi

if [ -a /usr/local/frontpage/version4.0/bin/fpsrvadm_suid.exe ]; then
    echo "  - Front Page Server Admin tool seems to already be installed...(This must be an upgrade)"
else
    echo "  - Installing Front Page Server Admin tool..."
    cp /usr/local/frontpage/version4.0/bin/fpsrvadm.exe /usr/local/frontpage/version4.0/bin/fpsrvadm_suid.exe
    chown root:cpqcfg /usr/local/frontpage/version4.0/bin/fpsrvadm_suid.exe
    chmod 550 /usr/local/frontpage/version4.0/bin/fpsrvadm_suid.exe
    chmod u+s /usr/local/frontpage/version4.0/bin/fpsrvadm_suid.exe
fi

# Startup the main web server
echo "  - Starting Apache..."
/etc/rc.d/init.d/httpd start

# END OF SCRIPT
echo "** Finished! **"
