#!/bin/bash
#
#  Program:      setup_base.sh
#
#  Description:  This program does post installation configuration to allow
#    the configurator to run properly.
#
#    This setup script installs the BASE package.
#
#  History:
#
#

echo "Starting Compaq Configurator setup script...BASE Module"

#echo "  - Stopping Compaq Configurator..."
#/etc/rc.d/init.d/cpqcfg stop

# First we add the cpqcfg user
echo "  - Adding \"cpqcfg\" user..."
/usr/sbin/adduser -u 300 -d /var/cpqcfg cpqcfg

# Setup temporary restore directory
if [ -a /var/tmp ]; then
    echo "  - Temporary restore directory already exists...(This must be an upgrade)"
else 
    echo "  - Building temporary restore directory"
    rm -rf /var/tmp
    mkdir /home/tmp
    chown root:root /home/tmp
    chmod ugo+rw /home/tmp
    ln -s /home/tmp /var/tmp
fi

# Install cpqcfg PAM config file
if [ -a /etc/cpqcfgusers ]; then
    echo "  - Skipping CPQCFG PAM module installation...(This must be an upgrade)"
else
    echo "  - Installing CPQCFG PAM module..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/cpqcfg.pam /etc/pam.d/cpqcfg
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/cpqcfgusers /etc/cpqcfgusers
    chown root:root /etc/pam.d/cpqcfg
    chmod go-rwx /etc/pam.d/cpqcfg
    chmod go+r /etc/pam.d/cpqcfg
fi

# Set default Administrator password
if [ -a /var/cpqcfg/cgi-bin/CompaqConfigurator/systemAdmin/.htpasswd ]; then
    echo "  - Skipping administrator password reset...(This must be an upgrade)"
else
    echo "  - Setting default administrator password...(administrator/administrator)"
    htpasswd -bc /var/cpqcfg/cgi-bin/CompaqConfigurator/systemAdmin/.htpasswd administrator administrator
fi

# Set general permissions on all files
echo "  - Settings permissions..."
chown -R cpqcfg:cpqcfg /var/cpqcfg/*
chmod -R 770 /var/cpqcfg/*

# Set SUID on custom components
echo "  - Setting SUID on select programs..."
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*

# Erase the datastore
if [ -a /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/network.xml ]; then
    echo "  - Datastore already installed...(This must be an upgrade)"    
else
    echo "  - Installing new datastore..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/network.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/template.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/history.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/general.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/defaults.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore

    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/*
    chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/*
    mkdir /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/backup

    echo "  - Creating datastore backup directory..."
    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/backup
    chmod o-rwx /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/backup
fi

# Run the initialization program
echo "  - Synching datastore with current configuration..."
/var/cpqcfg/cgi-bin/CompaqConfigurator/setup/initialize.cpq

# Clearing cpqcfg log files
echo "  - Clearing cpqcfg log files"
rm /var/cpqcfg/httpd/log/*

# Setup log rotation
echo "  - Setting up cpqcfg log rotation"
EXISTS=`grep "/var/cpqcfg/httpd/log/*" /etc/logrotate.conf`
if [ "$EXISTS" != "" ]; then
    echo "    * CPQCFG log rotate entry already included...(This must be an upgrade)"
else
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/logrotate.conf /etc/logrotate.conf
fi

# Setup log rotation for cpqcfg
echo "    * Adding CPQCFG log rotation config file (/etc/logrotate.d)..."
cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/cpqcfg.logrotate /etc/logrotate.d/cpqcfg

# Clean-up the directories
echo "  - Cleaning up installation directories"
#rm -rf /var/cpqcfg/cgi-bin/CompaqConfigurator/setup
rm /var/cpqcfg/cgi-bin/CompaqConfigurator/util/displayErrors.cpq 2> /dev/null
rm /var/cpqcfg/cgi-bin/CompaqConfigurator/util/displayMessages.cpq 2> /dev/null
rm /var/cpqcfg/cgi-bin/CompaqConfigurator/util/programInfo.cpq 2> /dev/null
rm /var/cpqcfg/cgi-bin/CompaqConfigurator/util/showCode.cpq 2> /dev/null

# Dump log files
echo "  - Dumping log files"
mkdir /var/cpqcfg/httpd/log
mkdir /var/cpqcfg/httpd/run
touch /var/cpqcfg/httpd/log/error_log
touch /var/cpqcfg/httpd/log/access_log
chown cpqcfg:cpqcfg /var/cpqcfg/httpd/log/*

# Startup the configurator
echo "  - Starting Compaq Configurator..."
/etc/rc.d/init.d/cpqcfg start

# END OF SCRIPT
echo "** Finished! **"
