#!/usr/bin/perl
#
#  Program:      upgradefp.pl
#
#  Copyright:    COPYRIGHT 2001 Compaq Computer Corporation. ALL rights reserved.
#
#  Description:  A program that upgrades the Front Page config files
#
#  History:
#
use strict;
use lib qw (
	    /var/cpqcfg/cgi-bin/CompaqConfigurator/system
	    );

use config;

use custom::custom;

my %system = config::system;

# Make Front Page happy
if (open(FPFILE, ">/etc/httpd/conf/fphttpd.conf")) {

    my $command = "/bin/cat $system{'httpd.conf'}";
    my $result = `$command`;
    
    print FPFILE "$result\n";
    
    $command = "/bin/cat /etc/httpd/conf/vhosts.conf";
    $result = `$command`;
    
    print FPFILE "$result\n";
    
    close(FPFILE);
    
    $command = "/bin/chmod o+r /etc/httpd/conf/fphttpd.conf";
    $result = `$command`;

}

my $filelist = `/bin/ls -a /usr/local/frontpage/*.cnf`;

my @files = split("\n", $filelist);

my @lines = ();

foreach my $file (@files) {

    my $sitename = $file;

    $sitename =~ s/\/usr\/local\/frontpage\///;
    my @values = split(":", $sitename);
    $sitename = $values[0];

  custom::updateVirtualSite($sitename);

    # Read in the existing config file
    if (open(FPFILE, "<$file")) {

	@lines = <FPFILE>;

	close(FPFILE);
    }

    if (open(FPFILE, ">$file")) {

	foreach my $line (@lines) {

	    if ($line =~ m/serverconfig:/) {
		$line = "serverconfig:/etc/httpd/conf/fphttpd.conf\n";
	    }
	    
	    print FPFILE "$line";
	    
	}
	
	close(FPFILE);
    }

}
    
