#!/usr/bin/perl
#
#  Program:      checkDatastore.cpq
#
#  Copyright:    COPYRIGHT 2001 Compaq Computer Corporation. ALL rights reserved.
#
#  Description:  This program updates an old version of the datastore to the latest version.
#
#
#  History:
#
#
use strict;
use lib qw (
	    /var/cpqcfg/cgi-bin/CompaqConfigurator/system
	    );

use XML::DOM;
use XML::QL;

use config;
use general;
use datastore;
use message;
use error;
use help;

print "* Upgrading datastore\n";

# Begin update
updateNetworkXML();
updateAlertsXML();

# Setting permissions
updatePermissions();

print "* Upgrade complete!\n";

# Exit
exit(0);

# A sub-routine to update the network.xml datastore file
sub updateNetworkXML {

    my %system = config::system;

    print "-------------\n * Upgrading '.../network.xml'\n";

    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/network.xml");

    # Change read-only SNMP community
    my $snmpNode = eval { $doc->getElementsByTagName("Network",0)->item(0)->getElementsByTagName("SNMP",0)->item(0)->getElementsByTagName("ROCommunity",0)->item(0); } || "";
    my $roCommString = eval { $snmpNode->getFirstChild->getData(); } || "";

    if ($roCommString eq "public") {
	print "   - SNMP read-only community string set to \"public\".  Changing to \"cpqPublic\"...\n";
      datastore::textNodeUpdate($snmpNode, "cpqPublic");
    }


    # Old datastores did not have these fields, so we double check for them
    foreach my $ifNode ($doc->getElementsByTagName("Interfaces")->item(0)->getElementsByTagName("Interface",0)) {

	my $if = eval { $ifNode->getAttribute("if"); } || "\"Unknown\"";
	my $refNode = $ifNode->getElementsByTagName("POP3")->item(0);

	# SNMP Check
	my $SNMPcheck = eval { $ifNode->getElementsByTagName("SNMP")->item(0); } || "";
	if ($SNMPcheck eq "") {

	    print " - SNMP tag on $if missing; adding it now.\n";
	    my $SNMPNode = $doc->createElement("SNMP");
	    $ifNode->insertBefore($SNMPNode, $refNode);
	  datastore::textNodeUpdate($ifNode->getElementsByTagName("SNMP")->item(0), "Yes");

	}

	# HTTP Check
	my $HTTPcheck = eval { $ifNode->getElementsByTagName("HTTP")->item(0); } || "";
	if ($HTTPcheck eq "") {

	    print " - HTTP tag on $if missing; adding it now.\n";
	    my $HTTPNode = $doc->createElement("HTTP");
	    $ifNode->insertBefore($HTTPNode, $refNode);
	  datastore::textNodeUpdate($ifNode->getElementsByTagName("HTTP")->item(0), "Yes");

	}

	# HTTPS Check
	my $HTTPScheck = eval { $ifNode->getElementsByTagName("HTTPS")->item(0); } || "";
	if ($HTTPScheck eq "") {

	    print " - HTTPS tag on $if missing; adding it now.\n";
	    my $HTTPSNode = $doc->createElement("HTTPS");
	    $ifNode->insertBefore($HTTPSNode, $refNode);
	  datastore::textNodeUpdate($ifNode->getElementsByTagName("HTTPS")->item(0), "Yes");

	}

	# WHO Check
	my $WHOcheck = eval { $ifNode->getElementsByTagName("WHO")->item(0); } || "";
	if ($WHOcheck eq "") {

	    print " - WHO tag on $if missing; adding it now.\n";
	    my $WHONode = $doc->createElement("WHO");
	    $ifNode->insertBefore($WHONode, $refNode);
	  datastore::textNodeUpdate($ifNode->getElementsByTagName("WHO")->item(0), "Yes");

	}

	# CIM Check
	my $CIMcheck = eval { $ifNode->getElementsByTagName("CIM")->item(0); } || "";
	if ($CIMcheck eq "") {

	    print " - CIM tag on $if missing; adding it now.\n";
	    my $CIMNode = $doc->createElement("CIM");
	    $ifNode->insertBefore($CIMNode, $refNode);
	  datastore::textNodeUpdate($ifNode->getElementsByTagName("CIM")->item(0), "Yes");

	}

	# ICMP Check
	my $ICMPcheck = eval { $ifNode->getElementsByTagName("ICMP")->item(0); } || "";
	if ($ICMPcheck eq "") {

	    print " - ICMP tag on $if missing; adding it now.\n";
	    my $ICMPNode = $doc->createElement("ICMP");
	    $ifNode->insertBefore($ICMPNode, $refNode);
	  datastore::textNodeUpdate($ifNode->getElementsByTagName("ICMP")->item(0), "Yes");

	}

	# IDENT Check
	my $IDENTcheck = eval { $ifNode->getElementsByTagName("IDENT")->item(0); } || "";
	if ($IDENTcheck eq "") {

	    print " - IDENT tag on $if missing; adding it now.\n";
	    my $IDENTNode = $doc->createElement("IDENT");
	    $ifNode->insertBefore($IDENTNode, $refNode);
	  datastore::textNodeUpdate($ifNode->getElementsByTagName("IDENT")->item(0), "Yes");

	}

    }
    
    # Write the XML to file
    $doc->printToFile("$system{'datastore'}/network.xml");

    print " * '.../network.xml' has been upgraded\n-------------\n";

}


# A sub-routine to update the alerts.xml datastore file
sub updateAlertsXML {

    my %system = config::system;

    print "-------------\n * Upgrading '.../alerts.xml'\n";

    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/alerts.xml");

    # Old datastores did not have this field, so we double check for it
    my $filesCheck = eval { $doc->getElementsByTagName("Alerts"); } || "";

    # Fix each alert that needs it
    foreach my $alertNode (eval { $doc->getElementsByTagName("Alert"); }) {

	my $alertType = eval { $alertNode->getAttribute("name"); } || "";

	print "   - Found alert type '$alertType'\n";

	# Disk space needs the threshold node added
	if ($alertType eq "diskspace") {

	    my $thresholdNode = eval { $alertNode->getElementsByTagName("Threshold")->item(0)->getFirstChild->getData(); } || "";

	    if (!$thresholdNode) {

		$thresholdNode = $doc->createElement("Threshold");

		# Set the threshold value
	      datastore::textNodeUpdate($thresholdNode, "/home,20%~/var,40%~/var/log,40%~/var/spool,40%~");

		my $refNode = $alertNode->getElementsByTagName("Email")->item(0);

		# Attach the new node to the main document
		$alertNode->insertBefore($thresholdNode, $refNode);

	    }
	    
	}
	# System utility change needs files section added
	elsif ($alertType eq "systemchange") {

	    my $sysChangeNode = eval { $alertNode->getElementsByTagName("Files")->item(0); } || "";

	    if (!$sysChangeNode) {

		$sysChangeNode = $doc->createElement("Files");

		# Populate the Files Section
		my @files = ("/bin/ls",
			     "/bin/mv",
			     "/bin/cp",
			     "/bin/login",
			     "/bin/netstat",
			     "/sbin/route",
			     "/usr/bin/passwd",
			     "/bin/rm",
			     "/bin/ps",
			     "/bin/cat",
			     "/usr/bin/less",
			     "/bin/more",
			     "/usr/sbin/sendmail",
			     "/usr/sbin/traceroute",
			     "/bin/ping",
			     "/usr/bin/telnet",
			     "/usr/bin/ftp");
		my @owners = ("root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root");
		my @groups = ("root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root",
			      "root");
		my @permissions = ("-rwxr-xr-x",
				   "-rwxr-xr-x",
				   "-rwxr-xr-x",
				   "-rwxr-xr-x",
				   "-rwxr-xr-x",
				   "-rwxr-xr-x",
				   "-r-s--x--x",
				   "-rwxr-xr-x",
				   "-r-xr-xr-x",
				   "-rwxr-xr-x",
				   "-rwxr-xr-x",
				   "-rwxr-xr-x",
				   "-r-sr-xr-x",
				   "-rwsr-xr-x",
				   "-rwsr-xr-x",
				   "-rwxr-xr-x",
				   "-rwxr-xr-x");
		my @sizes = ("43740",
			     "42076",
			     "33628",
			     "19464",
			     "78012",
			     "40284",
			     "13536",
			     "24636",
			     "65148",
			     "9588",
			     "83484",
			     "23900",
			     "401748",
			     "16992",
			     "20604",
			     "79420",
			     "64604");
		my @dates = ("Aug 25 2000",
			     "Aug 25 2000",
			     "Aug 25 2000",
			     "Aug 30 2000",
			     "Jul 12 2000",
			     "Jul 12 2000",
			     "Jul 12 2000",
			     "Aug 25 2000",
			     "Aug 17 2000",
			     "Aug 30 2000",
			     "Aug 23 2000",
			     "Aug 30 2000",
			     "Aug 22 2000",
			     "Jul 19 2000",
			     "Aug 8 2000",
			     "Jul 18 2000",
			     "Aug 16 2000");

		# Build a node for each file
		my $i=0;
		foreach my $file (@files) {

		    my $fileNode = $doc->createElement("File");
		    $fileNode->setAttribute("name", $files[$i]);

		    my $ownerNode = $doc->createElement("Owner");
		  datastore::textNodeUpdate($ownerNode, $owners[$i]);
		    $fileNode->appendChild($ownerNode);

		    my $groupNode = $doc->createElement("Group");
		  datastore::textNodeUpdate($groupNode, $groups[$i]);
		    $fileNode->appendChild($groupNode);

		    my $permissionsNode = $doc->createElement("Permissions");
		  datastore::textNodeUpdate($permissionsNode, $permissions[$i]);
		    $fileNode->appendChild($permissionsNode);

		    my $sizeNode = $doc->createElement("Size");
		  datastore::textNodeUpdate($sizeNode, $sizes[$i]);
		    $fileNode->appendChild($sizeNode);

		    my $dateNode = $doc->createElement("DateTime");
		  datastore::textNodeUpdate($dateNode, $dates[$i]);
		    $fileNode->appendChild($dateNode);


		    # Attach to main document
		    $sysChangeNode->appendChild($fileNode);

		    $i++;
		}

		# Attach the entire files section to the alert
		my $refNode = $alertNode->getElementsByTagName("Email")->item(0);
		$alertNode->insertBefore($sysChangeNode, $refNode);
	    }
	}
	# Datastore files change alert
	elsif ($alertType eq "configfile") {

	    my $configFileNode = eval { $alertNode->getElementsByTagName("Files")->item(0); } || "";

	    if (!$configFileNode) {

		$configFileNode = $doc->createElement("Files");
		my $refNode = $alertNode->getElementsByTagName("Email")->item(0);

		# Populate the Config Files Section
		my @files = ("/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/apache.xml",
			     "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/users.xml",
			     "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/groups.xml",
			     "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/network.xml",
			     "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/alerts.xml",
			     "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/defaults.xml",
			     "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/profiles.xml",
			     "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/reports.xml",
			     "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/template.xml",
			     "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/virtualsites.xml");
		my @owners = ("cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg");
		my @groups = ("cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg",
			      "cpqcfg");
		my @permissions = ("-rwxrwx---",
				   "-rwxrwx---",
				   "-rwxrwx---",
				   "-rwxrwx---",
				   "-rwxrwx---",
				   "-rwxrwx---",
				   "-rwxrwx---",
				   "-rwxrwx---",
				   "-rwxrwx---",
				   "-rwxrwx---");

		# Build a node for each file
		my $i=0;
		foreach my $file (@files) {

		    my $fileNode = $doc->createElement("File");
		    $fileNode->setAttribute("name", $files[$i]);

		    my $ownerNode = $doc->createElement("Owner");
		  datastore::textNodeUpdate($ownerNode, $owners[$i]);
		    $fileNode->appendChild($ownerNode);

		    my $groupNode = $doc->createElement("Group");
		  datastore::textNodeUpdate($groupNode, $groups[$i]);
		    $fileNode->appendChild($groupNode);

		    my $permissionsNode = $doc->createElement("Permissions");
		  datastore::textNodeUpdate($permissionsNode, $permissions[$i]);
		    $fileNode->appendChild($permissionsNode);

		    # Attach to main document
		    $configFileNode->appendChild($fileNode);

		    $i++;
		}

		# Attach the entire files section to the alert
		my $refNode = $alertNode->getElementsByTagName("Email")->item(0);
		$alertNode->insertBefore($configFileNode, $refNode);
	    }
	}
	
    }

    # Write the XML to file
    $doc->printToFile("$system{'datastore'}/alerts.xml");
	
    print " * '.../alerts.xml' has been upgraded\n-------------\n";

}

# A sub-routine to set the datastore permissions to be correct
sub updatePermissions {

    my %system = config::system;

    print " * Updating permissions on datastore\n";

    my $result = `$system{'root'}/system/bin/chmod 770 $system{'datastore'}/*.xml`;

    print " * Finished updating permissions on datastore\n-------------\n ";
    
}
