package config;
#
#  Package:      config.pm
#
#  Copyright:     COPYRIGHT Compaq Computer Corporation 2001.  All rights reserved.
#
#  Description:  A package that contains system-wide configuration
#   information.
#
#  History:
#
use strict;

sub system {

    my %system = "";

    # Product Information
    $system{'product_name'} = "Compaq TaskSmart W2220";
    $system{'version'} = "1.03";
    $system{'release'} = "";
    $system{'copyright'} = "COPYRIGHT 2001 Compaq Computer Corporation. All rights reserved.";

    # Path configuration
    $system{'root'} = "/var/cpqcfg/cgi-bin/CompaqConfigurator";
    $system{'cfgroot'} = "/CompaqConfigurator";
    $system{'docroot'} = "";
    $system{'resource'} = "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/resource";    

    # Apache config
    $system{'vhostroot'} = "/home/VirtualSites";    
    $system{'httpd.conf'} = "/etc/httpd/conf/httpd.conf";
    $system{'vhostsfile'} = "/etc/httpd/conf/vhosts.conf";

    # Linux config files
    $system{'sysconfig'} = "/etc/sysconfig";
    $system{'netscripts'} = "/etc/sysconfig/network-scripts";

    # Default system files
    $system{'datastore'} = "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore";
    $system{'menufile'} = "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/resource/menus.xml";
    $system{'wizardfile'} = "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/resource/wizards.xml";
    $system{'backups'} = "/home/backups";

    # Set the number of items to display on the screen at once
    $system{'displaylimit'} = 25;

    # Timeout values in seconds
    $system{'locktimeout'} = 60;
    $system{'ntptimeout'} = 7;

    # Alert parameters
    $system{'alert_sender'} = "TaskSmart";  # The email address that an alert appears to come from.
                                            # This is prepended to the fully qualified domain name of the box.
                                            # For example: "TaskSmart@web1.compaq.com" where "TaskSmart" is the
                                            # alert_sender.

    # Size of the chunks read in for the backup
    $system{'backupbuffersize'} = 1024;
    $system{'restorebuffersize'} = 1024;

    return (%system);
}


1;
