package datastore;
#
#  Package:      datastore.pm
#
#  Description:  A collection of sub-routines for manipulating the backend
#      datastore.
#
#  History:
#

use strict;

use CGI;
use XML::DOM;
use XML::QL;
use Net::IPv4Addr qw( :all);

use config;

# A sub-routine to change a Kilobyte figure to Bytes
sub KilobytesToBytes {

    my $value = shift || return;

    my $newvalue = $value * 1024;

    return $newvalue;
}

# This sub-routine updates an XML text node
sub textNodeUpdate {

    my $thisNode = shift || "";
    my $text = shift || "";

    my $editNode = eval { $thisNode->getFirstChild; } || "";

    if ($editNode eq "") {
	eval { $thisNode->addText("$text"); } || "";
    }
    else {
	eval { $editNode->setData("$text"); } || "";
    }
}

# This sub-routine updates an XML attribute node
sub attributeNodeUpdate {

    my $thisNode = shift || "";
    my $text = shift || "";

    my $editNode = eval { $thisNode->getFirstChild; } || "";

    if ($editNode eq "") {
	eval { $thisNode->addText("$text"); } || "";
    }
    else {
	eval { $editNode->setData("$text"); } || "";
    }
}

# A sub-routine that deletes a group from the groups.xml file
sub delGroup {

    my $doc = shift || return;
    my $shortname = shift || return;

    # Search for the group
    my $groups = $doc->getElementsByTagName("Group");
    my $numOfGroups = $groups->getLength;

    # Find and remove the correct group
    for (my $i=0; $i<$numOfGroups; $i++) {

	my $thisGroup = $groups->item($i)->getElementsByTagName("ShortName")->item(0)->getFirstChild->getData;

	# If we found it, remove it
	if ($thisGroup eq $shortname) {
#	    print STDERR "Deleting group $shortname\n";
	    $doc->getFirstChild->removeChild($groups->item($i));
	    last;
	}
    }

    return(1);
    
}

# A sub-routine that deletes a group from the groups.xml file.
# This routine uses the ID instead of the name as a key.
sub delGroupByID {

    my $doc = shift || return;
    my $gid = shift || return;

    # Search for the group
    my $groups = $doc->getElementsByTagName("Group");
    my $numOfGroups = $groups->getLength;

#    print STDERR "Trying to delete group by id ($gid)\n";

    # Find and remove the correct group
    for (my $i=0; $i<$numOfGroups; $i++) {

	my $thisGroup = $groups->item($i)->getAttribute("id");

	# If we found it, remove it
	if ($thisGroup eq $gid) {
#	    print STDERR "Deleting groupbyid $gid\n";
	    $doc->getFirstChild->removeChild($groups->item($i));
	    print STDERR "Deleted group by id $gid\n";
	    return(1);
	}
    }

    return(0);

}

# A sub-routine that adds a group to the groups.xml file
sub addGroup {

    my $doc = shift || return;
    my $groupID = shift || "";
    my $shortname = shift || return;
    my $name = shift || "";
    my $diskquota = shift || "0";
    my (@members) = @_;

#    print STDERR "Adding group $name - $shortname ($groupID) with members=$members[0] $members[1] $members[2]\n";

    my %system = config::system();
    
    eval {
	    
	# Set error handling
	local $SIG{ALRM} = sub { 
	    close(LOCK_FILE);
	    print "<H3><FONT color='red'>ERROR:  Add group timed out.</FONT></H3>";
	    warn("Add group timed out");
	    die("alarm\n");
	};
	
	# Set timeout
	alarm($system{'locktimeout'});
	
	# Set an exclusive lock
	open(LOCK_FILE, ">$system{'datastore'}/groups.lck");
	flock(LOCK_FILE, 2);
	
	my $newGroup = $doc->createElement("Group");
	$newGroup->setAttribute("id", $groupID);
	my $nameNode = $doc->createElement("Name");
	$nameNode->addText("$name");
	my $shortNameNode = $doc->createElement("ShortName");
	$shortNameNode->addText("$shortname");
	my $diskQuotaNode = $doc->createElement("DiskQuota");
	$diskQuotaNode->addText("$diskquota");
	
	$newGroup->appendChild($nameNode);
	$newGroup->appendChild($shortNameNode);
	$newGroup->appendChild($diskQuotaNode);
	
	foreach my $member (@members) {
	    my $memberNode = $doc->createElement("UserID");
	    $memberNode->addText("$member");
	    $newGroup->appendChild($memberNode);
	    print STDERR "  - $member\n";
	}
	
	$doc->getFirstChild->appendChild($newGroup);

	print STDERR "Finished!\n";
	
    };

    return(1);

}

# A sub-routine that deletes a user from the users.xml and groups.xml files
sub delUser {

    my $loginname = shift || return;

    my %system = config::system();

    my %user = datastore::userInfo($loginname);

    # Delete the user from the users file
    # Parse the user file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/users.xml");

    # Search for this user's login name
    my $users = $doc->getElementsByTagName("User");
    my $numOfUsers = $users->getLength;

    print STDERR "Deleting the user!\n";

    # Find the user
    for (my $i=0; $i<$numOfUsers; $i++) {
	my $thisLoginName = $users->item($i)->getElementsByTagName("LoginName")->item(0)->getFirstChild->getData;

	# If we found it, remove it
	if ($thisLoginName eq $loginname) {
	    $doc->getFirstChild->removeChild($doc->getElementsByTagName("User")->item($i));
	    last;
	}
    }

    $doc->printToFile("$system{'datastore'}/users.xml");

    $doc->dispose();

    print STDERR "User deleted!\n";
    
    # Delete any group membership
    # Parse the group file
    my $groupParser = new XML::DOM::Parser;
    my $groupDoc = $groupParser->parsefile("$system{'datastore'}/groups.xml");

    # Search for this user's login name
    my $members = $groupDoc->getElementsByTagName("UserID");
    my $numOfMembers = $members->getLength;

    print STDERR "Searching for group membership among $numOfMembers members\n";

    # Find and remove group inclusions for this user
    for (my $i=0; $i<$numOfMembers; $i++) {

	my $thisMember = $members->item($i)->getFirstChild->getData;

	# If we found it, remove it
	if ($thisMember eq $user{'uid'}) {

	    print STDERR "Deleting user $user{'uid'}\n";
	    my $parentNode = $members->item($i)->getParentNode;

	    eval { $parentNode->removeChild($members->item($i)); };
	    print STDERR "Finished removing user id from group\n";
	    last;
	}
    }

    print STDERR "Deleting users private group\n";
    delGroupByID($groupDoc, $user{'gid'});

    $groupDoc->printToFile("$system{'datastore'}/groups.xml");

    $groupDoc->dispose();

    print STDERR "Finished\n";

    return(1);

}

# A sub-routine that returns whether or not a user exists
sub userExist {

    my $loginname = shift || return(0);

    my %system = config::system();

    # Parse the user file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/users.xml");

    # Search for this user's login name
    my $users = $doc->getElementsByTagName("User");
    my $numOfUsers = $users->getLength;

    my %user = "";

    for (my $i=0; $i < $numOfUsers; $i++) {
	
	my $thisLoginName = eval { $users->item($i)->getElementsByTagName("LoginName")->item(0)->getFirstChild->getData; } || "";

	# We have a match
	if ($thisLoginName eq $loginname) {
	    return(1);
	}
    }

    $doc->dispose;

    return(0);
    
}

# This sub-routine grabs certain user information from the users.xml file
sub userInfo {

    my $loginname = shift || return("");

    my %system = config::system();

    # Parse the user file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/users.xml");

    # Search for this user's UID
    my $users = $doc->getElementsByTagName("User");
    my $numOfUsers = $users->getLength;

    my %user = "";

    for (my $i=0; $i < $numOfUsers; $i++) {
	
	my $thisLoginName = eval { $users->item($i)->getElementsByTagName("LoginName")->item(0)->getFirstChild->getData; } || "";

	# We have a match
	if ($thisLoginName eq $loginname) {

	    $user{'loginname'} = $thisLoginName;
	    $user{'uid'} = eval { $users->item($i)->getAttribute("uid"); } || "";
	    $user{'gid'} = eval { $users->item($i)->getAttribute("gid"); } || "";
	    $user{'lastname'} =  eval { $users->item($i)->getElementsByTagName("LastName")->item(0)->getFirstChild->getData; } || "";
	    $user{'firstname'} =  eval { $users->item($i)->getElementsByTagName("FirstName")->item(0)->getFirstChild->getData; } || "";
	    $user{'homedirectory'} =  eval { $users->item($i)->getElementsByTagName("HomeDirectory")->item(0)->getFirstChild->getData; } || "";
	    $user{'company'} =  eval { $users->item($i)->getElementsByTagName("CompanyName")->item(0)->getFirstChild->getData; } || "";
	    $user{'diskquota'} = eval { $users->item($i)->getElementsByTagName("DiskQuota")->item(0)->getFirstChild->getData; } || "";

	    $user{'allowtelnet'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("Telnet")->item(0)->getFirstChild->getData; } || "No";
	    $user{'allowftp'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("FTP")->item(0)->getFirstChild->getData; } || "No";
	    $user{'allowssh'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("SSH")->item(0)->getFirstChild->getData; } || "No";
	    $user{'allowpop3'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("POP3")->item(0)->getFirstChild->getData; } || "No";
	    $user{'allowimap'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("IMAP")->item(0)->getFirstChild->getData; } || "No";

	    last;
	}
    }

    $doc->dispose;

    return(%user);

}
# This sub-routine grabs matches a given virtualsite and site admin
# and determines if the siteadmin has authorization to use it
sub VSUserInfo {

    my $sitename = shift || return("");
    my $adminId = shift || return("");

    my %system = config::system();

    # Parse the virtualsites.xml

    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/virtualsites.xml");

    # Search for the correct virtualsite

    my $sites = $doc->getElementsByTagName("VirtualHost");
    my $numsites = $sites->getLength;

    my $result = "0";

    for (my $i=0;$i<$numsites;$i++) {
	
	my $servername= eval {$sites->item($i)->getElementsByTagName("ServerName")->item(0)->getFirstChild->getData();} || "";

	if ($servername eq $sitename) {
	    
	    my $serverAdmin = eval {$sites->item($i)->getElementsByTagName("ServerAdmin")->item(0)->getFirstChild->getData();} || "";

	    if ($serverAdmin eq $adminId) {
		$result = "1";
		last;
	    }
	}
    }

    $doc->dispose;

    return($result);
} 
				  








# This sub-routine grabs certain user information from the users.xml file
sub userInfoByID {

    my $uid = shift || return("");

    my %system = config::system();

    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/users.xml");

    # Search for this user's UID
    my $users = $doc->getElementsByTagName("User");
    my $numOfUsers = $users->getLength;

    my %user = "";

    for (my $i=0; $i < $numOfUsers; $i++) {
	
	my $thisUID = eval { $users->item($i)->getAttribute("uid"); } || "";

	# We have a match
	if ($thisUID eq $uid) {

	    $user{'loginname'} = eval { $users->item($i)->getElementsByTagName("LoginName")->item(0)->getFirstChild->getData; } || "";
	    $user{'uid'} = $uid;
	    $user{'gid'} = eval { $users->item($i)->getAttribute("gid"); } || "";
	    $user{'lastname'} =  eval { $users->item($i)->getElementsByTagName("LastName")->item(0)->getFirstChild->getData; } || "";
	    $user{'firstname'} =  eval { $users->item($i)->getElementsByTagName("FirstName")->item(0)->getFirstChild->getData; } || "";
	    $user{'homedirectory'} =  eval { $users->item($i)->getElementsByTagName("HomeDirectory")->item(0)->getFirstChild->getData; } || "";
	    $user{'company'} =  eval { $users->item($i)->getElementsByTagName("CompanyName")->item(0)->getFirstChild->getData; } || "";
	    $user{'diskquota'} = eval { $users->item($i)->getElementsByTagName("DiskQuota")->item(0)->getFirstChild->getData; } || "";

	    $user{'allowtelnet'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("Telnet")->item(0)->getFirstChild->getData; } || "No";
	    $user{'allowftp'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("FTP")->item(0)->getFirstChild->getData; } || "No";
	    $user{'allowssh'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("SSH")->item(0)->getFirstChild->getData; } || "No";
	    $user{'allowpop3'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("POP3")->item(0)->getFirstChild->getData; } || "No";
	    $user{'allowimap'} = eval { $users->item($i)->getElementsByTagName("Services")->item(0)->getElementsByTagName("IMAP")->item(0)->getFirstChild->getData; } || "No";

	    last;
	}
    }

    $doc->dispose;

    return(%user);

}

# This sub-routine returns an array of group ID's that the given user
# is a member of.
sub userGroups {

    my $userid = shift || "";

    my %system = config::system();

    # Parse the group file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/groups.xml");

    my $groups = $doc->getElementsByTagName("Group");
    my $numOfGroups = $groups->getLength();

    my @groups = ();

    # Run through each group determining if the user is a
    # member of this group or not
    for (my $i=0; $i < $numOfGroups; $i++) {

	my $thisGroup = $groups->item($i);
	my $gid = $thisGroup->getAttribute("id");

	my $members = $thisGroup->getElementsByTagName('UserID');
	my $numOfMembers = $members->getLength();

	# Run through each member looking for this user
	for (my $j=0; $j < $numOfMembers; $j++) {
	    
	    # See if this user is a member of this group
	    my $thisUser = eval { $members->item($j)->getFirstChild->getData; } || "";

	    if ($thisUser eq $userid) {
		push(@groups, $gid);
	    }
	}
    }
    
    $doc->dispose;

    return (@groups);
    
}
# this subroutine checks to see if the logged in SiteAdminuser is using the correct site
sub isSiteAdmin {

    my %system = config::system();
    my $userID = shift || "";
    
    print STDERR "UserID = $userID\n";
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/virtualsites.xml");

    my $sites = $doc->getElementsByTagName("VirtualHost");
    my $numOfSites = $sites->getLength();

    for (my $i=0; $i< $numOfSites; $i++) {
	my $thisSite = $sites->item($i);
	my $sip = $thisSite->getAttribute("ip");
	my $groupID = $thisSite->getElementsByTagName('Group')->item(0)->getFirstChild->getData();
	my $siteAdmin = $thisSite->getElementsByTagName('ServerAdmin')->item(0)->getFirstChild->getData();
	
	if ($siteAdmin eq $userID) {

	    return $groupID;
	}
    }
    return(0);
}
	
    

# This sub-routine checks to see if a user is in a particular group
sub isMember {

    my %system = config::system();

    my $member = shift || "";
    my $groupID = shift || "";

    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/groups.xml");
    
    
    # my $correctGroup = $doc->getElementsByTagName("Group");

    my $foundNode = "";
    foreach my $node ($doc->getElementsByTagName("Group")) {
	my $id = $node->getAttribute("id");

	if ($id == $groupID) {
	    $foundNode = $node;
	}
    }
    print STDERR "Found Node = $foundNode\n";
    if ($foundNode eq "") {
	return(0);
    }
    
    my $members = $foundNode->getElementsByTagName('UserID');
    my $numOfMembers = $members->getLength(); 
    
    # Run through each member looking for this user
    for (my $j=0; $j < $numOfMembers; $j++) {
	
	# See if this user is a member of this group
	my $thisUser = eval { $members->item($j)->getFirstChild->getData; } || "";
	print STDERR "This User = $thisUser\n";
	if ($thisUser eq $member) {
	    return(1);
	    
	}
    }
    
    
    $doc->dispose;
    
    return(0);
    
}


# This sub-routine grabs certain group information from the groups.xml file
sub groupInfo {

    my $id = shift || return("");

    my %system = config::system();

    # Parse the group file
    my $groupParser = new XML::DOM::Parser;
    my $groupDoc = $groupParser->parsefile("$system{'datastore'}/groups.xml");

    my %group = "";

    foreach my $groupNode ($groupDoc->getElementsByTagName("Group")) {

	my $groupID = $groupNode->getAttribute("id");

	if ($groupID eq $id) {
	    $group{'name'} = eval { $groupNode->getElementsByTagName("Name")->item(0)->getFirstChild->getData(); } || "";
	    $group{'shortname'} = eval { $groupNode->getElementsByTagName("ShortName")->item(0)->getFirstChild->getData(); } || "";
	    last;
	}
	
    }

    $groupDoc->dispose();


    return(%group);

}

# A sub-routine to build a select box of IP addresses
sub ipSelect {

    my %system = config::system();

    my $selected = shift || "";

    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/network.xml");

    my $interfaces = eval { $doc->getElementsByTagName("Interfaces")->item(0)->getElementsByTagName("Interface",0); } || "";
    my $numOfInterfaces = eval { $interfaces->getLength(); } || "0";

    my @information = ();

    for (my $i=0; $i < $numOfInterfaces; $i++) {
	my $name = eval { $interfaces->item($i)->getElementsByTagName("Name")->item(0)->getFirstChild->getData(); } || "";
	my $ip = eval { $interfaces->item($i)->getElementsByTagName("IP")->item(0)->getFirstChild->getData(); } || "";
	push (@information, "$name<TD>$ip");
    }

    my $ipSelect = "";

    foreach my $info (@information) {

	my ($name, $ip) = split(/<TD>/, $info);

	$ipSelect .= "<OPTION value='$ip'>$name - ($ip)</OPTION>";

    }

    if ($selected ne "") {
	$ipSelect =~ s/value='$selected'/value='$selected' selected/;
    }

    return($ipSelect);

}

# A sub-routine to build a select box of user login names
sub userSelect {

    my %system = config::system();

    my $selected = shift || "";

    # Parse the user file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/users.xml");

    my $users = eval { $doc->getElementsByTagName("User"); } || "";
    my $numOfUsers = eval { $users->getLength(); } || "0";

    my $result = "";

    my @names = ();

    for (my $i=0; $i<$numOfUsers; $i++) {

  	my $loginname = $users->item($i)->getElementsByTagName("LoginName")->item(0)->getFirstChild->getData();
  	my $uid = $users->item($i)->getAttribute("uid");

  	push (@names, "$loginname<TD>$uid");
    }

    # Sort the names
    @names = sort(@names);

    my $userSelect = "";
    foreach my $name (@names) {

	my ($loginname,$uid) = split(/<TD>/, $name);

	$userSelect .= "<OPTION value='$uid'>$loginname</OPTION>\n";

    }

    # Mark one of the options as selected
    $userSelect =~ s/value='$selected'/value='$selected' selected/;

    return($userSelect);

}

# A sub-routine to build a select box of user login names with
# the value set to login name instead of ID
sub userSelectLoginName {

    my %system = config::system();

    my $selected = shift || "";

    my $query = 'WHERE
         <User uid="$uid">
            <LoginName>$loginname</LoginName>
         </User>
        ORDER-BY $loginname
        IN "file:' . $system{'root'} . '/system/datastore/users.xml"
        CONSTRUCT $uid</TD><TD>$loginname</TR><TR>';

    # Make the query
    my $result = XML::QL->query($query);

    # Split out the values
    my @rows = split(/<\/TR><TR>/,$result);

    my $userSelect = "";
    foreach my $row (@rows) {

	my ($uid,$loginname) = split(/<\/TD><TD>/, $row);

	$userSelect .= "<OPTION value='$loginname'>$loginname</OPTION>\n";

    }

    # Mark one as selected
    $userSelect =~ s/value='$selected'/ value='$selected' selected/;

    return($userSelect);

}


# A sub-routine to build a select box of group names
sub groupSelect {

    my %system = config::system();

    my $selected = shift || "";

    # Parse the user file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/groups.xml");

    my $groups = eval { $doc->getElementsByTagName("Group"); } || "";
    my $numOfGroups = eval { $groups->getLength(); } || "0";

    my $result = "";

    for (my $i=0; $i<$numOfGroups; $i++) {

	my $name = $groups->item($i)->getElementsByTagName("Name")->item(0)->getFirstChild->getData();
	my $gid = $groups->item($i)->getAttribute("id");

	$result .= "$gid<TD>$name<TR>";
    }

    # Split out the values
    my @rows = split(/<TR>/,$result);

    my $groupSelect = "";
    foreach my $row (@rows) {

	my ($gid,$name) = split(/<TD>/, $row);

	$groupSelect .= "<OPTION value='$gid'>$name</OPTION>\n";

    }

    $groupSelect =~ s/value='$selected'/value='$selected' selected/;

    return($groupSelect);

}


# This sub-routine build a LoadModule directive, in the correct order
sub ApacheAddModule {

    my $doc = shift || return(0);
    my $moduleName = shift || return(0);

    # Search for the existance of the module
    my $foundNode = "";
    foreach my $module ( $doc->getElementsByTagName("LoadModule") ) {

	my $name = $module->getAttribute("name");

	if ($name eq $moduleName) {
	    $foundNode = $module;
	}

    }

    if ($foundNode eq "") {
	return(0);
    }

    # First we set the default entry node to be the first in the
    # entire list.
    my $refNode = eval { $doc->getElementsByTagName("LoadModule")->item(0); } || "";

    my $moduleDirective = "";
    # Set the directive for the module and double check to 
    # see if the order matters.
    if ($moduleName eq "mod_status.c") {
        $moduleDirective = "status_module          modules/mod_status.so";
    }
    elsif ($moduleName eq "mod_info.c") {
        $moduleDirective = "info_module            modules/mod_info.so";
	print STDERR "Setting info_module directive\n";
    }
    elsif ($moduleName eq "mod_autoindex.c") {
        $moduleDirective = "autoindex_module       modules/mod_autoindex.so";
    }
    elsif ($moduleName eq "mod_cgi.c") {
        $moduleDirective = "cgi_module             modules/mod_cgi.so";
    }
    elsif ($moduleName eq "mod_speling.c") {
        $moduleDirective = "speling_module         modules/mod_speling.so";
    }
    elsif ($moduleName eq "mod_userdir.c") {
        $moduleDirective = "userdir_module         modules/mod_userdir.so";
    }
    elsif ($moduleName eq "mod_perl.c") {         
        $moduleDirective = "perl_module            modules/libperl.so";
    }
    elsif ($moduleName eq "mod_php.c") {
	$moduleDirective = "php_module            modules/mod_php.so";
    }
    elsif ($moduleName eq "mod_php3.c") {
	$moduleDirective = "php3_module            modules/libphp3.so";
    }
    elsif ($moduleName eq "mod_php4.c") {
	$moduleDirective = "php4_module            modules/libphp4.so";
    }
    elsif ($moduleName eq "mod_ssl.c") {
        $moduleDirective = "ssl_module             modules/libssl.so";
    }
    elsif ($moduleName eq "mod_unique_id.c") {
        $moduleDirective = "unique_id_module       modules/mod_unique_id.so";
    }
    elsif ($moduleName eq "mod_include.c") {
        $moduleDirective = "includes_module       modules/mod_include.so";
    }
    elsif ($moduleName eq "mod_env.c") {
        $moduleDirective = "env_module         modules/mod_env.so";
    }
    elsif ($moduleName eq "mod_setenvif.c") {
        $moduleDirective = "setenvif_module    modules/mod_setenvif.so";
    }
    elsif ($moduleName eq "mod_userdir.c") {
        $moduleDirective = "userdir_module     modules/mod_userdir.so";
    }
    elsif ($moduleName eq "mod_userdir.c") {
        $moduleDirective = "speling_module     modules/mod_speling.so";
    }
    elsif ($moduleName eq "mod_autoindex.c") {
        $moduleDirective = "autoindex_module   modules/mod_autoindex.so";
    }
    elsif ($moduleName eq "mod_autoindex.c") {
        $moduleDirective = "status_module      modules/mod_status.so";
    }
    elsif ($moduleName eq "mod_info.c") {
        $moduleDirective = "info_module        modules/mod_info.so";
    }
    else {
	return(0);
    }

    # Update the node with the directive
    textNodeUpdate($foundNode, $moduleDirective);

    return(1);

}

# A sub-routine to remove a particular LoadModule directive
sub ApacheRemoveModule {

    my $doc = shift || return(0);
    my $moduleName = shift || return(0);

    # Search for the existance of the module
    foreach my $module ( $doc->getElementsByTagName("LoadModule") ) {

	my $name = $module->getAttribute("name");
	my $directive = eval { $module->getFirstChild->getData(); } || "";

	# If we find it, remove it
	if ($name eq $moduleName || $directive =~ m/$moduleName/) {
	    $directive =~ s/DONTLOAD - //g;
	    textNodeUpdate($module, "DONTLOAD - $directive");
	    return(1);
	}

    }

    return(0);

}

# A subroutine that rewrites a modified XML document to a file
# in a more visually appealing manner
sub XMLtoFile {

    my $doc = shift || return(0);
    my $filename = shift || return(0);

    my $string = $doc->toString();

    my @lines = split(/\n/, $string);

    my @newlines = ();

    # Format each line
    my $indentLevel = 0;
    foreach my $line (@lines) {

	$_ = $line;

	# Remove indentation level
	$line =~ s/^\s*</</;
	
	# Break tags that are on the same line
	$line =~ s/>\s*</>\n</g;
	$line =~ s/></>\n</g;

	# Calculate the number of stop tags
	my @tags = ();
	my $stopTags = 0;
	if ($line =~ m/<\// ) {
	    @tags = split(/<\//,$line) - 1;
	    $stopTags = scalar(@tags);
	}

	# Calculate the number of empty tags
	my $emptyTags = 0;
	if ($line =~ m/\/>/) {
	    @tags = split(/\/>/,$line);
	    $emptyTags = scalar(@tags) - 1;
	    if ($emptyTags <= 0) {
		$emptyTags = 1;
	    }
	}
	
	# Calculate the number of start tags
	my $totalTags = tr/<//;
	my $startTags = $totalTags - $stopTags - $emptyTags;

	# Calculate pre indentation changes
	if (($startTags - $stopTags) < 0) {
	    $indentLevel -= 2;
	}

	# Build the indentation, if necessary
	if ($startTags > 0 || 
            $emptyTags > 0 ||
            ($line =~ m/^</)) {

	    for (my $i=0; $i<$indentLevel; $i++) {
		$line = " " . $line;
	    }

	}

	# Calculate post indentation changes
	if (($startTags - $stopTags) >= 0) {
	    $indentLevel = $indentLevel + (($startTags - $stopTags)*2);
	}
	
	# Add the new line
	push (@newlines, $line);

    }

    # Write the file back out
    if (open (FILE, ">$filename")) {

	foreach my $line (@newlines) {
	    print FILE "$line\n";
	}
	
	close (FILE);

    }

}

# This subroutine looks for a specific Module in Apache XML,
#  then returns a value of 1 or 0
sub ApacheCheckModule {

    my $doc = shift || return(0);
    my $modulename = shift || return(0);

    # Search for the module
    foreach my $module ($doc->getElementsByTagName("LoadModule")) {

	my $name = $module->getAttribute("name");
	my $directive = eval { $module->getFirstChild->getData(); } || "";

        if ($directive =~ m/\/$modulename/ || $modulename eq $name) {

#	    print STDERR "        Checking module \"$name\" directive \"$directive\" against a value of \"$modulename\"\n";

	    if ($directive =~ m/DONTLOAD - /) {
#		print STDERR "            Returning zero\n";
		return(0);
	    }
	    else {
		return(1);
	    }
	}
	
    }

    return(1);

}









1;
