package error;
#
#  Package:      error.pm
#
#  Description:  A collection of sub-routines for handling errors.
#
#  History:
#

use strict;

use CGI;
use XML::DOM;
use XML::QL;

use config;

# A utilitarian routine to display all available messages
sub throwAllErrors {

    my %system = config::system;

    # Query the errors.xml file
    my $query = 'WHERE
         <Error code="$code" context="$context">
            <UserMessage>$usrmsg</UserMessage>
            <LogMessage>$logmsg</LogMessage>
         </Error>
        ORDER-BY $code
        IN "file:' . $system{'resource'} . '/errors.xml"
        CONSTRUCT <TR><TD>$code</TD><TD>$context</TD><TD>$usrmsg</TD><TD>$logmsg</TD></TR>';

    # Make the query
    my $errors = XML::QL->query($query);

    return($errors);
    
}

# This sub-routine:
#  1. returns the user message for a given
#  2. logs the error message to the log
sub throwError {

    my $errorCode = shift || return("");
    my $context = shift || "ANY";

    my %system = config::system;

    # Parse the network file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'resource'}/errors.xml"); 

    # Find the right error
    my $foundNode = "";
    foreach my $error ($doc->getElementsByTagName("Error")) {

	my $thisCode = $error->getAttribute("code");
	my $thisContext = $error->getAttribute("context");

	if ($thisCode eq $errorCode && $thisContext eq $context) {
	    $foundNode = $error;
	}
    }

    my $usrmsg = "";
    my $logmsg = "";

    if ($foundNode ne "") {

	$usrmsg = eval { $foundNode->getElementsByTagName("UserMessage")->item(0)->getFirstChild->getData(); } || "";
	$logmsg = eval { $foundNode->getElementsByTagName("LogMessage")->item(0)->getFirstChild->getData(); } || "";

	# Substitute place hodlers for real data
	my $placeHolder = 1;
	foreach my $value (@_) {
	    $usrmsg =~ s/\$$placeHolder/$value/g;
	    $logmsg =~ s/\$$placeHolder/$value/g;
	    ++$placeHolder;
	}
	
	# Write log message to error log
	if ($logmsg ne "") {
	    print STDERR "Error $errorCode: $logmsg\n";
	}
    }
    $usrmsg .= "<!--CPQCFGERR-->";
    return ($usrmsg);

}


1;
