package general;
#
#  Package:      general.pm
#
#  Description:  A collection of general purpose sub-routines
#
#  History:
#

use strict;

use CGI;
use XML::DOM;
use XML::QL;
use Time::localtime;

use config;

sub header {

    my $title = shift || "";

    my %system = config::system;

    print "Content-type: text/html\n\n";
    
    print "<HTML><HEAD>
             <META NAME=\"LAST_UPDATED\" CONTENT=\"Monday, February 12, 2001 - 9:41\">
             <HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\">
             <TITLE>$title</TITLE>
             <LINK title=new rel=stylesheet type=text/css href=$system{'docroot'}/configurator.css>
           </HEAD>
          ";

    return;
}

# A sub-routine to utilize advanced debugging
# error level denotes how much content is placed in the error log
# 0 being the smallest content to 5 being the most content
sub debug {
    
    my $debug = shift || "Standard Debug Statement";
    my $debuglevel = shift || "";
    
    if ($debuglevel eq ""){
	print STDERR "L0 $debug\n";
    }
    elsif ($debuglevel eq "1"){
	print STDERR "L1 $debug\n";
    }  
    elsif ($debuglevel eq "2"){
	print STDERR "L2 $debug\n";
    }  
    elsif ($debuglevel eq "3"){
	print STDERR "L3 $debug\n";
    }  
    elsif ($debuglevel eq "4"){
	print STDERR "L4 $debug\n";
    }  
    elsif ($debuglevel eq "5"){
	print STDERR "L5 $debug\n";
    }  
    
    return();
}

# A sub-routine to return the current up time of the system	
sub upTime {

    my $input =`/bin/cat /proc/uptime`;

    my @array = split(" ", $input);
    my $uptime = $array[0];

    my $days = "";
    my $hours = "";
    my $mins = "";
    my $secs = "";

    $days = int($uptime / (60*60*24));

    $hours = int( ($uptime - ($days*(60*60*24)) ) / (60*60) );

    $mins = int( ($uptime - ($days*(60*60*24)) - ($hours*(60*60)) ) / 60); 

    $secs = int( ($uptime - ($days*(60*60*24)) - ($hours*(60*60)) - ($mins*60)) );

    return ( "System Up Time:  $days days, $hours hours, $mins minutes, and $secs seconds");

    
}


# A sub-routine to redirect a browser to another URL
sub redirect {

    my $time = shift || "0";
    my $url = shift || "";
    my $title = shift || "";

    my %system = config::system;

    print "Content-type: text/html\n\n";

    print "<HTML><HEAD>
             <META http-equiv=\"refresh\" CONTENT=\"$time;URL=$url\">
             <TITLE>$title</TITLE>
             <LINK title=new rel=stylesheet type=text/css href=$system{'docroot'}/configurator.css>
           </HEAD>
           </HTML>
          ";
    return;
}

# A sub-routine to build the correct header for a framed web page
sub frameheader {

    my $title = shift || "";

    my %system = config::system;

    print "Content-type: text/html\n\n";
#    print CGI::header;

    print "<HTML>
<HEAD>
             <META http-equiv=\"refresh\">
             <TITLE>$title</TITLE>
             <LINK title=new rel=stylesheet type=text/css href=$system{'docroot'}/configurator.css>
           </HEAD>";

    return;
}

# A sub-routine to build a date selection box
sub dateSelect {

    my $prefix = shift || "";

    my $month = shift || "";
    my $day = shift || "";
    my $year = shift || "";

    # Month
    my $select = "<SELECT name='" . $prefix . "month'>\n";
    for (my $i=1; $i <=12; $i++) {
	if ($month eq $i) {
	    $select .= "<OPTION value=$i selected>$i</OPTION>\n";
	}
	else {
	    $select .= "<OPTION value=$i>$i</OPTION>\n";
	}
    }

    $select .= "</SELECT>";

    # Day
    $select .= "<SELECT name='" . $prefix . "day'>\n";
    for (my $i=1; $i <=31; $i++) {
	if ($day eq $i) {
	    $select .= "<OPTION value=$i selected>$i</OPTION>\n";
	}
	else {
	    $select .= "<OPTION value=$i>$i</OPTION>\n";
	}
    }

    $select .= "</SELECT>";

    # Year
    my $year = localtime->year() + 1900;
    $select .= "<SELECT name='" . $prefix . "year'>\n";
    for (my $i=$year-10; $i <=$year+10; $i++) {
	if ($year eq $i) {
	    $select .= "<OPTION value=$i selected>$i</OPTION>\n";
	}
	else {
	    $select .= "<OPTION value=$i>$i</OPTION>\n";
	}
    }

    $select .= "</SELECT>";

    return($select);

}

# A sub-routine to build a time selection box
sub timeSelect {

    my $prefix = shift || "";

    my $hour = shift || "";
    my $minute = shift || "";

    # Month
    my $select = "<SELECT name='" . $prefix . "hour'>\n";
    for (my $i=0; $i <=23; $i++) {
	if ($hour eq $i) {
	    $select .= "<OPTION value=$i selected>$i</OPTION>\n";
	}
	else {
	    $select .= "<OPTION value=$i>$i</OPTION>\n";
	}
    }

    $select .= "</SELECT>";

    # Day
    $select .= "<SELECT name='" . $prefix . "minute'>\n";
    for (my $i=0; $i <=59; $i++) {
	if ($minute eq $i) {
	    $select .= "<OPTION value=$i selected>$i</OPTION>\n";
	}
	else {
	    $select .= "<OPTION value=$i>$i</OPTION>\n";
	}
    }

    $select .= "</SELECT>";

    return($select);

}

# A sub-routine to build a select box of network interfaces
sub interfaceSelect {

    my %system = config::system;

    # Query for all of the network interfaces
    
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/network.xml");

    my $interface = $doc->getElementsByTagName("Interfaces")->item(0)->getElementsByTagName("Interface",0);
    my $numnics = $interface->getLength;

    my $result = "";

    for (my $i=0;$i<$numnics;$i++) {
	
	my $if = eval {$interface->item($i)->getAttribute("if");} || "";
	my $name = eval {$interface->item($i)->getElementsByTagName("Name")->item(0)->getFirstChild->getData();} || "";

	$result .= "<OPTION value='$if'>$if - $name</OPTION>";
    }
    
    return($result);

}

# A sub-routine to select languages
sub langSelect {

  my $selected = shift || "";

  my $select = "
     <OPTION value='en'>English</OPTION>
     <OPTION value='fr'>French</OPTION>
     <OPTION value='de'>German</OPTION>
       ";

  $select =~ s/value='$selected'/value='$selected' selected/;

  return($select);

}

# A subroutine to select time zones
sub timezoneSelect {

  my $selected = shift || "";
  my $select = ();

  my $output = `/usr/bin/find /usr/share/zoneinfo -type f -name \\* -print`;
  my @lines = split('\n', $output);
  my $numlines = scalar (@lines);

for (my $i=0; $i < $numlines; $i++) {

     if ($lines[$i] eq "/usr/share/zoneinfo/iso3166.tab" ) {
         next;
     
     } elsif ($lines[$i] eq "/usr/share/zoneinfo/zone.tab" ) {
         next;

     } else {

         my $tz = substr($lines[$i], 20);

         $select .="<OPTION value='$lines[$i]'>$tz</OPTION>";
     }

}

  
  # Mark one of the options as selected
  $select =~ s/value='$selected'/value='$selected' selected/;

  return($select);

}

# a subroutine to select a particular state
sub stateSelect   {

    my $selected = shift || "";

    my $select = "
              <option value=''></option>
              <option value='AL'>AL</option>
              <option value='AK'>AK</option>
              <option value='AZ'>AZ</option>
              <option value='AR'>AR</option>
              <option value='CA'>CA</option>
              <option value='CO'>CO</option>
              <option value='CT'>CT</option>
              <option value='DE'>DE</option>
              <option value='DC'>DC</option>
              <option value='FL'>FL</option>
              <option value='GA'>GA</option>
              <option value='GI'>HI</option>
              <option value='ID'>ID</option>
              <option value='IL'>IL</option>
              <option value='IN'>IN</option>
              <option value='IA'>IA</option>
              <option value='KS'>KS</option>
              <option value='KY'>KY</option>
              <option value='LA'>LA</option>
              <option value='ME'>ME</option>
              <option value='MD'>MD</option>
              <option value='MA'>MA</option>
              <option value='MI'>MI</option>
              <option value='MN'>MN</option>
              <option value='MS'>MS</option>
              <option value='MO'>MO</option>
              <option value='MT'>MT</option>
              <option value='NE'>NE</option>
              <option value='NV'>NV</option>
              <option value='NH'>NH</option>
              <option value='NJ'>NJ</option>
              <option value='NM'>NM</option>
              <option value='NY'>NY</option>
              <option value='NC'>NC</option>
              <option value='ND'>ND</option>
              <option value='OH'>OH</option>
              <option value='OK'>OK</option>
              <option value='OR'>OR</option>
              <option value='PA'>PA</option>
              <option value='RI'>RI</option>
              <option value='SC'>SC</option>
              <option value='SD'>SD</option>
              <option value='TN'>TN</option>
              <option value='TX'>TX</option>
              <option value='UT'>UT</option>
              <option value='VT'>VT</option>
              <option value='VA'>VA</option>
              <option value='WA'>WA</option>
              <option value='WV'>WV</option>
              <option value='WI'>WI</option>
              <option value='WY'>WY</option>";

    # Mark the selected state
    $select =~ s/value='$selected'/value='$selected' selected/;

    return($select);

}

# A sub-routine to return a space delimited string of IP interfaces
# Note:  This does not include the loop back device (127.?.?.?)
sub IPString {

    my %system = config::system;

    my $fqdn = FQDN();
    my $sender = "$system{'alert_sender'}\@$fqdn";
    
    # Grab the current IP address
    my $ippath = "/sbin/ifconfig | /bin/grep 'inet addr'";
    my $ipresult = `$ippath`;
    my @ipnewline = split("\n", $ipresult);
    my $ipstring = "";
    
    foreach my $ipline (@ipnewline) {
	
	my @ipcolon = split(":", $ipline);         
	my @spacecolon = split(" ", $ipcolon[1]);
	my $ipaddr = $spacecolon[0];
	
	# If this is not a loop back device, then add it
	if (!($spacecolon[0] =~ m/^127/)) {
	    $ipstring .= $spacecolon[0] . " ";
	}
    }
    
    return($ipstring);

}

# Return the fully qualified domain name for the system
sub FQDN {

    my $fqdn = `/bin/hostname -f`;
    $fqdn =~ s/\n//g;

    return($fqdn);

}

1;
