package help;
#
#  Package:      help.pm
#
#  Description:  A collection of sub-routines for displaying help messages.
#
#  History:
#

use strict;

use CGI;
use XML::DOM;
use XML::QL;

use config;

# A utilitarian routine to display all available help messages
sub throwAllHelp {

    my %system = config::system;

    # Query the messages.xml file
    my $query = 'WHERE
         <Message code="$code" context="$context">
            $msg
         </Message>
        ORDER-BY $code
        IN "file:' . $system{'resource'} . '/help.xml"
        CONSTRUCT <TR><TD>$code</TD><TD>$context</TD><TD>$msg</TD></TR>';

    # Make the query
    my $msgs = XML::QL->query($query);

    return($msgs);
    
}

# This sub-routine returns the help message for a given code
sub throwHelp {

    my $helpCode = shift || return("");
    my $context = shift || "ANY";

    my %system = config::system;

    # Parse the network file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'resource'}/help.xml"); 

    # Find the right help message
    my $foundNode = "";
    foreach my $message ($doc->getElementsByTagName("Help")) {

	my $thisCode = $message->getAttribute("code");
	my $thisContext = $message->getAttribute("context");

	if ($thisCode eq $helpCode && $thisContext eq $context) {
	    $foundNode = $message;
	}
    }

    my $msg = "";

    if ($foundNode ne "") {

	$msg = eval { $foundNode->getElementsByTagName("Message")->item(0)->getFirstChild->getData(); } || "";

	# Substitute place hodlers for real data
	my $placeHolder = 1;
	foreach my $value (@_) {
	    $msg =~ s/\$$placeHolder/$value/g;
	    ++$placeHolder;
	}
	
    }

    # Set a default value
    if ($msg eq "") {
	$msg = "/webhelp/notinstalled.html";
    }



    return ($msg);

}

# A sub-routine to build the help link
sub makeLink {

    my %system = config::system;

    my $code = shift || "";

    $code = CGI::escape($code);

    my $link = "<A target='help_window' class='sysAdminprog' href=$system{'cfgroot'}/util/help.cpq?code=$code>
        <IMG src=/help.gif ALT='Click here to view the help file for this page'>
       </A>";

    return($link);

}


1;
