package menu;
#
#  Package:      menu.pm
#
#  Copyright;    COPYRIGHT 2001 Compaq Computer Corporation. ALL rights reserved.
#
#  Description:  This package manages the display of all menus
#    within Compaq configurator.
#
#  History:
#

use strict;
use lib qw (
	/var/cpqcfg/cgi-bin/CompaqConfigurator/system
);

use CGI;
use XML::DOM;
use XML::QL;

use config;
use general;

# A sub-routine to display an entire menu
sub displayMenu {

    my %system = config::system;

    my $menuFile = shift || "$system{'menufile'}";
    my $menuName = shift || "";
    my $selectedItems = shift || "";

    my $menu = "";

    # Read in and parse menu file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile($menuFile);

    # Process Includes
    processIncludeFile($doc);

    # Find the correct menu
    foreach my $thisMenu ($doc->getFirstChild->getElementsByTagName("Menu",0)) {

	my $thisMenuName = eval { $thisMenu->getAttribute("name") } || "";

      general::debug("Looking at $thisMenuName");

	if ($thisMenuName eq $menuName) {
	    $menu = $thisMenu;
	}
    }

    # Check to make sure we found the menu
    if ($menu eq "") {
      general::debug("Could not find '$menuName' in file '$system{'menufile'}'");
	return();
    }

    my $mainTitle = eval { $menu->getElementsByTagName("MainTitle")->item(0)->getFirstChild->getData(); } || "";

    # Grab some visual stuff
    my $stylesheet = eval { $menu->getElementsByTagName("StyleSheet")->item(0)->getFirstChild->getData(); } || "";
    
    # Loop through all the menu items
    displayMenuItems($doc, $menu, $selectedItems, 0);

}


# A sub-routine to display all sub-menu items (if necessary)
sub displayMenuItems {

    my $root = shift || return;
    my $menu = shift || return;
    my $selectedItems = shift || "";
    my $level = shift || "0";

    my %system = config::system;

    # Grab some defaults first
    my $def_collapsedImage = eval { $root->getFirstChild->getElementsByTagName("CollapsedImage")->item(0)->getFirstChild->getData(); } || "";
    my $def_expandedImage = eval { $root->getFirstChild->getElementsByTagName("ExpandedImage")->item(0)->getFirstChild->getData(); } || "";

    my $tableStart = 0;

    # Display each item in the menu
    foreach my $item (eval { $menu->getElementsByTagName("Item",0) }) {

	# Grab menu item information
	my $id = eval { $item->getAttribute("id"); } || "";
	my $name = eval { $item->getElementsByTagName("Name")->item(0)->getFirstChild->getData(); } || "";
	my $class = eval { $item->getElementsByTagName("Class")->item(0)->getFirstChild->getData(); } || "";
	my $url = eval { $item->getElementsByTagName("URL")->item(0)->getFirstChild->getData(); } || "";
	$url =~ s/\$/\$main::/g;
	my $target = eval { $item->getElementsByTagName("Target")->item(0)->getFirstChild->getData(); } || "";

	# Variable substitution
	$url = '$url = "' . $url . '"';
	eval $url;

	# Grab the images to display next to menu items
	my $collapsedImage = eval { $item->getElementsByTagName("CollapsedImage",0)->item(0)->getFirstChild->getData(); } || $def_collapsedImage;
	my $expandedImage = eval { $item->getElementsByTagName("ExpandedImage",0)->item(0)->getFirstChild->getData(); } || $def_expandedImage;

	my $parentItem = $item->getParentNode(); 
	my $parentID = $parentItem->getAttribute("id");

	# Check to make sure we should display this item (Is it expanded?)
	if ($level == 0 || ($selectedItems =~ m/$parentID/ && $level > 0)) {

	    # Only print the table header once
	    if ($tableStart == 0) {

	        # Print the section header
		print "
<TABLE width=100%>
  <TR>
    <TD nowrap>\n";

		$tableStart = 1;

	    }

	    # Print spacers
	    for (my $i=0; $i < $level; $i++) {
		print "&nbsp;";
	    }

	    # Display the menu image
	    if ($expandedImage ne "NONE" && $selectedItems =~ m/\~$id\~/) {
		print "<IMG src='$expandedImage'> ";
	    }
	    elsif ($collapsedImage ne "NONE") {
		print "<IMG src='$collapsedImage'> ";
	    }

	    # Re-construct the correct selected items for this menu item
	    my $params = $selectedItems;
	    if ($params =~ m/\~$id\~/) {
		$params =~ s/\~$id\~/\~/;
	    }
	    else {
		$params = $selectedItems . "$id~";
	    }

	    # Clean-up any double tildes
	    $params =~ s/\~\~/\~/g;

	    # Check to see if we already have a parameter list started
	    if ($url =~ m/\?/) {
		$url .= "&selected=$params";
	    }
	    else {
		$url .= "?selected=$params";
	    }

	    # Display the menu item
	    print "<A class='$class' href='$url' target='$target'>$name</A><BR>\n";
	    
	    # Display all menu items underneath this one (if any)
	    my $subItems = eval { $item->getElementsByTagName("Item",0)->getLength; } || "0";

	    if ($subItems > 0) {

		displayMenuItems($root, $item, $selectedItems, ($level+3));
		
	    }
	}

    }

    # Print the section footer
    if ($tableStart) {
	print "
    </TD>
  </TR>
</TABLE>\n";

	return;
    }

}

# Sub-routine to recursively include files
sub processIncludeFile {

    my $doc = shift || return;

    # Handle the inclusion of any XML files
    foreach my $include ($doc->getElementsByTagName("IncludeFile")) {
	
	my $fileName = eval { $include->getFirstChild->getData(); } || "";
	
	# Skip this file if it is blank or does not exist
	if ($fileName eq "") {
	    next;
	}
	elsif (-r $fileName) {

	  general::debug("Including file $fileName");
	    
	    # Parse out the included file
	    my $inc_parser = new XML::DOM::Parser;
	    my $inc_doc = $inc_parser->parsefile($fileName);

	    processIncludeFile($inc_doc);
	    
	    $inc_doc->getFirstChild->setOwnerDocument($doc);
	    
	    # Append at the same level, then drop the include directive
	    $include->getParentNode->insertBefore($inc_doc->getFirstChild, $include);
	    $include->getParentNode->removeChild($include);
	    
	    $inc_doc->dispose();
	    
	}
    }
}



1;
