package message;
#
#  Package:      message.pm
#
#  Description:  A collection of sub-routines for handling user messages.
#
#  History:
#

use strict;

use CGI;
use XML::DOM;
use XML::QL;

use config;

# A utilitarian routine to display all available messages
sub throwAllMessages {

    my %system = config::system;

    # Query the messages.xml file
    my $query = 'WHERE
         <Message code="$code" context="$context">
            <UserMessage>$usrmsg</UserMessage>
         </Message>
        ORDER-BY $code
        IN "file:' . $system{'resource'} . '/messages.xml"
        CONSTRUCT <TR><TD>$code</TD><TD>$context</TD><TD>$usrmsg</TD></TR>';

    # Make the query
    my $msgs = XML::QL->query($query);

    return($msgs);
    
}

# This sub-routine returns the user message for a given message code
sub throwMessage {

    my $messageCode = shift || return("");
    my $context = shift || "ANY";

    my %system = config::system;

    # Parse the network file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'resource'}/messages.xml"); 

    # Find the right message
    my $foundNode = "";
    foreach my $message ($doc->getElementsByTagName("Message")) {

	my $thisCode = $message->getAttribute("code");
	my $thisContext = $message->getAttribute("context");

	if ($thisCode eq $messageCode && $thisContext eq $context) {
	    $foundNode = $message;
	}
    }

    my $usrmsg = "";
    my $logmsg = "";

    if ($foundNode ne "") {

	$usrmsg = eval { $foundNode->getElementsByTagName("UserMessage")->item(0)->getFirstChild->getData(); } || "";

	# Substitute place holders for real data
	my $placeHolder = scalar(@_);
	for (my $placeHolder=scalar(@_); $placeHolder>0; --$placeHolder) {

	    my $index = $placeHolder - 1;
	    $usrmsg =~ s/\$$placeHolder/$_[$index]/g;

	}
	
    }

    return ($usrmsg);

}


1;
