package wizard;
#
#  Package:      wizard.pm
#
#  Copyright;    COPYRIGHT 2001 Compaq Computer Corporation. ALL rights reserved.
#
#  Description:  This package supports wizard style interactions
#
#    Currently it will handle:
#
#     - Navigation through each step
#     - Retaining field values between steps (text, passwords, radio, checkbox, textarea, select)
#     - Visiblity of next/back buttons
#
#   Todo:
#
#     - Field validation & error checking
#     - Additional input types
#
#  History:
#

use strict;
use lib qw (
	/var/cpqcfg/cgi-bin/CompaqConfigurator/system
);

use CGI;
use XML::DOM;
use XML::QL;

use config;
use general;
use datastore;
use error;

# A sub-routine to display a particular step in the wizard
sub displayWizard {

    my %system = config::system;

    # Basic wizard information
    my $wizard_file = shift || "$system{'wizardfile'}";
    my $wizard_name = shift || "";
    
    # Current step information
    my $wizard_step = shift || "";
    my $wizard_prevstep = "";
    my $wizard_nextstep = "";

    # Read in and parse the wizard file
    my $parser = new XML::DOM::Parser;
    my $wizardDoc = $parser->parsefile("$wizard_file");

    # Handle the inclusion of any XML files
    processIncludeFile($wizardDoc);

    # Find the correct wizard
    my $wizard = "";
    my $numOfWizards = $wizardDoc->getFirstChild->getElementsByTagName("Wizard",0)->getLength();

 # general::debug("Number of wizards = $numOfWizards");
    
    foreach my $thisWizard ($wizardDoc->getFirstChild->getElementsByTagName("Wizard",0)) {

	my $thisWizardName = eval { $thisWizard->getAttribute("name"); } || "";
	
	# Default to the first wizard if no other was specified
	if ($wizard_name eq "") {
	    $wizard_name = $thisWizardName;
	}
	
     # general::debug("This wizard name = $thisWizardName  We're looking for $wizard_name");
	
	if ($thisWizardName eq $wizard_name) {
	    $wizard = $thisWizard;
	}
    }
    
    # Check to make sure we found the wizard
    if ($wizard eq "") {
     # general::debug("Could not find wizard '$wizard_name' in file '$wizard_file'");
	exit(0);
    }
    
    # Grab some global defaults
    my $wizard_action = eval { $wizard->getElementsByTagName("Action")->item(0)->getFirstChild->getData(); } || "";
    
    # Find the current step we're on
    my $step = "";
    my $steps = eval { $wizard->getElementsByTagName("Step",0); } || "";
    my $numOfSteps = $steps->getLength();
    
    for (my $i=0; $i < $numOfSteps; $i++) {
	
	my $thisStep = $steps->item($i);
	
	my $thisStepID = eval { $thisStep->getAttribute("id"); } || "";
	
	# Default to the first step if no other step was specified
	if ($wizard_step eq "") {
	    $wizard_step = $thisStepID;
	}
	
     # general::debug("Looking at $thisStepID");
	
	if ($thisStepID eq $wizard_step) {
	    
	 # general::debug("Found step node");
	    
	    # Set the current, next, and prev steps
	    $step = $thisStep;
	    if ($i < $numOfSteps) {
		$wizard_nextstep = eval { $steps->item(($i+1))->getAttribute("id"); } || "LAST";
	    }
	    
	    if ($i > 0) {
		$wizard_prevstep = eval { $steps->item(($i-1))->getAttribute("id"); } || "";
	    }
	    
	 # general::debug(" -- $i) Using step '$wizard_step'");
	 # general::debug(" -- $i) Next step is '$wizard_nextstep'");
	 # general::debug(" -- $i) Previous step is '$wizard_prevstep'");
	    
	    
	}
    }

    # Grab the information about this step
    my $wizard_form = eval { $step->getElementsByTagName("Form",0)->item(0)->getFirstChild->getData(); } || "";
    
    # Perform variable substitution
    $wizard_form =~ s/\$/\$main::/g;
    $wizard_form =~ s/\"/\\\"/g;
    $wizard_form =~ s/\@/\\\@/g;
    $wizard_form = '$wizard_form = "' . $wizard_form . '"';
    eval $wizard_form;

    # Check for errors in variable substitution
    if ($@ ne "") {
	$wizard_form = $@ . $wizard_form;
    }

    if (eval { $step->getElementsByTagName("Action",0)->item(0)->getFirstChild->getData(); }) {
	$wizard_action = eval { $step->getElementsByTagName("Action",0)->item(0)->getFirstChild->getData(); } || "";
    }
    
    # Get rid of the back button if there is no previous step
    if ($wizard_prevstep eq "" || $wizard_prevstep eq $wizard_step) {
	$wizard_form =~ s/<INPUT .*name='?wizard_back'?.*?>//i;
    }

    # Grab all current form variables and populate with existing values
    my @wizard_params = CGI::param();
    
    foreach my $wizard_field (@wizard_params) {

	# Skip all warning fields
	if ($wizard_field =~ m/warn_.*/i) {
	    next;
	}
	
	my $wizard_value = CGI::param($wizard_field);
	
	# Determine which type of field this is
	
#  general::debug("Found field name of '$wizard_field'");

	# Process a normal input type
	if ($wizard_form =~ m/(<INPUT [^>]*?name='?$wizard_field'?[^>]*?>)/i) {
	    
	    my $match = $1;
	    my $replacement = $match;
	    
#      general::debug("Found field '$wizard_field' in form '$1'");
	    
	    my $text = $1;
    
	    if ($1 =~ m/type=([^ ]*)/i) {
		
		my $type = uc $1;
		
#	  general::debug("Found wizard form input type = $type");
		
		if ($type eq "TEXT" || $type eq "PASSWORD") {
		    
		    # Replace the default value with the passed in value
		    $replacement =~ s/value='?[^\']*'?/value='$wizard_value'/i;
		    $wizard_form =~ s/$match/$replacement/i;
		    
#	      general::debug("Replacment for form field = $replacement");
		    
		}
		elsif ($type eq "RADIO") {

		    
		    # Clear all radio buttons with the same name and then check the correct one
		    $wizard_form =~ s/<INPUT (.*?name='?$wizard_field'? .*?)checked(.*?)>/<INPUT $1 $2>/ig;
		    
		    # Check the one that is currently selected
		    $wizard_form =~ s/<INPUT (.*?name='?$wizard_field'? .*?value='?$wizard_value'?.*?)>/<INPUT $1 checked>/i;
		    
		}
		elsif ($type eq "CHECKBOX") {
		    
#	      general::debug("Found a checkbox!");
		    
		    # Clear the checkbox
		    $wizard_form =~ s/<INPUT (.*?name='?$wizard_field'? .*?)checked(.*?)>/<INPUT $1 $2>/ig;
		    
		    # Check the one that is currently selected
		    if ($wizard_value =~ m/on/i) {
			$wizard_form =~ s/<INPUT (.*?name='?$wizard_field'?.*?)>/<INPUT $1 checked>/i;
		    }
		}
		
	    }
	    
	}
	# Process a textarea
	elsif ($wizard_form =~ m/(\<TEXTAREA .*?name='?$wizard_field'?.*?>)(.*?)(<\/TEXTAREA>)/si) {
	    
	    my $replace = $1 . $wizard_value . $3;
	    
	    $wizard_form =~ s/$1$2$3/$replace/;
	    
#      general::debug("Found a text area named $wizard_field! 1 = $1 2 = $2 3 = $3");
	    
	}
	# Process a select field
	elsif ($wizard_form =~ m/(<SELECT .*?name=$wizard_field.*?>.*?<\/SELECT>)/si) {
	    
#      general::debug("Select section $wizard_name found! $1");
	    
	    my $match = $1;
	    my $replace = $1;
	    
	    $replace =~ s/<OPTION (.*?)selected(.*?)>/<$1 $2>/i;
	    $replace =~ s/<OPTION (.*?)value='?$wizard_value'?/<OPTION $1value='$wizard_value' selected/i;
	    
	    $wizard_form =~ s/$match/$replace/;
	    
	}
	# This is a field from another step
	elsif (!($wizard_field =~ m/wizard_/i))  {
	    $wizard_form .= "<INPUT type=hidden name=$wizard_field value='$wizard_value'>\n";
	}
	
    }

    # Show the form
    my $display = "<FORM action='$wizard_action'>";
    
    $display .= $wizard_form;
    
    $display .= "

<INPUT type=hidden name=wizard_file value='$wizard_file'>
<INPUT type=hidden name=wizard_name value='$wizard_name'>
<INPUT type=hidden name=wizard_prevstep value='$wizard_prevstep'>
<INPUT type=hidden name=wizard_step value='$wizard_step'>
<INPUT type=hidden name=wizard_nextstep value='$wizard_nextstep'>

</FORM>
";

    return ($display);
}

# A sub-routine to display a warning that the user may override
sub displayWarning {

    my %system = config::system;

    # Basic wizard information
    my $wizard_file = shift || "$system{'wizardfile'}";
    my $wizard_name = shift || "";
    my $warning_id = shift || "";
    
    # Current step information
    my $wizard_step = shift || "";

    # Read in and parse the wizard file
    my $parser = new XML::DOM::Parser;
    my $wizardDoc = $parser->parsefile("$wizard_file");

    # Handle the inclusion of any XML files
    foreach my $include ($wizardDoc->getElementsByTagName("IncludeFile")) {
	
	my $fileName = eval { $include->getFirstChild->getData(); } || "";

	# Skip this file if it is blank or does not exist
	if ($fileName eq "") {
	    next;
	}
	# Make sure the file is readable
	elsif (-r $fileName) {
	    
	    # Parse out the included file
	    my $inc_parser = new XML::DOM::Parser;
	    my $inc_doc = $parser->parsefile($fileName);
	    
	    $inc_doc->getFirstChild->setOwnerDocument($wizardDoc);
	    
	    # Append at the same level, then drop the include directive
	    $include->getParentNode->insertBefore($inc_doc->getFirstChild, $include);
	    $include->getParentNode->removeChild($include);

	    $inc_doc->dispose();
	    
	}
	# Otherwise, send a debug error to the log
	else {
	 # general::debug("Could not include file \"$fileName\" in \"$wizard_file\"");
	}
    }


    # Find the correct wizard
    my $wizard = "";
    my $numOfWizards = $wizardDoc->getFirstChild->getElementsByTagName("Wizard",0)->getLength();

  # general::debug("Number of wizards = $numOfWizards");
    
    foreach my $thisWizard ($wizardDoc->getFirstChild->getElementsByTagName("Wizard",0)) {

	my $thisWizardName = eval { $thisWizard->getAttribute("name"); } || "";
	
	# Default to the first wizard if no other was specified
	if ($wizard_name eq "") {
	    $wizard_name = $thisWizardName;
	}
	
     # general::debug("This wizard name = $thisWizardName  We're looking for $wizard_name");
	
	if ($thisWizardName eq $wizard_name) {
	    $wizard = $thisWizard;
	}
    }
    
    # Check to make sure we found the wizard
    if ($wizard eq "") {
    #  general::debug("Could not find wizard '$wizard_name' in file '$wizard_file'");
	exit(0);
    }
    
    # Grab some global defaults
    my $wizard_action = eval { $wizard->getElementsByTagName("Action")->item(0)->getFirstChild->getData(); } || "";

    # Find the correct warning
    my $warning = "";
    my $warnings = eval { $wizard->getElementsByTagName("Warnings",0)->item(0)->getElementsByTagName("Warning",0); } || "";
    my $numOfWarnings = eval { $warnings->getLength(); } || "0";

    for (my $i=0; $i < $numOfWarnings; $i++) {

	my $thisWarning = $warnings->item($i);

	my $thisWarningID = eval { $thisWarning->getAttribute("id"); } || "";

	if ($thisWarningID eq $warning_id) {

	 # general::debug("Found the correct warning");

	    $warning = $thisWarning;
	}

    }

    # Return if we didn't find the warning at all
    if ($warning eq "") {
    #  general::debug("Could not find a wizard warning with id $warning_id");
	return();
    }

    my $warning_form = "<FORM action='$wizard_action'>";

    $warning_form .= eval { $warning->getElementsByTagName("Form")->item(0)->getFirstChild->getData(); } || "";

    # Perform variable substitution
    $warning_form =~ s/\$/\$main::/g;
    $warning_form =~ s/\"/\\\"/g;
    $warning_form =~ s/\@/\\\@/g;
    $warning_form = '$warning_form = "' . $warning_form . '"';
    eval $warning_form;

    # Check for errors in variable substitution
    if ($@ ne "") {
	$warning_form = $@ . $warning_form;
    }

    # Grab all current form variables and populate with existing values
    my @wizard_params = CGI::param();
    
    foreach my $wizard_field (@wizard_params) {

	my $wizard_value = CGI::param($wizard_field);

	$warning_form .= "<INPUT type=hidden name='$wizard_field' value='$wizard_value'>\n";

    }

    $warning_form .= "</FORM>";

    return ($warning_form);
}


# A sub-routine to validate the input fields on a form
sub validateStep {

    my $wizard_file = shift || return();
    my $wizard_name = shift || return();
    my $wizard_step = shift || return();

    my @args = @_;

    my $error = "";
    my %errors = "";

#  general::debug("Made it to validate step with $wizard_step");

    # Read in and parse the wizard file
    my $parser = new XML::DOM::Parser;
    my $wizardDoc = $parser->parsefile("$wizard_file");

    # Find the correct wizard
    my $wizard = "";
    my $numOfWizards = $wizardDoc->getFirstChild->getElementsByTagName("Wizard",0)->getLength();

    foreach my $thisWizard ($wizardDoc->getFirstChild->getElementsByTagName("Wizard",0)) {

	my $thisWizardName = eval { $thisWizard->getAttribute("name"); } || "";
	
	if ($thisWizardName eq $wizard_name) {
	    $wizard = $thisWizard;
	}
    }
    
    # Check to make sure we found the wizard
    if ($wizard eq "") {
     # general::debug("Could not find wizard '$wizard_name' in file '$wizard_file'");
	exit(0);
    }

    # Find the current step we're on
    my $step = "";
    my $steps = eval { $wizard->getElementsByTagName("Step",0); } || "";
    my $numOfSteps = $steps->getLength();
    
    for (my $i=0; $i < $numOfSteps; $i++) {
	
	my $thisStep = $steps->item($i);
	
	my $thisStepID = eval { $thisStep->getAttribute("id"); } || "";
	
	# Default to the first step if no other step was specified
	if ($wizard_step eq "") {
	    $wizard_step = $thisStepID;
	}
	
	if ($thisStepID eq $wizard_step) {
	    
	    # Set the current, next, and prev steps
	    $step = $thisStep;
	    
	}

    }

    # Check to make sure we found the step
    if ($step eq "") {
     # general::debug("Could not find the step '$wizard_step' in file '$wizard_file'");
	exit(0);
    }

    # Perform validation
    my $validation = eval { $step->getElementsByTagName("Validation",0)->item(0); } || "";

    # If we don't have any validation, simply return
    if ($validation eq "") {
     # general::debug("No validation instructions found for $wizard_step");
	return();
    }
    # Otherwise, process the fields
    else {

     # general::debug("About to check each field");

	# Check each field for valid data
	foreach my $field ($validation->getElementsByTagName("Field",0)) {

	    my $field_name = eval { $field->getAttribute("name"); } || "";
	    my $field_value = CGI::param($field_name) || "";
	    my $validation = eval { $field->getElementsByTagName("Valid",0)->item(0)->getFirstChild->getData(); } || "";
	    my $validation_context = eval { $field->getElementsByTagName("ErrorContext",0)->item(0)->getFirstChild->getData(); } || "";

	    # Skip this one if it isn't complete
	    if ($field_name eq "" || $validation eq "") {
		next;
	    }

	    # Fix-up context
	    if ($validation_context eq "") {
		$validation_context = "ANY";
	    }

	 # general::debug("  - Validating $field_name with value of $field_value and validation of $validation");

	    # Validate fields
	    my $validCall = '$error = datastore::' . $validation . '($field_value);';
	    eval $validCall;

	    if ($error ne "") {
		$errors{$field_name}{error} = $error;
		$errors{$field_name}{context} = $validation_context;
		$errors{$field_name}{value} = $field_value;
	    }


	}
    }

    return (%errors);
    
}

# Sub-routine to recursively include files
sub processIncludeFile {

    my $doc = shift || return;

    # Handle the inclusion of any XML files
    foreach my $include ($doc->getElementsByTagName("IncludeFile")) {
	
	my $fileName = eval { $include->getFirstChild->getData(); } || "";
	
	# Skip this file if it is blank or does not exist
	if ($fileName eq "") {
	    next;
	}
	elsif (-r $fileName) {

	 # general::debug("Including file $fileName");
	    
	    # Parse out the included file
	    my $inc_parser = new XML::DOM::Parser;
	    my $inc_doc = $inc_parser->parsefile($fileName);

	    processIncludeFile($inc_doc);
	    
	    $inc_doc->getFirstChild->setOwnerDocument($doc);
	    
	    # Append at the same level, then drop the include directive
	    $include->getParentNode->insertBefore($inc_doc->getFirstChild, $include);
	    $include->getParentNode->removeChild($include);
	    
	    $inc_doc->dispose();
	    
	}
    }
}


1;
