#!/bin/sh

# Compaq W2200 Update Script
# Copyright 2001 Compaq Computer Corporation
# Version 1.03
# Release 10
# 10-3-01

# Script is executed by the CompaqW2200-X.X-X.i386.rpm post section > starter.sh > update

# Create UpdateError.log file ONLY if an error occurs during the execution of this script
# File is required as a flag by the GUI 

version="1.03"
release="10"
cpqcfg="2.00-1"
eqbuild="NA"
updatetype="RPM Update"
err_flag="no"
datevar=(`date +%D`)

do_both()
{
    # Echo msg to standard log
    echo ${msg} >> /usr/compaq/log/LastUpdate.log
    # Echo msg to error log
    echo ${msg} >> /usr/compaq/log/UpdateError.log
    err_flag="yes"
}
do_error()
{
    # Echo msg to error log
    echo ${err_msg} >> /usr/compaq/log/UpdateError.log
    err_flag="yes"
}
do_log()
{
    # Echo msg to standard log
    echo ${msg} >> /usr/compaq/log/LastUpdate.log
}
do_preprocess()
{
    # Remove previous log symbolic link from previous update
    rm -rf /usr/compaq/log/LastUpdate.log

    # Remove any previous reference to an error log
    rm -rf /usr/compaq/log/UpdateError.log

    # Remove previous log file with same version / release
    rm -rf /usr/compaq/log/Update-${version}-${release}.log 

    # Create log file with version 
    touch /usr/compaq/log/Update-${version}-${release}.log 

    # Create symbolic link from LastUpdate.log to this versions log file for consistent GUI reference
    ln -s /usr/compaq/log/Update-${version}-${release}.log /usr/compaq/log/LastUpdate.log

    # Start Log File Here - Mark with version, date, and time
    echo "============================================================" >> /usr/compaq/log/LastUpdate.log
    echo "Compaq W2200 Update - Version " ${version}"-"${release} >> /usr/compaq/log/LastUpdate.log
    date >> /usr/compaq/log/LastUpdate.log
    echo "============================================================" >> /usr/compaq/log/LastUpdate.log

    # Log file list for /usr/compaq/update
    echo "* Files dumped to /usr/compaq/update" >> /usr/compaq/log/LastUpdate.log
    ls -l /usr/compaq/update >> /usr/compaq/log/LastUpdate.log

    # Display Start Message
    clear
    echo ""
    echo "Updating your Compaq W2200 ..........."
    echo ""
    echo "       Please Wait"
    echo ""

    # Wait 5 seconds for master rpm to close database
    sleep 5

    # Change to working directory
    if cd /usr/compaq/update ; then
        msg="Changed to /usr/compaq/update"
        do_log
    else
        msg="Cannot change directories to /usr/compaq/update"
        do_both
        msg="Cannot proceed with remaining updates"
        do_both
        exit 1
    fi
}

do_postprocess()
{
    # Remove dumped files
    rm -rf /usr/compaq/update/*
    msg="Removed update files"
    do_log

    # Display Finished Message
    clear
    echo ""
    echo "Update is complete"
    echo ""

    # Remove old version file if any
    if [ -f /_THIS_IS_VERSION* ] ; then
        rm -f /_THIS_IS_VERSION*
    fi

    # Check for errors, If errors display message and update log
    if [ "${err_flag}" = "yes" ] ; then
        echo "ERRORS WERE ENCOUNTERED DURING THE UPDATE PROCESS"
        echo ""
        echo "ERROR LOG FOLLOWS >> /usr/compaq/log/UpdateError.log"
        cat /usr/compaq/log/UpdateError.log
        echo ""
        echo "FOR MORE DETAIL REFER TO UPDATE LOG >> /usr/compaq/log/LastUpdate.log"
    fi

    # Write version file reference - complete
    touch /_THIS_IS_VERSION_${version}

    # Write update file reference - complete
    touch /_APPLIED_UPDATE_${version}-${release}

    echo ""
    echo "Press enter to continue"
}

do_historyupdate()
{
    # Update history.xml file with latest update record

    # Check for existence of history.xml file
        # Update with latest update information
        # Add xml record at end of file
        echo " <Upgrade>" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
        echo "  <Idate><![CDATA["${datevar}"]]></Idate>" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
        echo "  <Rdate><![CDATA[09/26/01]]></Rdate>" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
        if [ "${err_flag}" = "yes" ] ; then
            echo "  <Type><![CDATA[RPM Update - PARTIAL]]></Type>" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
        else
            echo "  <Type><![CDATA[RPM Update]]></Type>" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
        fi
        echo "  <Version><![CDATA["${version}"]]></Version>" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
        echo "  <Config><![CDATA["${cpqcfg}"]]></Config>" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
        echo " </Upgrade>" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml

        # Remove redundant </History> tag
        cat /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml | sed '/\/History/d' >/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml.new 2>>/usr/compaq/log/LastUpdate.log
        mv -f /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml.new /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
        echo "" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
        echo "</History>" >>/var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/history.xml
}


#****************************************************************************************************




do_102_upgrade_kernel_packages() #============================================================
{
    # UPGRADE KERNEL PACKAGES SECTION 

    # cd for good measure
    cd /usr/compaq/update

    # Upgrade UP kernel 
    echo "- Updating UP kernel"
    msg=">> Updating UP kernel"
    do_log
    if rpm --nodeps --force -Uvh ./kernel-2.2.19-7.0.8.i686.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="UP kernel package successful" 
        do_log
    else
        msg="Failed to install UP kernel package"
        do_both
    fi

    # Upgrade SMP kernel 
    echo "- Updating SMP kernel"
    msg=">> Updating SMP kernel"
    do_log
    if rpm --nodeps --force -Uvh ./kernel-smp-2.2.19-7.0.8.i686.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="SMP kernel package successful" 
        do_log
    else
        msg="Failed to install SMP kernel package"
        do_both
    fi

    # Upgrade kernel docs 
    echo "- Updating kernel docs"
    msg=">> Updating kernel docs"
    do_log
    if rpm --nodeps --force -Uvh ./kernel-doc-2.2.19-7.0.8.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="kernel docs package successful" 
        do_log
    else
        msg="Failed to install kernel docs package"
        do_both
    fi

    # Upgrade nfs-utils package 
    echo "- Updating nfs-utils package"
    msg=">> Updating nfs-utils package"
    do_log
    if rpm -Uvh ./nfs-utils-0.3.1-7.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="nfs-utils successful" 
        do_log
    else
        msg="Failed to update nfs-utils package"
        do_both
    fi

    # Upgrade mount package 
    echo "- Updating mount package"
    msg=">> Updating mount package"
    do_log
    if rpm -Uvh ./mount-2.10r-5.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="mount package successful" 
        do_log
    else
        msg="Failed to update mount package"
        do_both
    fi

    # Upgrade losetup package 
    echo "- Updating losetup package"
    msg=">> Updating losetup package"
    do_log
    if rpm -Uvh ./losetup-2.10r-5.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="losetup package successful" 
        do_log
    else
        msg="Failed to update losetup package"
        do_both
    fi

    # Upgrade kernel-ibcs package 
    echo "- Updating kernel-ibcs package"
    msg=">> Updating kernel-ibcs package"
    do_log
    if rpm -Uvh ./kernel-ibcs-2.2.19-7.0.8.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="kernel-ibcs package successful" 
        do_log
    else
        msg="Failed to update kernel-ibcs package"
        do_both
    fi

    # Upgrade kernel-utils package 
    #  First remove old conflicting pcmcia package
    echo "- Removing old kernel-pcmcia-cs package"
    msg=">> Removing old kernel-pcmcia-cs package"
    do_log
    if rpm -e kernel-pcmcia-cs 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="Removal of kernel-pcmcia-cs successful" 
        do_log
        echo "- Updating kernel-utils package"
        msg=">> Updating kernel-utils package"
        do_log
        if rpm -Uvh ./kernel-utils-2.2.19-7.0.8.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
             msg="kernel-utils package successful" 
             do_log
        else
             msg="Failed to update kernel-utils package"
             do_both
        fi
    else
        msg="Failed to remove kernel-pcmcia-cs package"
        do_both
    fi
    
    # Cleanup old kernel leftovers 
    echo "- Removing old kernel source package"
    msg=">> Removing old kernel source package"
    do_log
    if rpm -e kernel-source 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="Removal of kernel source successful" 
        do_log
    else
        msg="Failed to remove kernel source package"
        do_both
    fi
    
    echo "- Removing old kernel files "
    msg=">> Removing old kernel files "
    do_log
    if rm -rf /usr/src/linux-2.2.16 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="Removal of kernel source files successful" 
        do_log
    else
        msg="Failed to remove kernel source files"
        do_both
    fi
    if rm -rf /lib/modules/2.2.16-22 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="Removal of kernel module files successful" 
        do_log
    else
        msg="Failed to remove kernel module files"
        do_both
    fi
}





do_102_build_ram_disk_images() #========================================================================
{
    # Build RAM disk images 
    echo "- Building UP RAM disk image"
    msg=">> Building UP RAM disk image"
    do_log
    if /sbin/mkinitrd /boot/initrd-2.2.19-7.0.8.img 2.2.19-7.0.8 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="UP RAM disk image successful" 
        do_log
    else
        msg="Failed to create UP RAM disk image"
        do_both
    fi
    
    echo "- Building SMP RAM disk image"
    msg=">> Building SMP RAM disk image"
    do_log
    if /sbin/mkinitrd /boot/initrd-2.2.19-7.0.8smp.img 2.2.19-7.0.8smp 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="SMP RAM disk image successful" 
        do_log
    else
        msg="Failed to create SMP RAM disk image"
        do_both
    fi
}



do_102_configure_lilo()  #====================================================================================
{
    # Replace lilo.conf and run LILO 
    replace_lilo="NO"

    echo "- Backing up lilo.conf "
    msg=">> Backing up lilo.conf"
    do_log
    
    # Backup existing lilo.conf
    cp -f /etc/lilo.conf /etc/lilo.conf.orig 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
    msg="lilo.conf backed up" 
    do_log

    echo "- Replacing lilo.conf "
    msg=">> Replacing lilo.conf"
    do_log
    # Replace lilo.conf file

    if grep sda /etc/lilo.conf >>/dev/null; then
        msg="SCSI - Model 20 or 30 system found" 
        do_log
        if cp -f /usr/compaq/update/lilo.conf.scsi /etc/lilo.conf 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
            msg="lilo.conf replaced successfully" 
            do_log
            # Set permissions
            chown root:root /etc/lilo.conf 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
            chmod 644 /etc/lilo.conf 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
            replace_lilo="YES"
        else
            msg="lilo.conf replacement failed " 
            do_both
        fi
    else
        msg="IDE - Model 10 system found"
        do_log
        if cp -f /usr/compaq/update/lilo.conf.ide /etc/lilo.conf 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
            msg="lilo.conf replaced successfully" 
            do_log
            chown root:root /etc/lilo.conf 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
            chmod 644 /etc/lilo.conf 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
            replace_lilo="YES"
        else
            msg="lilo.conf replacement failed" 
            do_both
        fi
    fi

    if [ "${replace_lilo}" = "YES" ] ; then
        echo "- Running lilo"
        msg=">> Running lilo"
        do_log
        if /sbin/lilo 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
            msg="LILO run successfully" 
           do_log
       else
           msg="LILO run failed - restoring original lilo.conf"
           do_both
           cp -f /usr/compaq/update/lilo.conf.orig /etc/lilo.conf 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
       fi
    else
        echo "- lilo.conf not replaced successfully - continue to next stage"
    fi
}
    
    



do_102_replace_configpm()  # SHOULD NOT NEED IF NEW CONF. has latest rev in config.pm
{
    # Replace config.pm for proper version reference ==========================================
    
    echo "- Replacing config.pm"
    msg=">> Replacing config.pm"
    do_log
    
    if cp -f /usr/compaq/update/config.pm /var/cpqcfg/cgi-bin/CompaqConfigurator/system 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
         msg="config.pm replaced successfully" 
         do_log
         chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/config.pm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
         chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/config.pm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
    else
         msg="config.pm replacement failed" 
         do_both
    fi
}




do_102_system_restart() #==================================================================
{
    # Restart the System 
    echo "- Restarting the System"
    msg=">> Restarting the System"
    do_log
    /sbin/shutdown -r now 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
}



do_103_update_cim_agents() #===============================================================
{

    # Update current CIM agents 
    echo "- Updating CIM Agent packages"
    msg=">> Updating CIM Agent packages"
    do_log
    
    # Stop Current CIM Agents
    # Stop NIC Agent
    echo "- Stopping NIC Agent"
    if /etc/rc.d/init.d/cmanic stop 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="NIC Agent stopped" 
        do_log
    else
        msg="NIC Agent NOT stopped - failed"
        do_both
    fi
    # Stop Server Agent
    echo "- Stopping Server Agent"
    if /etc/rc.d/init.d/cmasvr stop 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="Server Agent stopped" 
        do_log
    else
        msg="Server Agent NOT stopped - failed"
        do_both
    fi
    # Stop Foundation Agent
    echo "- Stopping Foundation Agent"
    if /etc/rc.d/init.d/cmafdtn stop 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="Foundation Agent stopped" 
        do_log
    else
        msg="Foundation Agent NOT stopped - failed"
        do_both
    fi
    # Stop Storage Agent
    echo "- Stopping Storage Agent"
    if /etc/rc.d/init.d/cmastor stop 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="Storage Agent stopped" 
        do_log
    else
        msg="Storage Agent NOT stopped - failed"
        do_both
    fi
    # Stop Health Driver 
    echo "- Stopping Health Driver"
    if /etc/rc.d/init.d/cpqhealth stop 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="Health Driver stopped" 
        do_log
    else
        msg="Health Driver NOT stopped - failed"
        do_both
    fi

    # Remove all agents
    echo "- Remove Agents"
    msg="Removing Agents" 
    do_log
    rpm -e cmanic
    rpm -e cmastor
    rpm -e cmasvr
    rpm -e cmafdtn
    
    
    # Upgrade / Install CIM Agents
    echo "- Upgrading CIM Agents"
    if rpm -Uvh ./cpqhealth-2.2.0-11.redhat7_0.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="Health agent package update successful" 
        do_log
    else
        msg="Failed to update health agent packages"
        do_both
    fi

    if rpm -Uvh ./cma* 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="CMA* agent package updates successful" 
        do_log
    else
        msg="Failed to update 1 or more CIM Agent packages"
        do_both
    fi
    
    # Detect previous RIB agent then upgrade if appropriate
    if rpm -q cpqrid ; then
        # Must be scsi w/ RIB agent
        echo "- Upgrading RIB agent"
        if rpm -Uvh ./cpqrid-2.2.0-7.redhat7_0.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
    	# Installed good
            msg="RIB agent package update successful" 
            do_log
        else
            msg="Failed to update RIB Agent package"
            do_both
        fi
    else
        # No previous RIB board
        msg="No previous RIB agent package found - NON RIB Unit" 
        do_log
    fi
    
    # Change Health Driver Timing
    echo "- Updating Health Driver Timing"
    if cat /opt/compaq/server/etc/cmahealthd | sed -e 's/-p 30/-p 5/' >/opt/compaq/server/etc/cmahealthd.new 2>>/usr/compaq/log/LastUpdate.log; then
        mv -f /opt/compaq/server/etc/cmahealthd.new /opt/compaq/server/etc/cmahealthd
        # Insure correct permissions
        chown root: /opt/compaq/server/etc/cmahealthd
        chmod 775 /opt/compaq/server/etc/cmahealthd
        msg="cmahealthd update successful" 
        do_log
    else
        msg="Failed to Update cmahealthd"
        do_both
    fi
    
    # Install ciminfo.cfg file 
    # Revised version number.. overwrite current file

    echo "- Updating ciminfo.cfg file"
    msg=">> Updating ciminfo.cfg file"
    do_log
    if cp -rf ./ciminfo.cfg /etc 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
        msg="ciminfo.cfg update successful" 
        do_log
    else
        msg="Failed to update ciminfo.cfg file "
        do_both
    fi

    # Start CIM Agents
    # Starting Health Agent 
    echo "- Starting Health Agent"
    if /etc/rc.d/init.d/cpqhealth start 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="Health Agent started" 
        do_log
    else
        msg="Health Agent NOT started - failed"
        do_both
    fi
    # Starting Foundation Agents 
    echo "- Starting Foundation Agents"
    if /etc/rc.d/init.d/cmafdtn start 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="Foundation Agents started" 
        do_log
    else
        msg="Foundation Agents NOT started - failed"
    fi
    # Starting Server Agents 
    echo "- Starting Server Agents"
    if /etc/rc.d/init.d/cmasvr start 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="Server Agents started" 
        do_log
    else
        msg="Server Agents NOT started - failed"
        do_both
    fi
    # Starting NIC Agents 
    echo "- Starting NIC Agents"
    if /etc/rc.d/init.d/cmanic start 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="NIC Agents started" 
        do_log
    else
        msg="NIC Agents NOT started - failed"
        do_both
    fi
    # Starting Storage Agents 
    echo "- Starting Storage Agents"
    if /etc/rc.d/init.d/cmastor start 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg="Storage Agents started" 
        do_log
    else
        msg="Storage Agents NOT started - failed"
        do_both
    fi
    echo "- Starting RIB Agents"
    if rpm -q cpqrid ; then
        # RIB agent is installed
        if /etc/rc.d/init.d/cpqrid start 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
            msg="RIB Agents started" 
            do_log
        else
            msg="RIB Agents NOT started - failed"
            do_both
        fi
    else
        # No previous RIB board
        msg="No attempt to start RIB agent / No previous RIB agent package found - NON RIB Unit" 
        do_log
    fi
}


do_103_update_release_notes() #===========================================================
{
     # Update Release notes and Resolved issues list 
     echo "- Updating Release Notes and Resolved issues list"
     msg=">> Updating Release Notes and Resolved issues list"
     do_log
     # Copy release.html
     if cp -f /usr/compaq/update/release.html /var/cpqcfg/html 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
         # Release file copied successfully
         msg="release.html updated successfully" 
         do_log
         # Insure correct permissions
         chown cpqcfg:cpqcfg /var/cpqcfg/html/release.html 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
         chmod -v 770 /var/cpqcfg/html/release.html 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
     else
         # File was not copied properly
         msg="release.html update failed" 
         do_both
     fi
     # Remove old resolved.html
     if rm -f /var/cpqcfg/html/resolved.html 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
         # Resolved file copied successfully
         msg="resolved.html removed successfully" 
         do_log
     else
         # File was not removed properly
         msg="resolved.html removal failed" 
         do_both
     fi
}

do_103_install_uidutil() #===============================================================
{
     # Install UIDUTIL for UID light functionality from GUI
     if cp -f /usr/compaq/update/uidutil /usr/compaq/bin 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
         # uidutil installed successfully
         msg="uidutil installed successfully" 
         do_log
         # Insure correct permissions
         chown cpqcfg:cpqcfg /usr/compaq/bin/uidutil 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
         chmod -v 550 /usr/compaq/bin/uidutil 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
     else
         # File was not installed properly
         msg="uidutil install failed" 
         do_both
     fi
}

do_103_update_help_system() #============================================================
{
     # Update help system files
     echo "- Updating Help system files"
     msg=">> Updating Help system files"
     do_log
     # Remove current web help files
     rm -rf /var/cpqcfg/html/webhelp 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
     # Removal of old help files successful
     msg="Attempted removal of old help files "
     do_log
     # Copy current help.xml file
     if cp -f /usr/compaq/update/help.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/resource 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
         # help file copied successfully
         msg="help.xml copied successfully" 
         do_log
         # Insure correct permissions
         chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/resource/help.xml 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
         chmod -v 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/resource/help.xml 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
     else
         # File was not copied properly
         msg="help.xml copy failed" 
         do_both
     fi

     # Un-tar new help files
     cd /var/cpqcfg/html
     if tar -xvf /usr/compaq/update/webhelp.tar 2>>/usr/compaq/log/LastUpdate.log; then
          # Untar of new help files successful  
          msg="Untar of new help files successful" 
          do_log
          # Set proper ownership to webhelp files
          chown -R cpqcfg:cpqcfg /var/cpqcfg/html/webhelp 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
     else
          msg="Untar of new help files - Failed"
          do_both
     fi
}

do_103_remove_esmtp_port() #==============================================================
{
if cat /etc/sendmail.cf | sed '/Port=587/d' >/etc/sendmail.cf.new 2>>/usr/compaq/log/LastUpdate.log; then
    mv -f /etc/sendmail.cf.new /etc/sendmail.cf
    msg="sendmail.cf update successful" 
    do_log

    # Restart sendmail
    if /etc/rc.d/init.d/sendmail restart 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
        msg=" sendmail restarted" 
        do_log
    else
        msg="sendmail NOT restarted - failed"
        do_both
    fi

else
    msg="esmtp port reference doesnt exist"
    do_log
    # Replace file with original
    mv -f /etc/sendmail.cf.orig /etc/sendmail.cf
fi
}

do_103_update_cpqcfg() #==================================================================
{
     # Install CompaqConfigurator 1.0-20 ========================================
     cc_errflag="no"
     echo "- Updating CompaqConfigurator"
     msg=">> Updating CompaqConfigurator"
     do_log
     
     # Backup datastore
     # Create backup dir
     mkdir /usr/compaq/backup
     if cp -f /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/*.xml /usr/compaq/backup 2>>/usr/compaq/log/LastUpdate.log; then
         msg="Datastore backed up"
         do_log
         # Remove template.xml
         rm -f /usr/compaq/backup/template.xml
         msg="Omitting template.xml from restore"
         do_log
     else
         msg="Datastore back up - Failed"
         do_both
         cc_errflag="yes"
     fi
     
     # Remove old configurator and install new modules
     if [ "${cc_errflag}" = "yes" ] ; then
         echo "ERRORS WERE ENCOUNTERED DURING THE DATASTORE BACKUP"
         msg="ERRORS WERE ENCOUNTERED DURING THE DATASTORE BACKUP"
         do_both
         echo "CompaqConfigurator UPDATE ABORTED"
         msg="CompaqConfigurator UPDATE ABORTED"
         do_both
         msg="Failed to install CompaqConfigurator package"
         do_both
     else
         # Remove prior version of CompaqConfigurator
         if rpm --erase --nodeps CompaqConfigurator 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
             # Remove leftover files
             rm -rf /var/cpqcfg
             msg="CompaqConfigurator package removal successful" 
             do_log
         else
              cc_errflag="yes"
              msg="Failed to remove CompaqConfigurator package"
              do_both
         fi
     
         if [ "${cc_errflag}" = "yes" ] ; then
              echo "ERRORS WERE ENCOUNTERED DURING SOFTWARE REMOVAL"
              msg="ERRORS WERE ENCOUNTERED DURING SOFTWARE REMOVAL"
              do_both
              echo "CompaqConfigurator UPDATE ABORTED"
              msg="CompaqConfigurator UPDATE ABORTED"
              do_both
              msg="Failed to install CompaqConfigurator package"
              do_both
         else
     
              # Proceed with installation of Configurator
     
              # Install base
              if rpm -ivh ./compaqconfigurator-base-2.00-9.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator base package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator base package"
                  do_both
              fi
          
              # Install users
              if rpm -ivh ./compaqconfigurator-users-2.00-3.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator users package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator users package"
                  do_both
              fi

              # Install email
              if rpm -ivh ./compaqconfigurator-email-2.00-1.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator email package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator email package"
                  do_both
              fi
     
              # Install apache
              if rpm -ivh ./compaqconfigurator-apache-2.00-3.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator apache package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator apache package"
                  do_both
              fi
     
              # Install alerts
              if rpm -ivh ./compaqconfigurator-alerts-2.00-5.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator alerts package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator alerts package"
                  do_both
              fi
     
              # Install backup
              if rpm -ivh ./compaqconfigurator-backup-2.00-3.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator backup package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator backup package"
                  do_both
              fi
     
              # Install firewall
              if rpm -ivh ./compaqconfigurator-firewall-2.00-2.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator firewall package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator firewall package"
                  do_both
              fi
     
              # Install management
              if rpm -ivh ./compaqconfigurator-management-2.00-3.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator management package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator management package"
                  do_both
              fi
     
              # Install reports
              if rpm -ivh ./compaqconfigurator-reports-2.00-1.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator reports package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator reports package"
                  do_both
              fi
     
              # Install ssh
              if rpm -ivh ./compaqconfigurator-ssh-2.00-1.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator ssh package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator ssh package"
                  do_both
              fi
     
              # Install siteadmin
              if rpm -ivh ./compaqconfigurator-siteadmin-2.00-2.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator siteadmin package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator siteadmin package"
                  do_both
              fi
     
              # Install upgrade
              if rpm -ivh ./compaqconfigurator-upgrade-2.00-2.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator upgrade package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator upgrade package"
                  do_both
              fi
     
              # Install usertools
              if rpm -ivh ./compaqconfigurator-usertools-2.00-1.i386.rpm 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                  msg="CompaqConfigurator usertools package successful" 
                  do_log
              else
                  msg="Failed to install CompaqConfigurator usertools package"
                  do_both
              fi
     
         fi
     fi

     # Restore Data
     if cp -f /usr/compaq/backup/*.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore 2>>/usr/compaq/log/LastUpdate.log; then
         msg="Datastore restored"
         do_log
         # Repair ownership
         chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/*.xml
         # Copy new version of template.xml to datastore
         if cp -f /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/template.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
             # Insure correct permissions
             chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/template.xml 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
             chmod -v 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/template.xml 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log
             msg="Copied new version of template.xml to datastore"
             do_log

             # Execute checkdatastore.pl to convert database
             if /var/cpqcfg/cgi-bin/CompaqConfigurator/system/checkDatastore.pl 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log; then
                 msg="Datastore conversion successfull" 
                 do_log
             else
                 msg="Datastore conversion failed" 
                 do_log
             fi

             # Start up new version of CompaqConfigurator
             echo "- Starting Compaq Configurator"
             if /etc/rc.d/init.d/cpqcfg start 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
                 msg="Compaq Configurator started" 
                 do_log
             else
                 msg="Compaq Configurator NOT started - failed"
                 do_both
             fi
         else
             msg="Cannot copy template.xml to datastore"
             do_both
         fi
     else
         msg="Datastore restore - Failed"
         do_both
     fi
     
}

do_103_update_service_options() #==================================================================
{
     echo "- Updating Service Options"
     msg=">> Updating Service Options"
     do_log
     # Turn off mod_status dso module in Apache
     if /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom set_apache_module mod_status.c off 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
         msg="mod_status turned off" 
         do_log
     else
         msg="mod_status NOT turned off - failed"
         do_both
     fi
     # Update snmpd.conf from xml
     if /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom update_snmpconfig 1>>/usr/compaq/log/LastUpdate.log 2>>/usr/compaq/log/LastUpdate.log ; then
         msg="snmpd.conf updated " 
         do_log
     else
         msg="snmpd.conf NOT updated - failed"
         do_both
     fi
}



# ***************************************************************************
# Call Procedures Here.. Execute Upgrade. Master execution path.

do_preprocess

# CHECK CURRENT VERSION

if [ -f /_THIS_IS_VERSION_1.01 ] ;then
    do_103_update_cim_agents
    do_103_install_uidutil
    do_103_update_cpqcfg
    do_103_update_service_options
    do_103_update_help_system
    do_103_remove_esmtp_port
    do_103_update_release_notes
    do_102_upgrade_kernel_packages
    do_102_build_ram_disk_images
    do_102_configure_lilo
    do_historyupdate
    do_postprocess
    do_102_system_restart
else 
    # Assume version 1.02 ...already has new kernel
    do_103_update_cim_agents
    do_103_install_uidutil
    do_103_update_cpqcfg
    do_103_update_service_options
    do_103_update_help_system
    do_103_remove_esmtp_port
    do_103_update_release_notes
    do_historyupdate
    do_postprocess
fi

# ***************************************************************************



