<HTML>
<!-- $RCSfile: MS-DACTL.TPL $ $Revision: 1.13 $ -->
<!-- Copyright (C) 1998-2000 Compaq Computer Corporation -->
<HEAD>
<!#/COMMON/PAGETAGS.TPL>

<SCRIPT LANGUAGE="JavaScript">
contextHelp = true;

<!cpqDaCntlrEntry>
<!cpqDaAccelEntry>
<!cpqDaCntlrPerfEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#DAENUMS.JS>
<!#MS-DACMN.JS>
</SCRIPT>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">

idx = findArg("index"); // DA controller index passed in to page

if (idx == -1)
{
   // missing arg, try prev page load args
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqDaCntlrEntry.length)
{
   reportMissingArgs();
}
else
{
   writeBodyHead();
   cntlrIdx = cpqDaCntlrEntry[idx].cpqDaCntlrIndex;
   cntlrSlot = cpqDaCntlrEntry[idx].cpqDaCntlrSlot;
   perfData = null;

   for (i = 0; i < cpqDaCntlrPerfEntry.length; i++)
   {
      if (cpqDaCntlrPerfEntry[i].cpqDaCntlrPerfCntlrIndex == cntlrIdx)
      {
         perfData = cpqDaCntlrPerfEntry[i];
         break;
      }
   }
   postfix["cpqDaCntlrPerfCpuPercentBusy"] = "%";
   postfix["cpqDaCntlrPerfCommandCount"]   = "/sec";
   postfix["cpqDaCntlrPerfAvgLatency"]     = "/10000 sec";

   writePageHead("Array Controller Information", "/WEBAGENT/IMAGES/MASSHDR.GIF", "Array Controller Information");
   thisCntlr = cpqDaCntlrEntry[idx];
   duplexed = false;

   if (typeof(cpqDaCntlrEntry[idx].cpqDaCntlrCurrentRole != "undefined") &&
       cpqDaCntlrEntry[idx].cpqDaCntlrCurrentRole != null &&
       cpqDaCntlrEntry[idx].cpqDaCntlrCurrentRole != "")
   {
      duplexed = true;
   }
   cntlrCondition = new cpqCondition(cpqDaCntlrEntry[idx].cpqDaCntlrBoardCondition);
   writeTableLabel(cntlrCondition.image() + daCntlrBoardName(idx));
   writeTableHead();

   if (thisCntlr.cpqDaCntlrModel < 5)
   {
      // IDA controller, limited info in this table
      writeSingleTableRow("Model:",
         displayItem("cpqDaCntlrModel", thisCntlr.cpqDaCntlrModel));
      writeSingleTableRow("Firmware Version:",
         displayItem("cpqDaCntlrFWRev", thisCntlr.cpqDaCntlrFWRev));
   }
   else    // SMART controller
   {
      if (perfData == null)  // no perf data found for this controller
      {
         cpuUsage   = "N/A";
         cmdCount   = "N/A";
         cmdLatency = "N/A";
      }
      else
      {
         cpuUsage   = displayItem("cpqDaCntlrPerfCpuPercentBusy",
            perfData.cpqDaCntlrPerfCpuPercentBusy);
         cmdCount   = displayItem("cpqDaCntlrPerfCommandCount",
            perfData.cpqDaCntlrPerfCommandCount);
         cmdLatency = displayItem("cpqDaCntlrPerfAvgLatency",
            perfData.cpqDaCntlrPerfAvgLatency);
      }
      writeSingleTableRowInDoubleTable(
         "Model:", displayItem("cpqDaCntlrModel", thisCntlr.cpqDaCntlrModel));

      if (duplexed)
      {
         writeDoubleTableRow(
            "Controller Status:", displayItem("cpqDaCntlrBoardStatus", thisCntlr.cpqDaCntlrBoardStatus),
            "Redundancy Mode:",   displayItem("cpqDaCntlrRedundancyType", thisCntlr.cpqDaCntlrRedundancyType));
         writeDoubleTableRow(
            "Current Role:",     displayItem("cpqDaCntlrCurrentRole", thisCntlr.cpqDaCntlrCurrentRole),
            "Redundancy Error:", displayItem("cpqDaCntlrRedundancyError", thisCntlr.cpqDaCntlrRedundancyError));
      }
      writeDoubleTableRow(
         "Firmware Version:", thisCntlr.cpqDaCntlrFWRev,
         "CPU Usage:",        cpuUsage);
      writeDoubleTableRow(
         "Product Revision:", thisCntlr.cpqDaCntlrProductRev,
         "Command Count:",    cmdCount);
      writeDoubleTableRow(
         "Serial Number:",   displayItem("cpqDaCntlrSerialNumber", thisCntlr.cpqDaCntlrSerialNumber),
         "Command Latency:", cmdLatency);
      writeDoubleTableRow(
         "ADG Enabler Status:",  displayItem("cpqDaCntlrAccessModuleStatus", thisCntlr.cpqDaCntlrAccessModuleStatus),
         "Daughter Board Type:", displayItem("cpqDaCntlrDaughterBoardType", thisCntlr.cpqDaCntlrDaughterBoardType));
   }
   writeTableTail();

   // Display accelerator information
   accelIdx = -1;
   for (i = 0; i < cpqDaAccelEntry.length; i++)
   {
      if (cpqDaAccelEntry[i].cpqDaAccelCntlrIndex == cntlrIdx &&
          cpqDaAccelEntry[i].cpqDaAccelStatus != 2)
      {
         accelIdx = i;
         break;
      }
   }
   if (accelIdx >= 0 && accelIdx < cpqDaAccelEntry.length)
   {
      thisAccel = cpqDaAccelEntry[accelIdx];
      thisAccelCondition = new cpqCondition(thisAccel.cpqDaAccelCondition);

      postfix["cpqDaAccelMemory"] = "KB";
      postfix["cpqDaAccelReadMemory"] = "KB";
      postfix["cpqDaAccelTotalMemory"] = "KB";

      document.write("<BR>");
      writeTableLabel(thisAccelCondition.imageSmall()+"Accelerator", "Accelerator");
      writeTableHead();
      writeDoubleTableRow(
         "Status:",         displayItem("cpqDaAccelStatus", thisAccel.cpqDaAccelStatus),
         "Battery Status:", displayItem("cpqDaAccelBattery", thisAccel.cpqDaAccelBattery));
      writeDoubleTableRow(
         "Serial Number:", displayItem("cpqDaAccelSerialNumber", thisAccel.cpqDaAccelSerialNumber),
         "Read Errors:",   displayItem("cpqDaAccelReadErrs", thisAccel.cpqDaAccelReadErrs));
      writeDoubleTableRow(
         "Total Memory:",  displayItem("cpqDaAccelTotalMemory", thisAccel.cpqDaAccelTotalMemory),
         "Write Errors:",  displayItem("cpqDaAccelWriteErrs", thisAccel.cpqDaAccelWriteErrs));
      writeDoubleTableRow(
         "Read Cache:",  displayItem("cpqDaAccelReadMemory", thisAccel.cpqDaAccelReadMemory),
         "Error Code:",  displayItem("cpqDaAccelErrCode", thisAccel.cpqDaAccelErrCode));
      writeDoubleTableRow(
         "Write Cache:", displayItem("cpqDaAccelMemory", thisAccel.cpqDaAccelMemory),
         "Bad Data:",    displayItem("cpqDaAccelBadData", thisAccel.cpqDaAccelBadData));
      writeTableTail();
   }
   writeBodyTail();
}
</SCRIPT>
</HTML>

