package firewall;
#
#  Package:      firewall.pm
#
#  Copyright:     COPYRIGHT Compaq Computer Corporation 2001.  All rights reserved.
#
#  Description:  The OS specific routines for changing the system.
#
#    These routines handle FIREWALL specific changes including:
#
#     - IP Chains configuration
#
#  History:
#
use strict;

use CGI;
use XML::DOM;
use XML::QL;
use Quota;
use Time::localtime;

use config;
use general;
use datastore;
use message;
use error;

# A sub-routine to update the services configuration
sub updateServices {

  general::debug( "Update services called");

    my %system = config::system();
    
    my $rules = ":input ACCEPT\n:forward ACCEPT\n:output ACCEPT\n";

    my $proftp_file = "
# This is a basic ProFTPD configuration file (rename it to 
# 'proftpd.conf' for actual use.  It establishes a single server
# and a single anonymous login.  It assumes that you have a user/group
# \"nobody\" and \"ftp\" for normal operation and anon.

ServerName			\"ProFTPD Default Installation\"
ServerType	standalone
DefaultServer			on

# Port 21 is the standard FTP port.
Port				21
# Umask 022 is a good standard umask to prevent new dirs and files
# from being group and world writable.
Umask				022

# To prevent DoS attacks, set the maximum number of child processes
# to 30.  If you need to allow more than 30 concurrent connections
# at once, simply increase this value.  Note that this ONLY works
# in standalone mode, in inetd mode you should use an inetd server
# that allows you to limit maximum number of processes per service
# (such as xinetd)
MaxInstances			30

# Set the user and group that the server normally runs at.
User				nobody
Group				nobody

# Normally, we want files to be overwriteable.
<Directory /*>
  AllowOverwrite		on
</Directory>

";

    # Step 1:  Read in the service configuration for each network card

    # Parse the xml
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/network.xml");
    
    my $interfaces = $doc->getElementsByTagName("Interfaces")->item(0)->getElementsByTagName("Interface",0);
    my $numOfInterfaces = $interfaces->getLength;
    my $array = "";
    
    for (my $i=0;$i<$numOfInterfaces;$i++) {
	
        my $intNode = $interfaces->item($i);

	my $if1 = eval { $intNode->getAttribute("if"); } || next;

        my $enabled1 = eval { $intNode->getElementsByTagName("Enabled")->item(0)->getFirstChild->getData(); } || "";

        my $ip1 = eval { $intNode->getElementsByTagName("IP")->item(0)->getFirstChild->getData(); } || "";
	my $netmask1 = eval { $intNode->getElementsByTagName("NetMask")->item(0)->getFirstChild->getData(); } || "";
	my $bcast1 = eval { $intNode->getElementsByTagName("Broadcast")->item(0)->getFirstChild->getData(); } || "";

	# Attempt to get the IP address manually
	if ($ip1 eq "") {
	  my %ifConfig = network::getCurrentIFConfig($if1);
	  $ip1 = $ifConfig{'ip'};
	  $netmask1 = $ifConfig{'netmask'};
	  $bcast1 = $ifConfig{'broadcast'};
	}

        my $net1 = eval { $intNode->getElementsByTagName("Network")->item(0)->getFirstChild->getData(); } || "Yes";

        my $telnet1 = eval { $intNode->getElementsByTagName("Telnet",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $ftp1 = eval { $intNode->getElementsByTagName("FTP",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $anonftp1 = eval { $intNode->getElementsByTagName("AnonFTP",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $ssh1 = eval { $intNode->getElementsByTagName("SSH",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $smtp1 = eval { $intNode->getElementsByTagName("SMTP",0)->item(0)->getFirstChild->getData(); } || "Yes";           
        my $snmp1 = eval { $intNode->getElementsByTagName("SNMP",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $http1 = eval { $intNode->getElementsByTagName("HTTP",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $https1 = eval { $intNode->getElementsByTagName("HTTPS",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $who1 = eval { $intNode->getElementsByTagName("WHO",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $cim1 = eval { $intNode->getElementsByTagName("CIM",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $ident1 = eval { $intNode->getElementsByTagName("IDENT",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $icmp1 = eval { $intNode->getElementsByTagName("ICMP",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $pop31 = eval { $intNode->getElementsByTagName("POP3",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $imap1 = eval { $intNode->getElementsByTagName("IMAP",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $nfs1 = eval { $intNode->getElementsByTagName("NFS",0)->item(0)->getFirstChild->getData(); } || "Yes";
        my $cpqcfg1 = eval { $intNode->getElementsByTagName("CompaqConfigurator",0)->item(0)->getFirstChild->getData(); } || "Yes";
        $array .= "$enabled1<TD>$ip1<TD>$if1<TD>$telnet1<TD>$ftp1<TD>$anonftp1<TD>$smtp1<TD>$snmp1<TD>$http1<TD>$https1<TD>$who1<TD>$cim1<TD>$ident1<TD>$icmp1<TD>$ssh1<TD>$pop31<TD>$imap1<TD>$nfs1<TD>$cpqcfg1<TR>";
	
    }
     
  general::debug( "The array is  = $array");

    my @rows = split("<TR>", $array);

    # Step 2:  Execute IPChains command for each service
    foreach my $row (@rows) {

	my ($enabled, $ip, $if, $telnet, $ftp, $anonftp, $smtp, $snmp, $http, $https, $who, $cim, $ident, $icmp, $ssh, $pop3, $imap, $nfs, $cpqcfg) = split("<TD>", $row);

      general::debug("Writing firewall rules for $if");
	
	my $command = "";
	
	# Disable Telnet
	if ($telnet ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 23:23 -i $if -j REJECT -p tcp\n";
	}

	# Disable FTP
	if ($ftp ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 21:21 -i $if -j REJECT -p tcp\n";
	}

	# Enable/Disable Anonymous FTP
	if ($anonftp eq "Yes" && $enabled eq "Yes" && $ip ne "") {

	    # Make sure the ftp user has a valid shell
	    `/usr/sbin/usermod -s /bin/bash ftp`;

	    $proftp_file .= "<VirtualHost $ip>

     # Normally, we want files to be overwriteable.
    <Directory /*>
      AllowOverwrite		on
    </Directory>

    <Anonymous ~ftp>
  User                          ftp
  Group                         ftp
  # We want clients to be able to login with \"anonymous\" as well as \"ftp\"
  UserAlias                     anonymous ftp

  # Limit the maximum number of anonymous logins
  MaxClients                    10

  # We want 'welcome.msg' displayed at login, and '.message' displayed
  # in each newly chdired directory.
  DisplayLogin                  welcome.msg
  DisplayFirstChdir             .message

  # Limit WRITE everywhere in the anonymous chroot
  <Limit WRITE>
    DenyAll
  </Limit>

</Anonymous>            
</VirtualHost>\n";

	}
	
	
	# Disable SSH
	if ($ssh ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 22:22 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 22:22 -i $if -j REJECT -p udp\n";
	}
	
	# Disable SMTP
	if ($smtp ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 25:25 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 25:25 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 587:587 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 587:587 -i $if -j REJECT -p udp
";
	}
	
	
	# Disable SNMP
	if ($snmp ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 161:161 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 162:162 -i $if -j REJECT -p udp\n";
	}

	# Disable CIM
	if ($cim ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 2301:2301 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 2301:2301 -i $if -j REJECT -p tcp\n";
	}

	# Disable WHO
	if ($who ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 513:513 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 513:513 -i $if -j REJECT -p tcp\n";
	}

	# Disable IDENT
	if ($ident ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 113:113 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 113:113 -i $if -j REJECT -p tcp\n";
	}

	# Disable ICMP
	if ($icmp ne "Yes") {
 	    $rules .= "-A input -i $if -j DENY -p icmp\n";
	}

	# Disable HTTP
	if ($http ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 80:80 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 80:80 -i $if -j REJECT -p tcp\n";
	}

	# Disable HTTPS
	if ($https ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 443:443 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 443:443 -i $if -j REJECT -p tcp\n";
	}
	
	# Disable POP3
	if ($pop3 ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 110:110 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 110:110 -i $if -j REJECT -p udp\n";
	}
        
	
	# Disable IMAP
	if ($imap ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 143:143 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 143:143 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 220:220 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 220:220 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 993:993 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 993:993 -i $if -j REJECT -p udp\n";
	}

	# Disable NFS
	if ($nfs ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 2049:2049 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 111:111 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 1024:1024 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 1025:1025 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 2049:2049 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 111:111 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 1024:1024 -i $if -j REJECT -p udp
-A input -s 0/0 -d 0/0 1025:1025 -i $if -j REJECT -p udp
";
	}
	
	# Disable Compaq configurator
	if ($cpqcfg ne "Yes") {
 	    $rules .= "-A input -s 0/0 -d 0/0 3201:3201 -i $if -j REJECT -p tcp
-A input -s 0/0 -d 0/0 3201:3201 -i $if -j REJECT -p udp\n";
	}

    }

    # Step 3:  Make settings permanent
    if (open(FILE, ">/etc/sysconfig/ipchains")) {
	
	print FILE "$rules";
	
	close(FILE);
	
	# Setup permissions on ipchains file
	`/bin/chown root:root /etc/sysconfig/ipchains`;
	`/bin/chmod 600 /etc/sysconfig/ipchains`;

    }
    
    if (open(PROFILE, ">/etc/proftpd.conf")) {
	
	print PROFILE "# Compaq Configurator\n$proftp_file\n";
	
	close(PROFILE);
    }
    
    # Reset permissions
    `/bin/chmod o-rxw /etc/proftpd.conf`;
    
    my $command = "$system{'root'}/system/bin/ipchains restart";
    my $result = `$command`;

    $command = "$system{'root'}/system/bin/proftp restart";
    $result = `$command`;
    
}




1;
