#!/bin/bash
#
#  Program:      setup_users.sh
#
#  Description:  This program does post installation configuration to allow
#    the configurator to run properly.
#
#    This setup script installs the USERS/GROUPS package.
#
#  History:
#
#

echo "Starting Compaq Configurator setup script...USERS/GROUPS Module"

# Install cpqcfg PAM config file
if [ -a /etc/cpqcfgusers ]; then
    echo "  - Skipping CPQCFG PAM module installation...(This must be an upgrade)"
else
    echo "  - Installing CPQCFG PAM module..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/cpqcfg.pam /etc/pam.d/cpqcfg
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/cpqcfgusers /etc/cpqcfgusers
    chown root:root /etc/pam.d/cpqcfg
    chmod go-rwx /etc/pam.d/cpqcfg
    chmod go+r /etc/pam.d/cpqcfg
fi

echo "  - Installing PAM modifications to telnet, ftp, ssh, imap, and pop3"
touch /etc/ftpusers
touch /etc/telnetusers
touch /etc/sshusers
touch /etc/pop3users
touch /etc/imapusers
cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/sshd.pam /etc/pam.d/sshd
cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/ftp.pam /etc/pam.d/ftp
cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/rlogin.pam /etc/pam.d/rlogin
cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/login.pam /etc/pam.d/login
cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/pop3.pam /etc/pam.d/pop3
cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/imap.pam /etc/pam.d/imap
cp /var/cpqcfg/cgi-bin/CompaqConfigurator/setup/imapusers /etc/imapusers
chmod ugo+r /etc/imapusers
chown root:root /etc/imapusers
chown root:root /etc/pam.d/*
chmod go-wx /etc/pam.d/*
chmod g-r /etc/pam.d/sshd

# Setup the datastore components
if [ -a /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/users.xml ]; then
    echo "  - Datastore already installed...(This must be an upgrade)"    
else
    echo "  - Installing new datastore..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/users.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/groups.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/users.xml
    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/groups.xml
    chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/users.xml
    chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/groups.xml
fi

# Set SUID on custom components
echo "  - Setting SUID on select programs..."
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*

# END OF SCRIPT
echo "** Finished! **"
